

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DeleteClientGroup.sp,v $ $Id: QS_DeleteClientGroup.sp,v 1.5.48.2 2018/03/22 01:09:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteClientGroup')
	drop procedure QS_DeleteClientGroup
IF EXISTS (select * from GxQscripts where name='QS_DeleteClientGroup')
	delete from GxQscripts where name = 'QS_DeleteClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteClientGroup')
	delete from GXDBVersions where aliasname = 'QS_DeleteClientGroup'
GO
print '... Creating Procedure: QS_DeleteClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteClientGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @groupName nvarchar(1024)
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(32)
	SET		@scriptName	= 'DeleteClientGroup'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @now				integer
	DECLARE @userId				integer
	SET @now = dbo.GetUnixTime(GETDATE())
	SET @userId	 = 1	-- Until we find a way to fetch from Qcommand!
-----------------------validate parameters------------------------------
	DECLARE @clientGroupId integer
	SET @clientGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name like @groupName), 0)
	IF @clientGRoupId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Group ['+ @groupName +'] does not exist.'
		GOTO PROC_ERROR
	END
------------------------Check EDC clients associated with Client Group------------------------
	DECLARE @flag as INT = 0
	SET @flag = (SELECT flag from APP_ClientGroup WHERE id = @clientGroupId)
IF ( (@flag & 0x0100) <> 0 OR (@flag & 0x0200) <> 0)
	BEGIN
		SET @lastError = 1;
		SET @localErrorMsg = 'Error. EDC clients associated with Client Group ['+ @groupName +'] please use GUI to delete client group.'
		GOTO PROC_ERROR
	END
BEGIN TRY
BEGIN TRAN
	------------------------delete all associated schedules------------------------
	delete FROM TM_AssocEntity WHERE clientGroupId = @clientGroupId
	------------------------remove NetworkThrottle Entries------------------------
	delete FROM APP_NetworkThrottle WHERE clientGroupId = @clientGroupId OR forClientGroupId = @clientGroupId
	delete FROM APP_NetworkThrottleOptions WHERE clientGroupId = @clientGroupId
	------------------------Remove the entries from firewall tables------------------------
	delete FROM APP_Firewall WHERE clientGroupId = @clientGroupId OR forClientGroupId = @clientGroupId
	delete FROM APP_FirewallOptions WHERE clientGroupId = @clientGroupId
	delete FROM App_FWOutGoingRoutes WHERE clientGroupId = @clientGroupId OR forClientGroupId = @clientGroupId
	delete FROM APP_FWPortRange WHERE clientGroupId = @clientGroupId
	------------------------remove Security Entries------------------------
delete FROM UMGroupAssociation WHERE type1 = 2572 AND id1 = @clientGroupId
EXEC sec_deleteSecurityAssociationsForEntity 28, @clientGroupId
	------------------------remove Activity Control Entries------------------------
	delete FROM JMJobAction WHERE clientGroupId = @clientGroupId AND clientId = 1 AND appType = 0 AND mediaAgentID = 1
	------------------------remove SQL Authentication Entries------------------------
	delete FROM APP_ComponentProp WHERE componentType = 8 AND componentId = @clientGroupId
	------------------------remove clients from client group------------------------
	delete APP_ClientGroupAssoc WHERE clientGroupId = @clientGroupId
	------------------------remove client group----------------------------
	delete APP_ClientGroup WHERE id = @clientGroupId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto PROC_ERROR
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + 'completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'client group Name ['+ @groupName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteClientGroup')
	delete from GxQscripts where name = 'QS_DeleteClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteClientGroup')
	delete from GXDBVersions where aliasname = 'QS_DeleteClientGroup'
GO

insert into GXDBVersions values(2, 'QS_DeleteClientGroup',  '00010005004800020000', 'QS_DeleteClientGroup', '00010005004800020000')
GO

insert into GxQscripts values(2,'QS_DeleteClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn DeleteClientGroup -si ''group_name''
'
 + CHAR(10) + '	script_name: DeleteClientGroup.
'
 + CHAR(10) + '	group_name - name of the group to be deleted
'
)
GO

