

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteArchivedJobInfo.sp] ---------- 

--  +========================================================================+
--  |		 		Name:  QS_DeleteArchivedJobInfo()
--  | Description:  This SP is from Permanent QScript - DeleteArchivedJobInfo
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DeleteArchivedJobInfo.sp,v $ $Id: QS_DeleteArchivedJobInfo.sp,v 1.5.12.3 2019/08/13 05:15:09 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DeleteArchivedJobInfo')
BEGIN
	print '>>> Drop Stored Procedure: QS_DeleteArchivedJobInfo <<<'
	drop procedure QS_DeleteArchivedJobInfo
END
IF EXISTS (select * from GxQscripts where name='QS_DeleteArchivedJobInfo')
	delete from GxQscripts where name = 'QS_DeleteArchivedJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteArchivedJobInfo')
	delete from GXDBVersions where aliasname = 'QS_DeleteArchivedJobInfo'
GO
print '... Creating Procedure: QS_DeleteArchivedJobInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteArchivedJobInfo
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_fileName NVARCHAR(MAX) = ''
AS
SET NOCOUNT ON
DECLARE @errorCode INTEGER
SET			@errorCode = 0
DECLARE @retCode INTEGER
SET			@retCode = 0
DECLARE @rowCnt INTEGER
SET 		@rowCnt = 0
DECLARE @magneticBytes  BIGINT
DECLARE @l_delimiter		VARCHAR(256)
SET 		@l_delimiter		= ','
DECLARE @SQLQuery 	VARCHAR(MAX)
SET			@SQLQuery		= ''
DECLARE @currentTime 	INTEGER
SET 		@currentTime 	= dbo.GetUnixTime(GETUTCDATE())
DECLARE @maxJobsToDeleteInBatch	INTEGER
SET		@maxJobsToDeleteInBatch	= 50000
IF OBJECT_ID('tempdb.dbo.#tmpJobsToDelete') is not null DROP TABLE #tmpJobsToDelete
CREATE	TABLE #tmpJobsToDelete (
		JobId					INTEGER,
		CommCellId		INTEGER,
		archGrpId			INTEGER,
		archGrpCopyId	INTEGER,
		dataType			INTEGER
		)
CREATE INDEX Idx_tmpJobsToDelete_1 ON #tmpJobsToDelete(JobId, CommCellId, archGrpCopyId, dataType)
IF OBJECT_ID('tempdb.dbo.#ToBeAgedJob') is not null DROP TABLE #ToBeAgedJob
CREATE TABLE #ToBeAgedJob (
	jobId 					INTEGER,
	archGrpId 			INTEGER,
	archGrpCopyId 	INTEGER,
	dataType 				INTEGER,
	commCellId 			INTEGER,
	)
CREATE INDEX Idx_ToBeAgedJob_1 ON #ToBeAgedJob(JobId, CommCellId, archGrpCopyId, dataType)
	SELECT @maxJobsToDeleteInBatch = isnull(value, 50000)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_MAX_JOBS_TO_DELETE_IN_BATCH'
	SET @SQLQuery = 'BULK INSERT #tmpJobsToDelete FROM '''+ @i_fileName + ''' WITH (FIELDTERMINATOR = ''' + @l_delimiter + ''')'
	EXEC (@SQLQuery)
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	DELETE #ToBeAgedJob
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ToBeAgedJob
	SELECT TOP (@maxJobsToDeleteInBatch) JobId, archGrpId, archGrpCopyId, dataType, CommCellId
	FROM #tmpJobsToDelete
	SELECT @errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@errorCode != 0 GOTO CX_EXIT
	--Process job deletion in batches
	WHILE (@rowCnt > 0)
	BEGIN
		BEGIN TRAN DELETE_ARCHIVED_DATA
EXEC @retCode = archSetJobsAgedViaTable 262144, @currentTime
			SET @errorCode = @@ERROR
			IF  @errorCode = 0 SET @errorCode = @retCode
			IF	@errorCode != 0 GOTO CX_ERROR_EXIT
			--Create table here as the same temp table is created\dropped from archSetJobsAgedViaTable.sp
			IF OBJECT_ID('tempdb.dbo.#ToBeAgedAFC') is not null DROP TABLE #ToBeAgedAFC
			CREATE TABLE #ToBeAgedAFC (
				archFileId INTEGER,
				commCellId INTEGER,
				archCopyId INTEGER
				)
			CREATE INDEX Idx_ToBeAgedAFC_1 ON #ToBeAgedAFC(archFileId, commCellId, archCopyId)
			--Populate archive files to delete
			INSERT INTO #ToBeAgedAFC
			SELECT AFC.archFileId, AFC.commCellId, AFC.archCopyId
			FROM #ToBeAgedJob T, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
			WHERE T.jobId = AF.jobId
			AND		T.commCellId = AF.commCellId
			AND		T.dataType = AF.fileType
			AND		T.archGrpId = AF.archGroupId
			AND		AF.id = AFC.archFileId
			AND		AF.commCellId = AFC.commCellId
			AND		T.archGrpCopyId = AFC.archCopyId
			SET	@errorCode = @@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			EXEC @retCode = archFileDeleteViaTable 0, @magneticBytes OUTPUT
			SET @errorCode = @@ERROR
			IF  @errorCode = 0 SET @errorCode = @retCode
			IF	@errorCode != 0 GOTO CX_ERROR_EXIT
    	-- Mark jobs as deleted
			UPDATE  JMJobDataStats
SET     status = 1000, agedBy = (JDS.agedBy | 262144),
			        mediaDeletedTime = @currentTime, modifiedTime = @currentTime
			FROM    JMJobDataStats JDS, #ToBeAgedJob T
			WHERE   JDS.jobId = T.jobId
			AND     JDS.commCellId = T.commCellId
			AND     JDS.archGrpCopyId = T.archGrpCopyId
			AND     JDS.dataType = T.dataType
			SET	@errorCode = @@ERROR
			IF	@errorCode != 0 GOTO CX_ERROR_EXIT
		COMMIT TRAN DELETE_ARCHIVED_DATA
		DELETE #tmpJobsToDelete
		FROM #tmpJobsToDelete T, #ToBeAgedJob T1
		WHERE T.jobId = T1.jobId
		AND		T.commCellId = T1.commCellId
		AND		T.archGrpCopyId = T1.archGrpCopyId
		AND		T.dataType = T1.dataType
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		DELETE #ToBeAgedJob
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO #ToBeAgedJob
		SELECT TOP (@maxJobsToDeleteInBatch) JobId, archGrpId, archGrpCopyId, dataType, CommCellId
		FROM #tmpJobsToDelete
		SELECT @errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	GOTO CX_EXIT
CX_ERROR_EXIT:
	ROLLBACK TRAN DELETE_ARCHIVED_DATA
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tmpJobsToDelete') IS NOT null DROP TABLE #tmpJobsToDelete
	IF OBJECT_ID('tempdb.dbo.#ToBeAgedJob') is not null DROP TABLE #ToBeAgedJob
	IF OBJECT_ID('tempdb.dbo.#ToBeAgedAFC') is not null DROP TABLE #ToBeAgedAFC
	RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteArchivedJobInfo')
	delete from GxQscripts where name = 'QS_DeleteArchivedJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteArchivedJobInfo')
	delete from GXDBVersions where aliasname = 'QS_DeleteArchivedJobInfo'
GO

insert into GXDBVersions values(2, 'QS_DeleteArchivedJobInfo',  '00010005001200030000', 'QS_DeleteArchivedJobInfo', '00010005001200030000')
GO

insert into GxQscripts values(2,'QS_DeleteArchivedJobInfo',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn DeleteArchivedJobInfo.sql -si <CSV filename with jobs to delete> 
'
)
GO

