

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DelDanglingDataSourceFromEntity.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DelDanglingDataSourceFromEntity')
BEGIN
	print '>>> Drop Stored Procedure: QS_DelDanglingDataSourceFromEntity <<<'
	drop procedure QS_DelDanglingDataSourceFromEntity
END
IF EXISTS (select * from GxQscripts where name='QS_DelDanglingDataSourceFromEntity')
	delete from GxQscripts where name = 'QS_DelDanglingDataSourceFromEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DelDanglingDataSourceFromEntity')
	delete from GXDBVersions where aliasname = 'QS_DelDanglingDataSourceFromEntity'
GO
print '... Creating Procedure: QS_DelDanglingDataSourceFromEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DelDanglingDataSourceFromEntity
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @i_clientIdList NVARCHAR(MAX) = N'',
  @i_subclientIdList NVARCHAR(MAX) =N'',
  @i_backupSetIdList NVARCHAR(MAX) =N'',
  @i_ignoreAssociationCheck NVARCHAR(100) =N'false'
AS
Set NOCOUNT ON
BEGIN
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_DelDanglingDataSourceFromEntity'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
-----------------------invalid parameters------------------------------
IF(@i_clientIdList = @NoParameter AND @i_subclientIdList = @NoParameter AND @i_backupSetIdList = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
IF OBJECT_ID('#inputEntities') IS NOT NULL DROP TABLE #inputEntities
CREATE  TABLE  #inputEntities(entityType INT, entityId INT)
--get list of input clientIds
IF(@i_clientIdList <> N'')
BEGIN
	INSERT INTO #inputEntities
SELECT 3, CAST(_ID AS INT)
    FROM dbo.SplitStringByDelimiter(@i_clientIdList, ',')
END
--get list of input subclientIds
IF(@i_subclientIdList <> N'')
BEGIN
	INSERT INTO #inputEntities
SELECT 7, CAST(_ID AS INT)
    FROM dbo.SplitStringByDelimiter(@i_subclientIdList, ',')
END
--get list of input backupSetIds
IF(@i_backupSetIdList <> N'')
BEGIN
	INSERT INTO #inputEntities
SELECT 6, CAST(_ID AS INT)
	FROM dbo.SplitStringByDelimiter(@i_backupSetIdList, ',')
END
IF NOT EXISTS(SELECT TOP 1 1 FROM #inputEntities)
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error: ClientId / SubclientId / Backupset information is not provided. Nothing to do'
	GOTO SCRIPT_EXIT
END
BEGIN TRAN
	BEGIN TRY
		--remove association at client level
		DELETE CP
		FROM APP_ClientProp CP
JOIN #inputEntities E ON CP.componentNameId = E.entityId AND E.entityType = 3
		LEFT JOIN SEdatasource SE (NOLOCK) ON CP.attrval = SE.DataSourceId
		WHERE attrName =  'indexing datasource id' AND (SE.DataSourceId IS NULL OR @i_ignoreAssociationCheck ='true')
		IF @@ROWCOUNT > 0
		PRINT @scriptName + ' Deleted rows from APP_ClientProp table with attrName =''indexing datasource id'' '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@i_clientIdList + ', '+@i_subclientIdList + ', '+@i_backupSetIdList +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
		--remove association at subclient level
		DELETE SCP
		FROM APP_subclientProp  SCP
JOIN #inputEntities E ON SCP.componentNameId = E.entityId AND E.entityType = 7
		LEFT JOIN SEdatasource SE (NOLOCK) ON SCP.attrval = SE.DataSourceId
		WHERE attrName =  'indexing datasource id' AND (SE.DataSourceId IS NULL OR @i_ignoreAssociationCheck ='true')
		--remove association at backupsetclient level
		DELETE BCP
		FROM APP_BackupSetProp  BCP
JOIN #inputEntities E ON BCP.componentNameId = E.entityId AND E.entityType = 6
		LEFT JOIN SEdatasource SE (NOLOCK) ON BCP.attrval = SE.DataSourceId
		WHERE attrName =  'indexing datasource id' AND (SE.DataSourceId IS NULL OR @i_ignoreAssociationCheck ='true')
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
		GOTO SCRIPT_EXIT
	END CATCH
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: clientIdList ['+@i_clientIdList + '], subclientIdList [' +@i_subclientIdList + '], backupSetIdList ['+@i_backupSetIdList + '], ignoreAssociationCheck ['+ @i_ignoreAssociationCheck
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DelDanglingDataSourceFromEntity')
	delete from GxQscripts where name = 'QS_DelDanglingDataSourceFromEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DelDanglingDataSourceFromEntity')
	delete from GXDBVersions where aliasname = 'QS_DelDanglingDataSourceFromEntity'
GO

insert into GXDBVersions values(2, 'QS_DelDanglingDataSourceFromEntity',  '00000000000000000000', 'QS_DelDanglingDataSourceFromEntity', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DelDanglingDataSourceFromEntity',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '--         Script to remove Data Source to Entiy (client / Subclient / backupSet) association'
 + CHAR(10) + '--         qoperation execscript -sn QS_DelDanglingDataSourceFromEntity -si ''clientIdList'' [-si ''subClientIdList'' -si ''backupSetIdList'' -si ''ignoreAssociationCheck (true/false)'']'
 + CHAR(10) + '-- 			clientIdList - list of comma seperated clientIds'
 + CHAR(10) + '-- 			subClientIdList - Optional, list of comma seperated subclientIds'
 + CHAR(10) + '-- 			backupSetIdList - Optional, list of comma seperated backupSetIds'
 + CHAR(10) + '-- 			ignoreAssociationCheck - Optional, remove datasource to entity association even if datasource exists. (default value = ''''false'''')'
)
GO

