

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeconfigureAgent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeconfigureAgent <<<'

IF EXISTS (select * from sysobjects where name='QS_DeconfigureAgent')
	drop procedure QS_DeconfigureAgent
IF EXISTS (select * from GxQscripts where name='QS_DeconfigureAgent')
	delete from GxQscripts where name = 'QS_DeconfigureAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeconfigureAgent')
	delete from GXDBVersions where aliasname = 'QS_DeconfigureAgent'
GO
print '... Creating Procedure: QS_DeconfigureAgent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DeconfigureAgent
-- Stored Procedure Inputs
  @i_clientName nvarchar(1030),
  @i_idaName nvarchar(1030)=''
AS
Set NOCOUNT ON
----------------------constants--------
DECLARE @scriptName nvarchar(100)
SET @scriptName = 'QS_DeconfigureAgent'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
------------------------------------------
--  VARIABLES 							--
------------------------------------------
DECLARE @errorCode		AS integer			= 0
DECLARE @errorString	AS nvarchar(1024)	= ''
DECLARE @clientId		AS integer 			= 0
DECLARE @appTypeId		AS integer			= 0
--
---insufficient parameters: -----------
DECLARE @noParameter nvarchar(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
--
DECLARE @tmpAppTbl	TABLE(
						id integer,
						appTypeId integer,
						instance integer,
						backupset integer,
						clientId integer
					)
--------------------------------------
------------------------------------------
-- PARSE PARAMS AND CHECK FOR ERRORS	--
------------------------------------------
BEGIN TRY
	IF @i_clientName = @noParameter
	BEGIN
		SET @ErrorString	= 'No client specified'
		SET @errorCode		= 1
		GOTO ARGS_ERROR
	END
	SET @ClientId  = ISNULL((Select id from app_client Where name = @i_clientName), 0)
	IF @clientId = 0
	BEGIN
		SET @ErrorString	= 'No Client with name ['+@i_clientName + '] exists on this Commserver'
		SET @errorCode		= 1
		GOTO ARGS_ERROR
	END
--
	IF @i_idaName <> @noParameter AND @i_idaName <> ''
	BEGIN
		INSERT INTO @tmpAppTbl
		SELECT id, appTypeId, instance, backupset, clientId FROM App_Application
		WHERE clientId = @clientId
		SET @appTypeId = ISNULL((SELECT type FROM app_IDAType WHERE name=@i_idaName AND type in
									(SELECT appTypeId FROM @tmpAppTbl WHERE clientId = @clientId)), 0)
		IF @appTypeId = 0
			SET @appTypeId = ISNULL((SELECT appTypeId FROM app_idaname
								WHERE clientid = @clientId AND appTypeId in
									(SELECT DISTINCT appTypeId FROM simAppTypeLicTypeMap
											WHERE display_Name = @i_idaName)), 0)
		IF @appTypeId = 0
		BEGIN
			SET @ErrorString	= 'No Ida [' + @i_idaName+'] exists on client['+@i_clientName + '] on this Commserver.'
			SET @errorCode		= 1
			GOTO ARGS_ERROR
		END
	END
	ELSE
		SET @i_idaName = 'No Ida Specified'		-- For "Logging"
		EXEC AppConfDeconf @clientId, @appTypeId, 0, 2, @errorCode OUTPUT, @errorString OUTPUT
	IF @errorCOde != 0
	BEGIN
		GOTO ARGS_ERROR
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END  CATCH
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO
/* FOR DEBUGGING:
DROP PROC QS_DeconfigureAgent
GO
exec QS_DeconfigureAgent 'california64', 'file system'  -- White64_90
*/

IF EXISTS (select * from GxQscripts where name = 'QS_DeconfigureAgent')
	delete from GxQscripts where name = 'QS_DeconfigureAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeconfigureAgent')
	delete from GXDBVersions where aliasname = 'QS_DeconfigureAgent'
GO

insert into GXDBVersions values(2, 'QS_DeconfigureAgent',  '00000000000000000000', 'QS_DeconfigureAgent', '00000000000000000000')
GO

