

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DataProtectionJobSummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DataProtectionJobSummary.sp,v $ $Id: QS_DataProtectionJobSummary.sp,v 1.1.88.11 2020/05/05 01:59:04 junlu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DataProtectionJobSummary')
BEGIN
	print '>>> Drop Stored Procedure: QS_DataProtectionJobSummary <<<'
	drop procedure QS_DataProtectionJobSummary
END
IF EXISTS (select * from GxQscripts where name='QS_DataProtectionJobSummary')
	delete from GxQscripts where name = 'QS_DataProtectionJobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataProtectionJobSummary')
	delete from GXDBVersions where aliasname = 'QS_DataProtectionJobSummary'
GO
print '... Creating Procedure: QS_DataProtectionJobSummary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DataProtectionJobSummary
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Set input parameters here
  @FromTime VARCHAR(32)	= '',
  @ToTime VARCHAR(32)	= '',
  @LastNDays INT		= 1,
  @IncludeAged INT		= 1,
  @IncludeRunning INT		= 1,
  @BackupType VARCHAR(32)	= '',
  @OrderBy VARCHAR(32)	= 'JobID',
  @IncludeBackupCopy INT	= 0,
  @IncludeCommandLine INT = 0,
  @IncludeOneTouch INT = 0
AS
SET NOCOUNT ON
DECLARE	@CopyId			INT = 0
DECLARE	@TimeRangeBegin	INT = 0
DECLARE	@TimeRangeEnd	INT = 0x7FFFFFFF
DECLARE	@BackupLevel	INT = 0
DECLARE	@TimeZoneBias	INT = DATEDIFF(SECOND, GETUTCDATE(), GETDATE())
DECLARE	@FromDateTime	DATETIME = @FromTime
DECLARE	@ToDateTime		DATETIME = @ToTime
IF @FromTime = '' AND @ToTime = ''
BEGIN
	SET @ToDateTime		= GETUTCDATE()
	SET	@TimeRangeEnd	= dbo.GetUnixTime(@ToDateTime)
	IF	@LastNDays > 0
	BEGIN
		SET @FromDateTime	= DATEADD(DAY, -@LastNDays, @ToDateTime)
		SET @TimeRangeBegin = dbo.GetUnixTime(@FromDateTime)
	END
END
IF @FromTime <> ''
BEGIN
	SET	@FromDateTime	= dbo.ClientLocalToUTCTime(@FromDateTime, 2)
	SET	@TimeRangeBegin = dbo.GetUnixTime(@FromDateTime)
END
IF @ToTime <> ''
BEGIN
	SET	@ToDateTime		= dbo.ClientLocalToUTCTime(@ToDateTime, 2)
	SET	@TimeRangeEnd	= dbo.GetUnixTime(@ToDateTime)
END
SET @BackupType  = UPPER(@BackupType)
SET @BackupLevel = CASE WHEN @BackupType = 'FULL' THEN 1
						WHEN @BackupType = 'INCR' THEN 2
						ELSE 0
					END
CREATE TABLE #VSA_AppIDs (appId INT, isIndexingV2 INT)
-- Before IndexingV2, JMJobDataStats and archFile tables only have entries of parent jobs. Count parent jobs.
-- Since IndexingV2, JMJobDataStats and archFile tables have entries of both parent and child jobs. Count child jobs.
-- Parent jobs associated with appId of IndexingV2 VSA subclients will be excluded in calcultion.
INSERT	INTO #VSA_AppIDs
SELECT	A.id, ISNULL(CP.attrVal, 0)
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = A.instance
			AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal <> '' AND IP.modified = 0
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = A.clientId
			AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1'
WHERE	A.appTypeId = 106 AND A.subclientStatus&0x00020 = 0
CREATE TABLE #JobDetails (
		JobId INT, CommCellId INT, AppId INT, AppTypeId INT, ArchGrpId INT, OpType INT, BkpLevel INT, Status INT, StartDate INT, EndDate INT,
		ScanType INT, SizeChangePct INT, TotakWriteTime INT, ProtectedObjects BIGINT, FailedObjects INT, FailedFolders INT,
		TotalUncompBytes BIGINT, CompressionRate FLOAT, NwTransBytes BIGINT, SizeOnMedia BIGINT, SpaceSaving FLOAT,
		vmClientId INT, vmStatus INT, vmFailureReason NVARCHAR(512), FailureCode VARCHAR(32), FailureReason NVARCHAR(512)
)
-- Defect 200750 --
CREATE TABLE #opTypes (type INT)
INSERT #opTypes VALUES (4), (14), (76), (59), (65)
IF @IncludeCommandLine <> 0		INSERT #opTypes VALUES (18)
IF @IncludeOneTouch <> 0		INSERT #opTypes VALUES (43)
-------------------
IF @IncludeRunning = 0
	INSERT INTO #JobDetails
	SELECT	jobId, commCellId, appId, appType, CASE WHEN dataArchGrpId > 0 THEN dataArchGrpId ELSE logArchGrpId END,
			opType, bkpLevel, CASE displayStatus WHEN 0 THEN status ELSE displayStatus END,
			servStartDate + @TimeZoneBias, servEndDate + @TimeZoneBias,
			scanType, percentageChange, totalWriteTime, totalNumOfFiles,
			scanFileFailures + backupFileFailures, scanFolderFailures + backupFolderFailures,
			totalUncompBytes,
			CASE WHEN totalUncompBytes > 0 AND (totalUncompBytes > totalCompBytes) THEN 1.0*(totalUncompBytes - totalCompBytes)/totalUncompBytes
				 ELSE 0	END,
			nwTransBytes, 0, 0, 0, 0, '', '',
			CASE WHEN CHARINDEX(',', failureReason) = LEN(failureReason) THEN failureReason
				 ELSE RIGHT(failureReason, CHARINDEX(',', REVERSE(failureReason), 2)-1) END
	FROM	JMBkpStats J WITH (NOLOCK)
	 INNER JOIN #opTypes O															-- Defect 200750
	   ON J.opType = O.type  AND failureErrorCode <> 8								-- Defect 200750
	WHERE	servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
--		AND opType IN (4, 14, 76, 59, 65) AND failureErrorCode <> 8					-- Defect 200750
		AND (@IncludeAged = 1 OR dataStatus = 0)
		AND bkpLevel = CASE WHEN @BackupType = 'FULL' THEN 1
							WHEN @BackupType = 'INCR' THEN 2
							ELSE bkpLevel
						END
ELSE
BEGIN
	INSERT INTO #JobDetails
	SELECT	jobId, commCellId, appId, appType, CASE WHEN dataArchGrpId > 0 THEN dataArchGrpId ELSE logArchGrpId END,
			opType, bkpLevel, CASE displayStatus WHEN 0 THEN status ELSE displayStatus END,
			servStartDate + @TimeZoneBias, servEndDate + @TimeZoneBias,
			scanType, percentageChange, totalWriteTime, totalNumOfFiles,
			scanFileFailures + backupFileFailures, scanFolderFailures + backupFolderFailures,
			totalUncompBytes,
			CASE WHEN totalUncompBytes > 0 AND (totalUncompBytes > totalCompBytes) THEN 1.0*(totalUncompBytes - totalCompBytes)/totalUncompBytes
				 ELSE 0	END,
			nwTransBytes, 0, 0, 0, 0, '', '',
			CASE WHEN CHARINDEX(',', failureReason) = LEN(failureReason) THEN failureReason
				 ELSE RIGHT(failureReason, CHARINDEX(',', REVERSE(failureReason), 2)-1) END
	FROM	JMBkpStats j WITH (NOLOCK)
	 INNER JOIN #opTypes O															-- Defect 200750
	   ON J.opType = O.type  AND failureErrorCode <> 8								-- Defect 200750
	WHERE	servEndDate > @TimeRangeBegin AND servStartDate < @TimeRangeEnd
--		AND opType IN (4, 14, 76, 59, 65) AND failureErrorCode <> 8					-- Defect 200750
		AND (@IncludeAged = 1 OR dataStatus = 0)
		AND bkpLevel = CASE WHEN @BackupType = 'FULL' THEN 1
							WHEN @BackupType = 'INCR' THEN 2
							ELSE bkpLevel
						END
	UNION ALL
	SELECT	J.jobId, J.commCellId, B.applicationId, A.appTypeId, CASE WHEN B.dataPolicy > 0 THEN B.dataPolicy ELSE B.logPolicy END,
			J.opType, B.bkpLevel, -(CASE displayState WHEN 0 THEN state ELSE displayState END), J.jobStartTime + @TimeZoneBias, -1,
			B.scanType, 0,
			ISNULL((SELECT SUM(writeTime) FROM JMBkpAttemptInfo WITH (NOLOCK) WHERE JMBkpAttemptInfo.jobId = J.jobId), 0) +
			ISNULL((SELECT MAX(writeTime) FROM JMJobStreams WITH (NOLOCK) WHERE jobId = J.jobId), 0),
			B.filesXfered,
			B.scanFileFailures + B.backupFileFailures, B.scanFolderFailures + B.backupFolderFailures,
			B.unCompBytes,
			CASE WHEN B.unCompBytes > 0 AND (B.unCompBytes > B.compBytes) THEN 1.0*(B.unCompBytes - B.compBytes)/B.unCompBytes
				 ELSE 0	END,
			B.nwTransBytes, 0, 0, 0, 0, '', '',
			CASE WHEN CHARINDEX(',', failureReason) = LEN(failureReason) THEN failureReason
				 ELSE RIGHT(failureReason, CHARINDEX(',', REVERSE(failureReason), 2)-1) END
	FROM	JMJobInfo J WITH (NOLOCK)
			INNER JOIN JMBkpJobInfo B WITH (NOLOCK) ON J.jobId = B.jobId
			INNER JOIN APP_Application A WITH (NOLOCK) ON B.applicationId = A.id
		    INNER JOIN #opTypes O															-- Defect 200750
				ON J.opType = O.type														-- Defect 200750
	WHERE	J.jobStartTime < @TimeRangeEnd
--		AND J.opType IN (4, 14, 76, 59, 65)													-- Defect 200750
		AND B.bkpLevel = 	CASE WHEN @BackupType = 'FULL' THEN 1
							WHEN @BackupType = 'INCR' THEN 2
							ELSE B.bkpLevel
						END
END
IF @IncludeBackupCopy = 1
BEGIN
    IF @IncludeRunning = 0
        INSERT INTO #JobDetails
        SELECT	jobId, commCellId, appId, appType, CASE WHEN dataArchGrpId > 0 THEN dataArchGrpId ELSE logArchGrpId END,
                opType, bkpLevel, CASE displayStatus WHEN 0 THEN status ELSE displayStatus END,
                servStartDate + @TimeZoneBias, servEndDate + @TimeZoneBias,
                scanType, percentageChange, totalWriteTime, totalNumOfFiles,
                scanFileFailures + backupFileFailures, scanFolderFailures + backupFolderFailures,
                totalUncompBytes,
                CASE WHEN totalUncompBytes > 0 AND (totalUncompBytes > totalCompBytes) THEN 1.0*(totalUncompBytes - totalCompBytes)/totalUncompBytes
                     ELSE 0	END,
                nwTransBytes, 0, 0, 0, 0, '', '',
                CASE WHEN CHARINDEX(',', failureReason) = LEN(failureReason) THEN failureReason
                     ELSE RIGHT(failureReason, CHARINDEX(',', REVERSE(failureReason), 2)-1) END
        FROM	JMBkpStats WITH (NOLOCK)
        WHERE	servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
            AND opType IN (60/*SNAPTOTAPE*/) AND failureErrorCode <> 8
            AND (@IncludeAged = 1 OR dataStatus = 0)
			AND bkpLevel = CASE WHEN @BackupType = 'FULL' THEN 1
							WHEN @BackupType = 'INCR' THEN 2
							ELSE bkpLevel
						END
    ELSE
    BEGIN
        INSERT INTO #JobDetails
        SELECT	jobId, commCellId, appId, appType, CASE WHEN dataArchGrpId > 0 THEN dataArchGrpId ELSE logArchGrpId END,
                opType, bkpLevel, CASE displayStatus WHEN 0 THEN status ELSE displayStatus END,
                servStartDate + @TimeZoneBias, servEndDate + @TimeZoneBias,
                scanType, percentageChange, totalWriteTime, totalNumOfFiles,
                scanFileFailures + backupFileFailures, scanFolderFailures + backupFolderFailures,
                totalUncompBytes,
                CASE WHEN totalUncompBytes > 0 AND (totalUncompBytes > totalCompBytes) THEN 1.0*(totalUncompBytes - totalCompBytes)/totalUncompBytes
                     ELSE 0	END,
                nwTransBytes, 0, 0, 0, 0, '', '',
                CASE WHEN CHARINDEX(',', failureReason) = LEN(failureReason) THEN failureReason
                     ELSE RIGHT(failureReason, CHARINDEX(',', REVERSE(failureReason), 2)-1) END
        FROM	JMBkpStats WITH (NOLOCK)
        WHERE	servEndDate > @TimeRangeBegin AND servStartDate < @TimeRangeEnd
            AND opType IN (60/*SNAPTOTAPE*/) AND failureErrorCode <> 8
            AND (@IncludeAged = 1 OR dataStatus = 0)
			AND bkpLevel = CASE WHEN @BackupType = 'FULL' THEN 1
							WHEN @BackupType = 'INCR' THEN 2
							ELSE bkpLevel
						END
        UNION ALL
        SELECT	J.jobId, J.commCellId, B.applicationId, A.appTypeId, CASE WHEN B.dataPolicy > 0 THEN B.dataPolicy ELSE B.logPolicy END,
                J.opType, B.bkpLevel, 0, J.jobStartTime + @TimeZoneBias, -1,
                B.scanType, 0,
                ISNULL((SELECT SUM(writeTime) FROM JMBkpAttemptInfo WITH (NOLOCK) WHERE JMBkpAttemptInfo.jobId = J.jobId), 0) +
                ISNULL((SELECT MAX(writeTime) FROM JMJobStreams WITH (NOLOCK) WHERE jobId = J.jobId), 0),
                B.filesXfered,
                B.scanFileFailures + B.backupFileFailures, B.scanFolderFailures + B.backupFolderFailures,
                B.unCompBytes,
                CASE WHEN B.unCompBytes > 0 AND (B.unCompBytes > B.compBytes) THEN 1.0*(B.unCompBytes - B.compBytes)/B.unCompBytes
                     ELSE 0	END,
                B.nwTransBytes, 0, 0, 0, 0, '', '',
                CASE WHEN CHARINDEX(',', failureReason) = LEN(failureReason) THEN failureReason
                     ELSE RIGHT(failureReason, CHARINDEX(',', REVERSE(failureReason), 2)-1) END
        FROM	JMJobInfo J WITH (NOLOCK)
                INNER JOIN JMBkpJobInfo B WITH (NOLOCK) ON J.jobId = B.jobId
                INNER JOIN APP_Application A WITH (NOLOCK) ON B.applicationId = A.id
        WHERE	J.jobStartTime < @TimeRangeEnd
            AND J.opType IN (60 /*SNAPTOTAPE*/)
			AND B.bkpLevel = CASE WHEN @BackupType = 'FULL' THEN 1
								WHEN @BackupType = 'INCR' THEN 2
								ELSE B.bkpLevel
							END
    END
END
-- Remove IndexingV2 VSA parent jobs
DELETE	J
FROM	#JobDetails J
		INNER JOIN #VSA_AppIDs VA ON J.appId = VA.appId AND VA.isIndexingV2 = 1
UPDATE	#JobDetails
SET		SizeOnMedia = A.sizeOnMedia,
		SpaceSaving = CASE WHEN J.TotalUncompBytes > 0 AND (J.TotalUncompBytes > A.sizeOnMedia)
							THEN 1.0*(J.TotalUncompBytes - A.sizeOnMedia)/J.TotalUncompBytes
							ELSE 0 END
FROM	(SELECT	T.jobId, T.commcellId, MAX(T.sizeOnMedia) AS sizeOnMedia
		FROM	(SELECT	S.jobid, S.commcellId, S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
				FROM	JMJobDataStats S WITH (NOLOCK), #JobDetails B
				WHERE	S.commcellId = B.commcellId and S.jobid = B.jobid and S.AuxCopyJobId = 0
				GROUP BY S.jobid, S.commcellId, S.archGrpCopyId) T
		GROUP BY T.jobid, T.commcellId) A
		INNER JOIN #JobDetails J ON J.jobId = A.jobId AND J.CommCellId = A.commCellId
--------------------------------------------
-- Retrieve application size of VMs       --
--------------------------------------------
CREATE	TABLE #JobVMs (
	jobId INT, commCellId INT, appId INT, bkpLevel INT,
	startDate INT, endDate INT, vmClientId INT,
	vmStatus INT, vmFailureReason VARCHAR(512),
	vmAppSize BIGINT, vmGuestSize BIGINT, vmSize BIGINT
)
INSERT INTO #JobVMs
SELECT	JobId, CommCellId, J.AppId, BkpLevel, StartDate, EndDate, 0, 0, '', 0, 0, 0
FROM	#JobDetails J
		INNER JOIN #VSA_AppIDs VA ON J.appId = VA.appId AND VA.isIndexingV2 = 0
WHERE	AppTypeId = 106
IF EXISTS (SELECT 1 FROM #JobVMs)
BEGIN
	CREATE INDEX JobVMs_jobId_commCellId_idx ON #JobVMs (jobId, commCellId)
	-- Populate #JobVMs table for VMs and remove initial entries (with vmClientId = 0)
	EXEC AppSizeOfJobVMs 0
	INSERT INTO #JobDetails
	SELECT	J.JobId, J.CommCellId, J.AppId, J.AppTypeId, J.archGrpId, J.OpType, J.BkpLevel, J.Status,
			CASE WHEN V.startDate > 0 THEN V.startDate + @TimeZoneBias ELSE J.StartDate END,
			CASE WHEN V.endDate > 0 THEN V.endDate + @TimeZoneBias ELSE J.EndDate END,
			J.ScanType, J.SizeChangePct, J.TotakWriteTime, J.ProtectedObjects, J.FailedObjects, J.FailedFolders,
			CASE WHEN T.vmAppSize > 0 THEN (1.0*V.vmAppSize/T.vmAppSize)*J.TotalUncompBytes ELSE 0 END,
			J.CompressionRate,
			CASE WHEN T.vmAppSize > 0 THEN (1.0*V.vmAppSize/T.vmAppSize)*J.NwTransBytes ELSE 0 END,
			CASE WHEN T.vmAppSize > 0 THEN (1.0*V.vmAppSize/T.vmAppSize)*J.SizeOnMedia ELSE 0 END,
			J.SpaceSaving, V.vmClientId, V.vmStatus, V.vmFailureReason, J.FailureCode, J.FailureReason
	FROM	#JobDetails J
			INNER JOIN #JobVMs V ON J.JobId = V.jobId AND J.CommCellId = V.commCellId
			INNER JOIN (SELECT	jobId, commCellId, SUM(vmAppSize) AS vmAppSize
						FROM	#JobVMs
						GROUP BY jobId, commCellId) T ON J.JobId = T.jobId AND J.CommCellId = T.commCellId
	DELETE	#JobDetails
	FROM	(SELECT DISTINCT jobId, commCellId FROM #JobVMs) T
	WHERE	#JobDetails.JobId = T.jobId AND #JobDetails.CommCellId = T.commCellId AND #JobDetails.vmClientId = 0
END
DROP TABLE #JobVMs
DROP TABLE #VSA_AppIDs
--------------------------------------------
-- End of Retrieving application size of VMs
--------------------------------------------
UPDATE	#JobDetails
SET		FailureCode = CAST(C.SubsystemID AS NVARCHAR(12)) + ':' + CAST(C.MessageNum AS NVARCHAR(16)),
		FailureReason = LEFT(dbo.JMGetLocalizedMessageFunc(0, A.FailureReason), 512)
FROM	#JobDetails A
		INNER JOIN JMFailureReasonMsg B WITH (NOLOCK) ON CAST(LEFT(A.FailureReason, LEN(A.FailureReason)-1) AS INT) = B.id
		INNER JOIN EvLocaleMsgs C WITH (NOLOCK) ON B.messageId = C.MessageID AND C.LocaleID = 0
WHERE	A.FailureReason <> ''
CREATE TABLE #ClientGroupsString (clientId INT, clientGroups NVARCHAR(MAX))
EXEC GetClientGroupsString 0
SELECT	CL.name	AS 'Client',
		T.name AS 'Agent',
		I.name AS 'Instance',
		BS.name AS 'Backupset',
		A.subclientName AS 'Subclient',
		J.JobId AS 'Job Id',
		CASE J.Status
			WHEN -1 THEN 'Running'
			WHEN -2 THEN 'Pending'
			WHEN -3 THEN 'Waiting'
			WHEN -4 THEN 'Running'
			WHEN -5 THEN 'Suspended'
			WHEN -6 THEN 'Kill Pending'
			WHEN -7 THEN 'Suspend Pending'
			WHEN -8 THEN 'Interrupt Pending'
			WHEN -9 THEN 'Running'
			WHEN -10 THEN 'Failed'
			WHEN -11 THEN 'Killed'
			WHEN -12 THEN 'Running'
			WHEN -13 THEN 'System Kill Pending'
			WHEN -14 THEN 'Suspended'
			WHEN -15 THEN 'Queued'
			WHEN -16 THEN 'Queued'
			WHEN -17 THEN 'Running (Cannot be verified)'
			WHEN -18 THEN 'Abnormally Terminated Cleanup'
			WHEN 0 THEN 'Running'
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Failed'
			WHEN 3 THEN 'Completed with errors'
			WHEN 4 THEN 'Killed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Interrupted'
			WHEN 6 THEN 'Any Status'
			WHEN 8 THEN 'Skipped'
			WHEN 9 THEN 'Failed To Start'
			WHEN 10 THEN 'Synchronized'
			WHEN 11 THEN 'Not Synchronized'
			WHEN 12 THEN 'Not Attempted'
			WHEN 13 THEN 'Started'
			WHEN 14 THEN 'Completed with warnings'
			WHEN 15 THEN 'System Failed'
			WHEN 16 THEN 'Committed'
			ELSE 'Unknown'
		END AS 'Job Status',
		CASE WHEN J.vmClientId > 0 THEN ISNULL((SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = J.vmClientId), 'N/A')
			 WHEN A.appTypeId = 106 THEN CL.name ELSE 'N/A' END AS 'VM',
		CASE
			WHEN J.vmClientId <= 0 THEN 'N/A'
			WHEN J.BkpLevel IN (64, 128, 16384) THEN (CASE J.Status WHEN 1 THEN 'Completed' ELSE 'N/A' END)
			ELSE (CASE J.vmStatus
					WHEN 0 THEN 'Completed'
					WHEN 1 THEN 'Failed'
					WHEN 2 THEN 'In Progress'
					WHEN 3 THEN 'Completed with warnings'
					WHEN 4 THEN 'Waiting'
					ELSE (CASE WHEN J.Status IN (1,2,3) THEN 'Failed' WHEN J.Status = 4 THEN 'Killed' ELSE 'N/A' END)
				  END)
		END AS 'VM Status',
		CASE WHEN J.vmClientId > 0
			 THEN REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(J.vmFailureReason,
				',',' '), CHAR(10),';'), CHAR(13),';'), '''',' '), CHAR(145),' '), CHAR(146),' '), '<BR>','')
			 ELSE 'N/A'
		END AS 'VM Failure Reason',
		CASE J.opType
			WHEN 4 THEN (CASE WHEN A.appTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
			WHEN 14 THEN N'Synthetic Full'
			WHEN 18 THEN N'Backup 3RD'
			WHEN 59 THEN N'Snap Backup'
			WHEN 60 THEN N'Backup Copy'
			WHEN 65 THEN N'Snap Backup3RD'
			ELSE N'Unknown'
		END AS 'Operation',
		CASE J.BkpLevel
			WHEN 1 THEN (CASE WHEN A.appTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
			WHEN 2 THEN (CASE WHEN A.appTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN A.appTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
			WHEN 4 THEN (CASE WHEN A.appTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
			WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
			WHEN 0x100   THEN (CASE WHEN A.appTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
			WHEN 0x200   THEN N'ASR'
			WHEN 0x800   THEN N'Snapshot'
			WHEN 0x1000  THEN N'New Volume Creation'
			WHEN 0x2000  THEN N'Incremental Volume Update'
			WHEN 0x400   THEN N'Offline Full'
			WHEN 0x20000 THEN N'Analysis'
			WHEN 0x40000 THEN N'Discovery'
			ELSE N'Unknown'
		END AS 'Job Type',
		CASE J.ScanType
			WHEN 1 THEN 'Change Journal'
			WHEN 2 THEN 'Classic'
			WHEN 3 THEN 'Mixed'
			WHEN 4 THEN 'Optimized Scan'
			ELSE 'N/A'
		END AS 'Scan Type',
		CONVERT(VARCHAR(10), DATEADD(ss, J.StartDate, '1970-01-01'), 101) AS 'Start Date',
		CONVERT(VARCHAR(10), DATEADD(ss, J.StartDate, '1970-01-01'), 108) AS 'Start Time',
		CASE J.EndDate
			WHEN -1 THEN 'N/A'
			ELSE CONVERT(VARCHAR(10), DATEADD(ss, J.EndDate, '1970-01-01'), 101)
		END AS 'End Date',
		CASE J.EndDate
			WHEN -1 THEN 'N/A'
			ELSE CONVERT(VARCHAR(10), DATEADD(ss, J.EndDate, '1970-01-01'), 108)
		END AS 'End Time',
		CAST(J.TotalUncompBytes/1024.0/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size (GB)',
		CAST(100.0*J.CompressionRate AS DECIMAL(10,2)) AS 'Compression Rate (%)',
		CAST(J.NwTransBytes/1024.0/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred (GB)',
		CAST(J.SizeOnMedia/1024.0/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written (GB)',
		CAST(100.0*J.SpaceSaving AS DECIMAL(10,2)) AS 'Space Saving (%)',
		J.SizeChangePct AS 'Data Size Change (%)',
		CONVERT(VARCHAR(20), DATEADD(SECOND, J.TotakWriteTime, 0), 108) AS 'Transfer Time',
		CAST((CASE WHEN J.TotakWriteTime > 0 THEN 3600.0*J.TotalUncompBytes/1024.0/1024.0/1024.0/J.TotakWriteTime ELSE 0.0 END)
			AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)',
		CASE WHEN J.vmClientId > 0 THEN (CASE WHEN J.vmStatus = 0 THEN 1 ELSE 0 END) ELSE J.ProtectedObjects END AS 'Protected Objects',
		CASE WHEN J.vmClientId > 0 THEN (CASE WHEN J.vmStatus = 0 THEN 0 ELSE 1 END) ELSE J.FailedObjects END AS 'Failed Objects',
		CASE WHEN J.vmClientId > 0 THEN 0 ELSE J.FailedFolders END AS 'Failed Folders',
		J.FailureCode AS 'Failure Code',
		REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(J.FailureReason,
				',',' '), CHAR(10),';'), CHAR(13),';'), '''',' '), CHAR(145),' '), CHAR(146),' '), '<BR>','') AS 'Failure Reason',
		ISNULL(AG.name, 'N/A') AS 'Storage Policy',
		COALESCE(CG1.ClientGroups, CG2.ClientGroups, 'N/A') AS 'Client Group'
FROM	#JobDetails J
		INNER JOIN APP_Application A WITH (NOLOCK) ON J.AppId = A.id
		INNER JOIN APP_Client CL WITH (NOLOCK) ON A.clientId = CL.id
		INNER JOIN APP_iDAType T WITH (NOLOCK) ON A.appTypeId = T.type
		INNER JOIN APP_InstanceName I WITH (NOLOCK) ON A.instance = I.id
		INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON A.backupSet = BS.id
		LEFT OUTER JOIN archGroup AG ON J.ArchGrpId = AG.id
		LEFT OUTER JOIN #ClientGroupsString CG1 ON (J.vmClientId > 0 AND J.vmClientId = CG1.ClientId)
		LEFT OUTER JOIN #ClientGroupsString CG2 ON (J.vmClientId = 0 AND A.clientId = CG2.ClientId)
ORDER BY (CASE WHEN @OrderBy = 'JobID' THEN J.JobId ELSE 0 END) DESC,
		(CASE WHEN @OrderBy = 'Agent' THEN T.name ELSE '' END),
		CL.name, T.name, I.name, BS.name, A.subclientName, J.JobId DESC, J.StartDate
DROP TABLE #ClientGroupsString
DROP TABLE #JobDetails
DROP TABLE #opTypes
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DataProtectionJobSummary')
	delete from GxQscripts where name = 'QS_DataProtectionJobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataProtectionJobSummary')
	delete from GXDBVersions where aliasname = 'QS_DataProtectionJobSummary'
GO

insert into GXDBVersions values(2, 'QS_DataProtectionJobSummary',  '00010001008800110000', 'QS_DataProtectionJobSummary', '00010001008800110000')
GO

insert into GxQscripts values(2,'QS_DataProtectionJobSummary',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--   qoperation execscript -sn QS_DataProtectionJobSummary [-si @FromTime = ''''] [-si @ToTime = ''''] [-si @LastNDays = ''1''] [-si @IncludeAged = ''1''] [-si @IncludeRunning = ''1''] [-si @BackupType = ''''] [-si @OrderBy = ''JobID''] [-si @IncludeCommandLine = ''0''] [-si @IncludeOneTouch = ''0''] '
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '--     qoperation execscript -sn QS_DataProtectionJobSummary -si ''2013-09-01'' -si ''2013/09/30 23:59:59'''
 + CHAR(10) + '--     qoperation execscript -sn QS_DataProtectionJobSummary -si @LastNDays = ''7'''
 + CHAR(10) + '
'
 + CHAR(10) + '  Parameters:
'
 + CHAR(10) + '    1. Time range can be specified by either FromTime and ToTime or by LastNDays. Default is last 1 day.
'
 + CHAR(10) + '       FromTime and ToTime should be in ''mm/dd/yyyy hh:mm:ss'' or ''yyyy-mm-dd hh:mm:ss'' format.
'
 + CHAR(10) + '    2. Default is IncludeAged = 1 for including aged jobs.
'
 + CHAR(10) + '    3. Default is IncludeRunning = 1 for including jobs that are running but not completed in the given time range.
'
 + CHAR(10) + '    4. BackupType can be ''Full'' or ''Incr''. Default is '''' for all backup types.
'
 + CHAR(10) + '    5. OrderBy can be ''JobID'', ''Client'' or ''Agent''. Default is descending order of JobID.
'
 + CHAR(10) + '    6. Both Include CommandLine & Include 1-Touch default to ''No'' (0) for compatibility with previous versions of this command.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  Output:
'
 + CHAR(10) + '    1. It returns data protection (Backup, Snap and Archive) jobs ended in the given time range.
'
 + CHAR(10) + '    2. Active jobs that were running in the given time range are also included.
'
 + CHAR(10) + '    3. Jobs of Virtual Server Agent are shown for each VMs.
'
)
GO

