

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DataProtectionCoverage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DataProtectionCoverage <<<'

IF EXISTS (select * from sysobjects where name='QS_DataProtectionCoverage')
	drop procedure QS_DataProtectionCoverage
IF EXISTS (select * from GxQscripts where name='QS_DataProtectionCoverage')
	delete from GxQscripts where name = 'QS_DataProtectionCoverage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataProtectionCoverage')
	delete from GXDBVersions where aliasname = 'QS_DataProtectionCoverage'
GO
print '... Creating Procedure: QS_DataProtectionCoverage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DataProtectionCoverage
-- Qscript is Enabled
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @nLastDays INTEGER		= 7,
  @bSummary INTEGER		= 0
AS
SET NOCOUNT ON
DECLARE @csTimeZoneName NVARCHAR(255) = (SELECT timeZone FROM APP_CommCell WHERE id = 2)
SELECT  @csTimeZoneName = TimeZoneStdName
FROM    SchedTimeZone WITH (NOLOCK)
WHERE   TimeZoneName = SUBSTRING(@csTimeZoneName, CHARINDEX(':', @csTimeZoneName, CHARINDEX(':', @csTimeZoneName, 0) + 1) + 1, 255)
DECLARE	@Today		DATETIME = DATEDIFF(DAY, 0, GETDATE())
DECLARE	@StartTime	INT
SET	@StartTime = dbo.GetUnixTime(DATEADD(DAY, -@nLastDays, @Today))
CREATE TABLE #tblSubclient (ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, SubclientName NVARCHAR(128),
							ClientGroupList NVARCHAR(MAX), BackupScheduled INT, Deconfigured INT, Disabled INT)
INSERT	INTO #tblSubclient
SELECT	A.clientId, A.appTypeId, A.instance, A.backupSet, A.id, A.SubclientName, '', 0,
		CASE WHEN (A.subclientStatus & 6) = 0 THEN 0 ELSE 1 END AS Deconfigured, 0
FROM	APP_Application A WITH (NOLOCK)
WHERE	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1
	AND A.id NOT IN (SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName = 'DDB Backup' AND attrVal <> '0' AND modified = 0)
	AND A.clientId NOT IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1')
UPDATE	#tblSubclient
SET		Disabled = 1
FROM	#tblSubclient S INNER JOIN JMJobAction J WITH (NOLOCK)
	ON	J.opType IN (4, 14, 76) AND J.action = 1 AND (J.clientId = S.ClientId AND J.appType IN (S.AppTypeId, 0) OR J.appId = S.AppId)
CREATE INDEX Idx_tblSubclient_ClientId ON #tblSubclient(ClientId)
CREATE INDEX Idx_tblSubclient_AppId ON #tblSubclient(AppId)
CREATE TABLE #tblSubclientAggr (AppId INT, nSuccessfulJobs INT, nUnsuccessfulJobs INT, ScanStarted INT, ScanCompleted INT, DataTransfer INT,
		LastSuccessfulJobID INT, LastJobID INT, LastJobType INT, LastJobStartTime INT, LastJobEndTime INT, LastJobStatus INT,
		LastJobAppSize BIGINT, LastJobFailureReason VARCHAR(256))
INSERT	INTO #tblSubclientAggr
SELECT	S.AppId,
		SUM(CASE WHEN B.jobId IS NOT NULL AND B.status IN (1, 3, 14) THEN 1 ELSE 0 END),
		SUM(CASE WHEN B.jobId IS NOT NULL AND B.status NOT IN (1, 3, 14) THEN 1 ELSE 0 END),
		0, 0, 0,
		MAX(CASE WHEN B.status IN (1, 3, 14) THEN B.jobId ELSE 0 END),
		MAX(B.jobId),
		0, 0, 0 ,0, 0, ''
FROM	#tblSubclient S INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.appId = S.AppId
WHERE	B.servEndDate > @StartTime AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768) AND B.commCellId = 2
GROUP BY S.AppId
IF	@bSummary = 1
BEGIN
	SELECT	ClientGroup = 'All',
			Category	= CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
						  WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
						  ELSE 'Not Protected' END,
			Counts		= COUNT(*)
	FROM	#tblSubclient S
			LEFT OUTER JOIN #tblSubclientAggr A ON A.AppId = S.AppId
			INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = S.ClientId
			INNER JOIN APP_InstanceName INST WITH (NOLOCK) ON INST.id = S.InstanceId
	WHERE	CL.origCCId NOT IN (SELECT id FROM APP_CommCell WITH (NOLOCK) WHERE type > 1) AND (INST.status & 2048) = 0
	GROUP BY CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
				  WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
				  ELSE 'Not Protected' END
	UNION
	SELECT	ClientGroup	= ISNULL(CG.name, ''),
			Category	= CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
					 	  WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
						  ELSE 'Not Protected' END,
			Counts		= COUNT(*)
	FROM	#tblSubclient S
			LEFT OUTER JOIN #tblSubclientAggr A ON A.AppId = S.AppId
			INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = S.ClientId
			INNER JOIN APP_InstanceName INST WITH (NOLOCK) ON INST.id = S.InstanceId
			LEFT OUTER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CGA.clientId = S.ClientId
			LEFT OUTER JOIN APP_ClientGroup CG WITH (NOLOCK) ON CG.id = CGA.clientGroupId
	WHERE	CL.origCCId NOT IN (SELECT id FROM APP_CommCell WITH (NOLOCK) WHERE type > 1) AND (INST.status & 2048) = 0
	GROUP BY ISNULL(CG.name, ''),
			CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
				 WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
				 ELSE 'Not Protected' END
END
ELSE
BEGIN
	UPDATE	#tblSubclient
	SET		ClientGroupList = CG.ClientGroups
	FROM	#tblSubclient SC
			INNER JOIN ClientGroupsStringView CG ON CG.ClientId = SC.ClientId
	CREATE TABLE #tblBackupTask (ClientGroupId INT, ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT)
	INSERT	INTO #tblBackupTask
	SELECT	DISTINCT AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId
	FROM	TM_AssocEntity AE WITH (NOLOCK)
	        INNER JOIN TM_SubTask ST WITH (NOLOCK) ON AE.taskId = ST.taskId
	        INNER JOIN TM_SubTaskOptions STO WITH (NOLOCK) ON STO.subTaskId = ST.SubTaskId
	        INNER JOIN TM_Task T WITH (NOLOCK) ON T.taskId = ST.taskId
WHERE	STO.optionId = 458405394 AND STO.value IN ('1', '2', '3', '6')
		AND ST.subTaskType = 2
		AND T.disabled = 0
		AND (AE.clientGroupId = 0 AND AE.taskId NOT IN (SELECT DISTINCT taskId FROM TM_AssocFilter WITH (NOLOCK) WHERE filter_type = 2 AND filter_value = 124)
		  OR AE.clientGroupId > 0 AND AE.taskId NOT IN (SELECT taskId FROM TM_Task WITH (NOLOCK) WHERE taskName = 'System Created for Content Store' AND taskType = 4))
	DECLARE @clientOnlineTime TABLE (ClientId INT, LastOnlineTime INT)
	DECLARE @csClientId  int
	SET @csClientId = (SELECT distinct ClientID From APP_CommCell WHERE id = 2)
	INSERT INTO @clientOnlineTime
	SELECT  C.id, MAX(LastOnlineTime)
	FROM	CCRClientToClient CCR WITH (NOLOCK)
			INNER JOIN APP_Client C WITH (NOLOCK) ON CCR.FromClientID = @csClientId AND CCR.ToClientID = C.id
	GROUP BY C.id
	UPDATE	#tblSubclient
	SET		BackupScheduled = 1
	FROM	#tblSubclient S, #tblBackupTask T
	WHERE (	T.ClientId = 0 AND T.ClientGroupId = 0
		OR	T.ClientId > 0 AND S.ClientId = T.ClientId
			AND S.AppTypeId IN (T.AppTypeId, 0) AND S.InstanceId IN (T.InstanceId, 0) AND S.BackupsetId IN (T.BackupsetId, 0) AND S.AppId IN (T.AppId, 0) )
	UPDATE	#tblSubclient
	SET		BackupScheduled = 1
	FROM	#tblSubclient S, APP_ClientGroupAssoc CGA WITH (NOLOCK),
			(SELECT ClientGroupId FROM #tblBackupTask WHERE ClientId = 0 AND ClientGroupId > 0) T
	WHERE	S.BackupScheduled = 0 AND S.ClientId = CGA.clientId AND CGA.ClientGroupId = T.ClientGroupId
	DROP TABLE #tblBackupTask
	UPDATE	#tblSubclientAggr
	SET		LastJobId = LastSuccessfulJobID
	WHERE	LastSuccessfulJobID > 0
	UPDATE	#tblSubclientAggr
	SET		LastJobStartTime = B.servStartDate, LastJobEndTime = B.servEndDate,
			LastJobType = B.bkpLevel, LastJobStatus = B.status,
			LastJobAppSize = B.totalUncompBytes, LastJobFailureReason = B.failureReason
	FROM	#tblSubclientAggr S INNER JOIN JMBkpStats B WITH (NOLOCK)
		ON B.jobId = S.LastJobId AND B.commCellId = 2
	UPDATE	#tblSubclientAggr
	SET		ScanStarted		= CASE WHEN Y.ScanStarted > 0 THEN 1 ELSE 0 END,
			ScanCompleted	= CASE WHEN Y.ScanCompleted > 0 THEN 1 ELSE 0 END,
			DataTransfer	= CASE WHEN Y.DataTransfer > 0 THEN 1 ELSE 0 END
	FROM	#tblSubclientAggr X,
			(SELECT	S.AppId,
					COUNT(B.jobId) AS ScanStarted,
					SUM(CASE WHEN A.status = 1 THEN 1 ELSE 0 END) AS ScanCompleted,
					SUM(A.nwTransBytes) AS DataTransfer
			FROM	#tblSubclientAggr S
			INNER JOIN JMBkpStats B WITH (NOLOCK)
				ON	B.appId = S.AppId
			INNER JOIN JMBkpAtmptStats A WITH (NOLOCK)
				ON	A.jobId = B.jobId AND A.commCellId = B.commCellId
			WHERE	B.servEndDate > @StartTime AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768) AND B.commCellId = 2
			GROUP BY S.AppId) Y
	WHERE	X.AppId = Y.AppId
	SELECT	Client				= CL.name,
			ClientGroup			= S.ClientGroupList,
			ClientDescription	= CL.clientDescription,
			Agent				= IDA.name,
			Instance			= dbo.FixInstanceName(INST.name, S.AppTypeId),
			Backupset			= BSN.name,
			Subclient			= S.SubclientName,
			Category			= CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
								  WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
								  ELSE 'Not Protected' END,
			SLA_Reason			= CASE WHEN S.Deconfigured > 0			THEN 'Deconfigured'
								  WHEN S.Disabled > 0				THEN 'Backup Disabled'
								  WHEN CL.clientDescription LIKE '%offline%'	THEN 'Offline'
								  WHEN ISNULL(A.nSuccessfulJobs, 0) > 0		THEN 'Protected'
								  WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 AND ISNULL(A.DataTransfer, 0) > 0
																			THEN 'Backup Failed With Transferred Data'
								  WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 AND ISNULL(A.ScanCompleted, 0) = 1 AND ISNULL(A.DataTransfer, 0) = 0
																			THEN 'Backup Failed Without Transferred Data'
								  WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 AND ISNULL(A.ScanStarted, 0) = 1 AND ISNULL(A.ScanCompleted, 0) = 0
																			THEN 'Backup Scan Phase Not Completed'
								  WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 AND ISNULL(A.ScanStarted, 0) = 0
																			THEN 'Backup Scan Phase Not Started'
								  WHEN ISNULL(A.nUnsuccessfulJobs, 0) = 0 AND S.BackupScheduled = 1
																			THEN 'Backup May Be Scheduled At A Later Time'
								  WHEN ISNULL(A.nUnsuccessfulJobs, 0) = 0 AND S.BackupScheduled = 0
																			THEN 'Backup Not Scheduled'
								  ELSE 'Not Protected' END,
			Scheduled			= CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 THEN 'N/A' WHEN S.BackupScheduled = 1 THEN 'Yes' ELSE 'NO' END,
			SuccessfulJobs		= ISNULL(A.nSuccessfulJobs, 0),
			UnsuccessfulJobs	= ISNULL(A.nUnsuccessfulJobs, 0),
			LastBackupJobID		= ISNULL(A.LastJobID, 0),
			LastBackupType		= CASE WHEN ISNULL(A.LastJobType, 0) = 0 THEN 'N/A'
								  ELSE dbo.GetJobBackupTypeDisplay(A.LastJobType) END,
			LastJobStartTime	= CASE WHEN ISNULL(A.LastJobStartTime, 0) = 0 THEN 'N/A'
								  ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(A.LastJobStartTime), @csTimeZoneName) END,
			LastJobEndTime		= CASE WHEN ISNULL(A.LastJobEndTime, 0) = 0 THEN 'N/A'
								  ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(A.LastJobEndTime), @csTimeZoneName) END,
			LastJobStatus		= CASE WHEN ISNULL(A.LastJobStatus, 0) = 0 THEN 'No Run'
								  WHEN A.LastJobStatus = 1  THEN 'Completed'
								  WHEN A.LastJobStatus = 3  THEN 'Completed With Errors'
								  WHEN A.LastJobStatus = 14 THEN 'Completed With Warnings'
								  WHEN A.LastJobStatus IN (2, 9)  THEN 'Failed'
								  WHEN A.LastJobStatus IN (4, 15) THEN 'Killed' END,
			LastJobAppSizeGB	= CAST(ROUND(ISNULL(A.LastJobAppSize, 0)/1024.0/1024.0/1024.0, 2) AS DECIMAL(10, 2)),
			LastJobFailureReason= dbo.JMGetLocalizedMessageFunc(0, ISNULL(A.LastJobFailureReason, '')),
			LastOnlineTime		= CASE WHEN ISNULL(clTime.LastOnlineTime, 0) = 0 THEN 'N/A'
								  ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(clTime.LastOnlineTime), @csTimeZoneName) END
	FROM	#tblSubclient S
			LEFT OUTER JOIN #tblSubclientAggr A ON A.AppId = S.AppId
			INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = S.ClientId
			INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = S.AppTypeId
			INNER JOIN APP_InstanceName INST WITH (NOLOCK) ON INST.id = S.InstanceId
			INNER JOIN APP_BackupsetName BSN WITH (NOLOCK) ON BSN.id = S.BackupsetId
			LEFT OUTER JOIN @clientOnlineTime clTime ON clTime.ClientId = S.ClientId
	WHERE	CL.origCCId NOT IN (SELECT id FROM APP_CommCell WITH (NOLOCK) WHERE type > 1) AND (INST.status & 2048) = 0
	ORDER BY S.Deconfigured DESC,
			S.Disabled DESC,
			CASE WHEN CL.clientDescription LIKE '%offline%' THEN 1 ELSE 0 END DESC,
			(CASE WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 2 WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 THEN 1 ELSE 0 END),
			ISNULL(A.DataTransfer, 0) DESC,
			ISNULL(A.ScanCompleted, 0) DESC,
			ISNULL(A.ScanStarted, 0) DESC,
			S.BackupScheduled DESC,
			CL.name,
			IDA.name,
--			dbo.FixInstanceName(INST.name, S.AppTypeId),
			BSN.name,
			S.SubclientName
END
DROP TABLE #tblSubclient
DROP TABLE #tblSubclientAggr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DataProtectionCoverage')
	delete from GxQscripts where name = 'QS_DataProtectionCoverage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataProtectionCoverage')
	delete from GXDBVersions where aliasname = 'QS_DataProtectionCoverage'
GO

insert into GXDBVersions values(2, 'QS_DataProtectionCoverage',  '00000000000000000000', 'QS_DataProtectionCoverage', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DataProtectionCoverage',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_DataProtectionCoverage '
 + CHAR(10) + '--  -                    [-si @nLastDays = ''7'']'
 + CHAR(10) + '--  -                    [-si @bSummary = ''0'']'
 + CHAR(10) + '--  - '
 + CHAR(10) + '--  Options: @nLastDays   : A valid positive integer. Otherwise use default value 7.'
 + CHAR(10) + '--  -        @bSummary    : 0 or 1. Otherwise use default value 0.'
)
GO

