

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DataInterfacePairConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DataInterfacePairConfig.sp,v $ $Id: QS_DataInterfacePairConfig.sp,v 1.5.42.5 2019/01/04 20:07:42 pparvatham Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DataInterfacePairConfig')
BEGIN
	print '>>> Drop Stored Procedure: QS_DataInterfacePairConfig <<<'
	drop procedure QS_DataInterfacePairConfig
END
IF EXISTS (select * from GxQscripts where name='QS_DataInterfacePairConfig')
	delete from GxQscripts where name = 'QS_DataInterfacePairConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataInterfacePairConfig')
	delete from GXDBVersions where aliasname = 'QS_DataInterfacePairConfig'
GO
print '... Creating Procedure: QS_DataInterfacePairConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DataInterfacePairConfig
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM_1 varchar(1024)='',
  @PARAM_2 varchar(1024)='',
  @PARAM_3 varchar(1024)='',
  @PARAM_4 varchar(1024)='',
  @PARAM_5 varchar(1024)=''
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'DataInterfacePairConfig'
DECLARE @lastError				integer
SET		@lastError				= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @Option_Add				varchar(1024)
SET		@Option_Add				= 'Add'
DECLARE @Option_Enable			varchar(1024)
SET		@Option_Enable			= 'Enable'
DECLARE @Option_Disable			varchar(1024)
SET		@Option_Disable			= 'Disable'
DECLARE @Option_Delete			varchar(1024)
SET		@Option_Delete			= 'Delete'
DECLARE @Option_DeleteByClient	varchar(1024)
SET		@Option_DeleteByClient	= 'DeleteByClient'
DECLARE @Option_DeleteAll		varchar(1024)
SET		@Option_DeleteAll		= 'DeleteAll'
DECLARE @Option_ListByClient	varchar(1024)
SET		@Option_ListByClient	= 'ListByClient'
DECLARE @Option_ListAll			varchar(1024)
SET		@Option_ListAll			= 'ListAll'
DECLARE @client_name			varchar(1024)
DECLARE @M1_client_name			varchar(1024)
DECLARE @M1_interface			varchar(1024)
DECLARE @M2_client_name			varchar(1024)
DECLARE @M2_interface			varchar(1024)
DECLARE @clientId				integer
DECLARE @M1_clientId			integer
DECLARE @M2_clientId			integer
DECLARE @Default_destGroupId	integer = 0
DECLARE @pipeline_id 			integer = 0
DECLARE @isActive 				integer = 0
DECLARE @createTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
IF @PARAM_1 = @Option_DeleteAll OR @PARAM_1 = @Option_ListAll
BEGIN
	IF @PARAM_2 <> @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error. Too many arguments.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
ELSE
IF @PARAM_1 = @Option_DeleteByClient OR @PARAM_1 = @Option_ListByClient
BEGIN
	SET @client_name = @PARAM_2
	SET @clientId = ISNULL((select C.Id from APP_Client C where C.name = @client_name), 0)
	if @client_name = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Missing client name input.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @clientId = 0
	BEGIN
		SET @localErrorMsg = 'Error.  Client ['+ @client_name + '] does not exist.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	IF @PARAM_3 <> @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error. Too many arguments.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
ELSE
IF @PARAM_1 = @Option_Add OR @PARAM_1 = @Option_Delete OR @PARAM_1 = @Option_Disable OR @PARAM_1 = @Option_Enable
BEGIN
	SET @M1_client_name			= @PARAM_2
	SET @M1_interface			= @PARAM_3
	SET @M2_client_name			= @PARAM_4
	SET @M2_interface			= @PARAM_5
	SET @M1_clientId = ISNULL((select C.Id from APP_Client C where C.name = @M1_client_name), 0)
	SET @M2_clientId = ISNULL((select C.Id from APP_Client C where C.name = @M2_client_name), 0)
	if @M1_client_name = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Missing client name input.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @M1_clientId = 0
	BEGIN
		SET @localErrorMsg = 'Error.  Client ['+ @M1_client_name + '] does not exist.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @M1_interface = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Interface for Client ['+ @M1_client_name +'] was not supplied as an input.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @M2_client_name = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Missing second client name input.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @M2_clientId = 0
	BEGIN
		SET @localErrorMsg = 'Error.  Client ['+ @M2_client_name + '] does not exist.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @M2_interface = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Interface for Client ['+ @M2_client_name +'] was not supplied as an input.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @M1_clientId = @M2_clientId
	BEGIN
		SET @localErrorMsg = 'Error.  The two input client names should be different.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	if @M1_interface = @M2_interface
	BEGIN
		SET @localErrorMsg = 'Error.  The two input client interfaces should be different.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
ELSE
BEGIN
		SET @localErrorMsg = 'Error.  Invalid option  [' + @PARAM_1 + '] for the script.'
		Set @lastError = 1
		goto   ARGS_ERROR
END
BEGIN TRAN
BEGIN TRY
	IF @PARAM_1 = @Option_ListAll
	BEGIN
		SELECT * FROM ArchPipeline WITH (NOLOCK)
	END
	ELSE
	IF @PARAM_1 = @Option_ListByClient
	BEGIN
		SELECT * FROM ArchPipeline WITH (NOLOCK)
		WHERE srcClientId = @clientId OR destClientId = @clientId
	END
	ELSE
	IF @PARAM_1 = @Option_DeleteAll
	BEGIN
		Delete FROM ArchPipeline
	END
	ELSE
	IF @PARAM_1 = @Option_DeleteByClient
	BEGIN
		Delete FROM ArchPipeline
		WHERE srcClientId = @clientId OR destClientId = @clientId
	END
	ELSE
	IF @PARAM_1 = @Option_Add
	BEGIN
		IF EXISTS (SELECT * FROM ArchPipeline WHERE
				srcClientId = @M1_clientId AND
				srcInterface = @M1_interface AND
				destClientId = @M2_clientId AND
				destInterface = @M2_interface
			OR	srcClientId = @M2_clientId AND
				srcInterface = @M2_interface AND
				destClientId = @M1_clientId AND
				destInterface = @M1_interface)
		BEGIN
			set @lastError = 1
			set @localErrorMsg = 'Fail to add data interface pair because it exists already.'
		END
		ELSE
		BEGIN
			INSERT INTO ArchPipeline ([srcClientId], [srcInterface], [destClientId], [destInterface], [useCount_h], [useCount_l], [isActive], [srcIP], [destIP], [srcGroupId], [destGroupId])
			SELECT @M1_clientId, @M1_interface, @M2_clientId, @M2_interface, 0, 0, 1, '', '', 0,  @Default_destGroupId
			DECLARE @dipId INTEGER = SCOPE_IDENTITY()
			/*
			*   When archPipeline table is modified, we also need to handle entries in archPipelineFirewall table so that commvault network configuration is updated.
				*   Here the inserted dips are from client to client and do not have any wildcards involved. So we are doing a direct insert into the archPipelineFirewall table.
				*   Otherwise we should be constructing the following xml and call AppProcessDips.sp
				*
				*   <App_WildcardDIPWorkqueueParams requestType="1" archpipelineID="1">
				*       <newDIP srcInterface="172*" destInterface="172.16.26.53" srcType="2" destType="0" isActive="1">
				*           <srcClientGroup clientGroupId="5"/>
				*           <destClient clientId="2"/>
				*       </newDIP>
				*   </App_WildcardDIPWorkqueueParams>
				*/
			INSERT INTO ArchPipelineFirewall ([srcClientId], [srcInterface], [destClientId], [destInterface], [created], [modified], [archPipelineId])
			SELECT @M1_clientId, @M1_interface, @M2_clientId, @M2_interface, @createTime, 0, @dipId
		END
	END
	ELSE
	IF @PARAM_1 = @Option_Enable OR @PARAM_1 = @Option_Disable
	BEGIN
		SELECT @pipeline_id=id, @isActive=isActive FROM ArchPipeline WHERE
				srcClientId = @M1_clientId AND
				srcInterface = @M1_interface AND
				destClientId = @M2_clientId AND
				destInterface = @M2_interface
			OR	srcClientId = @M2_clientId AND
				srcInterface = @M2_interface AND
				destClientId = @M1_clientId AND
				destInterface = @M1_interface
		IF @@ROWCOUNT=0
		BEGIN
			set @lastError = 1
			set @localErrorMsg = 'Fail to update data interface pair because it does not exist.'
		END
		ELSE
		BEGIN
			UPDATE ArchPipeline
			SET isActive = case @PARAM_1 when @Option_Enable then 1 else 0 end
			where
				srcClientId = @M1_clientId AND
				srcInterface = @M1_interface AND
				destClientId = @M2_clientId AND
				destInterface = @M2_interface
			OR	srcClientId = @M2_clientId AND
				srcInterface = @M2_interface AND
				destClientId = @M1_clientId AND
				destInterface = @M1_interface
			IF @PARAM_1 = @Option_Enable AND @isActive = 0
			BEGIN
				INSERT INTO ArchPipelineFirewall ([srcClientId], [srcInterface], [destClientId], [destInterface], [created], [modified], [archPipelineId])
				SELECT @M1_clientId, @M1_interface, @M2_clientId, @M2_interface, @createTime, 0, @pipeline_id
			END
			ELSE
			IF @PARAM_1 = @Option_Disable AND @isActive = 1
			BEGIN
			Delete FROM ArchPipelineFirewall
			WHERE	srcClientId = @M1_clientId AND
					srcInterface = @M1_interface AND
					destClientId = @M2_clientId AND
					destInterface = @M2_interface AND
					archPipelineId = @pipeline_id
				OR	srcClientId = @M2_clientId AND
					srcInterface = @M2_interface AND
					destClientId = @M1_clientId AND
					destInterface = @M1_interface AND
					archPipelineId = @pipeline_id
			END
 		END
	END
	ELSE
	IF @PARAM_1 = @Option_Delete
	BEGIN
		Delete FROM ArchPipeline
		WHERE	srcClientId = @M1_clientId AND
				srcInterface = @M1_interface AND
				destClientId = @M2_clientId AND
				destInterface = @M2_interface
			OR	srcClientId = @M2_clientId AND
				srcInterface = @M2_interface AND
				destClientId = @M1_clientId AND
				destInterface = @M1_interface
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = @localErrorMsg + ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DataInterfacePairConfig')
	delete from GxQscripts where name = 'QS_DataInterfacePairConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataInterfacePairConfig')
	delete from GXDBVersions where aliasname = 'QS_DataInterfacePairConfig'
GO

insert into GXDBVersions values(2, 'QS_DataInterfacePairConfig',  '00010005004200050000', 'QS_DataInterfacePairConfig', '00010005004200050000')
GO

insert into GxQscripts values(2,'QS_DataInterfacePairConfig',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn DataInterfacePairConfig -si add|Delete|disable|enable -si clientName_1 -si clientInterface_1 -si clientName_2 -si clientInterface_2'
 + CHAR(10) + '-- 		qoperation execscript -sn DataInterfacePairConfig -si DeleteByClient|listByClient -si clientName'
 + CHAR(10) + '-- 		qoperation execscript -sn DataInterfacePairConfig -si DeleteAll|listAll'
)
GO

