

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DataGrowthSummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DataGrowthSummary <<<'

IF EXISTS (select * from sysobjects where name='QS_DataGrowthSummary')
	drop procedure QS_DataGrowthSummary
IF EXISTS (select * from GxQscripts where name='QS_DataGrowthSummary')
	delete from GxQscripts where name = 'QS_DataGrowthSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataGrowthSummary')
	delete from GXDBVersions where aliasname = 'QS_DataGrowthSummary'
GO
print '... Creating Procedure: QS_DataGrowthSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DataGrowthSummary
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @Frequency VARCHAR(32)	= 'Week',	-- 'Day', 'Week', 'Month'
  @Periods INTEGER		= 8,
  @StartDate VARCHAR(32)	= '',		-- 'mm/dd/yyyy'
  @EndDate VARCHAR(32)	= '',		-- current date
  @MediaType VARCHAR(32) = ''		-- 'Disk', 'Tape' or '' for all
AS
SET NOCOUNT ON
SELECT	DISTINCT CommCell,
		Library,
		LibGrowth_GBDay AS GrowthRate_GBDay,
		LibFreeSpace_GB	AS FreeSpace_GB,
		LibEstDaysToUse	AS EstDaysToUse,
		LibTotalSpace_GB AS TotalSpace_GB
FROM dbo.DataGrowthPerCopy(@Frequency, @Periods, @StartDate, @EndDate, 0, @MediaType, '', '', '', '')
ORDER BY Library
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DataGrowthSummary')
	delete from GxQscripts where name = 'QS_DataGrowthSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataGrowthSummary')
	delete from GXDBVersions where aliasname = 'QS_DataGrowthSummary'
GO

insert into GXDBVersions values(2, 'QS_DataGrowthSummary',  '00000000000000000000', 'QS_DataGrowthSummary', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DataGrowthSummary',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_DataGrowthSummary '
 + CHAR(10) + '--  -                    [-si @Frequency = ''Month'']'
 + CHAR(10) + '--  -                    [-si @Periods = ''6'']'
 + CHAR(10) + '--  -                    [-si @StartDate = ''mm/dd/yyyy'']'
 + CHAR(10) + '--  -                    [-si @EndDate = ''mm/dd/yyyy'']'
 + CHAR(10) + '--  -                    [-si @MediaType = ''Disk'']'
 + CHAR(10) + '--  - '
 + CHAR(10) + '--  Options: @Frequency   : ''Month'', ''Week'' or ''Day''. Otherwise use default value ''Week''.'
 + CHAR(10) + '--  -        @Periods     : A valid positive integer. Otherwise use default value 8. It will be ignored if @StartDate is set to a valid date.'
 + CHAR(10) + '--  -        @StartDate   : ''mm/dd/yyyy''. It will be set using @Frequency and @Periods if it is not set to a valid date.'
 + CHAR(10) + '--  -        @EndDate     : ''mm/dd/yyyy''. It will be set to the current date if it is not set to a valid date.'
 + CHAR(10) + '--  -        @MediaType   : ''Disk'', ''Tape'' or '''' for all'
 + CHAR(10) + '--  - '
 + CHAR(10) + '--  Default: @Frequency   = ''Week'''
 + CHAR(10) + '--  -        @Periods     = ''8'''
 + CHAR(10) + '--  -        @StartDate   = '''''
 + CHAR(10) + '--  -        @EndDate     = '''''
 + CHAR(10) + '--  -        @MediaType   = '''''
)
GO

