

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DataGrowthPerCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DataGrowthPerCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_DataGrowthPerCopy')
	drop procedure QS_DataGrowthPerCopy
IF EXISTS (select * from GxQscripts where name='QS_DataGrowthPerCopy')
	delete from GxQscripts where name = 'QS_DataGrowthPerCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataGrowthPerCopy')
	delete from GXDBVersions where aliasname = 'QS_DataGrowthPerCopy'
GO
print '... Creating Procedure: QS_DataGrowthPerCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DataGrowthPerCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @Frequency VARCHAR(32)	= 'Week',	-- 'Day', 'Week', 'Month'
  @Periods INTEGER		= 8,
  @StartDate VARCHAR(32)	= '',		-- 'mm/dd/yyyy'
  @EndDate VARCHAR(32)	= '',		-- current date
  @Predictions INTEGER		= 0,		-- No prediction
  @MediaType VARCHAR(32)	= '',		-- 'Disk', 'Tape'
  @CopyType VARCHAR(32)	= '',		-- 'Backup', 'Replication'
  @LibraryName NVARCHAR(64) = '',		-- All
  @PolicyName NVARCHAR(144)= '',		-- All
  @CopyName NVARCHAR(64) = ''		-- All
AS
SET NOCOUNT ON
SELECT	CommCell,
		StoragePolicy + ' : ' + Copy AS StoragePolicyCopy,
		IsPrimaryCopy,
		PeriodBegin,
		PeriodEnd,
		SizeOnMedia_GB,
		DataGrowth_GB,
		Duration_Hr,
		Throughput_GBHr,
		IsPrediction,
		MediaAgent,
		Library,
		LibGrowth_GBDay,
		LibFreeSpace_GB,
		LibEstDaysToUse,
		TimeZone,
		LibTotalSpace_GB
FROM dbo.DataGrowthPerCopy(@Frequency, @Periods, @StartDate, @EndDate, @Predictions, @MediaType, @CopyType, @LibraryName, @PolicyName, @CopyName)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DataGrowthPerCopy')
	delete from GxQscripts where name = 'QS_DataGrowthPerCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataGrowthPerCopy')
	delete from GXDBVersions where aliasname = 'QS_DataGrowthPerCopy'
GO

insert into GXDBVersions values(2, 'QS_DataGrowthPerCopy',  '00000000000000000000', 'QS_DataGrowthPerCopy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DataGrowthPerCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_DataGrowthPerCopy '
 + CHAR(10) + '--  -                    [-si @Frequency = ''Month''] '
 + CHAR(10) + '--  -                    [-si @Periods = ''6''] '
 + CHAR(10) + '--  -                    [-si @StartDate = ''mm/dd/yyyy'']'
 + CHAR(10) + '--  -                    [-si @EndDate = ''mm/dd/yyyy'']'
 + CHAR(10) + '--  -                    [-si @Predictions = ''4'']'
 + CHAR(10) + '--  -                    [-si @MediaType = ''Disk'']'
 + CHAR(10) + '--  -                    [-si @CopyType = ''Backup'']'
 + CHAR(10) + '--  -                    [-si @LibraryName = ''****'']'
 + CHAR(10) + '--  -                    [-si @PolicyName = ''****'']'
 + CHAR(10) + '--  -                    [-si @CopyName = ''****'']'
 + CHAR(10) + '--  -'
 + CHAR(10) + '--  Options: @Frequency   : ''Month'', ''Week'' or ''Day''. Otherwise use default value ''Week''.'
 + CHAR(10) + '--  -        @Periods     : A valid positive integer. Otherwise use default value 8. It will be ignored if @StartDate is set to a valid date.'
 + CHAR(10) + '--  -        @StartDate   : ''mm/dd/yyyy''. It will be set using @Frequency and @Periods if it is not set to a valid date.'
 + CHAR(10) + '--  -        @EndDate     : ''mm/dd/yyyy''. It will be set to the current date if it is not set to a valid date.'
 + CHAR(10) + '--  -        @Predictions : A valid positive integer. Otherwise use default value 0.'
 + CHAR(10) + '--  -        @MediaType   : ''Disk'' or ''Tape''. Otherwise for both.'
 + CHAR(10) + '--  -        @CopyType    : ''Backup'' or ''Replication''. Otherwise for both.'
 + CHAR(10) + '--  -        @LibraryName : Return all storage policy copies which use this library.'
 + CHAR(10) + '--  -        @PolicyName  : Return all copies of this storage policy.'
 + CHAR(10) + '--  -        @CopyName    : Return only this storage policy copy.'
 + CHAR(10) + '--  -'
 + CHAR(10) + '--  Default: @Frequency   = ''Week'''
 + CHAR(10) + '--  -        @Periods     = ''8'''
 + CHAR(10) + '--  -        @StartDate   = '''''
 + CHAR(10) + '--  -        @EndDate     = '''''
 + CHAR(10) + '--  -        @Predictions = ''0'''
 + CHAR(10) + '--  -        @MediaType   = '''''
 + CHAR(10) + '--  -        @CopyType    = '''''
 + CHAR(10) + '--  -        @LibraryyName= '''''
 + CHAR(10) + '--  -        @PolicyName  = '''''
 + CHAR(10) + '--  -        @CopyName    = '''''
)
GO

