

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DDBParam.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DDBParam.sp,v $ $Id: QS_DDBParam.sp,v 1.7.12.9 2020/07/01 00:36:44 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DDBParam')
BEGIN
	print '>>> Drop Stored Procedure: QS_DDBParam <<<'
	drop procedure QS_DDBParam
END
IF EXISTS (select * from GxQscripts where name='QS_DDBParam')
	delete from GxQscripts where name = 'QS_DDBParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DDBParam')
	delete from GXDBVersions where aliasname = 'QS_DDBParam'
GO
print '... Creating Procedure: QS_DDBParam'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DDBParam
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_setOrGet NVARCHAR(20)='',
  @i_StoreId INTEGER=0,
  @i_paramName NVARCHAR(100)='',
  @i_paramValue NVARCHAR(100)=''
AS
Set NOCOUNT ON
	-- setOrGet
	-- --------------------------------
	-- get - get values
	-- set - set values
	-- config to set MMConfigs param.
	-- Variables to hold the values from App_SubClientProp Table Row
	DECLARE @C_CV_SI_NUMAFINSECFILE NVARCHAR(100)
	DECLARE @C_CV_SI_MAX_CONNECTIONS NVARCHAR(100)
	DECLARE @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME NVARCHAR(100)
	DECLARE @C_CV_SI_DEDUPFACTOR	 NVARCHAR(100)
	DECLARE @C_CV_SET_OPTION	NVARCHAR(20) = 'set'
	DECLARE @C_CV_GET_OPTION	NVARCHAR(20) = 'get'
	DECLARE @C_CV_SET_CONFIG_OPTION NVARCHAR(20) = 'config'
	DECLARE @C_CV_SI_DO_NOT_REF_BEFORE_TIME	NVARCHAR(50)
	DECLARE @minValue		INTEGER = 0
	DECLARE @maxValue		INTEGER = 0
	DECLARE @paramIntVal		INTEGER = 0
	DECLARE @C_CV_SI_FOLLOW_PRIMARY_BLOCK NVARCHAR(50) = 'FollowPrimaryBlock'
	-- Max Num of AFs in secondary file
	SET @C_CV_SI_NUMAFINSECFILE = N'MaxNumOfAFsInSecondaryFile'
	-- Max connections per store
	SET @C_CV_SI_MAX_CONNECTIONS = N'MaxConnectionsPerStore'
	-- oldestEligibleObjArchiveTime per store
	SET @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME = N'OldestEligibleObjArchiveTime'
	-- dedupFactor
	SET @C_CV_SI_DEDUPFACTOR = N'DedupFactor'
	-- DoNotRefBeforeTime
SET @C_CV_SI_DO_NOT_REF_BEFORE_TIME = N'DDBDoNotRefBeforeTime'
	DECLARE @retVal INTEGER = 0
	DECLARE @retStr VARCHAR(50) = ''
	-- Variable used for getting & setting the Current Date Time Stamp
	-- (as count of seconds, rather than as a string)
	DECLARE @nowTime INTEGER
	SET		@nowTime = dbo.GetUnixTime(GetUTCdate())
	-- Variables to hold the Error Number & Error Message
	DECLARE @ErrorNumber INTEGER
	DECLARE @ErrorMessage NVARCHAR(MAX)
	-- perform all the parameter validations here
	IF (@i_paramName IN (@C_CV_SI_NUMAFINSECFILE, @C_CV_SI_MAX_CONNECTIONS, @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME, @C_CV_SI_DEDUPFACTOR, @C_CV_SI_FOLLOW_PRIMARY_BLOCK))
	BEGIN
		SET @paramIntVal = CAST(@i_paramValue AS INT)
	END
	IF (@i_setOrGet = 'config')
	BEGIN
		IF (@i_paramName <> 'MMS2_CONFIG_DDB_MAX_NUM_OF_AF_IN_SECFILE')
		BEGIN
			SET @ErrorMessage = N'Config parameter not allowed to be set with this qscript.'
			SET @ErrorNumber = 1
			GOTO	QS_ERROR
		END
		SELECT @minValue = nMin, @maxValue = nMax
		FROM MMConfigs WITH (NOLOCK)
		WHERE name = 'MMS2_CONFIG_DDB_MAX_NUM_OF_AF_IN_SECFILE'
		IF (@paramIntVal < @minValue) OR (@paramIntVal > @maxValue)
		BEGIN
			SET @ErrorMessage = N'Param value does not fall between the prescribed limits.Min['+cast(@minValue as varchar(10))+'] Max['+cast(@maxValue as varchar(10))+']'
			SET @ErrorNumber = 6
			GOTO	QS_ERROR
		END
		IF ((@paramIntVal & (@paramIntVal - 1)) > 0)
		BEGIN
			SET @ErrorMessage = N'Parameter setting should be power of 2.'
			SET @ErrorNumber = 4
			GOTO QS_ERROR
		END
		UPDATE MMConfigs
		SET value = @paramIntVal
		WHERE name = 'MMS2_CONFIG_DDB_MAX_NUM_OF_AF_IN_SECFILE'
		SELECT 'Successfully saved ['+ @i_paramName + '] Value[' + @i_paramValue + '].'
		GOTO QS_ERROR
	END
	IF ((@i_paramName = '') OR ((@i_setOrGet = 'set') AND (@paramIntVal < 0 AND @i_paramName <> @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME)))
	BEGIN
		SET @ErrorMessage = N'Incorrect parameters'
		SET @ErrorNumber = 1
		GOTO	QS_ERROR
	END
	-- additional parameter validation
	IF (@i_storeId = 0)
	BEGIN
		SET @ErrorMessage = N'Incorrect parameters. Store supplied is invalid. '
		SET @ErrorNumber = 1
		GOTO	QS_ERROR
	END
	IF NOT EXISTS (SELECT 1 FROM IdxSIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId AND (@i_storeId > 0))
	BEGIN
			SET @ErrorMessage = N'Store is invalid.'
			SET @ErrorNumber = 4
			GOTO	QS_ERROR
	END
	IF (@i_paramName = @C_CV_SI_NUMAFINSECFILE)
	BEGIN
		IF (@i_setOrGet = 'set')
		BEGIN
			IF ((SELECT FirstBackupTime FROM IdxSIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId) > -1)
			BEGIN
				SET @ErrorMessage = N'Store is already initialized. Unable to proceed with setting.'
				SET @ErrorNumber = 4
				GOTO QS_ERROR
			END
		END
		-- check if there exists MA with lesser service pack level than needed.
		IF EXISTS (SELECT 1 FROM IdxSIDBSubStore S WITH (NOLOCK)
				INNER JOIN APP_Client C WITH (NOLOCK) ON S.ClientId = C.id
				INNER JOIN simInstalledPackages I ON C.id = I.ClientId
			   WHERE S.SIDBStoreId = @i_storeId
AND I.simPackageID IN (51, 1301)
AND (C.releaseId < 16))
		BEGIN
			SET @ErrorMessage = N'MediaAgents of partitions should v11. Unable to proceed with setting.'
			SET @ErrorNumber = 4
			GOTO QS_ERROR
		END
		IF ((@paramIntVal & (@paramIntVal - 1)) > 0)
		BEGIN
			SET @ErrorMessage = N'Parameter setting should be power of 2.'
			SET @ErrorNumber = 4
			GOTO QS_ERROR
		END
	END
	ELSE IF (@i_paramName = @C_CV_SI_DEDUPFACTOR)
	BEGIN
		IF (@i_setOrGet = 'set')
		BEGIN
			IF (@paramIntVal = 0)
			BEGIN
				UPDATE IdxSIDBStore
				SET DedupFactor = 1,
flags = flags & ~(65536 | 131072)
				WHERE SIDBStoreId = @i_storeId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to update the setting (DedupFactor) due to error.'
					GOTO QS_ERROR
				END
			END
			ELSE
			BEGIN
				UPDATE IdxSIDBStore
				SET DedupFactor = @paramIntVal,
flags |= 65536 | 131072
				WHERE SIDBStoreId = @i_storeId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to update the setting (DedupFactor) due to error.'
					GOTO QS_ERROR
				END
			END
			GOTO QS_ERROR
		END
	END
	ELSE IF (@i_paramName = @C_CV_SI_DO_NOT_REF_BEFORE_TIME)
	BEGIN
		IF (@i_setOrGet = 'set')
		BEGIN
			DECLARE @RefUnixTime INT = 0
			SET @i_paramValue = LTRIM(RTRIM(@i_paramValue))
			SET @RefUnixTime = dbo.getUnixTime(dbo.CellLocalToUTCTime(@i_paramValue, 2))
			UPDATE MMEntityProp
			SET intVal = @RefUnixTime,
			modified = @nowTime
			WHERE EntityId = @i_storeId
AND EntityType = 3
AND propertyName = 'DDBDoNotRefBeforeTime'
			IF @@ROWCOUNT = 0
			BEGIN
			    INSERT  INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT @i_storeId, 3, 'DDBDoNotRefBeforeTime', 1, @RefUnixTime, 0, '', @nowTime, @nowTime, 2
			END
			GOTO QS_ERROR
		END
	END
	ELSE IF (@i_paramName = @C_CV_SI_FOLLOW_PRIMARY_BLOCK)
	BEGIN
		IF (@i_setOrGet = 'set')
		BEGIN
			IF (@paramIntVal = 0)
			BEGIN
				UPDATE IdxSIDBStore
SET flags = flags & ~(131072)
				WHERE SIDBStoreId = @i_storeId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to update the setting (FollowPrimaryBlock) due to error.'
					GOTO QS_ERROR
				END
			END
			ELSE
			BEGIN
				UPDATE IdxSIDBStore
SET flags |= 131072
				WHERE SIDBStoreId = @i_storeId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to update the setting (FollowPrimaryBlock) due to error.'
					GOTO QS_ERROR
				END
			END
			GOTO QS_ERROR
		END
	END
	IF @i_paramName NOT IN (@C_CV_SI_NUMAFINSECFILE, @C_CV_SI_MAX_CONNECTIONS, @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME, @C_CV_SI_DEDUPFACTOR, @C_CV_SI_DO_NOT_REF_BEFORE_TIME)
	BEGIN
		SET @ErrorMessage = N'DDB Parameter is invalid'
		SET @ErrorNumber = 5
		GOTO	QS_ERROR
	END
	IF (@i_setOrGet = 'set')
	BEGIN
		IF (@paramIntVal = 0)
		BEGIN
			IF (@i_paramName = @C_CV_SI_NUMAFINSECFILE)
			BEGIN
				UPDATE IdxSIDBStore
SET MaxNumOfAFsInSecFile = 16
				WHERE SIDBStoreId = @i_storeId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to clear the setting due to error.'
					GOTO QS_ERROR
				END
			END
			ELSE IF (@i_paramName = @C_CV_SI_MAX_CONNECTIONS)
			BEGIN
				UPDATE IdxSIDBStore
SET MaxAllowedConnections = 0
				WHERE SIDBStoreId = @i_storeId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to clear the setting due to error.'
					GOTO QS_ERROR
				END
			END
			ELSE IF (@i_paramName = @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME)
			BEGIN
					SET @ErrorMessage = N'Invalid paramValue for setting OldestEligibleObjArchiveTime.'
					GOTO QS_ERROR
			END
			SELECT 'Successfully reset ['+ @i_paramName + '].'
		END
		ELSE
		BEGIN
			SELECT @minValue = nMin, @maxValue = nMax
			FROM MMConfigs WITH (NOLOCK)
			WHERE name = (CASE WHEN @i_paramName = @C_CV_SI_NUMAFINSECFILE THEN 'MMS2_CONFIG_DDB_MAX_NUM_OF_AF_IN_SECFILE' ELSE 'MMCONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_CONNECTION_PER_DDB' END)
			IF @@ROWCOUNT = 0
			BEGIN
SET @minValue = (CASE WHEN @i_paramName = @C_CV_SI_NUMAFINSECFILE THEN 4 ELSE 0 END)
SET @maxValue = (CASE WHEN @i_paramName = @C_CV_SI_NUMAFINSECFILE THEN 256 ELSE 0 END)
			END
			IF ((@paramIntVal < @minValue) OR (@paramIntVal > @maxValue)) AND (@i_paramName <> @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME)
			BEGIN
				SET @ErrorMessage = N'Param value does not fall between the prescribed limits.Min['+cast(@minValue as varchar(10))+'] Max['+cast(@maxValue as varchar(10))+']'
				SET @ErrorNumber = 6
				GOTO	QS_ERROR
			END
			IF (@i_paramName = @C_CV_SI_NUMAFINSECFILE)
			BEGIN
				UPDATE IdxSIDBStore
				SET MaxNumOfAFsInSecFile = @paramIntVal
				WHERE SIDBStoreId = @i_storeId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to enable/change the setting due to error.'
					GOTO QS_ERROR
				END
			END
			ELSE IF (@i_paramName = @C_CV_SI_MAX_CONNECTIONS)
			BEGIN
				UPDATE IdxSIDBStore
				SET MaxAllowedConnections = @paramIntVal
				WHERE SIDBStoreId = @i_storeId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to enable/change the setting due to error.'
					GOTO QS_ERROR
				END
			END
			ELSE IF (@i_paramName = @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME)
			BEGIN
				UPDATE IdxSIDBStore
				SET oldestEligibleObjArchiveTime = @paramIntVal
				WHERE SIDBStoreId = @i_StoreId
				SET @ErrorNumber = @@ERROR
				IF @ErrorNumber <> 0
				BEGIN
					SET @ErrorMessage = N'Failed to update the do not deduplicate against setting due to error.'
					GOTO QS_ERROR
				END
				SET @ErrorNumber = 0
				GOTO QS_ERROR
			END
			SELECT 'Successfully saved ['+ @i_paramName + '] Value[' + @i_paramValue + '].'
		END
	END
	ELSE
	BEGIN
		IF (@i_paramName = @C_CV_SI_NUMAFINSECFILE)
		BEGIN
			SET @retVal = ISNULL((SELECT MaxNumOfAFsInSecFile FROM IdxSIDBStore WHERE SIDBStoreId = @i_storeId), 0)
			SET @retStr = cast(@retVal as varchar(10))
		END
		ELSE IF (@i_paramName = @C_CV_SI_MAX_CONNECTIONS)
		BEGIN
			SET @retVal = ISNULL((SELECT MaxAllowedConnections FROM IdxSIDBStore WHERE SIDBStoreId = @i_storeId), 0)
			SET @retStr = cast(@retVal as varchar(10))
		END
		ELSE IF (@i_paramName = @C_CV_SI_OLDEST_ELIGIBLE_OBJARCHIVETIME)
		BEGIN
			SET @retVal = ISNULL((SELECT oldestEligibleObjArchiveTime FROM IdxSIDBStore WHERE SIDBStoreId = @i_storeId), 0)
			SET @retStr = cast(@retVal as varchar(10))
		END
		ELSE IF (@i_paramName = @C_CV_SI_DEDUPFACTOR)
		BEGIN
			SET @retVal = ISNULL((SELECT DedupFactor FROM IdxSIDBStore WHERE SIDBStoreId = @i_storeId), 0)
			SET @retStr = cast(@retVal as varchar(10))
		END
		ELSE IF (@i_paramName = @C_CV_SI_DO_NOT_REF_BEFORE_TIME)
		BEGIN
			DECLARE @tStamp INT = 0
			SET @tStamp = ISNULL((SELECT intVal FROM MMEntityProp WITH (NOLOCK)
								WHERE EntityId = @i_storeId
AND EntityType = 3
AND propertyName = 'DDBDoNotRefBeforeTime'), 0)
			SET @retStr = dbo.UTCToCellLocalTime(dbo.getDateTime(@tStamp), 2)
		END
		SELECT 'Parameter Setting['+ @i_paramName + '] :' + @retStr
	END
QS_ERROR:
	IF @ErrorNumber <> 0
		Raiserror(@ErrorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DDBParam')
	delete from GxQscripts where name = 'QS_DDBParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DDBParam')
	delete from GXDBVersions where aliasname = 'QS_DDBParam'
GO

insert into GXDBVersions values(2, 'QS_DDBParam',  '00010007001200090000', 'QS_DDBParam', '00010007001200090000')
GO

insert into GxQscripts values(2,'QS_DDBParam',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '		qoperation execscript -sn DDBParam -si setOrGet -si StoreId -si paramName -si paramValue
'
 + CHAR(10) + '-- 		setOrGet - Use keyword set when enabling or changing the setting, use keyword get when viewing the setting.'
 + CHAR(10) + '-- 			 - Use keyword config to set the global configuration parameter. The value has to be power of 2.'
 + CHAR(10) + '-- 		paramName - Use keyword MaxConnectionsPerStore Or MaxNumOfAFsInSecondaryFile Or OldestEligibleObjArchiveTime Or DedupFactor Or DDBDoNotRefBeforeTime Or FollowPrimaryBlock'
 + CHAR(10) + '-- 		MaxConnectionsPerStore - to set the maximum allowed concurrent connections per store'
 + CHAR(10) + '-- 		MaxNumOfAFsInSecondaryFile - Maximum number of archive files in secondary file'
 + CHAR(10) + '-- 		OldestEligileObjArchiveTime - Oldest time upto which a particular signature can be referenced'
 + CHAR(10) + '-- 		DedupFactor - Factor by which the size of data would be considered for deduplication'
 + CHAR(10) + '-- 		DDBDoNotRefBeforeTime - The fixed timestamp before which any dedup block created will not be referenced'
 + CHAR(10) + '-- 		FollowPrimaryBlock - Set the option to set the store to follow primary block for secondary copies'
)
GO

