

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DDBBackupJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DDBBackupJob.sp,v $ $Id: QS_DDBBackupJob.sp,v 1.1.2.3 2018/06/13 17:47:22 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DDBBackupJob <<<'

IF EXISTS (select * from sysobjects where name='QS_DDBBackupJob')
	drop procedure QS_DDBBackupJob
IF EXISTS (select * from GxQscripts where name='QS_DDBBackupJob')
	delete from GxQscripts where name = 'QS_DDBBackupJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DDBBackupJob')
	delete from GXDBVersions where aliasname = 'QS_DDBBackupJob'
GO
print '... Creating Procedure: QS_DDBBackupJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DDBBackupJob
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_StoreId INTEGER=0,
  @i_subStoreId INTEGER=0,
  @i_setOrGet NVARCHAR(20)='',
  @i_jobId INTEGER= 0
AS
Set NOCOUNT ON
	-- setOrGet
	-- --------------------------------
	-- get - get available DDB backup jobs
	-- set - set DDB backup job as current job
	DECLARE @C_CV_SET_OPTION	NVARCHAR(20) = 'set'
	DECLARE @C_CV_GET_OPTION	NVARCHAR(20) = 'get'
	DECLARE @retVal INTEGER = 0
	-- Variable used for getting & setting the Current Date Time Stamp
	-- (as count of seconds, rather than as a string)
	DECLARE @nowTime INTEGER
	SET		@nowTime = dbo.GetUnixTime(GetUTCdate())
	DECLARE @latestDDBBackupJobId INT = 0
	-- Variables to hold the Error Number & Error Message
	DECLARE @ErrorNumber INTEGER
	DECLARE @ErrorMessage NVARCHAR(MAX)
	-- perform all the parameter validations here
	IF (@i_storeId <= 0) OR (@i_subStoreId <= 0)
	BEGIN
		SET @ErrorMessage = N'Incorrect parameters. Store / SubStore supplied is invalid. '
		SET @ErrorNumber = 1
		GOTO	QS_ERROR
	END
	-- additional parameter validation
	IF ((@i_setOrGet <> @C_CV_SET_OPTION) AND ((@i_setOrGet <> @C_CV_GET_OPTION)))
	BEGIN
		SET @ErrorMessage = N'Incorrect Get / Set parameters'
		SET @ErrorNumber = 1
		GOTO	QS_ERROR
	END
	IF NOT EXISTS (SELECT 1 FROM IdxSIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId)
	BEGIN
			SET @ErrorMessage = N'Store is invalid.'
			SET @ErrorNumber = 4
			GOTO	QS_ERROR
	END
	IF NOT EXISTS (SELECT 1 FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId)
	BEGIN
			SET @ErrorMessage = N'SubStore is invalid.'
			SET @ErrorNumber = 4
			GOTO	QS_ERROR
	END
	IF (@i_setOrGet = @C_CV_SET_OPTION)
	BEGIN
		IF ((@i_jobId > 0) AND (NOT EXISTS (SELECT 1 FROM IdxSIDBSubStoreBackupInfo WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId AND LastSnapJobId = @i_jobId)))
			OR NOT EXISTS (SELECT 1 FROM IdxSIDBSubStoreBackupInfo WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId)
		BEGIN
			SET @ErrorMessage = N'DDB Backup job does not exists for the store/substore. Unable to proceed with setting.'
			SET @ErrorNumber = 4
			GOTO QS_ERROR
		END
	END
	IF (@i_setOrGet = @C_CV_SET_OPTION)
	BEGIN
		SET @latestDDBBackupJobId = (SELECT TOP(1)LastSnapJobId FROM IdxSIDBSubStoreBackupInfo WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId ORDER BY LastSnapJobId Desc)
		BEGIN TRAN
			UPDATE S
			SET LastSnapJobId = I.LastSnapJobId,
			LastSnapTime = I.LastSnapTime,
			SIDBSnapPath = I.SIDBSnapPath,
			DDBBackupCSGUID = I.DDBBackupCSGUID,
			SnapLogSequence = I.SnapLogSequence
			FROM IdxSIDBSubStore S
				INNER JOIN IdxSIDBSubStoreBackupInfo I WITH (READUNCOMMITTED) ON S.SIDBStoreId = I.SIDBStoreId AND S.SubStoreId = I.SubStoreId
			WHERE S.SIDBStoreId = @i_StoreId
			AND S.SubStoreId = @i_subStoreId
			AND (((@i_jobId = 0) AND (I.LastSnapJobId = @latestDDBBackupJobId))
				OR ((@i_jobId > 0) AND (I.LastSnapJobId = @i_jobId)))
			SET @retVal = @@ERROR
			IF (@retVal <> 0)
			BEGIN
				SET @ErrorMessage = N'Unable to update IdxSIDBSubStore table due to database error.'
				SET @ErrorNumber = 4
				ROLLBACK TRAN
				GOTO QS_ERROR
			END
			DELETE FROM IdxSIDBSubStoreBackupInfo
			WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId
				AND (((@i_jobId = 0) AND (LastSnapJobId = @latestDDBBackupJobId))
					OR ((@i_jobId > 0) AND (LastSnapJobId = @i_jobId)))
			SET @retVal = @@ERROR
			IF (@retVal <> 0)
			BEGIN
				SET @ErrorMessage = N'Unable to update IdxSIDBSubStoreBackupInfo table due to database error.'
				SET @ErrorNumber = 4
				ROLLBACK TRAN
				GOTO QS_ERROR
			END
		COMMIT TRAN
	END
	ELSE IF (@i_setOrGet = @C_CV_GET_OPTION)
	BEGIN
		SELECT SIDBStoreId, SubStoreId, LastSnapJobId, dbo.getDateTime(LastSnapTime) as UTCTime, SIDBSnapPath
		FROM IdxSIDBSubStoreBackupInfo WITH (NOLOCK)
		WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId
	END
QS_ERROR:
	IF @ErrorNumber <> 0
		Raiserror(@ErrorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DDBBackupJob')
	delete from GxQscripts where name = 'QS_DDBBackupJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DDBBackupJob')
	delete from GXDBVersions where aliasname = 'QS_DDBBackupJob'
GO

insert into GXDBVersions values(2, 'QS_DDBBackupJob',  '00010001000200030000', 'QS_DDBBackupJob', '00010001000200030000')
GO

insert into GxQscripts values(2,'QS_DDBBackupJob',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '		qoperation execscript -sn DDBBackupJob -si StoreId -si SubStoreId -si setOrGet -si jobId
'
 + CHAR(10) + '-- 		setOrGet - Use keyword set when changing the current DDB backup job, use keyword get when viewing the list of available DDB backup jobs.'
 + CHAR(10) + '-- 		jobId -    Specify the DDB backup job to be promoted as current job for the DDB partition.'
)
GO

