

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateVirtualIndexServerCloud.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateVirtualIndexServerCloud <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateVirtualIndexServerCloud')
	drop procedure QS_CreateVirtualIndexServerCloud
IF EXISTS (select * from GxQscripts where name='QS_CreateVirtualIndexServerCloud')
	delete from GxQscripts where name = 'QS_CreateVirtualIndexServerCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateVirtualIndexServerCloud')
	delete from GXDBVersions where aliasname = 'QS_CreateVirtualIndexServerCloud'
GO
print '... Creating Procedure: QS_CreateVirtualIndexServerCloud'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CreateVirtualIndexServerCloud
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_analyticsClientList NVARCHAR(2048) = N'',
  @i_operationType VARCHAR(64) ='',
  @i_virtualCloudName NVARCHAR(128) =N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_CreateVirtualIndexServerCloud'
DECLARE @lastError int
SET @lastError = 0
DECLARE @localErrorMsg NVARCHAR(1024)
SET @localErrorMsg = N'Succeeded'
-----------------------invalid parameters------------------------------
IF @i_analyticsClientList	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Analytics Client names are not provided in parameter 1.'
	GOTO ARGS_ERROR
END
IF @i_operationType	= @NoParameter OR @i_operationType NOT IN ('ADD', 'REMOVE', 'DELETE_CLOUD')
BEGIN
	SET @lastError = 2
	SET @localErrorMsg = 'Error. Operation type ADD or REMOVE or DELETE_CLOUD is not provided in parameter 2.'
	GOTO ARGS_ERROR
END
IF @i_virtualCloudName	= @NoParameter
BEGIN
	SET @lastError = 3
	SET @localErrorMsg = 'Error. Virtual cloud name is not provided in parameter 3.'
	GOTO ARGS_ERROR
END
-----------------------Validation ------------------------------
DECLARE @tmpAnalyticsClient TABLE (t_clientName NVARCHAR(1024), t_clientId INT)
INSERT INTO @tmpAnalyticsClient
SELECT	Data, ISNULL(C.id ,0)
FROM	 dbo.SplitString(@i_analyticsClientList,',')
		LEFT JOIN  APP_CLIENT C (NOLOCK) ON Data = C.name
IF EXISTS (SELECT 1 FROM @tmpAnalyticsClient WHERE t_clientId = 0)
BEGIN
	SET @lastError = 4
	SET @localErrorMsg = 'Error. Wrong analytics client name is provided in parameter 1.'
	GOTO ARGS_ERROR
END
------------------------------------------------------------------------
BEGIN TRY
BEGIN TRAN
	DECLARE @virtualCloudId int
	DECLARE @cloudId int
	DECLARE @nowTime int =dbo.GetUnixTime (GetUTCdate())
	DECLARE @searchCloudTbl Table (t_cloudId int)
SET @cloudId = ISNULL((SELECT cloudId FROM DM2Cloud (nolock) WHERE name = @i_virtualCloudName AND (flags & 8) > 0),0)
	--delete virtual cloud
	IF @i_operationType IN ('DELETE_CLOUD')
	BEGIN
		DELETE FROM DM2Cloud WHERE cloudId = @cloudId
		DELETE FROM DM2SearchServerCoreInfo WHERE cloudId = @cloudId
	END
	ELSE IF @i_operationType IN ('ADD')
	BEGIN
		--create new virtual cloud or add a new node
		IF @cloudId = 0
		BEGIN
			INSERT INTO DM2Cloud (commcellId, name, description, flags, createTime)
VALUES (2, @i_virtualCloudName,'virtual', 8 ,@nowTime)
			SET @cloudId = (SELECT cloudId FROM DM2Cloud (nolock) WHERE name = @i_virtualCloudName)
		END
		-- remove already existing nodes
		DELETE  T
		FROM @tmpAnalyticsClient T
		INNER JOIN DM2SearchServerCoreInfo S (NOLOCK) ON T.t_clientId = S.clientId AND S.cloudId= @cloudId
		INSERT INTO DM2SearchServerCoreInfo (CoreName,CommCellId,CloudId,ClientId,CreateTime,SoftState,Enabled,Attributes,ServiceLink,CoreRoles,CollectionSize,FreeSpace,OccupiedSpace,Description,skippedItems,failedItems,numFiles,numEmails)
		SELECT 'Virtual_cloud_' + cast (@cloudId AS VARCHAR(50)), 2, @cloudId, t_clientId, GETUTCDATE(), 1, 1, 0, S.serviceLink, 28, 0, -1, 0, '',0, 0, 0, 0
		FROM @tmpAnalyticsClient
		INNER JOIN DM2SearchServerCoreInfo S (NOLOCK) ON t_clientId = S.clientId
		INNER JOIN DM2CloudCoreRole R (NOLOCK) ON S.CloudId= R.CloudId
	END
	ELSE IF @i_operationType IN ('REMOVE')
	BEGIN
		--delete a node
		DELETE FROM DM2SearchServerCoreInfo WHERE cloudId = @cloudId AND ClientId IN (SELECT t_clientId FROM @tmpAnalyticsClient)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto TRANS_EXIT
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@i_analyticsClientList+'], ['+@i_operationType+ '], ['+ @i_virtualCloudName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateVirtualIndexServerCloud')
	delete from GxQscripts where name = 'QS_CreateVirtualIndexServerCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateVirtualIndexServerCloud')
	delete from GXDBVersions where aliasname = 'QS_CreateVirtualIndexServerCloud'
GO

insert into GXDBVersions values(2, 'QS_CreateVirtualIndexServerCloud',  '00000000000000000000', 'QS_CreateVirtualIndexServerCloud', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateVirtualIndexServerCloud',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_CreateVirtualIndexServerCloud.sql -si ''analyticsClientList'' -si ''ADD|REMOVE|DELETE_CLOUD'' -si ''virtualCloudName''
'
 + CHAR(10) + '-- 	Qscript to create Virtual Cloud'
 + CHAR(10) + '-- 	script_name: QS_CreateVirtualIndexServerCloud'
 + CHAR(10) + '-- 	analyticsClientList: list of analytics clients seperated by comma(,)'
 + CHAR(10) + '-- 	operationType: ADD or REMOVE analytics node to existing Virtual Cloud or DELETE Virtual Cloud '
 + CHAR(10) + '-- 	virtualCloudName: name of the virtual cloud'
)
GO

