

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateVirtualCloud.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateVirtualCloud <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateVirtualCloud')
	drop procedure QS_CreateVirtualCloud
IF EXISTS (select * from GxQscripts where name='QS_CreateVirtualCloud')
	delete from GxQscripts where name = 'QS_CreateVirtualCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateVirtualCloud')
	delete from GXDBVersions where aliasname = 'QS_CreateVirtualCloud'
GO
print '... Creating Procedure: QS_CreateVirtualCloud'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CreateVirtualCloud
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @searchCloudList nvarchar(2048) = N'',
  @operationType varchar(64) ='',
  @virtualCloudName NVARCHAR(128) =N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_CreateVirtualCloud'
DECLARE @lastError int
SET @lastError = 0
DECLARE @localErrorMsg NVARCHAR(1024)
SET @localErrorMsg = N'Succeeded'
-----------------------invalid parameters------------------------------
IF @searchCloudList	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Search Engine cloud names are not provided in parameter 1.'
	GOTO ARGS_ERROR
END
IF @operationType	= @NoParameter OR @operationType NOT IN ('ADD', 'REMOVE', 'DELETE_CLOUD')
BEGIN
	SET @lastError = 2
	SET @localErrorMsg = 'Error. Operation type ADD or REMOVE or DELETE_CLOUD is not provided in parameter 2.'
	GOTO ARGS_ERROR
END
IF @virtualCloudName	= @NoParameter
BEGIN
	SET @lastError = 3
	SET @localErrorMsg = 'Error. Virtual cloud name is not provided in parameter 3.'
	GOTO ARGS_ERROR
END
ELSE IF EXISTS (SELECT ID FROM APP_ComponentProp WITH (NOLOCK)  WHERE stringVal = @virtualCloudName AND propertytypeid = 1 AND componentType =1
AND id IN (SELECT componentid FROM APP_ComponentProp WITH (NOLOCK) WHERE componenttype = 2 AND propertyTypeId =1001 AND stringval <> 'virtual' ))
BEGIN
	SET @lastError = 4
	SET @localErrorMsg = 'Error. Virtual cloud name should not be same as physical cloud name in parameter 3.'
	GOTO ARGS_ERROR
END
------------------------------------------------------------------------
BEGIN TRY
BEGIN TRAN
	DECLARE @virtualCloudId int
	DECLARE @cloudId int
	DECLARE @nowTime int =dbo.GetUnixTime (GetUTCdate())
	DECLARE @searchCloudTbl Table (t_cloudId int)
	IF @operationType IN ('ADD', 'REMOVE')
	BEGIN
		--IF WRONG CLOUD NAME IS SPECIFIED OR VIRTUAL CLOUD IS SPECIFIED
IF EXISTS ( SELECT Data FROM dbo.SplitString(@searchCloudList,',') WHERE data NOT IN (SELECT stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componenttype = 1 AND propertyTypeId =1))
OR EXISTS ( SELECT Data FROM dbo.SplitString(@searchCloudList,',') WHERE data IN (SELECT stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componenttype = 1 AND propertyTypeId =1
AND id IN (SELECT componentid FROM APP_ComponentProp WITH (NOLOCK) WHERE componenttype = 2 AND propertyTypeId =1001 AND stringval = 'virtual' )))
		begin
			SET @lastError = 5
			SET @localErrorMsg = 'Error: Invaild search engine cloud names [' + @searchCloudList +'] are provided.'
			GOTO TRANS_EXIT
		end
		ELSE
		BEGIN
			--GET cloudId of the input
			INSERT INTO @searchCloudTbl (t_cloudId)
			SELECT Id FROM APP_ComponentProp WITH (NOLOCK)
			WHERE stringVal in ( SELECT Data FROM dbo.SplitString(@searchCloudList,',') )
AND componenttype = 1 AND propertyTypeId =1
		END
	END
	--Check if virtual cloud already exists
	-- create new virtual cloud only if it does not exists and operationtype = ADD
SET @virtualCloudId = ISNULL((SELECT ID FROM APP_ComponentProp WITH (NOLOCK)  WHERE stringVal = @virtualCloudName AND propertytypeid = 1 AND componentType =1),0)
	IF @virtualCloudId = 0
	BEGIN
		IF @operationType = 'ADD'
		BEGIN
			insert into APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
values (1,	2,	1,	1	,0,	0,	@virtualCloudName,	@nowTime	,0)
SET @virtualCloudId = ISNULL((SELECT ID FROM APP_ComponentProp WHERE stringVal = @virtualCloudName AND propertytypeid = 1 AND componentType =1),0)
			IF @virtualCloudId = 0
			BEGIN
				--IF WRONG VIRTUAL CLOUD NAME IS SPECIFIED
				SET @lastError = 6
				SET @localErrorMsg = 'Error: Failed to create Virtual cloud [' + @virtualCloudName +'].'
				GOTO TRANS_EXIT
			END
			insert into APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
values (2 ,@virtualCloudId,1014,	1,	0	,0,	'Solr 1.0',	@nowTime,	0)
			insert into APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
values (2 ,@virtualCloudId,1001,	1,	0	,0,	'virtual',	@nowTime,	0)
		END
		ELSE
		BEGIN
			--IF WRONG VIRTUAL CLOUD NAME IS SPECIFIED
			SET @lastError = 7
			SET @localErrorMsg = 'Error: Invaild Virtual cloud name [' + @virtualCloudName +'] is provided.'
			GOTO TRANS_EXIT
		END
	END
	--Insert o remove physical cloud association with given virtual cloud
	DECLARE cur cursor for SELECT t_cloudId  from @searchCloudTbl
		OPEN cur
		FETCH NEXT FROM cur INTO  @cloudId
		WHILE @@fetch_status = 0
		BEGIN
		IF @operationType = 'ADD'
		BEGIN
IF NOT EXISTS ( SELECT 1 FROM APP_ComponentProp WHERE componentid = @virtualCloudId AND propertytypeid = 1010 AND longVal = @cloudId)
			BEGIN
				insert into APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
values (2 ,@virtualCloudId, 1010,	7,	@cloudId	,0,	'',	@nowTime,	0)
			END
		END
		ELSE
		BEGIN
DELETE FROM APP_ComponentProp WHERE componentid = @virtualCloudId AND propertytypeid = 1010 AND longVal = @cloudId AND componentType =2
		END
		FETCH NEXT FROM cur INTO @cloudId
		END
		CLOSE cur
		DEALLOCATE cur
	--Delete virtual cloud information
	IF @operationType = 'DELETE_CLOUD'
	BEGIN
DELETE FROM APP_ComponentProp WHERE componentid = @virtualCloudId AND propertytypeid IN ( 1014, 1001, 1010) AND componentType =2
DELETE FROM APP_ComponentProp WHERE iD = @virtualCloudId AND propertytypeid = 1 AND componentType =1
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto TRANS_EXIT
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@searchCloudList+'], ['+@operationType+ '], ['+ @virtualCloudName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateVirtualCloud')
	delete from GxQscripts where name = 'QS_CreateVirtualCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateVirtualCloud')
	delete from GXDBVersions where aliasname = 'QS_CreateVirtualCloud'
GO

insert into GXDBVersions values(2, 'QS_CreateVirtualCloud',  '00000000000000000000', 'QS_CreateVirtualCloud', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateVirtualCloud',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_CreateVirtualCloud.sql -si ''SearchEngineCloudNameList'' -si ''ADD|REMOVE|DELETE_CLOUD'' -si ''VirtualCloudName''
'
 + CHAR(10) + '	Creates a Virtual Cloud of the search engines and provides a federated search across all the search engines that are part of a Virtual Cloud in compliance and end user search.
'
 + CHAR(10) + '-- 	SearchEngineCloudNameList: Search Engine Cloud name list separated by comma(,) Eg. (''SearchEngineCloud1,SearchEngineCloud2'')'
 + CHAR(10) + '-- 	OperationType:'
 + CHAR(10) + '-- 					ADD - to add a search engine to an existing Virtual Cloud'
 + CHAR(10) + '-- 					REMOVE  to remove a search engine from an existing Virtual Cloud'
 + CHAR(10) + '-- 					DELETE_CLOUD To delete the Virtual Cloud'
 + CHAR(10) + '-- 	VirtualCloudName: name of the Virtual Cloud'
)
GO

