

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateScheduleHoliday.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_createscheduleholiday <<<'

IF EXISTS (select * from sysobjects where name='QS_createscheduleholiday')
	drop procedure QS_createscheduleholiday
IF EXISTS (select * from GxQscripts where name='QS_createscheduleholiday')
	delete from GxQscripts where name = 'QS_createscheduleholiday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_createscheduleholiday')
	delete from GXDBVersions where aliasname = 'QS_createscheduleholiday'
GO
print '... Creating Procedure: QS_createscheduleholiday'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_createscheduleholiday
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @param1 AS NVARCHAR(512) = '',
  @param2 AS NVARCHAR(512) = '',
  @param3 AS NVARCHAR(512) = '',
  @param4 AS NVARCHAR(512) = ''
AS
DECLARE @clientId		INT = 0
DECLARE @groupId		INT = 0
DECLARE @vtPolicyId		INT = 0
DECLARE @vtPolicyName	VARCHAR(MAX) = ''
DECLARE @startYear		INT = 0
DECLARE @startMonth		INT = 0
DECLARE @startDay		INT = 0
DECLARE @startHour		INT = 0
DECLARE @startMinute	INT = 0
DECLARE @startSecond	INT = 0
DECLARE @endYear		INT = 0
DECLARE @endMonth		INT = 0
DECLARE @endDay			INT = 0
DECLARE @endHour		INT = 0
DECLARE @endMinute		INT = 0
DECLARE @endSecond		INT = 59
DECLARE @yearly			INT = 0
DECLARE @errorcode as INT = 0
DECLARE @errorstring as NVARCHAR(MAX) = 'Successful'
--Validate first parameter, client name
IF @param1 = ''
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: First parameter is empty, it must be client name/commserve.'
		GOTO ARGS_ERROR
	END
ELSE IF @param1 = 'commserve'
	BEGIN
		SET @clientId = 0
		SET @groupId = 0
		SET @vtPolicyId = 0
	END
ELSE IF @param1 LIKE 'pn=%'
	BEGIN
		SET @vtPolicyName = SUBSTRING(@param1, (CHARINDEX('=', @param1) + 1 ), (LEN(@param1) - CHARINDEX('=', @param1)))
		SET @vtPolicyId = ISNULL((SELECT PolicyId FROM VTPolicy where PolicyName = @vtPolicyName), 0)
		IF @vtPolicyId = 0
		BEGIN
			SET		@errorstring = 'Error: First parameter policy name ''' + @param1 + ''' is not correct. Please give correct policy name.'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
		SET @clientId = 0
		SET @groupId = 0
	END
ELSE
	BEGIN
		SET @clientId = ISNULL((SELECT id FROM APP_Client where name = @param1), 0)
		IF @clientId = 0
		BEGIN
			SET		@errorstring = 'Error: First parameter client name/commserve[' + @param1 + ']not correct. Please give valid client name/commserve.'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
		--Identify Client Group id
		--SET @groupId = ISNULL((SELECT TOP(1) clientGroupId FROM APP_ClientGroupAssoc where clientId = @clientId), 0)
	END
--Validate second parameter, start date
IF @param2 = ''
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: Second parameter start date is empty, please give valid start date [MM-DD-YYYY].'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF ISDATE(@param2) = 1
			BEGIN
				DECLARE @startDateConverted DATETIME = CONVERT(datetime, @param2, 110)
				SET @startYear = DATEPART ( YEAR, @startDateConverted )
				SET @startMonth = CAST( DATEPART ( MONTH, @startDateConverted ) - 1 AS INT)
				SET @startDay = DATEPART ( DAY, @startDateConverted )
				IF @startDateConverted < CONVERT(datetime, (SELECT CONVERT(char(10), GetDate(),126)), 110)
				BEGIN
					SET		@errorstring = 'Error: Second parameter start date[' + @param2 + '] is already passed. Please give valid start date.'
					SET		@errorcode = 1
					GOTO	ARGS_ERROR
				END
			END
		ELSE
			BEGIN
				SET		@errorstring = 'Error: Second parameter start date[' + @param2 + '] is not correct or it is not in format[MM-DD-YYYY], please give valid start date.'
				SET		@errorcode = 1
				GOTO	ARGS_ERROR
			END
	END
--Validate third parameter, end date
IF @param3 = ''
	BEGIN
		SET @endYear = @startYear
		SET @endMonth = @startMonth
		SET @endDay = @startDay	+ 1
	END
ELSE
	BEGIN
		IF ISDATE(@param3) = 1
			BEGIN
				DECLARE @endDateConverted DATETIME = CONVERT(datetime, @param3, 110)
				SET @endYear = DATEPART ( YEAR, @endDateConverted )
				SET @endMonth = CAST( DATEPART ( MONTH, @endDateConverted ) - 1 AS INT)
				SET @endDay = DATEPART ( DAY, @endDateConverted )
				IF @endDateConverted < @startDateConverted
				BEGIN
					SET		@errorstring = 'Error: End date[' + @param3 + '] must be greater than start date[' + @param2 + ']'
					SET		@errorcode = 1
					GOTO	ARGS_ERROR
				END
			END
		ELSE
			BEGIN
				SET		@errorstring = 'Error: third parameter end date[' + @param3 + '] is not correct or it is not in format[MM-DD-YYYY], please give valid end date.'
				SET		@errorcode = 1
				GOTO	ARGS_ERROR
			END
	END
-- Validate fourth parameter, yearly input
IF @param4 = ''
	BEGIN
		-- Optional parameter, do nothing
		SET @yearly = 0
	END
ELSE
	BEGIN
		IF @param4 NOT IN ('true', 'false')
		BEGIN
			SET		@errorstring = 'Error: fourth parameter, yearly [' + @param4 + '] is not correct or it is not in format[true/false], please give correct input for yearly.'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
		IF @param4 = 'true'
			BEGIN
				SET @startYear = 0
				SET @endYear = 0
			END
	END
----------------------------------------------
--Validation done, add operation window rule--
----------------------------------------------
BEGIN TRAN
BEGIN TRY
		IF EXISTS( SELECT * FROM SchedHoliday WHERE startYear = @startYear
												AND startMonth = @startMonth
												AND startDay = @startDay
												AND startHour = @startHour
												AND startMinute = @startMinute
												AND startSecond = @startSecond
												AND endYear = @endYear
												AND endMonth = @endMonth
												AND endDay = @endDay
												AND endHour = @endHour
												AND endMinute = @endMinute
												AND endSecond = @endSecond
												AND clientId = @clientId
												AND groupId = @groupId
												AND vtPolicyId = @vtPolicyId)
			BEGIN
				UPDATE SchedHoliday SET modified = dbo.GetUnixTime (GetUTCdate())
				WHERE startYear = @startYear
													AND startMonth = @startMonth
													AND startDay = @startDay
													AND startHour = @startHour
													AND startMinute = @startMinute
													AND startSecond = @startSecond
													AND endYear = @endYear
													AND endMonth = @endMonth
													AND endDay = @endDay
													AND endHour = @endHour
													AND endMinute = @endMinute
													AND endSecond = @endSecond
													AND clientId = @clientId
													AND groupId = @groupId
													AND vtPolicyId = @vtPolicyId
				PRINT 'Duplicate Schedule holiday is available.'
			END
		ELSE
			BEGIN
				INSERT SchedHoliday(startYear, startMonth, startDay, startHour, startMinute, startSecond, endYear, endMonth, endDay, endHour, endMinute, endSecond, modified, description, clientId, groupId, vtPolicyId)
				VALUES (@startYear, @startMonth, @startDay, @startHour, @startMinute, @startSecond, @endYear, @endMonth, @endDay, @endHour, @endMinute, @endSecond, dbo.GetUnixTime (GetUTCdate()),'', @clientId, @groupId, @vtPolicyId)
				PRINT 'Successfully created Schedule holiday.'
			END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	BEGIN
		SET @errorcode = ERROR_NUMBER()
		SET @errorstring = @errorstring + ERROR_MESSAGE()
	END
END CATCH
ALL_DONE:
	IF (@errorcode  = 0)
		commit Tran
	ELSE
		rollback Tran
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateScheduleHoliday')
	delete from GxQscripts where name = 'QS_CreateScheduleHoliday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateScheduleHoliday')
	delete from GXDBVersions where aliasname = 'QS_CreateScheduleHoliday'
GO

insert into GXDBVersions values(2, 'QS_CreateScheduleHoliday',  '00000000000000000000', 'QS_CreateScheduleHoliday', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateScheduleHoliday',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ClientName/commserve/pn=<PolicyName> -si Startdate -si Enddate -si Yearly
'
 + CHAR(10) + '	Where 	(ClientName/commserve/pn=<PolicyName>) would be ''NameOfClient'' for client name OR ''commserve'' OR Policy Name.
'
 + CHAR(10) + '			StartDate		Format is MM-DD-YYYY
'
 + CHAR(10) + '			EndDate			Optional parameter, format is MM-DD-YYYY
'
 + CHAR(10) + '			Yearly			Optional parameter, true/false
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ''ClientName'' -si ''04-10-2012''
'
 + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ''ClientName'' -si ''04-10-2012'' -si ''04-11-2012''
'
 + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ''ClientName'' -si ''04-10-2012'' -si ''04-11-2012'' -si false
'
 + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ''pn=<PolicyName>'' -si ''04-10-2012''
'
 + CHAR(10) + '-- 	script_name: createscheduleholiday'
 + CHAR(10) + '-- 	Create Schedule holiday'
)
GO

