

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateSAPOracleSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CreateSAPOracleSubclient.sp,v $ $Id: QS_CreateSAPOracleSubclient.sp,v 1.2.208.2 2018/03/27 08:07:25 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateSAPOracleSubclient <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateSAPOracleSubclient')
	drop procedure QS_CreateSAPOracleSubclient
IF EXISTS (select * from GxQscripts where name='QS_CreateSAPOracleSubclient')
	delete from GxQscripts where name = 'QS_CreateSAPOracleSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateSAPOracleSubclient')
	delete from GXDBVersions where aliasname = 'QS_CreateSAPOracleSubclient'
GO
print '... Creating Procedure: QS_CreateSAPOracleSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CreateSAPOracleSubclient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = ''
AS
Set NOCOUNT ON
      -------------------INPUTS all mandatory----------------------------------
DECLARE @client varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @defSP varchar(1024)
DECLARE @subclientName varchar(1024)
SET @client = @PARAM1
SET @instancename = @PARAM2
SET @defSP = @PARAM3
SET @subclientName = @PARAM4
DECLARE @subclientId integer
     -------------------------------
      --select @client, @instancename , @defSP, @subclientName
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = '%%'
      SET @noParameter = @noParameter + 's'
     ----------------------const------------------------------
      DECLARE @scriptName nvarchar(128)
      SET @scriptName = 'CreateSAPOracleSubclient'
	  DECLARE @nowTime integer
	  SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
	  DECLARE @backupsetName nvarchar(1024)
	  SET @backupsetName = 'default'
      DECLARE @sapOracleApptype varchar(128)
      SET @sapOracleApptype = '61'
	  DECLARE @defArchGrpId integer
	  SET @defArchGrpId = 1
      DECLARE @logArchGrpId integer
      SET @logArchGrpId = 1
      DECLARE @instStatus integer
      SET @instStatus = 0
      DECLARE @instanceId integer
      SET @instanceId = 0
      DECLARE @backupsetId integer
      SET @backupsetId = 0
     ---------------------parameter 1 - client name--------------------------------------------
     IF @client = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @client), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] not found.'
     	GOTO ERROR_EXIT
     END
     IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @sapOracleApptype)
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] does not have SAP Oracle iDataAgent.'
     	GOTO ERROR_EXIT
     END
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     -----------------Validate other parameters---------------
       IF @defSP = @noParameter
     	BEGIN
     		SET @errorCode = 1
    		SET @errorString = 'Error. The parameters supplied are not sufficient to create backupset. Please try again with all inputs.'
     		GOTO ERROR_EXIT
     	END
        SET @instanceId =   ISNULL((SELECT distinct APP_Application.instance
							from  APP_Application, APP_Client, APP_iDAType, APP_InstanceName
							where APP_Application.clientId = APP_Client.id
							and APP_Application.appTypeId = @sapOracleApptype
							and APP_Application.instance = APP_InstanceName.id
							and APP_Client.name = @client
							and APP_InstanceName.name = @instanceName),0)
     SET @backupsetId = ISNULL(( select distinct APP_BackupSetName.id
							from APP_BackupSetName, APP_Application, APP_Client, APP_InstanceName
							where APP_Application.clientId = APP_Client.id
							and APP_Application.appTypeId = @sapOracleApptype
							and APP_Application.instance = APP_InstanceName.id
							and APP_BackupSetName.id = APP_Application.backupSet
							and APP_Client.name = @client
							and APP_InstanceName.name = @instanceName
							and APP_BackupSetName.name = @backupsetName), 0)
   SET @defArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @defSP), 0)
     IF @defArchGrpId = 0
     BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Storage policy ['+@defSP+'] not found'
     	GOTO ERROR_EXIT
     END
   SET @logArchGrpId = ISNULL((SELECT logArchGrpId FROM APP_Application where clientId = @clientId and appTypeId = @sapOracleApptype and instance = @instanceId and backupSet = @backupsetId and subclientName = 'default'), 0)
   BEGIN TRAN
    IF EXISTS (SELECT * FROM APP_Application A WHERE A.subclientName = @subclientName AND A.clientid = @clientId AND A.apptypeid = @sapOracleApptype and A.instance = @instanceId and
		A.backupSet = @backupsetId and A.subclientStatus = 4)
    BEGIN
	update APP_Application
	SET subclientName = @subclientName + '_' + convert(varchar(1024),@nowTime) where subclientName = @subclientName AND clientid = @clientId AND apptypeid = @sapOracleApptype and instance = @instanceId and
		backupSet = @backupsetId and subclientStatus = 4
    END
    IF EXISTS (SELECT * FROM APP_Application A WHERE A.subclientName = @subclientName AND A.clientid = @clientId AND A.apptypeid = @sapOracleApptype and A.instance = @instanceId and
		A.backupSet = @backupsetId )
    BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. subclient ['+@subclientName+'] already exists in client ['+@client+'].'
     	GOTO ERROR_EXIT
    END
     --Create  SC
     INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
     	VALUES(@clientId, @sapOracleApptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, @nowTime, @subclientName, 0)
     SET @errorCode = @@error
    IF @errorCode <> 0
    BEGIN
     	SET @errorString = 'Error. Error tryint to create  subclient for instance['+@instanceName +'].'
     	GOTO TRANS_EXIT
     END
    SET @subclientId = @@IDENTITY
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Single Instancing Option', 7, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Encrypt: encryption', 10, 2,@nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last data SP', 10, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last log SP', 10, 1, @nowTime ,0)
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Oracle Backup Device', 7, 1, @nowTime ,0)
     TRANS_EXIT:
     IF @errorCode <> 0
     	ROLLBACK TRAN
    ELSE
    	COMMIT TRAN
     --ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
     ERROR_EXIT:
    -- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
    if @errorCode <> 0
     	Raiserror(@errorString,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
    				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateSAPOracleSubclient')
	delete from GxQscripts where name = 'QS_CreateSAPOracleSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateSAPOracleSubclient')
	delete from GXDBVersions where aliasname = 'QS_CreateSAPOracleSubclient'
GO

insert into GXDBVersions values(2, 'QS_CreateSAPOracleSubclient',  '00010002020800020000', 'QS_CreateSAPOracleSubclient', '00010002020800020000')
GO

insert into GxQscripts values(2,'QS_CreateSAPOracleSubclient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateSAPOracleSubclient.sql -si clientname -si instancename -si storagepolicy -si subclientName
'
 + CHAR(10) + '-- 	script_name: CreateSAPOracleSubclient.'
 + CHAR(10) + '-- 	creates new SAP Oracle subclient under the given client and instance name'
)
GO

