

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateSAPOracleInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CreateSAPOracleInstance.sp,v $ $Id: QS_CreateSAPOracleInstance.sp,v 1.2.208.2 2018/03/27 08:14:10 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateSAPOracleInstance <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateSAPOracleInstance')
	drop procedure QS_CreateSAPOracleInstance
IF EXISTS (select * from GxQscripts where name='QS_CreateSAPOracleInstance')
	delete from GxQscripts where name = 'QS_CreateSAPOracleInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateSAPOracleInstance')
	delete from GXDBVersions where aliasname = 'QS_CreateSAPOracleInstance'
GO
print '... Creating Procedure: QS_CreateSAPOracleInstance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CreateSAPOracleInstance
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = '',
  @PARAM5 nvarchar(1024) = '',
  @PARAM6 nvarchar(1024) = '',
  @PARAM7 nvarchar(1024) = '',
  @PARAM8 nvarchar(1024) = '',
  @PARAM9 nvarchar(1024) = '',
  @PARAM10 nvarchar(1024) = '',
  @PARAM11 nvarchar(1024) = '',
  @PARAM12 nvarchar(1024) = ''
AS
Set NOCOUNT ON
      -------------------INPUTS all mandatory----------------------------------
DECLARE @client varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @homeDir nvarchar(1024)
DECLARE @sapDataPath nvarchar(1024)
DECLARE @defSP nvarchar(1024)
DECLARE @logSP nvarchar(1024)
DECLARE @cmdSP nvarchar(1024)
DECLARE @user nvarchar(1024)
DECLARE @pwd nvarchar(1024)
DECLARE @service nvarchar(1024)
DECLARE @sapExeFolder nvarchar(1024)
DECLARE @hostuser nvarchar(1024)
SET @client = @PARAM1
SET @instancename = @PARAM2
SET @homeDir = @PARAM3
SET @sapDataPath = @PARAM4
SET @defSP = @PARAM5
SET @logSP = @PARAM6
SET @cmdSP = @PARAM7
SET @user = @PARAM8
SET @pwd = @PARAM9
SET @service = @PARAM10
SET @sapExeFolder  = @PARAM11
SET @hostuser =  @PARAM12
     -------------------------------
      --select @client, @instancename , @homeDir, @sapDataPath,@defSP,@logSP,@cmdSP,@user, @pwd  , @service , @sapExeFolder, @hostuser
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = '%%'
      SET @noParameter = @noParameter + 's'
     ----------------------const------------------------------
      DECLARE @scriptName nvarchar(128)
      SET @scriptName = 'CreateSAPOracleInstance'
	DECLARE @nowTime integer
	SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
	DECLARE @sapOracleApptype integer
	SET @sapOracleApptype = 61
	DECLARE @defArchGrpId integer
	SET @defArchGrpId = 1
	DECLARE @logArchGrpId integer
	SET @logArchGrpId = 1
	DECLARE @cmdArchGrpId integer
	SET @cmdArchGrpId = 1
	DECLARE @instStatus integer
	SEt @instStatus = 0
     ---------------------parameter 1 - client name--------------------------------------------
     IF @client = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @client), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] not found.'
     	GOTO ERROR_EXIT
     END
     IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @sapOracleApptype)
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] does not have SAP Oracle iDataAgent.'
     	GOTO ERROR_EXIT
     END
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
IF EXISTS (SELECT * FROM APP_InstanceName I INNER JOIN APP_Application A ON I.id = A.instance
		WHERE I.name = @instanceName AND A.clientid = @clientId AND A.apptypeid = @sapOracleApptype)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance ['+@instanceName+'] already exists in client ['+@client+'].'
	GOTO ERROR_EXIT
END
-------other parameters---------------------
	 IF @sapExeFolder = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. SAP Exe Folder was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
	--SQL connect
	IF @user = '/'
	BEGIN
		SET @service = ''
		SET @pwd = '2'
	END
	IF @homeDir = @noparameter OR
		@defSP = @noParameter OR
		@logSP = @noParameter OR
		@cmdSP = @noParameter OR
		@user = @noParameter OR
		@pwd = @noParameter OR
		@service = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. The parameters supplied are not sufficient to create the instance. Please try again with all inputs.'
		GOTO ERROR_EXIT
	END
	SET @defArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @defSP), 0)
	SET @logArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @logSP), 0)
	SET @cmdArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @cmdSP), 0)
	IF @defArchGrpId = 0 OR
		@logArchGrpId = 0 OR
		@cmdArchGrpId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Invalid storage policy given.'
		GOTO ERROR_EXIT
	END
	--split hostuser into domain name and user name
	DECLARE @domainName nvarchar(1024)
	SET @domainName= ''
	DECLARE @userName nvarchar(1024)
	SET @userName = SUBSTRING(@hostuser, charindex('\', @hostuser, 0)+1, LEN(@hostuser))
	IF @userName = @hostuser
	BEGIN
		SET @userName = SUBSTRING(@hostuser, charindex('/', @hostuser, 0)+1, LEN(@hostuser))
	END
	SET @domainName = SUBSTRING(@hostuser, 0, LEN(@hostuser)-LEN(@userName))
BEGIN TRAN
--Create instance
INSERT INTO APP_InstanceName (name, reftime, modified, status) VALUES(@instanceName, @nowTime, 0, @instStatus)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Could not create instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @instanceId integer
SET @instanceId = @@IDENTITY
	--Create instance properties
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Oracle Home', 1, @homeDir, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SAP Data Home', 1, @sapDataPath, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Domain Name', 1, @domainName, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Oracle User', 1, @userName, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect', 1, @user, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect Password', 1, @pwd, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect Machine', 1, @service, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SAP Exe Folder', 1, @sapExeFolder, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'use Catalog Connect', 2, 0, @nowTime, 0)
--Create default backupset
INSERT INTO APP_BackupsetName (name, refTime, modified, status) VALUES ('default', @nowTime, 0, 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error tryint to create default backupset for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @backupsetId integer
SET @backupsetId = @@IDENTITY
--Create default SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @sapOracleApptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, 0, 'default', 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error tryint to create default subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @defaultSCId integer
SET @defaultSCId = @@IDENTITY
INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@defaultSCId, 'Oracle Backup Device', 7, 1, @nowTime ,0)
--Create commandline SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @sapOracleApptype, @instanceId, @backupsetId, 0, @cmdArchGrpId , @logArchGrpId , @nowTime, 0, '(command line)', 64)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error trying to create subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
--Create commandline SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @sapOracleApptype, @instanceId, @backupsetId, 0, @cmdArchGrpId , @logArchGrpId , @nowTime, 0, '(Logcommand line)', 4096)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error trying to create subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
TRANS_EXIT:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
ERROR_EXIT:
Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateSAPOracleInstance')
	delete from GxQscripts where name = 'QS_CreateSAPOracleInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateSAPOracleInstance')
	delete from GXDBVersions where aliasname = 'QS_CreateSAPOracleInstance'
GO

insert into GXDBVersions values(2, 'QS_CreateSAPOracleInstance',  '00010002020800020000', 'QS_CreateSAPOracleInstance', '00010002020800020000')
GO

insert into GxQscripts values(2,'QS_CreateSAPOracleInstance',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateSAPOracleInstance.sql -si client_name -si instance_name -si oracle_home -si SAP_Data_Path -si default_Storage_policy -si log_storage_policy -si cmd_storage_policy -si Oracle_user -p2 Oracle_pwd -si Oracle_service -si sap_Exe_Folder  -si host_user
'
 + CHAR(10) + '-- 	script_name: CreateSAPOracleInstance.'
 + CHAR(10) + '-- 	creates new SAP Oracle Instance for given client'
)
GO

