

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateSAPMAXDBInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateSAPMAXDBInstance <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateSAPMAXDBInstance')
	drop procedure QS_CreateSAPMAXDBInstance
IF EXISTS (select * from GxQscripts where name='QS_CreateSAPMAXDBInstance')
	delete from GxQscripts where name = 'QS_CreateSAPMAXDBInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateSAPMAXDBInstance')
	delete from GXDBVersions where aliasname = 'QS_CreateSAPMAXDBInstance'
GO
print '... Creating Procedure: QS_CreateSAPMAXDBInstance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CreateSAPMAXDBInstance
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = ''
AS
Set NOCOUNT ON
      -------------------INPUTS all mandatory----------------------------------
DECLARE @client varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @cmdSP nvarchar(1024)
SET @client = @PARAM1
SET @instancename = @PARAM2
SET @cmdSP = @PARAM3
     -------------------------------
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = ''
     ----------------------const------------------------------
      DECLARE @scriptName nvarchar(128)
      SET @scriptName = 'CreateSAPMAXDBInstance'
	DECLARE @nowTime integer
	SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
	DECLARE @sapmaxdbApptype integer
SET @sapmaxdbApptype = 79
	DECLARE @cmdArchGrpId integer
	SET @cmdArchGrpId = 1
	DECLARE @instStatus integer
	SEt @instStatus = 0
     ---------------------parameter 1 - client name--------------------------------------------
     IF @client = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @client), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] not found.'
     	GOTO ERROR_EXIT
     END
     IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @sapmaxdbApptype)
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] does not have SAP Oracle iDataAgent.'
     	GOTO ERROR_EXIT
     END
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
IF EXISTS (SELECT * FROM APP_InstanceName I INNER JOIN APP_Application A ON I.id = A.instance
		WHERE I.name = @instanceName AND A.clientid = @clientId AND A.apptypeid = @sapmaxdbApptype)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance ['+@instanceName+'] already exists in client ['+@client+'].'
	GOTO ERROR_EXIT
END
-------other parameters---------------------
	IF @cmdSP = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. The parameters supplied are not sufficient to create the instance. Please try again with all inputs.'
		GOTO ERROR_EXIT
	END
	SET @cmdArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @cmdSP), 0)
	IF @cmdArchGrpId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Invalid storage policy given.'
		GOTO ERROR_EXIT
	END
BEGIN TRAN
--Create instance
INSERT INTO APP_InstanceName (name, reftime, modified, status) VALUES(@instanceName, @nowTime, 0, @instStatus)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Could not create instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @instanceId integer
SET @instanceId = @@IDENTITY
--Create default backupset
INSERT INTO APP_BackupsetName (name, refTime, modified, status) VALUES ('default', @nowTime, 0, 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error tryint to create default backupset for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @backupsetId integer
SET @backupsetId = @@IDENTITY
--Create commandline SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @sapmaxdbApptype, @instanceId, @backupsetId, 0, @cmdArchGrpId , 1 , @nowTime, 0, '(command line)', 72) --CV_STATUS_DEFAULT + CV_STATUS_CMD_LINE,  CV_DEFAULT_ARCHIVE_GROUP
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error tryint to create default subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @cmdSCId integer
SET @cmdSCId = @@IDENTITY
INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdSCId, 'turbo:last full', 8, 1, @nowTime ,0)
INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdSCId, 'Reason last backup time cleared', 7, 1, @nowTime ,0)
INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
 VALUES (@cmdSCId, 'last data SP', 10, 1, @nowTime ,0)
 INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdSCId, 'turbo:last incr', 8, 1, @nowTime ,0)
 INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdSCId, 'Single Instancing Option', 7, 0, @nowTime ,0)
TRANS_EXIT:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
ERROR_EXIT:
Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateSAPMAXDBInstance')
	delete from GxQscripts where name = 'QS_CreateSAPMAXDBInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateSAPMAXDBInstance')
	delete from GXDBVersions where aliasname = 'QS_CreateSAPMAXDBInstance'
GO

insert into GXDBVersions values(2, 'QS_CreateSAPMAXDBInstance',  '00000000000000000000', 'QS_CreateSAPMAXDBInstance', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateSAPMAXDBInstance',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_CreateSAPMAXDBInstance.sql -si client_name -si instance_name -si cmd_storage_policy
'
 + CHAR(10) + '-- 	script_name: QS_CreateSAPMAXDBInstance.'
 + CHAR(10) + '-- 	creates new SAP MAX DB Instance for given client'
)
GO

