

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateOracleInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateOracleInstance <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateOracleInstance')
	drop procedure QS_CreateOracleInstance
IF EXISTS (select * from GxQscripts where name='QS_CreateOracleInstance')
	delete from GxQscripts where name = 'QS_CreateOracleInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateOracleInstance')
	delete from GXDBVersions where aliasname = 'QS_CreateOracleInstance'
GO
print '... Creating Procedure: QS_CreateOracleInstance'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CreateOracleInstance
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @client nvarchar(1024) = '%s',
  @instancename nvarchar(1024) = '%s',
  @homeDir nvarchar(1024) = '%s',
  @version nvarchar(1024) = '%s',
  @defSP nvarchar(1024) = '%s',
  @logSP nvarchar(1024) = '%s',
  @cmdSP nvarchar(1024) = '%s',
  @user nvarchar(1024) = '%s',
  @pwd nvarchar(1024) = '%s',
  @service nvarchar(1024) = '%s',
  @useCat nvarchar(1024)= '%s',
  @catUser nvarchar(1024) = '%s',
  @catpwd nvarchar(1024) = '%s',
  @catservice nvarchar(1024) = '%s',
  @hostuser nvarchar(1024) = '%s',
  @ntpwd nvarchar(1024) = '%s'
AS
SET NOCOUNT ON
-------------------INPUTS all mandatory----------------------------------
--DECLARE @client nvarchar(1024)
--SET @client = '%s'
--DECLARE @instanceName nvarchar(1024)
--SET @instancename = '%s'
--DECLARE @homeDir nvarchar(1024)
--SET @homeDir = '%s'
--DECLARE @version nvarchar(1024)
--SET @version = '%s'
--DECLARE @defSP nvarchar(1024)
--SET @defSP = '%s'
--DECLARE @logSP nvarchar(1024)
--SET @logSP = '%s'
--DECLARE @cmdSP nvarchar(1024)
--SET @cmdSP = '%s'
--DECLARE @user nvarchar(1024)
--SET @user = '%s'
--DECLARE @pwd nvarchar(1024)
--SET @pwd = '%s'
--DECLARE @service nvarchar(1024)
--SET @service = '%s'
--DECLARE @useCat nvarchar(1024)
--SET @useCat = '%s'
--DECLARE @catUser nvarchar(1024)
--SET @catUser = '%s'
--DECLARE @catpwd nvarchar(1024)
--SET @catPwd = '%s'
--DECLARE @catService nvarchar(1024)
--SET @catService = '%s'
--DECLARE @hostuser nvarchar(1024)
--SET @hostuser = '%s'
--DECLARE @ntpwd nvarchar(1024)
--SET  @ntpwd = '%s'
--DECLARE @MAX_ENTITY_SIZE smallint
--SET @MAX_ENTITY_SIZE = 100
-------------------------------
--SET @client = 'bingo'
--SET @instancename = '%s'
--select @client, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
-------------------------------
----------------------Error Handling----------------------------------------------
DECLARE @errorCode integer
SET @errorCode = 0
DECLARE @errorString nvarchar(1024)
SET @errorString = ''
DECLARE @noParameter nvarchar(4)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
----------------------const------------------------------
DECLARE @scriptName nvarchar(128)
SET @scriptName = 'CreateOracleInstance'
DECLARE @onDmndInst nvarchar(128)
SET @onDmndInst = 'On Demand Instance'
DECLARE @nowTime integer
SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
DECLARE @oracleApptype integer
SET @oracleApptype = 22
DECLARE @defArchGrpId integer
SET @defArchGrpId = 1
DECLARE @logArchGrpId integer
SET @logArchGrpId = 1
DECLARE @cmdArchGrpId integer
SET @cmdArchGrpId = 1
DECLARE @instStatus integer
SEt @instStatus = 0
---------------------parameter 1 - client name--------------------------------------------
IF @client = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
DECLARE @clientId integer
SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @client), 0)
IF @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@client+'] not found.'
	GOTO ERROR_EXIT
END
IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @oracleApptype)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@client+'] does not have Oracle iDataAgent.'
	GOTO ERROR_EXIT
END
-----------------------------instance name ----------------------------
IF @instanceName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
IF @instanceName = @onDmndInst
BEGIN
	SET @instStatus = 2048
	SET @instanceName = @onDmndInst
	IF EXISTS (SELECT * FROM APP_InstanceName I INNER JOIN APP_Application A ON I.id = A.instance
			WHERE I.status & 2048 = 2048 AND A.clientid = @clientId AND A.apptypeid = @oracleApptype)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. On Demand Instance already exists in client ['+@client+'].'
		GOTO ERROR_EXIT
	END
END
-----------------Validate other parameters for non ondemand instance---------------
DECLARE @useCatalogConnect integer
IF EXISTS (SELECT * FROM APP_InstanceName I INNER JOIN APP_Application A ON I.id = A.instance
		WHERE I.name = @instanceName AND A.clientid = @clientId AND A.apptypeid = @oracleApptype)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance ['+@instanceName+'] already exists in client ['+@client+'].'
	GOTO ERROR_EXIT
END
IF @instanceName <> @onDmndInst
BEGIN
	--SQL connect
	IF @user = '/'
	BEGIN
		SET @ntpwd = @catService
		SET @hostuser = @catPwd
		SET @catService = @catUser
		SET @catPwd = @useCat
		SET @catUser = @service
		SET @useCat = @pwd
		SET @service = ''
		SET @pwd = '2'
		--select @client, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
	END
	IF @homeDir = @noparameter OR
		@version = @noParameter OR
		@defSP = @noParameter OR
		@logSP = @noParameter OR
		@cmdSP = @noParameter OR
		@user = @noParameter OR
		@pwd = @noParameter OR
		@service = @noParameter OR
		@useCat = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. The parameters supplied are not sufficient to create the instance. Please try again with all inputs.'
		GOTO ERROR_EXIT
	END
	SET @defArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @defSP), 0)
	SET @logArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @logSP), 0)
	SET @cmdArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @cmdSP), 0)
	IF @defArchGrpId = 0 OR
		@logArchGrpId = 0 OR
		@cmdArchGrpId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Invalid storage policy given.'
		GOTO ERROR_EXIT
	END
	IF @useCat = 'yes'
		SET @useCatalogConnect = 1
	ELSE IF @useCat = 'no'
		SET @useCatalogConnect = 0
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Invalid input for Catalog connect.'
		GOTO ERROR_EXIT
	END
	IF @useCatalogConnect = 1 AND
		(@catUser = @noParameter OR
		@catPwd = @noParameter OR
		@catService = @noParameter OR
		@hostuser = @noParameter)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Please provide Catalog connect parameters and host user name.'
		GOTO ERROR_EXIT
	END
IF LEN(@instanceName ) > 100
	BEGIN
		SET @errorCode = 1
SET @errorString = 'Error. Instance name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
		GOTO ERROR_EXIT
	END
	--if no catalog connect is NOT used then the username and password that follow it are for the host computer.
	IF @useCatalogConnect = 0
	BEGIN
		SET @hostuser = @catUser
		SET @ntpwd = @catPwd
		SET @catUser = ''
		SET @catPwd = ''
		SET @catService = ''
	END
	--split hostuser into domain name and user name
	DECLARE @domainName nvarchar(1024)
	SET @domainName= ''
	DECLARE @userName nvarchar(1024)
	SET @userName = SUBSTRING(@hostuser, charindex('\', @hostuser, 0)+1, LEN(@hostuser))
	IF @userName = @hostuser
	BEGIN
		SET @userName = SUBSTRING(@hostuser, charindex('/', @hostuser, 0)+1, LEN(@hostuser))
	END
	SET @domainName = SUBSTRING(@hostuser, 0, LEN(@hostuser)-LEN(@userName))
	--nt password
	IF @ntpwd = @noParameter
		SET @ntpwd = ''
END  --IF @instanceName <> @onDmndInst
BEGIN TRAN
--Create instance
INSERT INTO APP_InstanceName (name, reftime, modified, status) VALUES(@instanceName, @nowTime, 0, @instStatus)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Could not create instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @instanceId integer
SET @instanceId = @@IDENTITY
IF @instanceName <> @onDmndInst
BEGIN
	--Create instance properties
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Oracle Home', 1, @homeDir, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Oracle Version', 1, @version, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Domain Name', 1, @domainName, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Oracle User', 1, @userName, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Domain User Password', 1, @ntPwd, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect', 1, @user, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect Password', 1, @pwd, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect Machine', 1, @service, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'use Catalog Connect', 2, @useCatalogConnect, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Catalog Connect', 1, @catUser, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Catalog Connect Password', 1, @catPwd, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Catalog Connect Machine', 1, @catService, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'TNS admin path', 1, '', @nowTime, 0)
END
--Create default backupset
INSERT INTO APP_BackupsetName (name, refTime, modified, status) VALUES ('default', @nowTime, 0, 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error tryint to create instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @backupsetId integer
SET @backupsetId = @@IDENTITY
--Create default SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @oracleApptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, 0, 'default', 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error tryint to create default subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
--Create commandline SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @oracleApptype, @instanceId, @backupsetId, 0, @cmdArchGrpId , @logArchGrpId , @nowTime, 0, '(command line)', 64)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error trying to create subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
TRANS_EXIT:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
ERROR_EXIT:
Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateOracleInstance')
	delete from GxQscripts where name = 'QS_CreateOracleInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateOracleInstance')
	delete from GXDBVersions where aliasname = 'QS_CreateOracleInstance'
GO

insert into GXDBVersions values(2, 'QS_CreateOracleInstance',  '00000000000000000000', 'QS_CreateOracleInstance', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateOracleInstance',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateOracleInstance.sql -si client_name -si instance_name -si oracle_home -si Oracle_version	-si default_Storage_policy -si log_storage_policy -si cmd_storage_policy -si Oracle_user -p2 Oracle_pwd -si Oracle_service -si yes/no(catalog_connect) [-si catalog_user] [-p2 catalog_pwd] [-si catalog_service] -si host_user [-p2 host_pwd]
'
 + CHAR(10) + '--   script_name : CreateOracleInstance'
)
GO

