

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateOperationWindowRule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_createoperationwindowrule')
BEGIN
	print '>>> Drop Stored Procedure: QS_createoperationwindowrule <<<'
	drop procedure QS_createoperationwindowrule
END
IF EXISTS (select * from GxQscripts where name='QS_createoperationwindowrule')
	delete from GxQscripts where name = 'QS_createoperationwindowrule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_createoperationwindowrule')
	delete from GXDBVersions where aliasname = 'QS_createoperationwindowrule'
GO
print '... Creating Procedure: QS_createoperationwindowrule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_createoperationwindowrule
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @param1 AS NVARCHAR(512) = '',
  @param2 AS NVARCHAR(512) = '',
  @param3 AS NVARCHAR(512) = '',
  @param4 AS NVARCHAR(512) = '',
  @param5 AS NVARCHAR(512) = '',
  @param6 AS NVARCHAR(512) = '',
  @param7 AS NVARCHAR(512) = '',
  @param8 AS NVARCHAR(512) = '',
  @param9 AS NVARCHAR(512) = '',
  @param10 AS NVARCHAR(512) = ''
AS
DECLARE @clientOrGroupName		NVARCHAR(MAX) = ''
DECLARE @clientOrGroupNameValue	NVARCHAR(MAX) = ''
DECLARE @clientId				INT = 0
DECLARE @clientGroupId			INT = 0
DECLARE @opTypeId		INT = 0
DECLARE @daysOfWeekId	INT = 0
DECLARE @startDateValue	INT = 0
DECLARE @endDateValue	INT = 0
DECLARE @startTimeValue	INT = 0
DECLARE @endTimeValue	INT = 0
DECLARE @enableValue	INT = 0
DECLARE @utilization	INT	= 100
DECLARE @appTypeId		INT = 0
DECLARE @description	NVARCHAR(MAX) = ''
DECLARE @GMTTime		INT = dbo.GetUnixTime (GetUTCdate())
DECLARE @clientTime		INT = 0
DECLARE @timeOffSet		INT = 0
DECLARE @clientTimeZone	NVARCHAR(MAX) = ''
DECLARE @errorcode as INT = 0
DECLARE @errorstring as NVARCHAR(MAX) = 'Successful'
IF @param1 NOT LIKE 'c=%' AND @param1 NOT LIKE 'cg=%' AND @param1 != 'commserve'
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: First parameter is [' + @param1 + '], it must be ''c=client name'' OR ''cg=client group name'' OR ''commserve'' '
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		SET @clientOrGroupNameValue = SUBSTRING(@param1, (CHARINDEX('=', @param1) + 1 ), (LEN(@param1) - CHARINDEX('=', @param1)))
		IF @param1 LIKE 'c=%'
			BEGIN
				SET @clientId = ISNULL((SELECT id FROM APP_Client where name = @clientOrGroupNameValue), 0)
				IF @clientId = 0
				BEGIN
					SET		@errorstring = 'Error: First parameter client name ''c=' + @clientOrGroupNameValue + ''' is not correct. Please give correct client name.'
					SET		@errorcode = 1
					GOTO	ARGS_ERROR
				END
				SET @clientTimeZone	= dbo.GetClientTimeZone(@clientId)
			END
		ELSE IF @param1 LIKE 'cg=%'
			BEGIN
				SET @clientGroupId = ISNULL((SELECT id FROM APP_ClientGroup where name = @clientOrGroupNameValue), 0)
				IF @clientGroupId = 0
				BEGIN
					SET		@errorstring = 'Error: First parameter client group name ''cg=' + @clientOrGroupNameValue + ''' is not correct. Please give correct client group name.'
					SET		@errorcode = 1
					GOTO	ARGS_ERROR
				END
				SET @clientTimeZone	= dbo.GetClientTimeZone(2)
			END
		ELSE IF @param1 = 'commserve'
			BEGIN
				SET @clientId = 2
				SET @appTypeId = 1000
				SET @clientTimeZone	= dbo.GetClientTimeZone(@clientId)
			END
	END
--@GMTTime means now time at GMT.
--@clientTime means now time at client machine.
SET @clientTime = dbo.getunixtime(dbo.UTCToLocalTime(dbo.getdatetime(@GMTTime), @clientTimeZone))
SET @timeOffSet = (@GMTTime - @clientTime)
--Validate second parameter of operation type
IF @param2 = 'all'
	SET @opTypeId = 1048576
ELSE IF @param2 = 'backup'
	SET @opTypeId = 7
ELSE IF @param2 = 'restore'
	SET @opTypeId = 8
ELSE IF @param2 = 'admin'
	SET @opTypeId = 57072
ELSE
	BEGIN
		SET		@errorstring = 'Error: Second parameter [' + @param2 + '] is not correct. Valid operation names are [all / backup / restore / admin].'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate third parameter, day of week
DECLARE @length INT = 0
DECLARE @pos INT = 0
DECLARE @daysOfWeekName NVARCHAR(MAX) = ''
DECLARE @OriginalParam3 NVARCHAR(MAX) = @param3
SET @daysOfWeekId = 0
SET @length = LEN(@param3)
WHILE @length > 0
BEGIN
	SET @pos = PATINDEX('%,%', @param3)
	IF (@pos <> 0)
		BEGIN
			SET @daysOfWeekName = SUBSTRING(@param3, 0, @pos)
			SET @param3 = SUBSTRING(@param3, @pos+1, @length)
			SET @length = LEN(@param3)
		END
	ELSE
		BEGIN
			SET @daysOfWeekName = SUBSTRING(@param3, @pos+1, @length)
			SET @length = 0
		END
	SET @daysOfWeekName = REPLACE( @daysOfWeekName, ' ', '')
	IF @daysOfWeekName = 'Sunday'
		SET @daysOfWeekId |= 1
	ELSE IF @daysOfWeekName = 'Monday'
		SET @daysOfWeekId |= 2
	ELSE IF @daysOfWeekName = 'Tuesday'
		SET @daysOfWeekId |= 4
	ELSE IF @daysOfWeekName = 'Wednesday'
		SET @daysOfWeekId |= 8
	ELSE IF @daysOfWeekName = 'Thursday'
		SET @daysOfWeekId |= 16
	ELSE IF @daysOfWeekName = 'Friday'
		SET @daysOfWeekId |= 32
	ELSE IF @daysOfWeekName = 'Saturday'
		SET @daysOfWeekId |= 64
	ELSE
		BEGIN
			SET		@errorstring = 'Error: Third parameter [' + @OriginalParam3 + '], has invalid day of the week[' + @daysOfWeekName + ']. Valid days of weeks are comma separated[Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday].'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
END
IF @daysOfWeekId = 0
BEGIN
	SET		@errorstring = 'Error: Third parameter [' + @OriginalParam3 + '] is not correct. Valid days of week are comma separated[Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday].'
	SET		@errorcode = 1
	GOTO	ARGS_ERROR
END
--Validate fourth parameter, start date
IF ISDATE (@param4) = 1
	SET @startDateValue = CAST( (SELECT dbo.GetUnixTime(@param4)) AS INT)
ELSE
	BEGIN
		SET		@errorstring = 'Error: Fourth parameter [' + @param4 + '] is not correct. Please give valid start date as[MM-DD-YYYY].'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
SET @startDateValue = (@startDateValue + @timeOffSet)
--Validate fifth parameter, end date
IF ISDATE (@param5) = 1
BEGIN
	SET @endDateValue = CAST( (SELECT dbo.GetUnixTime(@param5)) AS INT)
	SET @endDateValue = @endDateValue + @timeOffSet
	IF @endDateValue < @startDateValue
	BEGIN
		SET		@errorstring = 'Error: End date[' + @param5 + '] must be greater than start date[' + @param4 + ']'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
END
ELSE
	BEGIN
		SET		@errorstring = 'Error: Fifth parameter [' + @param5 + '] is not correct. Please give valid end date as[MM-DD-YYYY].'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate sixth parameter, start time
IF ISDATE(@param6) = 1
	BEGIN
		DECLARE @startTimeConverted DATETIME = CONVERT(datetime, @param6, 108)
		DECLARE @startHour	INT = DATEPART ( HOUR, @startTimeConverted )
		DECLARE @startMin	INT = DATEPART ( MINUTE, @startTimeConverted )
		SET @startTimeValue = CAST( (@startHour * 3600) + (@startMin * 60) AS INT)
	END
ELSE
	BEGIN
		SET		@errorstring = 'Error: Sixth parameter [' + @param6 + '] is not correct. Please give start time as [HH:MM] 24 hr format.'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate seventh parameter, end time
IF ISDATE(@param7) = 1
	BEGIN
		DECLARE @endTimeConverted DATETIME = CONVERT(datetime, @param7, 108)
		DECLARE @endHour	INT = DATEPART ( HOUR, @endTimeConverted )
		DECLARE @endMin		INT = DATEPART ( MINUTE, @endTimeConverted )
		SET @endTimeValue = CAST( (@endHour * 3600) + (@endMin * 60) AS INT)
	END
ELSE
	BEGIN
		SET		@errorstring = 'Error: Seventh parameter [' + @param7 + '] is not correct. Please give end time as [HH:MM] 24 hr format.'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate eighth parameter, enable
IF @param8 = 'true'
	SET @enableValue = 1
ELSE IF @param8 = 'false'
	SET @enableValue = 0
ELSE
	BEGIN
		SET		@errorstring = 'Error: Eighth parameter [' + @param8 + '] is not correct. Please give correct value of enable[true/false].'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate ninth parameter, ApptypeName
IF @param1 = 'commserve'
	BEGIN
		SET @appTypeId = 1000
	END
ELSE IF @param9 = '' OR @clientId = 0
	BEGIN
		SET @appTypeId = 0
	END
ELSE
	BEGIN
		SET @appTypeId=(select type from app_IDAType where name=@param9 AND type IN (select appTypeId from APP_Application where clientId = @clientId))
		IF  @appTypeId IS NULL
		BEGIN
			SET @appTypeId = (SELECT appTypeId FROM app_idaname
										WHERE clientid = @clientId
												AND appTypeId IN (SELECT DISTINCT appTypeId FROM simAppTypeLicTypeMap
												WHERE display_name = @param9))
		END
		IF  @appTypeId IS NULL
		BEGIN
			SET @appTypeId = (SELECT DISTINCT TOP 1 appTypeId FROM simAppTypeLicTypeMap
												WHERE display_name = @param9)
		END
		IF @appTypeId IS NULL
		BEGIN
			SET		@errorstring = 'Error: Ninth parameter Application name [' + @param9 + '] is not correct. Please give correct application name.'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
	END
--10th parameter
SET	@description = @param10
BEGIN TRAN
BEGIN TRY
	DECLARE @ruleId INT = ISNULL((Select MAX(id) from APP_OpWindowRule),0)
	IF @ruleId != 0
		SET @ruleId = @ruleId + 1
	ELSE
		SET @ruleId = 1
	INSERT APP_OpWindowRule (id, clientId,appTypeId, opType, daysOfWeek, startTime, endTime, enable, description, utilization, clientGroupId, instanceId, backupsetId, subclientId, startDate, endDate)
	VALUES (@ruleId, @clientId, @appTypeId, @opTypeId, @daysOfWeekId, @startTimeValue, @endTimeValue, @enableValue, @description, @utilization, @clientGroupId, 0, 0, 0, @startDateValue, @endDateValue)
	PRINT 'Successfully created operation window rule.'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	BEGIN
		SET @errorcode = ERROR_NUMBER()
		SET @errorstring = @errorstring + ERROR_MESSAGE()
	END
END CATCH
ALL_DONE:
	IF (@errorcode  = 0)
		commit Tran
	ELSE
		rollback Tran
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateOperationWindowRule')
	delete from GxQscripts where name = 'QS_CreateOperationWindowRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateOperationWindowRule')
	delete from GXDBVersions where aliasname = 'QS_CreateOperationWindowRule'
GO

insert into GXDBVersions values(2, 'QS_CreateOperationWindowRule',  '00000000000000000000', 'QS_CreateOperationWindowRule', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateOperationWindowRule',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ClientName/ClientGroupName/commserve -si OperationType -si DayofWeek -si Startdate -si Enddate -si StartTime -si EndTime -si Enable -si ApplicationName -si Description
'
 + CHAR(10) + '	Where 	(ClientName/ClientGroupName/commserve) would be ''c=testclient'' for client name OR ''cg=testGroup'' for client group name OR ''commserve''
'
 + CHAR(10) + '			OperationType	Operation types are ''all / backup / restore / admin''
'
 + CHAR(10) + '			DayOfWeek		Day of the week are comma separated[Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday]
'
 + CHAR(10) + '			StartDate		Format is MM-DD-YYYY
'
 + CHAR(10) + '			EndDate			Format is MM-DD-YYYY
'
 + CHAR(10) + '			StartTime		Format is 24 hrs HH:MM
'
 + CHAR(10) + '			EndTime			Format is 24 hrs HH:MM
'
 + CHAR(10) + '			Enable			true/false
'
 + CHAR(10) + '			ApplicationName	Optional parameter, Application name
'
 + CHAR(10) + '			Description		Optional parameter, Description of Operation Window
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ''c=clientname'' -si ''backup'' -si ''Monday, Wednesday, Friday'' -si ''04-20-2012'' -si ''04-21-2013'' -si ''09:00'' -si ''18:00'' -si true -si '''' -si ''Test Description, client backup''
'
 + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ''c=clientname'' -si ''restore'' -si ''Tuesday, Thursday, Saturday'' -si ''04-20-2012'' -si ''04-21-2013'' -si ''09:00'' -si ''18:00'' -si true -si ''File system'' -si ''Test Description, client restore''
'
 + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ''commserve'' -si ''restore'' -si ''Tuesday, Thursday, Saturday'' -si ''04-20-2012'' -si ''04-21-2013'' -si ''09:00'' -si ''18:00'' -si true -si '''' -si ''Test Description, commserve restore''
'
 + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ''cg=clientgroupname'' -si ''all'' -si Saturday -si ''04-20-2012'' -si ''04-20-2013'' -si ''09:00'' -si ''18:00'' -si true -si '''' -si ''Test Description, client group all operation''
'
 + CHAR(10) + '-- 	script_name: createoperationwindowrule'
 + CHAR(10) + '-- 	Create operation window rule'
)
GO

