

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateDB2Subclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CreateDB2Subclient.sp,v $ $Id: QS_CreateDB2Subclient.sp,v 1.4.208.2 2018/03/22 01:06:19 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateDB2Subclient <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateDB2Subclient')
	drop procedure QS_CreateDB2Subclient
IF EXISTS (select * from GxQscripts where name='QS_CreateDB2Subclient')
	delete from GxQscripts where name = 'QS_CreateDB2Subclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateDB2Subclient')
	delete from GXDBVersions where aliasname = 'QS_CreateDB2Subclient'
GO
print '... Creating Procedure: QS_CreateDB2Subclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CreateDB2Subclient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = '',
  @PARAM5 nvarchar(1024) = ''
AS
Set NOCOUNT ON
      -------------------INPUTS all mandatory----------------------------------
DECLARE @client varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @defSP varchar(1024)
DECLARE @backupsetName varchar(1024)
DECLARE @subclientName varchar(1024)
SET @client = @PARAM1
SET @instancename = @PARAM2
SET @defSP = @PARAM3
SET @backupsetName = @PARAM4
SET @subclientName = @PARAM5
     -------------------------------
      --select @client, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = '%%'
      SET @noParameter = @noParameter + 's'
     ----------------------const------------------------------
      DECLARE @scriptName nvarchar(128)
      SET @scriptName = 'CreateDB2Subclient'
      DECLARE @db2user nvarchar(128)
      SET @db2user = ''
      DECLARE @db2password nvarchar(128)
      SET @db2password = ''
      DECLARE @nowTime integer
      SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
      DECLARE @DB2Apptype varchar(128)
      SET @DB2Apptype = '62'
      DECLARE @defArchGrpId integer
      SET @defArchGrpId = 1
      DECLARE @logArchGrpId integer
      SET @logArchGrpId = 1
      DECLARE @cmdArchGrpId integer
      SET @cmdArchGrpId = 1
      DECLARE @instStatus integer
      SET @instStatus = 0
      DECLARE @instanceId integer
      SET @instanceId = 0
      DECLARE @backupsetId integer
      SET @backupsetId = 0
     ---------------------parameter 1 - client name--------------------------------------------
     IF @client = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @client), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] not found.'
     	GOTO ERROR_EXIT
     END
     IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @DB2Apptype)
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] does not have DB2 iDataAgent.'
     	GOTO ERROR_EXIT
     END
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     -----------------Validate other parameters---------------
    SET @instanceId =   ISNULL((SELECT distinct I.id
							from  APP_Application APP INNER JOIN  APP_InstanceName I
							ON APP.instance = I.id
							where APP.clientId = @clientId
							and APP.appTypeId = @DB2Apptype
							and I.name = @instanceName),0)
	IF (@instanceId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Instance ['+@instanceName+'] not found in client ['+@client+'] , apptype [' + @DB2Apptype + '].'
     	GOTO ERROR_EXIT
     END
     IF @defSP = @noParameter OR
    	@backupsetName = @noParameter
     	BEGIN
     		SET @errorCode = 1
    		SET @errorString = 'Error. The parameters supplied are not sufficient to create subclient. Please try again with all inputs.'
     		GOTO ERROR_EXIT
     END
     --get backupset id
    SET @backupsetId = ISNULL(( select distinct APP_BackupSetName.id
							from APP_BackupSetName, APP_Application, APP_Client, APP_InstanceName
							where APP_Application.clientId = APP_Client.id
							and APP_Application.appTypeId = @DB2Apptype
							and APP_Application.instance = APP_InstanceName.id
							and APP_BackupSetName.id = APP_Application.backupSet
							and APP_Client.name = @client
							and APP_InstanceName.name = @instanceName
							and APP_BackupSetName.name = @backupsetName), 0)
	IF (@backupsetId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Backupset ['+@backupsetName+'] not found in client ['+@client+'] , apptype [' + @DB2Apptype + '], instanceName [' +  @instanceName +'].'
     	GOTO ERROR_EXIT
     END
IF LEN(@subclientName) > 100
     BEGIN
		SET @errorCode = 1
SET @errorString = 'Error. Subclientname cannot be more than ' + CAST(100 AS VARCHAR(3))+ ' characters.'
		GOTO ERROR_EXIT
	 END
    SET @defArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @defSP), 0)
    SET @logArchGrpId = ISNULL((SELECT attrVal FROM APP_BackupSetProp WHERE attrName like 'DB2 Default index SP' and componentNameId = @backupsetId and modified = 0), 0)
    SET @cmdArchGrpId = ISNULL((SELECT attrVal FROM APP_InstanceProp WHERE attrName like 'DB2 Default Command Line SP' and componentNameId = @instanceId and modified = 0), 0)
     IF @defArchGrpId = 0 OR
     	@logArchGrpId = 0 OR
     	@cmdArchGrpId = 0
     BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Invalid storage policy given.'
     	GOTO ERROR_EXIT
     END
    BEGIN TRAN
    IF EXISTS (SELECT * FROM APP_Application A WHERE A.subclientName = @subclientName AND A.clientid = @clientId AND A.apptypeid = @DB2Apptype and A.instance = @instanceId and
		A.backupSet = @backupsetId and A.subclientStatus = 4)
    BEGIN
	update APP_Application
	SET subclientName = @subclientName + '_' + convert(varchar(1024),@nowTime) where subclientName = @subclientName 	AND clientid = @clientId AND apptypeid = @DB2Apptype and instance = @instanceId and
		backupSet = @backupsetId and subclientStatus = 4
    END
    IF EXISTS (SELECT * FROM APP_Application A WHERE A.subclientName = @subclientName AND A.clientid = @clientId AND                A.apptypeid = @DB2Apptype and A.instance = @instanceId and
		A.backupSet = @backupsetId )
    BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. subclient ['+@subclientName+'] already exists in client ['+@client+'].'
     	GOTO ERROR_EXIT
    END
     --Create  SC
     INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
     	VALUES(@clientId, @DB2Apptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, 0, @subclientName, 0)
     SET @errorCode = @@error
    IF @errorCode <> 0
    BEGIN
     	SET @errorString = 'Error. Error tryint to create  subclient for instance['+@instanceName +'].'
     	GOTO TRANS_EXIT
     END
    DECLARE @subclientId integer
    SET @subclientId = @@IDENTITY
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Single Instancing Option', 7, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Encrypt: encryption', 10, 2,@nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last data SP', 10, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last log SP', 10, 1, @nowTime ,0)
    INSERT INTO archPipeConfig(appNumber, compressWhere, numNWAgents, NWWriteSpeed)
				VALUES (@subclientId, 2, 2, 0)
     TRANS_EXIT:
     IF @errorCode <> 0
     	ROLLBACK TRAN
    ELSE
    	COMMIT TRAN
     --ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
     ERROR_EXIT:
    -- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
    if @errorCode <> 0
     	Raiserror(@errorString,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
    				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateDB2Subclient')
	delete from GxQscripts where name = 'QS_CreateDB2Subclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateDB2Subclient')
	delete from GXDBVersions where aliasname = 'QS_CreateDB2Subclient'
GO

insert into GXDBVersions values(2, 'QS_CreateDB2Subclient',  '00010004020800020000', 'QS_CreateDB2Subclient', '00010004020800020000')
GO

insert into GxQscripts values(2,'QS_CreateDB2Subclient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateDB2SubClient.sql -si cleintname -si instancename -si storagepolicy -si backupsetname -si subclientName
'
 + CHAR(10) + '-- 	script_name: CreateDB2SubClient.'
 + CHAR(10) + '-- 	creates new DB2 subclient under the given client, instance name and backupset.'
)
GO

