

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateDB2Backupset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CreateDB2Backupset.sp,v $ $Id: QS_CreateDB2Backupset.sp,v 1.3.208.3 2020/08/12 20:57:47 abhinawkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_CreateDB2BackupSet')
BEGIN
	print '>>> Drop Stored Procedure: QS_CreateDB2BackupSet <<<'
	drop procedure QS_CreateDB2BackupSet
END
IF EXISTS (select * from GxQscripts where name='QS_CreateDB2BackupSet')
	delete from GxQscripts where name = 'QS_CreateDB2BackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateDB2BackupSet')
	delete from GXDBVersions where aliasname = 'QS_CreateDB2BackupSet'
GO
print '... Creating Procedure: QS_CreateDB2BackupSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CreateDB2BackupSet
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = ''
AS
SET NOCOUNT ON
      -------------------INPUTS all mandatory----------------------------------
DECLARE @clientname varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @logSP varchar(1024)
DECLARE @backupsetName varchar(1024)
SET @clientname = @PARAM1
SET @instancename = @PARAM2
SET @logSP = @PARAM3
SET @backupsetName = @PARAM4
     -------------------------------
      --SET @clientname = 'bingo'
      --SET @instancename = '%s'
      --select @clientname, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = '%'
      SET @noParameter = @noParameter + 's'
     ----------------------const------------------------------
     DECLARE @scriptName nvarchar(128)
     SET @scriptName = 'CreateDB2BackupSet'
     DECLARE @db2user nvarchar(128)
     SET @db2user = ''
     DECLARE @db2password nvarchar(128)
     SET @db2password = ''
     DECLARE @nowTime integer
     SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
     DECLARE @DB2Apptype varchar(128)
     SET @DB2Apptype = '62'
     DECLARE @defArchGrpId integer
     SET @defArchGrpId = 1
     DECLARE @logArchGrpId integer
     SET @logArchGrpId = 1
     DECLARE @cmdArchGrpId integer
     SET @cmdArchGrpId = 1
     DECLARE @instStatus integer
     SET @instStatus = 0
     DECLARE @instanceId integer
     SET @instanceId = 0
     ---------------------parameter 1 - clientname name--------------------------------------------
     IF @clientname = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. clientname Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @clientname), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@clientname+'] not found.'
     	GOTO ERROR_EXIT
     END
     IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @DB2Apptype)
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@clientname+'] does not have DB2 iDataAgent.'
     	GOTO ERROR_EXIT
     END
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     -----------------Validate other parameters for ---------------
     SET @instanceId =   ISNULL((SELECT distinct I.id
							from  APP_Application APP INNER JOIN  APP_InstanceName I
							ON APP.instance = I.id
							where APP.clientId = @clientId
							and APP.appTypeId = @DB2Apptype
							and I.name = @instanceName),0)
	IF (@instanceId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Instance ['+@instanceName+'] not found in client ['+@clientname+'] , apptype [' + @DB2Apptype + '], instanceName [' +  @instanceName +'].'
     	GOTO ERROR_EXIT
     END
	IF @logSP = @noParameter OR
    	@backupsetName = @noParameter
     	BEGIN
     		SET @errorCode = 1
    		SET @errorString = 'Error. The parameters supplied are not sufficient to create backupset. Please try again with all inputs.'
     		GOTO ERROR_EXIT
     	END
IF LEN(@backupsetName)>100
     BEGIN
		SET @errorCode = 1
SET @errorString = 'Error. Backupset name cannot be more than ' + CAST (100 AS VARCHAR(3)) + ' characters.'
		GOTO ERROR_EXIT
	 END
     IF EXISTS (SELECT * FROM APP_backupSetName I INNER JOIN APP_Application A ON I.id = A.backupSet
     		WHERE I.name = @backupSetName AND A.clientid = @clientId AND A.apptypeid = @DB2Apptype and A.instance = @instanceId)
     BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Backupset ['+@backupsetName+'] already exists in client ['+@clientname+'].'
     	GOTO ERROR_EXIT
     END
    SET @logArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @logSP), 0)
    SET @defArchGrpId = ISNULL((SELECT attrVal FROM APP_InstanceProp WHERE attrName like 'DB2 Default Data SP' and componentNameId = @instanceId and modified = 0), 0)
    SET @cmdArchGrpId = ISNULL((SELECT attrVal FROM APP_InstanceProp WHERE attrName like 'DB2 Default Command Line SP' and componentNameId = @instanceId and modified = 0), 0)
     IF @defArchGrpId = 0 OR
     	@logArchGrpId = 0 OR
     	@cmdArchGrpId = 0
     BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Invalid storage policy given.'
     	GOTO ERROR_EXIT
     END
     BEGIN TRAN
     --Create backupset
     INSERT INTO APP_BackupsetName (name, refTime, modified, status) VALUES (@backupsetName, @nowTime, 0, 0)
     SET @errorCode = @@error
     IF @errorCode <> 0
     BEGIN
     	SET @errorString = 'Error. Error trying to create Backupset['+@backupsetName +'].'
     	GOTO TRANS_EXIT
     END
    DECLARE @backupsetId integer
    SET @backupsetId = @@IDENTITY
    SET @db2user = ISNULL((SELECT attrVal from APP_InstanceProp where attrName = 'DB2 User Id' and componentNameId = @instanceId and modified = 0),0)
    SET @db2password = ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) from APP_InstanceProp where attrName = 'DB2 Domain Password' and componentNameId = @instanceId and modified = 0),0)
    INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@backupsetId, 'DB2 Default Index SP', 7, @logArchGrpId, @nowTime ,0)
    INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@backupsetId, 'DB2 SQL Connect', 1, @db2user, @nowTime ,0)
    INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@backupsetId, 'DB2 SQL Connect Password', 1, @db2password, @nowTime ,0)
     --Create default SC
     INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
     	VALUES(@clientId, @DB2Apptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, 0, 'default', 8)
     SET @errorCode = @@error
    IF @errorCode <> 0
    BEGIN
     	SET @errorString = 'Error. Error trying to create default subclient for Backupset['+@backupsetName +'].'
     	GOTO TRANS_EXIT
     END
    DECLARE @subclientId integer
    SET @subclientId = @@IDENTITY
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Single Instancing Option', 7, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Encrypt: encryption', 10, 2,@nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last data SP', 10, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last log SP', 10, 1, @nowTime ,0)
    INSERT INTO archPipeConfig(appNumber, compressWhere, numNWAgents, NWWriteSpeed)
	VALUES (@subclientId, 2, 2, 0)
     --Create commandline SC
    INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
     	VALUES(@clientId, @DB2Apptype, @instanceId, @backupsetId, 0, @cmdArchGrpId , @logArchGrpId , @nowTime, 0, '(command line)', 64)
    SET @errorCode = @@error
     IF @errorCode <> 0
     BEGIN
     	SET @errorString = 'Error. Error trying to create subclient for backupset['+@backupsetName +'].'
     	GOTO TRANS_EXIT
     END
    DECLARE @cmdsubclientId integer
    SET @cmdsubclientId = @@IDENTITY
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdsubclientId, 'Single Instancing Option', 7, 1, @nowTime ,0)
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdsubclientId, 'Encrypt: encryption', 10, 2,@nowTime ,0)
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdsubclientId, 'last data SP', 10, 1, @nowTime ,0)
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdsubclientId, 'last log SP', 10, 1, @nowTime ,0)
     TRANS_EXIT:
     IF @errorCode <> 0
     	ROLLBACK TRAN
     ELSE
    	COMMIT TRAN
     --ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
     ERROR_EXIT:
     Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
    if @errorCode <> 0
     	Raiserror(@errorString,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
    				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateDB2Backupset')
	delete from GxQscripts where name = 'QS_CreateDB2Backupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateDB2Backupset')
	delete from GXDBVersions where aliasname = 'QS_CreateDB2Backupset'
GO

insert into GXDBVersions values(2, 'QS_CreateDB2Backupset',  '00010003020800030000', 'QS_CreateDB2Backupset', '00010003020800030000')
GO

insert into GxQscripts values(2,'QS_CreateDB2Backupset',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateDB2BackupSet.sql -si cleintname -si instancename -si logstoragepolicy -si backupsetname
'
 + CHAR(10) + '-- 	script_name: CreateDb2BackupSet.'
 + CHAR(10) + '-- 	create DB2 backup set under the given client and instance name.'
)
GO

