

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateCustomEntity.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateCustomEntity <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateCustomEntity')
	drop procedure QS_CreateCustomEntity
IF EXISTS (select * from GxQscripts where name='QS_CreateCustomEntity')
	delete from GxQscripts where name = 'QS_CreateCustomEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateCustomEntity')
	delete from GXDBVersions where aliasname = 'QS_CreateCustomEntity'
GO
print '... Creating Procedure: QS_CreateCustomEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CreateCustomEntity
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @entityName VARCHAR(512) = '',
  @operationType varchar(64) ='',
  @entityRegExFileName NVARCHAR(MAX) =N''
AS
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_CreateCustomEntity'
DECLARE @lastError int
SET @lastError = 0
DECLARE @localErrorMsg NVARCHAR(1024)
SET @localErrorMsg = N'Succeeded'
DECLARE @entityRegularExpression NVARCHAR(MAX)=N''
DECLARE @BulkInsertSql NVARCHAR(MAX)  =N''
CREATE TABLE #entityRegularExpression
(
entityRegularExpression nvarchar(max)
)
-----------------------invalid parameters------------------------------
IF @entityName	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Entity names is not provided in parameter 1.'
	GOTO ARGS_ERROR
END
IF @operationType	= @NoParameter OR @operationType NOT IN ('ADD', 'REMOVE','UPDATE')
BEGIN
	SET @lastError = 2
	SET @localErrorMsg = 'Error. Operation type ADD or REMOVE OR UPDATE is not provided in parameter 2.'
	GOTO ARGS_ERROR
END
IF @operationType IN ('ADD','UPDATE') AND @entityRegExFileName	= @NoParameter
BEGIN
	SET @lastError = 3
	SET @localErrorMsg = 'Error. Entity Regular expression file path is not provided in parameter 3.'
	GOTO ARGS_ERROR
END
------------------------------------------------------------------------
BEGIN TRY
BEGIN TRAN
	IF @operationType IN ('ADD','UPDATE')
		BEGIN
		SET @BulkInsertSql   =N'INSERT INTO #entityRegularExpression
										SELECT *
										FROM OPENROWSET (
										BULK ''' + @entityRegExFileName + ''',SINGLE_CLOB) as json'
		EXEC(@BulkInsertSql)
		SET  @entityRegularExpression =(select TOP 1 entityRegularExpression from #entityRegularExpression)
		IF NOT EXISTS (Select * from EntityAnnotator where Name = @entityName)
			BEGIN
				IF @operationType = 'ADD'		-- To add new custom entity
					BEGIN
						INSERT INTO EntityAnnotator (Name, Description, EntityType, Enabled, DataType, Flags, RegularExpression)
						VALUES (@entityName, '', 1, 1, 1, 0x0, @entityRegularExpression)
					END
				ELSE
					BEGIN
						SET @lastError = 4		--Update command when entity name does not exist. Throwing error with entity name does not exist.
						SET @localErrorMsg = 'Error. Entity Name ['+@entityName+'] does not exist.'
					END
			END
		ELSE
			IF @operationType = 'UPDATE'		--updating the entity with the details.
				BEGIN
					UPDATE EntityAnnotator
					SET RegularExpression=@entityRegularExpression
					WHERE Name = @entityName
				END
			ELSE IF @operationType = 'ADD'		-- custom entity name passed already exists so throwing the error.
				BEGIN
					SET @lastError = 5
					SET @localErrorMsg = 'Error. Can not add the custom entity as the entity name ['+@entityName+'] already exists.'
				END
	END
	IF @operationType = 'REMOVE'
	BEGIN
		IF EXISTS (Select * from EntityAnnotator where Name = @entityName)		--Deleting the entity if it exists.
		BEGIN
			DELETE Ep FROM EntityProcessor ep
			left JOIN EntitySelection ES
			ON ES.EntityRulerId=ep.EntityRulerId
			left JOIN EntityAnnotator EA
			ON EA.EntityID =ES.EntityID
			WHERE EA.Name= @entityName
			DELETE FROM EntityAnnotator where Name = @entityName
		END
		ELSE																	--Error as entity name passed to remove doesn't exist.
		BEGIN
			SET @lastError = 6
			SET @localErrorMsg = 'Error. Entity Name ['+@entityName+'] does not exist.'
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto TRANS_EXIT
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
IF OBJECT_ID('tempdb..#entityRegularExpression') IS NOT NULL
DROP TABLE #entityRegularExpression
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@entityName+'], ['+@operationType+ '], ['+ @entityRegExFileName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateCustomEntity')
	delete from GxQscripts where name = 'QS_CreateCustomEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateCustomEntity')
	delete from GXDBVersions where aliasname = 'QS_CreateCustomEntity'
GO

insert into GXDBVersions values(2, 'QS_CreateCustomEntity',  '00000000000000000000', 'QS_CreateCustomEntity', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateCustomEntity',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_CreateCustomEntity.sql -si ''EntityName'' -si ''ADD|REMOVE|UPDATE'' -si ''entityRegExFileName''
'
 + CHAR(10) + '	Creates a custom entity with the regex as input to extract the custom entity defined during entity extraction.
'
 + CHAR(10) + '-- 	EntityName: Entity name which will appear in the UI Eg. (''UKDL'')'
 + CHAR(10) + '-- 	OperationType:'
 + CHAR(10) + '-- 					ADD - to add a custom entity from the entityAnnonator'
 + CHAR(10) + '-- 					REMOVE  to remove a custom entity from the entityAnnonator'
 + CHAR(10) + '-- 					UPDATE  to UPDATE a custom entity regular expression from the entity passed		'
 + CHAR(10) + '-- 	entityRegExFileName: file path which contains the regex'
)
GO

