

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CreateClientGroup.sp,v $ $Id: QS_CreateClientGroup.sp,v 1.5.60.2 2018/03/22 01:05:25 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateClientGroup')
	drop procedure QS_CreateClientGroup
IF EXISTS (select * from GxQscripts where name='QS_CreateClientGroup')
	delete from GxQscripts where name = 'QS_CreateClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateClientGroup')
	delete from GXDBVersions where aliasname = 'QS_CreateClientGroup'
GO
print '... Creating Procedure: QS_CreateClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CreateClientGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @groupName nvarchar(1024),
  @groupDescription nvarchar(1024)=''
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(32)
	SET		@scriptName	= 'CreateClientGroup'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @now				integer
	DECLARE @userId				integer
	SET @now = dbo.GetUnixTime(GETDATE())
	SET @userId	 = 1
BEGIN TRY
BEGIN TRAN
	IF EXISTS(SELECT * FROM APP_ClientGroup WHERE name=@groupName )
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Group name ['+CAST(@groupName AS VARCHAR(10))+'] already exists.'
		GOTO TRANS_EXIT
	END
ELSE IF (LEN(@groupName)>100)
	BEGIN
		SET @lastError = 1
SET @localErrorMsg = 'Error. ClientGroup name cannot be more than '+ CAST (100 AS VARCHAR(3)) + ' characters.'
		GOTO TRANS_EXIT
	END
	INSERT INTO APP_ClientGroup VALUES (@groupName, @groupDescription, 0, 0, @userId, @now, @now, '', 2, NEWID())
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
			 + Convert(varchar(60), getdate())
			 + ' with Parameters: ['+@groupName+', '+@groupDescription+
			 + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateClientGroup')
	delete from GxQscripts where name = 'QS_CreateClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateClientGroup')
	delete from GXDBVersions where aliasname = 'QS_CreateClientGroup'
GO

insert into GXDBVersions values(2, 'QS_CreateClientGroup',  '00010005006000020000', 'QS_CreateClientGroup', '00010005006000020000')
GO

insert into GxQscripts values(2,'QS_CreateClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateClientGroup -si @groupName=''group_name'' -si @groupDescription=''group_description''
'
 + CHAR(10) + '	qoperation execscript -sn CreateClientGroup -si ''group_name'' -si ''group_description''
'
 + CHAR(10) + '-- 	script_name: CreateClientGroup.'
 + CHAR(10) + '-- 	exec_status: 1 for successful execution, 2 for failed execution. 0 for all status.'
)
GO

