

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConvertSyncToSelectiveCopy.sp] ---------- 

  -- ----------------------------------------------------------------------
  --
 --           Copyright (c) 1998  CommVault Systems, Inc.
 --                  All rights reserved.
 --
 --
 --        This is unpublished proprietary source code of CommVault
 --        Systems, Inc. The copyright notice above does not evidence
 --        any actual or intended publication of such source code.
 -- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ConvertSyncToSelectiveCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_ConvertSyncToSelectiveCopy')
	drop procedure QS_ConvertSyncToSelectiveCopy
IF EXISTS (select * from GxQscripts where name='QS_ConvertSyncToSelectiveCopy')
	delete from GxQscripts where name = 'QS_ConvertSyncToSelectiveCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConvertSyncToSelectiveCopy')
	delete from GXDBVersions where aliasname = 'QS_ConvertSyncToSelectiveCopy'
GO
print '... Creating Procedure: QS_ConvertSyncToSelectiveCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ConvertSyncToSelectiveCopy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
-- SP Input Params
  @i_StoragePolicy NVARCHAR(2048) = N'',
  @i_StoragePolicyCopy NVARCHAR(2048) = N''
AS
SET NOCOUNT ON
DECLARE @errorCode INTEGER
DECLARE @ErrorMessage NVARCHAR(MAX) = N''
DECLARE @i_SPId INTEGER
DECLARE @i_defaultSPCId INTEGER
DECLARE @i_SPCId INTEGER
DECLARE @i_sourceSPCId INTEGER
DECLARE @i_SPCType INTEGER
DECLARE @i_SPFlag	INTEGER
DECLARE @l_defaultSnapPrimaryCopyId INTEGER = -1
DECLARE @l_IsSnapCopy INTEGER = -1
DECLARE @l_SPType INTEGER = -1
DECLARE @i_extendedFlags INTEGER = 0
SET		@errorCode = 0
SET		@i_SPId = -1
SET		@i_defaultSPCId = -1
SET		@i_SPCId = -1
SET		@i_sourceSPCId = -1
SET		@i_SPCType = -1
SET		@i_SPFlag = -1
BEGIN TRANSACTION
	IF @i_StoragePolicy = N'' OR @i_StoragePolicyCopy = N''
	BEGIN
		SET	@errorCode = -1
		GOTO CX_EXIT
	END
	SELECT @i_SPId = Id, @i_defaultSPCId = defaultCopy, @i_SPFlag = flags,  @l_defaultSnapPrimaryCopyId = defaultSnapCopy, @l_SPType = type
	FROM archGroup WITH (NOLOCK)
	WHERE name = @i_StoragePolicy
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0
		GOTO CX_EXIT
IF @l_SPType = 2
	BEGIN
		SET	@errorCode = -9
		GOTO CX_EXIT
	END
	IF @i_SPId = -1
	BEGIN
		SET	@errorCode = -2
		GOTO CX_EXIT
	END
	IF @i_SPFlag & 256 <> 0
	BEGIN
		SET @errorCode = -3
		GOTO CX_EXIT
	END
	SELECT @i_SPCId = id, @i_SPCType = type, @i_sourceSPCId = sourceCopyId, @l_IsSnapCopy = isSnapCopy, @i_extendedFlags = extendedFlags
	FROM archGroupCopy WITH (NOLOCK)
	WHERE	name = @i_StoragePolicyCopy
			AND archGroupId = @i_SPId
			--AND isSnapCopy = 0
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0
		GOTO CX_EXIT
	IF @i_SPCId = -1
	BEGIN
		SET	@errorCode = -4
		GOTO CX_EXIT
	END
	IF @i_SPCType != 1
	BEGIN
		SET	@errorCode = -5
		GOTO CX_EXIT
	END
	IF @i_SPCId = @i_defaultSPCId
	BEGIN
		SET	@errorCode = -6
		GOTO CX_EXIT
	END
	IF (@i_sourceSPCId = 0)
		SET	@i_sourceSPCId = @i_defaultSPCId
	-- Check whether source copy is spool copy, if yes the check whether there is at least one active synchronous copy exists
	IF EXISTS (SELECT * FROM archAgingRule WHERE copyId = @i_sourceSPCId AND	retentionDays = 0 AND fullCycles = 0)
	BEGIN
		DECLARE @tblDestCopyForSource TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
		INSERT INTO @tblDestCopyForSource
		EXEC ArchDestinationCopyList @i_sourceSPCId
		IF (@l_IsSnapCopy <> 1 AND NOT EXISTS (
													SELECT * FROM @tblDestCopyForSource T, archGroupCopy
													WHERE T.copyId = id AND type = 1 AND isActive = 1 AND T.copyId <> @i_SPCId AND T.sourceCopyId = @i_sourceSPCId
											  )
											  )
		OR (@l_IsSnapCopy =  1 AND NOT EXISTS (
													SELECT * FROM @tblDestCopyForSource T, archGroupCopy AGC
													WHERE T.copyId = AGC.id AND AGC.type = 1 AND AGC.isActive = 1 AND T.copyId <> @i_SPCId AND T.sourceCopyId = @i_sourceSPCId AND AGC.isMirrorCopy = 0 AND AGC.isSnapCopy = 1
											  )
							   AND NOT EXISTS (
													SELECT * FROM archMaterializeSnapshotProp
													WHERE enabled = 1 AND type = 0 AND archGroupId = @i_SPId AND ( CASE WHEN sourceCopyId = 0 THEN @l_defaultSnapPrimaryCopyId ELSE sourceCopyId END) = @i_sourceSPCId
											  )
			)
		BEGIN
			SET	@errorCode = -7
			GOTO CX_EXIT
		END
	END
	-- Check whether is any synchronous destination copy exists
	BEGIN
		DECLARE @tblDestCopy TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
		INSERT INTO @tblDestCopy
		EXEC ArchDestinationCopyList @i_SPCId
		IF (EXISTS (SELECT * FROM @tblDestCopy T, archGroupCopy WHERE T.copyId = id AND type = 1 AND T.sourceCopyId = @i_SPCId AND (T.isSnapCopy = 0 OR (T.isSnapCopy = 1 AND T.isMirrorCopy = 0)) ))
		BEGIN
			SET	@errorCode = -8
			GOTO CX_EXIT
		END
	END
if @i_extendedFlags & 32768 > 0
	BEGIN
		print 'Warning: The option "Pick Data from Running Backups" is not supported for selective copies, This option will be reset'
	END
	UPDATE	archGroupCopy
SET		type = 2, startTime = (CASE WHEN startTime < 0 THEN startTime * -1 ELSE startTime END), extendedFlags = extendedFlags & ~32768
	WHERE	id = @i_SPCId
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0
		GOTO CX_EXIT
	--Selective Copy with All Fulls Selective Rule
	INSERT INTO archSelectiveCopy
	VALUES (@i_SPCId, 1, 1, 0, 0, 0, 0, 0)
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0
		GOTO CX_EXIT
CX_EXIT:
	IF @errorCode <> 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
	IF @errorCode = -1
		SET @ErrorMessage = 'Error: Either the storage policy name or the storage policy copy name is not provided'
	ELSE IF @errorCode = -2
		SET @ErrorMessage = 'Error: Invalid Storage Policy Name [' + @i_StoragePolicy + ']'
	ELSE IF @errorCode = -3
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] is a Global Dedup storage policy'
	ELSE IF @errorCode = -4
		SET @ErrorMessage = 'Error: Invalid Storage Policy Copy Name [' + @i_StoragePolicyCopy + ']'
	ELSE IF @errorCode = -5
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is not a synchronous copy'
	ELSE IF @errorCode = -6
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is a primary copy'
	ELSE IF @errorCode = -7
		SET @ErrorMessage = 'Error: Source copy is a spool copy and needs at least one active synchronous copy'
	ELSE IF @errorCode = -8
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is source to at least one synchronous copy'
	ELSE IF @errorCode = -9
		SET @ErrorMessage = 'Error: Cannot have selective Copy in DR Storage Policy'
	ELSE IF @errorCode = -10
		SET @ErrorMessage = 'Error: Cannot convert a copy to selective with "Pick Data from Running Backups" enabled, Please disable this option and retry the conversion'
	ELSE IF @errorCode <> 0
		SET @ErrorMessage = 'Error: Failed to execute script. Error code [' + CAST(@errorCode AS VARCHAR(20)) + '], Error Message [' + @ErrorMessage + ']'
	ELSE
		SET @ErrorMessage = 'Success: ConvertSyncToSelectiveCopy completed successfully'
	SET	@ErrorMessage = @ErrorMessage + ', ' + CONVERT(VARCHAR(60), GETDATE())+'.'
	IF @errorCode NOT IN (0)
		Raiserror(@ErrorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConvertSyncToSelectiveCopy')
	delete from GxQscripts where name = 'QS_ConvertSyncToSelectiveCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConvertSyncToSelectiveCopy')
	delete from GXDBVersions where aliasname = 'QS_ConvertSyncToSelectiveCopy'
GO

insert into GXDBVersions values(2, 'QS_ConvertSyncToSelectiveCopy',  '00000000000000000000', 'QS_ConvertSyncToSelectiveCopy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ConvertSyncToSelectiveCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn QS_ConvertSyncToSelectiveCopy -si StoragePolicyName -si StoragePolicyCopyName 
'
 + CHAR(10) + ' script_name : QS_ConvertSyncToSelectiveCopy
'
)
GO

