

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConvertSelectiveToSyncCopy.sp] ---------- 

  -- ----------------------------------------------------------------------
  --
 --           Copyright (c) 1998  CommVault Systems, Inc.
 --                  All rights reserved.
 --
 --
 --        This is unpublished proprietary source code of CommVault
 --        Systems, Inc. The copyright notice above does not evidence
 --        any actual or intended publication of such source code.
 -- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ConvertSelectiveToSyncCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_ConvertSelectiveToSyncCopy')
	drop procedure QS_ConvertSelectiveToSyncCopy
IF EXISTS (select * from GxQscripts where name='QS_ConvertSelectiveToSyncCopy')
	delete from GxQscripts where name = 'QS_ConvertSelectiveToSyncCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConvertSelectiveToSyncCopy')
	delete from GXDBVersions where aliasname = 'QS_ConvertSelectiveToSyncCopy'
GO
print '... Creating Procedure: QS_ConvertSelectiveToSyncCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ConvertSelectiveToSyncCopy
--Modified for Checkin
--QScript is enabled
-- QScript secure this script does the user validation
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
-- SP Input Params
  @i_StoragePolicy NVARCHAR(2048) = N'',
  @i_StoragePolicyCopy NVARCHAR(2048) = N''
AS
SET NOCOUNT ON
DECLARE @errorCode INTEGER = 0
DECLARE @ErrorMessage NVARCHAR(MAX) = N''
DECLARE @l_SPId INTEGER = -1
DECLARE @l_defaultSPCId INTEGER = -1
DECLARE @l_SPCId INTEGER = -1
DECLARE @l_SPCType INTEGER = -1
DECLARE @l_IsSnapCopy INTEGER = -1
DECLARE @l_currentTime INTEGER = dbo.GetUnixTime(GetUTCDate())
BEGIN TRANSACTION
	SELECT @l_SPId = Id, @l_defaultSPCId = defaultCopy
	FROM archGroup WITH (NOLOCK)
	WHERE name = @i_StoragePolicy
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @l_SPId = -1
	BEGIN
		SET	@errorCode = -1
		GOTO CX_EXIT
	END
	SELECT @l_SPCId = id, @l_SPCType = type, @l_IsSnapCopy = isSnapCopy
	FROM archGroupCopy WITH (NOLOCK)
	WHERE	name = @i_StoragePolicyCopy
			AND archGroupId = @l_SPId
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @l_SPCId = -1
	BEGIN
		SET	@errorCode = -2
		GOTO CX_EXIT
	END
	IF @l_SPCId = @l_defaultSPCId
	BEGIN
		SET	@errorCode = -4
		GOTO CX_EXIT
	END
	IF @l_SPCType != 2
	BEGIN
		SET	@errorCode = -3
		GOTO CX_EXIT
	END
	IF @l_IsSnapCopy = 1
	BEGIN
		SET	@errorCode = -5
		GOTO CX_EXIT
	END
	UPDATE	archGroupCopy
	SET		type = 1, flags = flags &~(4096|8192) /*CVA_AGCOPYTYPE_SYNC=2, CVA_LAST_FULL_FLAG=4096, CVA_LAST_FULL_WAIT_FLAG=8192 */
	WHERE	id = @l_SPCId
			AND type = 2  /*CVA_AGCOPYTYPE_SPARSE  */
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0 GOTO CX_EXIT
	DELETE FROM archSelectiveCopy
	WHERE	copyId = @l_SPCId
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0 GOTO CX_EXIT
      DECLARE @userId integer
      SET @userId = 0
     -- get quser id
     SET @userId =  ISNULL( (select userId from #tempQSUser),0)
     IF (@userId = 0)
     BEGIN
		SET @errorCode = -6
		GOTO CX_EXIT
     END
	-- Declare temp variables for Gui Audit
	DECLARE @opMsgId 			INTEGER
	DECLARE @opEvMsgId 		INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId 	INTEGER
	-- Assume admin user here
	DECLARE @GUIAuditUserId INT
	SELECT	@GUIAuditUserId = @userId
	-- Set Gui Audit Operation
	SET @opMsgId = 1409286158 -- GUIAUDIT_OPS_CHANGE_SP_COPY_PROPS, 14
	EXEC EvGuiAuditSetOpWithEntity @opMsgId, @GUIAuditUserId, 17, @l_SPId, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @paramMsgId = 1426063386 -- GUIAUDIT_PARAMS_STORAGE_POLICY, 26
	EXEC EvGuiAuditSetParamData @opId, @i_StoragePolicy, 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
	SET @paramMsgId = 1426063387 -- GUIAUDIT_PARAMS_STORAGE_POLICY_COPY, 27
	EXEC EvGuiAuditSetParamData @opId, @i_StoragePolicyCopy, 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
	SET @paramMsgId = 1426063507 --GUIAUDIT_PARAMS_CI_SP_MOD_TYPE, 147
	EXEC EvGuiAuditSetParamData @opId, 'Selective', 1
	EXEC EvGuiAuditSetParamData @opId, 'Synchronous', 1
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
CX_EXIT:
	IF @errorCode <> 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
	IF @errorCode = -1
		SET @ErrorMessage = 'Error: Invalid Storage Policy Name [' + @i_StoragePolicy + ']'
	ELSE IF @errorCode = -2
		SET @ErrorMessage = 'Error: Invalid Storage Policy Copy Name [' + @i_StoragePolicyCopy + ']'
	ELSE IF @errorCode = -3
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is not a selective copy'
	ELSE IF @errorCode = -4
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is primary copy'
	ELSE IF @errorCode = -5
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is a snap copy'
	ELSE IF @errorCode = -6
		SET @ErrorMessage = 'Error: Logged in user information not found'
	ELSE IF @errorCode <> 0
		SET @ErrorMessage = 'Error: Failed to execute script. Error code [' + CAST(@errorCode AS VARCHAR(20)) + '], Error Message [' + @ErrorMessage + ']'
	ELSE
		SET @ErrorMessage = 'ConvertSelectiveToSyncCopy completed successfully at '	+ CONVERT(VARCHAR(60), GETDATE())+'.'
	IF @errorCode NOT IN (0)
		Raiserror(@ErrorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	ELSE
		SELECT	@ErrorMessage
	RETURN  @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConvertSelectiveToSyncCopy')
	delete from GxQscripts where name = 'QS_ConvertSelectiveToSyncCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConvertSelectiveToSyncCopy')
	delete from GXDBVersions where aliasname = 'QS_ConvertSelectiveToSyncCopy'
GO

insert into GXDBVersions values(2, 'QS_ConvertSelectiveToSyncCopy',  '00000000000000000000', 'QS_ConvertSelectiveToSyncCopy', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_ConvertSelectiveToSyncCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn ConvertSelectiveToSyncCopy -si StoragePolicyName -si StoragePolicyCopyName 
'
 + CHAR(10) + ' script_name : ConvertSelectiveToSyncCopy
'
)
GO

