

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConvertNextGRCExportAsFull.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ConvertNextGRCExportAsFull <<<'

IF EXISTS (select * from sysobjects where name='QS_ConvertNextGRCExportAsFull')
	drop procedure QS_ConvertNextGRCExportAsFull
IF EXISTS (select * from GxQscripts where name='QS_ConvertNextGRCExportAsFull')
	delete from GxQscripts where name = 'QS_ConvertNextGRCExportAsFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConvertNextGRCExportAsFull')
	delete from GXDBVersions where aliasname = 'QS_ConvertNextGRCExportAsFull'
GO
print '... Creating Procedure: QS_ConvertNextGRCExportAsFull'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ConvertNextGRCExportAsFull
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_ccName VARCHAR(1024)
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'ConvertNextGRCExportAsFull'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @l_ccId integer
BEGIN TRY
BEGIN TRAN
	IF(@PARAM1 = @NoParameter) --Requires commcell name
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_ConvertNextGRCExportAsFull'
		SET @localErrorMsg = 'Error: Insufficient command line parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SET @i_ccName = @PARAM1
	--------------------------------------------------------
	--Validate commcell name
	SELECT @l_ccId = id FROM App_CommCell WHERE aliasName = @i_ccName
	IF ISNULL(@l_ccId, 0) = 0
	BEGIN
		SET @localErrorMsg	=	'Error: Invalid CommCell ['+ @i_ccName + ']'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	DELETE 	GRC_SubClientTrackingStats
	WHERE	commcellId = @l_ccId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = ISNULL(ERROR_MESSAGE(), 'Error: Unknown')
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
		print 'Successfully converted next GRC Export job as full for CommCell [' + @i_ccName + '].'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConvertNextGRCExportAsFull')
	delete from GxQscripts where name = 'QS_ConvertNextGRCExportAsFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConvertNextGRCExportAsFull')
	delete from GXDBVersions where aliasname = 'QS_ConvertNextGRCExportAsFull'
GO

insert into GXDBVersions values(2, 'QS_ConvertNextGRCExportAsFull',  '00000000000000000000', 'QS_ConvertNextGRCExportAsFull', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ConvertNextGRCExportAsFull',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn ConvertNextGRCExportAsFull -si <GRC CommCell Name>'
)
GO

