

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ContainerSetup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ContainerSetup.sp,v $ $Id: QS_ContainerSetup.sp,v 1.1.2.3 2018/03/22 01:02:05 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ContainerSetup <<<'

IF EXISTS (select * from sysobjects where name='QS_ContainerSetup')
	drop procedure QS_ContainerSetup
IF EXISTS (select * from GxQscripts where name='QS_ContainerSetup')
	delete from GxQscripts where name = 'QS_ContainerSetup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ContainerSetup')
	delete from GXDBVersions where aliasname = 'QS_ContainerSetup'
GO
print '... Creating Procedure: QS_ContainerSetup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ContainerSetup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_containerName varchar(1024)='',
  @i_command varchar(1024)='',
  @i_input varchar(1024)=''
AS
Set NOCOUNT ON
declare @c_ContainerId integer = 0
declare @c_flag integer = 0
declare @c_capacity integer = 0
declare @c_numMedia integer = 0
declare @c_description NVARCHAR(max) = ''
declare @c_trackingID NVARCHAR(1024) = ''
declare @tblOutput table (message nvarchar(max))
if @i_containerName = ''
begin
	if @i_command <> 'list'
	begin
		insert into @tblOutput select 'Error: invalid command. Expect list!'
		goto PROC_EXIT
	end
	select ContainerName, Capacity,
	case when flag&1=1 then 'System' else 'User' end as CreatedBy,
	case when flag&2=2 then 'Yes' else 'No' end as Offsite,
	(select count(*) from MMMedia M with (nolock) where M.containerId = C.containerId),
	TrackingID, Descript
	from MMContainer C with (nolock)
	where containerId > 0
	goto PROC_EXIT
end
else
begin
	select @c_ContainerId = containerID, @c_flag = flag, @c_capacity = capacity, @c_description = Descript, @c_trackingID = TrackingId
	from MMContainer with (NOLOCK)
	where ContainerName = @i_containerName
	if @@rowcount = 0
	begin
		insert into @tblOutput select 'Error: container is not found in database!'
		goto PROC_EXIT
	end
	set @c_numMedia = (select count(*) from MMMedia with (nolock) where containerId = @c_containerId)
end
if @i_command = 'info'
begin
	insert into @tblOutput select 'Container Name: ' + @i_containerName
	insert into @tblOutput select 'Description: ' + @c_description
	insert into @tblOutput select 'Tracking ID: ' + @c_trackingID
	insert into @tblOutput select 'Capacity: ' + CAST(@c_capacity AS VARCHAR(100))
	insert into @tblOutput select 'Media Count: ' + CAST(@c_numMedia AS VARCHAR(100))
	if @c_flag & 1 = 1
		insert into @tblOutput select 'Created by: ' + 'system'
	else
		insert into @tblOutput select 'Created by: ' + 'user'
	if @c_flag & 2 = 2
		insert into @tblOutput select 'Offsite: ' + 'true'
	else
		insert into @tblOutput select 'Onsite: ' + 'true'
end
else if @i_command = 'offsite'
begin
	if @i_input = 'Yes'
	begin
		update MMContainer set flag = flag | 2
		where containerId = @c_containerId
		if @@error = 0
			insert into @tblOutput select 'Successfully set container offsite.'
		else
		begin
			insert into @tblOutput select 'Error: failed to set container offsite!'
			goto PROC_EXIT
		end
	end
	else if @i_input = 'No'
	begin
		update MMContainer set flag = flag & ~ 2
		where containerId = @c_containerId
		if @@error = 0
			insert into @tblOutput select 'Successfully set container onsite.'
		else
		begin
			insert into @tblOutput select 'Error: failed to set container onsite!'
			goto PROC_EXIT
		end
	end
	else
	begin
		insert into @tblOutput select 'Error: Invalid offsite value!'
		goto PROC_EXIT
	end
end
else if @i_command = 'description'
begin
	update MMContainer set Descript = @i_input
	where containerId = @c_containerId
	if @@error = 0
		insert into @tblOutput select 'Successfully set container description.'
	else
	begin
		insert into @tblOutput select 'Error: failed to set container description!'
		goto PROC_EXIT
	end
end
else if @i_command = 'tracking'
begin
	update MMContainer set TrackingId = @i_input
	where containerId = @c_containerId
	if @@error = 0
		insert into @tblOutput select 'Successfully set container tracking ID.'
	else
	begin
		insert into @tblOutput select 'Error: failed to set container tracking ID!'
		goto PROC_EXIT
	end
end
else if @i_command = 'capacity'
begin
	if ISNUMERIC(@i_input) = 0 or cast (@i_input as int) <= 0
	begin
		insert into @tblOutput select 'Error: invalid capacity input!'
		goto PROC_EXIT
	end
	if @c_numMedia > cast (@i_input as int)
	begin
		insert into @tblOutput select 'Error: container has more media than the new capacity!'
		goto PROC_EXIT
	end
	update MMContainer set capacity = cast(@i_input as int)
	where containerId = @c_containerId
	if @@error = 0
		insert into @tblOutput select 'Successfully set container capacity.'
	else
	begin
		insert into @tblOutput select 'Error: failed to set container capacity!'
		goto PROC_EXIT
	end
end
else
begin
		insert into @tblOutput select 'Error: Invalid command!'
		goto PROC_EXIT
end
PROC_EXIT:
if exists (select * from @tblOutput)
	select * from @tblOutput
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ContainerSetup')
	delete from GxQscripts where name = 'QS_ContainerSetup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ContainerSetup')
	delete from GXDBVersions where aliasname = 'QS_ContainerSetup'
GO

insert into GXDBVersions values(2, 'QS_ContainerSetup',  '00010001000200030000', 'QS_ContainerSetup', '00010001000200030000')
GO

insert into GxQscripts values(2,'QS_ContainerSetup',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn ContainerSetup -si container_name -si info'
 + CHAR(10) + '-- 		qoperation execscript -sn ContainerSetup -si container_name -si offsite -si yes/no'
 + CHAR(10) + '-- 		qoperation execscript -sn ContainerSetup -si container_name -si description -si new_description'
 + CHAR(10) + '-- 		qoperation execscript -sn ContainerSetup -si container_name -si tracking -si new_tracking_ID'
 + CHAR(10) + '-- 		qoperation execscript -sn ContainerSetup -si container_name -si capacity -si new_capacity'
 + CHAR(10) + '-- 		qoperation execscript -sn ContainerSetup -si ''''	-si list'
)
GO

