

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConfigureSIDBStoreAndSubStoreInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ConfigureSIDBStoreAndSubStoreInfo.sp,v $ $Id: QS_ConfigureSIDBStoreAndSubStoreInfo.sp,v 1.13.44.7 2019/05/31 19:50:20 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ConfigureSIDBStoreAndSubStoreInfo')
BEGIN
	print '>>> Drop Stored Procedure: QS_ConfigureSIDBStoreAndSubStoreInfo <<<'
	drop procedure QS_ConfigureSIDBStoreAndSubStoreInfo
END
IF EXISTS (select * from GxQscripts where name='QS_ConfigureSIDBStoreAndSubStoreInfo')
	delete from GxQscripts where name = 'QS_ConfigureSIDBStoreAndSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureSIDBStoreAndSubStoreInfo')
	delete from GXDBVersions where aliasname = 'QS_ConfigureSIDBStoreAndSubStoreInfo'
GO
print '... Creating Procedure: QS_ConfigureSIDBStoreAndSubStoreInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ConfigureSIDBStoreAndSubStoreInfo
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_GroupNum int,
  @strXMLPath nvarchar(255),
  @strXML nvarchar(1024)
AS
  DECLARE @errCode integer;
  DECLARE @errStr varchar(MAX);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @errCode = 0
SET @errStr = 'NO ERROR'
DECLARE @iDoc INTEGER
Declare @numSubStores int
Declare @clientId int
Declare @commCellId int
Declare @storeName varchar(250)
Declare @accesspath varchar(250)
Declare @createTime int
Declare @loopVar int
Declare @numGroups int
Declare @splitsPerGroup int
Declare @remainder int
DECLARE @input xml
Declare @copyId int
DECLARE @SQLString nvarchar(500);
DECLARE @ParmDefinition nvarchar(500);
SET @createTime = dbo.GetUnixTime(GETUTCDATE())
SET @loopVar = 0
---------------------------------To Be Populated Manually---------------------------------
set @numSubStores = 0
set @clientId = 0
set @commCellId = 0
set @accesspath = ''
set @numGroups = @i_GroupNum
--set @input = '<DedupInfo storeName="SIDBStore_1" commCellId="2" clientId="2" copyId="3">
--		<SubStoreInfo accessPath="E:\substore3\path1" clientId="2" commCellId="2"/>
--		<SubStoreInfo accessPath="E:\substore3\path2" clientId="2" commCellId="2"/>
--		<SubStoreInfo accessPath="E:\substore3\path3" clientId="2" commCellId="2"/>
--	     </DedupInfo>'
if (@strXML <> '')
begin
	set @input = @strXML
end
else
begin
	SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @strXMLPath + ''', SINGLE_CLOB ) AS xmlData)';
	SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
	EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
end
------------------------------------------------------------------------------------------
exec sp_xml_preparedocument @iDoc OUTPUT, @input
	SET @numSubStores =
	(
		SELECT count(*)
		FROM
			OPENXML(@iDoc, 'DedupInfo/SubStoreInfo', 0) WITH (accesspath NVARCHAR(250) '@accessPath')
	)
	IF(@numSubStores = 0 or @numSubStores is null)
	BEGIN
		SET @errStr = 'NO SubStores Specified'
		SET @errCode = 1
		GOTO CX_EXIT
	END
	set @splitsPerGroup = @numSubStores / @numGroups
	set @remainder = @numSubStores % @numGroups
	SELECT @copyId = copyId
	FROM
		OPENXML(@iDoc, 'DedupInfo', 0)WITH(copyId NVARCHAR(250) '@copyId')
	IF(@copyId = 0 or @copyId is null)
	BEGIN
		SET @errStr = 'NO CopyId Specified'
		SET @errCode = 2
		GOTO CX_EXIT
	END
	SELECT @storeName = storeName
	FROM
		OPENXML(@iDoc, 'DedupInfo', 0)WITH(storeName NVARCHAR(250) '@storeName')
	SELECT @clientId = clientId
	FROM
		OPENXML(@iDoc, 'DedupInfo', 0)WITH(clientId int '@clientId')
	IF(@clientId = 0 or @clientId is null)
	BEGIN
		SET @errStr = 'NO clientId Specified'
		SET @errCode = 3
		GOTO CX_EXIT
	END
	SELECT @commCellId = commCellId
	FROM
		OPENXML(@iDoc, 'DedupInfo', 0)WITH(commCellId int '@commCellId')
	IF(@commCellId = 0 or @commCellId is null)
	BEGIN
		SET @errStr = 'NO commCellId Specified'
		SET @errCode = 4
		GOTO CX_EXIT
	END
	-- Retreive the substore information from the XML
	SELECT
			tXml.accessPath			as 'accessPath',
			tXml.clientId			as 'clientId',
			tXml.commCellId			as 'commCellId'
	INTO #tempSubStore
	FROM
		OPENXML(@iDoc, 'DedupInfo/SubStoreInfo', 0)
		WITH
		(
			accessPath			nvarchar(250)	'@accessPath',
			clientId			INTEGER		'@clientId',
			commCellId			INTEGER		'@commCellId'
		) as tXml
--select * from #tempSubStore
-- find if an active store exists for this copy
Declare @sidbStoreId int
if not exists (select * from IdxSIDBStore where SIDBStoreId in (select SIDBStoreId from archCopySIDBStore where copyId = @copyId and commCellId = @commCellId) and status = 0)
begin
/*
INSERT INTO IdxSIDBStore
           ([SIDBStoreName],[SIDBStoreAliasName],[CommCellId],[IdxCacheId]
           ,[IdxAccessPathId],[ClientId],[FirstBackupTime],[MinObjSizeKB]
           ,[oldestEligibleObjArchiveTime],[SignatureType],[flags]
           ,[TotalDataSizeBytes],[InstancedDataSizeBytes],[Status],[LastAccessTime]
           ,[CreatedTime],[SealedTime],[origCCSIDBStoreId],[Version]
           ,[SIDBSnapPath],[LastSnapTime],[LastRecoveryTime],[SealedReason]
           ,[SIDBSiloedTime],[SIDBSiloStatus],[SIDBSiloJobId], [SubStoreCount], [MaxAllowedConnections], [MaxNumOfAFsInSecFile])
     VALUES
           (@storeName,@storeName ,@commCellId,0
           ,0,@clientId,0,50
           ,365,4,3145730
           ,0,0,0,0
           ,@createTime,0,0,-1
           ,'',0,0,0
           ,0,0,0, 1,0,0)
*/
goto CX_EXIT
end
else
begin
	select @sidbStoreId = SIDBStoreId from IdxSIDBStore where SIDBStoreId in (select SIDBStoreId from archCopySIDBStore where copyId = @copyId and commCellId = @commCellId) and status = 0
end
DECLARE curSubStore CURSOR FOR
	SELECT *
	FROM #tempSubStore TM
OPEN curSubStore
FETCH NEXT FROM curSubStore INTO @accesspath, @clientId, @commCellId
declare @splitGroupCount int
declare @groupNum int
set @splitGroupCount = 1
set @groupNum = 0
WHILE (@loopVar < @numSubStores)
BEGIN
IF not exists (select * from IdxAccessPath IA WITH (NOLOCK) Where IA.Path = @accessPath)
BEGIN
	Declare @poolId int
	INSERT INTO IdxPool
	           ([Description],[Enabled],[IsShared],[AgeingNoOfDays])
	     VALUES
	           ('Parallel Dedup POOL',1,0,20)
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: QS_ConfigureSIDBStoreAndSubStoreInfo -- Insert Pool Info Failed '
		GOTO CX_EXIT
	END
	Set @poolId = @@identity
	INSERT INTO IdxCache
	           ([IdxPoolId],[Description],[Enabled],[Creationtime]
	           ,[SoftState],[OfflineReason],[AgeingPercentDiskspace],[FillUpOrder]
	           ,[FreeDiskSpaceMB],[LastUpdateTime],[LastUpdateAPId],[DiskUsageMB]
	           ,[DiskUsageLastChecked],[DiskFreeThresholdMB],[DiskFreeWarningThreshholdMB],[IdxCacheType]
	           ,[DiskReadSpeed],[DiskWriteSpeed],[CatalogServerClientId],[flags]
	           ,[TotalCapacityMB])
	     VALUES
	           (@poolId,'Parallel Dedup Cache',1,@createTime
	           ,1,0,90,1
	           ,-1,0,-1,-1
	           ,0,0,1024,2
	           ,0,0,0,0
	           ,-1)
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: QS_ConfigureSIDBStoreAndSubStoreInfo -- Insert Cache Info Failed '
		GOTO CX_EXIT
	END
	Declare @cacheId int
	set @cacheId = @@identity
	INSERT INTO IdxAccessPath
	           ([IdxCacheId],[ClientId],[Path],[Username]
	           ,[Password],[Enabled],[SoftState],[OfflineReason]
	           ,[Priority],[LocalIndexTimeStamp],[ActualDaysIndexRetain],[Flags]
	           ,[AgeingNoOfDays],[AgeingPercentDiskspace],[DiskFreeThresholdMB],[DiskFreeWarningThreshholdMB]
	           ,[TotalCapacityMB],[FreeDiskSpaceMB],[DiskUsageMB],[DiskUsageLastChecked]
	           ,[StagingCachePath], [VolumeGUID])
	     VALUES
	           (@cacheId,@clientId,@accessPath,''
	           ,'',1,1,0
	           ,1,0,0,0
	           ,0,0,0,0
	           ,0,0,0,0
	           ,'', '')
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: QS_ConfigureSIDBStoreAndSubStoreInfo -- Insert AccessPath Info Failed '
		GOTO CX_EXIT
	END
	Declare @accessPathId int
	set @accessPathId = @@identity
END
ELSE
BEGIN
	IF exists (select * from IdxAccessPath IA WITH (NOLOCK), IdxCache IC WITH (NOLOCK) Where IA.Path = @accessPath and IA.IdxCacheId = IC.IdxCacheId and IC.IdxCacheType = 1)
	BEGIN
		SET @errStr = 'ERROR: QS_ConfigureSIDBStoreAndSubStoreInfo -- Accesspath exists but for different cachetype'
		SET @errCode = 5
		goto CX_EXIT
	END
	select @cacheId = IA.IdxCacheId, @accessPathId = IA.IdxAccessPathId from IdxAccessPath IA Where IA.Path = @accessPath
END
if (@splitGroupCount <= @splitsPerGroup)
begin
	set @splitGroupCount = @splitGroupCount + 1
end
else
begin
	--reset @splitGroupCount
	set @splitGroupCount = 2
	if (@groupNum < (@numGroups-1))
	begin
		set @groupNum = @groupNum + 1
	end
	else
	begin
		set @groupNum = 0
	end
end
DECLARE @AFPerSec INT = 0 -- Set it to 0, older MAs anyway wont read that field.
SELECT @AFPerSec = 1
	FROM APP_Client C WITH (NOLOCK)
	    LEFT OUTER JOIN APP_VMToPMMap MAP WITH (READUNCOMMITTED) ON MAP.VMClientId = C.Id
	    INNER JOIN SimInstalledPackages PKG WITH (READUNCOMMITTED) ON PKG.ClientId = ISNULL(MAP.PMClientId, C.Id)
WHERE (C.releaseId > 16) OR ((C.releaseId = 16)  AND (PKG.HighestSP >= 13))
AND C.id = @clientId
INSERT INTO IdxSIDBSubStore
           ([SIDBStoreId], [commCellId], [GroupNumber], [IdxCacheId]
           ,[IdxAccessPathId], [ClientId], [FirstBackupTime], [flags]
           ,[TotalDataSizeBytes],[InstancedDataSizeBytes],[Status],[LastAccessTime]
           ,[CreatedTime],[SealedTime],[Version],[SIDBSnapPath]
           ,[LastSnapTime],[origSubStoreId], [ReconLevel], LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile, ExtendedFlags, PageSize)
     VALUES
           (@sidbStoreId,@commCellId,@groupNum,@cacheId
           ,@accessPathId,@clientId,-1,3145730
           ,0,0,0,0
           ,@createTime,0,-1,''
           ,0,0, 0, 0, '', 0, 0, 0, 0, '', '', '', @AFPerSec, 0, 0)
set @errCode = @@ERROR
if (@errCode <> 0)
BEGIN
	SET @errStr = 'ERROR: QS_ConfigureSIDBStoreAndSubStoreInfo -- Insert SubStore Info Failed '
	GOTO CX_EXIT
END
SET @loopVar = @loopVar + 1
FETCH NEXT FROM curSubStore INTO @accesspath, @clientId, @commCellId
END
CX_EXIT:
EXEC sp_xml_removedocument @iDoc
IF OBJECT_ID('tempdb.dbo.#tempSubStore') is not null DROP TABLE #tempSubStore
select @errCode, @errStr
return
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConfigureSIDBStoreAndSubStoreInfo')
	delete from GxQscripts where name = 'QS_ConfigureSIDBStoreAndSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureSIDBStoreAndSubStoreInfo')
	delete from GXDBVersions where aliasname = 'QS_ConfigureSIDBStoreAndSubStoreInfo'
GO

insert into GXDBVersions values(2, 'QS_ConfigureSIDBStoreAndSubStoreInfo',  '00010013004400070000', 'QS_ConfigureSIDBStoreAndSubStoreInfo', '00010013004400070000')
GO

insert into GxQscripts values(2,'QS_ConfigureSIDBStoreAndSubStoreInfo',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn ConfigureSIDBStoreAndSubStoreInfo -si groupNo -si xmlfilepath -si xmlString'
)
GO

