

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConfigureSFSaaSInfra.sp] ---------- 

-------------------------------------------
--         Name:   QS_ConfigureSFSaaSInfra.sp
--         Date:   02/26/2018
--       Author:   Sunil Telagamsetti
--  Description:   Configure the remote software cache.
-------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ConfigureSFSaaSInfra <<<'

IF EXISTS (select * from sysobjects where name='QS_ConfigureSFSaaSInfra')
	drop procedure QS_ConfigureSFSaaSInfra
IF EXISTS (select * from GxQscripts where name='QS_ConfigureSFSaaSInfra')
	delete from GxQscripts where name = 'QS_ConfigureSFSaaSInfra'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureSFSaaSInfra')
	delete from GXDBVersions where aliasname = 'QS_ConfigureSFSaaSInfra'
GO
print '... Creating Procedure: QS_ConfigureSFSaaSInfra'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ConfigureSFSaaSInfra
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @userLogin NVARCHAR(128),
  @infraClientGroupName NVARCHAR(256),
  @downloadCachePath NVARCHAR(1024),
  @backupStreams INT,
  @dbHost NVARCHAR(256),
  @dbInstance NVARCHAR(256),
  @dbPort NVARCHAR(32),
  @dbUsername NVARCHAR(32),
  @password NVARCHAR(256),
  @dbType NVARCHAR(32) = ''
AS
SET NOCOUNT ON
---------------------
-- Optional inputs --
---------------------
DECLARE @dbEnabled INT = 1
DECLARE @dbTypeId INT = 2
--Error tracking
DECLARE @errorCode INT = 0
DECLARE @localErrorMsg	varchar(512) = 'Script executed successfully'
DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
-- Find the Company ID
DECLARE @orgId INTEGER
SELECT @orgId = umDSproviderId
FROM UMUsers WHERE login = @userLogin
IF @orgId IS NULL
BEGIN
	SET @localErrorMsg = 'Invalid user login name ''' + @userLogin + '''.';
	SET @errorCode = 1
	GOTO EXIT_PROC;
END
IF (@dbType = '' OR @dbType = 'SQLSERVER')
	SET @dbTypeId = 2
ELSE IF (@dbType = 'ORACLE')
	SET @dbTypeId = 1
ELSE IF (@dbType = 'POSTGRESQL')
	SET @dbTypeId = 3
ELSE IF (@dbType = 'H2_EMBEDDED')
	SET @dbTypeId = 4
ELSE
BEGIN
	SET @localErrorMsg = 'Invalid DB type ''' + @dbType + '''.';
	SET @errorCode = 1
	GOTO EXIT_PROC
END
--Find the client group id and associate to Company
DECLARE @infraClientGroupID INT
SELECT @infraClientGroupID = id FROM APP_ClientGroup WHERE name = @infraClientGroupName
IF ISNULL(@infraClientGroupID, 0) = 0
BEGIN
	SET @localErrorMsg = 'Invalid client group name ''' + @infraClientGroupName + '''.';
	SET @errorCode = 1
	GOTO EXIT_PROC
END
IF EXISTS (SELECT 1 FROM App_CompanyProp WHERE attrName = 'Salesforce infrastructure group' AND modified = 0 AND componentNameId = @orgId)
BEGIN
	UPDATE App_CompanyProp SET modified = @timeNow WHERE attrName = 'Salesforce infrastructure group' AND modified = 0 AND componentNameId = @orgId;
END
INSERT INTO App_CompanyProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@orgId, 'Salesforce infrastructure group', 1, @infraClientGroupID, @timeNow, 0)
--Set the client group properties
--Sync DB
DECLARE @syncDB XML
DECLARE @encPwd VARCHAR(MAX)
DECLARE @base64Pwd VARCHAR(MAX)
EXEC pswEncryptionManaged @password, @encPwd OUTPUT
SELECT @base64Pwd =
    '||#5!' + CAST(N'' AS XML).value('xs:base64Binary(xs:hexBinary(sql:column("bin")))', 'VARCHAR(MAX)')
FROM (
    SELECT CAST(@encPwd AS VARBINARY(MAX)) AS bin
) AS Base64Temp;
SET @syncDB =
	(
		SELECT	@dbEnabled AS '@dbEnabled',
				@dbHost AS '@dbHost',
				@dbInstance AS '@dbInstance',
				'' AS '@dbName',
				@dbPort AS '@dbPort',
				@dbTypeId AS '@dbType',
				@dbUsername AS 'dbUserPassword/@userName',
				@base64Pwd AS 'dbUserPassword/@password'
		FOR XML PATH('App_SalesforceSyncDatabase'), TYPE
	)
IF EXISTS (SELECT 1 FROM APP_ComponentProp WHERE componentId = @infraClientGroupID AND modified = 0 AND propertyTypeId = 1043 and componentType = 8 /*Client group*/)
BEGIN
	UPDATE APP_ComponentProp SET modified = @timeNow WHERE componentId = @infraClientGroupID AND propertyTypeId = 1043 and componentType = 8 AND modified = 0;
END
INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
VALUES (8, @infraClientGroupID, 1043, 1, 0, 0, CAST(@syncDB AS NVARCHAR(MAX)), @timeNow, 0)
--Download cache path
IF EXISTS (SELECT 1 FROM APP_ComponentProp WHERE componentId = @infraClientGroupID AND modified = 0 AND propertyTypeId = 1044 and componentType = 8 /*Client group*/)
BEGIN
	UPDATE APP_ComponentProp SET modified = @timeNow WHERE componentId = @infraClientGroupID AND propertyTypeId = 1044 and componentType = 8 AND modified = 0;
END
INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
VALUES (8, @infraClientGroupID, 1044, 1, 0, 0, @downloadCachePath, @timeNow, 0)
--Backup streams
IF EXISTS (SELECT 1 FROM APP_ComponentProp WHERE componentId = @infraClientGroupID AND modified = 0 AND propertyTypeId = 1045 and componentType = 8 /*Client group*/)
BEGIN
	UPDATE APP_ComponentProp SET modified = @timeNow WHERE componentId = @infraClientGroupID AND propertyTypeId = 1045 and componentType = 8 AND modified = 0;
END
INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
VALUES (8, @infraClientGroupID, 1045, 1, @backupStreams, 0, '', @timeNow, 0)
EXIT_PROC:
	PRINT @localErrorMsg
	if @errorCode > 0
	BEGIN
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConfigureSFSaaSInfra')
	delete from GxQscripts where name = 'QS_ConfigureSFSaaSInfra'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureSFSaaSInfra')
	delete from GXDBVersions where aliasname = 'QS_ConfigureSFSaaSInfra'
GO

insert into GXDBVersions values(2, 'QS_ConfigureSFSaaSInfra',  '00000000000000000000', 'QS_ConfigureSFSaaSInfra', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ConfigureSFSaaSInfra',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '        Script to set the parameters in CommServ DB for Salesforce tenant.
'
 + CHAR(10) + '        Usage: Qoperation execscript sn QS_ConfigureSFSaaSInfra -si ''UserLogin'' -si ''ClientGroupName'' -si ''DownloadCachePath'' -si backupstreams -si ''DB Hostname'' -si ''DB instance'' -si ''DB Port'' -si ''DB username'' -si ''DB password'' -si dbType ''DB Engine''
'
)
GO

