

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConfigureRemoteCacheOnFailoverClient.sp] ---------- 

-----------------------------------------------------------------------
--         Name:   QS_ConfigureRemoteCacheOnFailoverClient.sp
--         Date:   11/18/2020
--       Author:   Bishwajeet
--  Description:   Configure remote software cache on Failover client
------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_ConfigureRemoteCacheOnFailoverClient')
BEGIN
	print '>>> Drop Stored Procedure: QS_ConfigureRemoteCacheOnFailoverClient <<<'
	drop procedure QS_ConfigureRemoteCacheOnFailoverClient
END
IF EXISTS (select * from GxQscripts where name='QS_ConfigureRemoteCacheOnFailoverClient')
	delete from GxQscripts where name = 'QS_ConfigureRemoteCacheOnFailoverClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureRemoteCacheOnFailoverClient')
	delete from GXDBVersions where aliasname = 'QS_ConfigureRemoteCacheOnFailoverClient'
GO
print '... Creating Procedure: QS_ConfigureRemoteCacheOnFailoverClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_ConfigureRemoteCacheOnFailoverClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName VARCHAR(MAX),
  @swCachePath VARCHAR(MAX)
AS
SET NOCOUNT ON
DECLARE @localErrorMsg	VARCHAR(512)
DECLARE @clientId   INTEGER
DECLARE @lastError	INTEGER
DECLARE @isActiveNode INTEGER
DECLARE @tmpConfigResultTbl  TABLE(t_ClientID INT, t_ErrorCode INT, t_ErrorStr VARCHAR(MAX))
SET @localErrorMsg =''
SET	@lastError = 0
SET @clientId = 0
SET @isActiveNode = 0
SELECT @clientId=id from APP_Client WITH(NOLOCK) WHERE name = @clientName
IF @clientId=0
BEGIN
	SET @localErrorMsg = 'Input clientName ' + @clientName +' is incorrect.'
	SET @lastError = 1
	GOTO EXIT_ERROR
END
IF NOT EXISTS(SELECT TOP 1 ID FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId=@clientId AND attrName='Linked CS Client' AND modified=0)
BEGIN
	SET @localErrorMsg = 'Input client ' + @clientName +' is not a Failover client.'
	SET @lastError = 1
	GOTO EXIT_ERROR
END
--check for active node
IF EXISTS (SELECT ID FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId=2 AND
															attrName = 'Active CS Client' AND modified=0 AND
                                                            attrVal= ISNULL((SELECT attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE
															attrName = 'Linked CS Client' AND componentNameId = @clientId AND modified=0),0))
SET @isActiveNode=1
SET @localErrorMsg = 'Remote cache is configured on Failover client:[ ' + @clientName + ' ].'
INSERT INTO @tmpConfigResultTbl EXEC simConfigureAutomaticRemoteCacheOnFailoverClient @clientName, @clientId, @swCachePath, @isActiveNode
SELECT TOP 1 @lastError = t_ErrorCode, @localErrorMsg = t_ErrorStr FROM @tmpConfigResultTbl
EXIT_ERROR:
	PRINT @localErrorMsg
	if @lastError <> 0
	BEGIN
		RAISERROR(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConfigureRemoteCacheOnFailoverClient')
	delete from GxQscripts where name = 'QS_ConfigureRemoteCacheOnFailoverClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureRemoteCacheOnFailoverClient')
	delete from GXDBVersions where aliasname = 'QS_ConfigureRemoteCacheOnFailoverClient'
GO

insert into GXDBVersions values(2, 'QS_ConfigureRemoteCacheOnFailoverClient',  '00000000000000000000', 'QS_ConfigureRemoteCacheOnFailoverClient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ConfigureRemoteCacheOnFailoverClient',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '    Script to configure the remote software cache on Failover client.
'
 + CHAR(10) + '    Usage: Qoperation execscript -sn QS_ConfigureRemoteCacheOnFailoverClient -si ''Clientname'' -si ''Commserve SoftwareCache Path''
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_ConfigureRemoteCacheOnFailoverClient -si myClient -si C:\SWCache
'
)
GO

