

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConfigureRemoteCache.sp] ---------- 

-------------------------------------------
--         Name:   QS_ConfigureRemoteCache.sp
--         Date:   05/29/2013
--       Author:   Shravani Chepuri
--  Description:   Configure the remote software cache.
-------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_ConfigureRemoteCache')
BEGIN
	print '>>> Drop Stored Procedure: QS_ConfigureRemoteCache <<<'
	drop procedure QS_ConfigureRemoteCache
END
IF EXISTS (select * from GxQscripts where name='QS_ConfigureRemoteCache')
	delete from GxQscripts where name = 'QS_ConfigureRemoteCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureRemoteCache')
	delete from GXDBVersions where aliasname = 'QS_ConfigureRemoteCache'
GO
print '... Creating Procedure: QS_ConfigureRemoteCache'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_ConfigureRemoteCache
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName NVARCHAR(1024),
  @swCachePath NVARCHAR(1024),
  @clGroupName NVARCHAR(1024)= '',
  @isNetworkShare INTEGER = 0,
  @userName NVARCHAR(1024) = '',
  @passWord NVARCHAR(1024) = '',
  @syncPackagesType INTEGER = 1
AS
SET NOCOUNT ON
DECLARE @localErrorMsg	varchar(512)
DECLARE @clientId   INTEGER
DECLARE @clGroupId   INTEGER
DECLARE @uaId	INTEGER
DECLARE @lastError	INTEGER
DECLARE @remoteCacheConfigured INTEGER
SET	@lastError	= 0
SET @clientId=0
SET @clGroupId=0
SET @uaId=0
SET	@remoteCacheConfigured	= 0
SELECT @clientId=id from APP_Client where name like @clientName
SELECT @clGroupId=id from APP_ClientGroup where name like @clGroupName
IF @clientId=0
BEGIN
	SET @localErrorMsg = 'Input clientName ' + @clientName +' is incorrect.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
ELSE
BEGIN
	IF  NOT EXISTS (SELECT * FROM PatchUpdateAgentInfo PI WHERE PI.clientId=@clientId )
	BEGIN
		insert into PatchUpdateAgentInfo Values(@clientId,1,@swCachePath,'','',1,1,0,0,0,'')
		SET	@remoteCacheConfigured	= 1
		SET @localErrorMsg = 'Remote Cache is Configured.'
	END
	ELSE IF EXISTS (SELECT * FROM PatchUpdateAgentInfo PI WHERE PI.clientId=@clientId and PI.isDeleted=1)
	BEGIN
		UPDATE PatchUpdateAgentInfo SET cachePath=@swCachePath, isLocalDrive=1,isDeleted=0,isEnabled=1,autoSyncWithCS=1,inSyncWithCS=0,packageStatus=0 where clientId=@clientId
		SET	@remoteCacheConfigured	= 1
		SET @localErrorMsg = 'Remote Cache is Configured.'
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Remote Cache already exists.'
	END
	if object_id('CommServ.dbo.PatchUAContentConfig') IS NOT null
	BEGIN
              DECLARE @csRelId INT
	      SET @csRelId = (SELECT releaseId FROM  APP_Client WHERE id = 2)
	      DECLARE @uaRelId INT
              SET @uaRelId = (SELECT releaseId FROM  APP_Client WHERE id = @clientId)
              IF NOT EXISTS (SELECT * FROM PatchUAContentConfig WHERE UAClientId = @clientId and ReleaseId = @csRelId)
              BEGIN
                   IF @csRelId = @uaRelId
		   BEGIN
			--insert the default values in PatchUAContentConfig table
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,1,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,3,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,14,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,15,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,16,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,17,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,18,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,20,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,22,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,23,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,27,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,25,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,26,@syncPackagesType,1,'','')
INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,33,@syncPackagesType,1,'','')
		   END
              END
	END
	SELECT @uaId=id from PatchUpdateAgentInfo where clientId=@clientId
	IF @uaId <> 0
	BEGIN
		IF @remoteCacheConfigured = 1
		BEGIN
			--If already exists, Clear it
			IF EXISTS (SELECT * FROM app_clientProp where componentNameId=@clientId and attrName='UPDATE CACHE AGENT ID')
			BEGIN
				delete from app_clientProp where componentNameId=@clientId and attrName='UPDATE CACHE AGENT ID'
			END
			insert into app_clientProp Values(@clientId,'UPDATE CACHE AGENT ID',7,@uaId,0,0,0)
			IF @isNetworkShare <> 0
			BEGIN
				UPDATE PatchUpdateAgentInfo SET isLocalDrive=0, username=@userName, passwd=@passWord where clientId=@clientId
			END
		END
		IF @clGroupName NOT LIKE ''
		BEGIN
			IF @clGroupId = 0
			BEGIN
				SET @localErrorMsg = @localErrorMsg + 'Incorrect clientgroup name ' + @clGroupName + ' has been given to associate with it'
				Set @lastError = 1
				goto   ARGS_ERROR
			END
			ELSE
			BEGIN
				--If already exists, Clear it
				IF EXISTS (SELECT * FROM APP_ComponentProp where componentType=8 and componentId=@clGroupId and propertyTypeId=1300)
				BEGIN
					delete from APP_ComponentProp where componentType=8 and componentId=@clGroupId and propertyTypeId=1300
				END
				insert into APP_ComponentProp Values( 8,@clGroupId,1300,10,@uaId,0,'',0,0)
				SET @localErrorMsg = @localErrorMsg + 'Associated the specified client group to the Remote Cache.'
			END
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Failed to configure the Remote cache for the given client ' + @clientName
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
ARGS_ERROR:
	PRINT @localErrorMsg
	if @lastError <> 0
	BEGIN
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConfigureRemoteCache')
	delete from GxQscripts where name = 'QS_ConfigureRemoteCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureRemoteCache')
	delete from GXDBVersions where aliasname = 'QS_ConfigureRemoteCache'
GO

insert into GXDBVersions values(2, 'QS_ConfigureRemoteCache',  '00000000000000000000', 'QS_ConfigureRemoteCache', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ConfigureRemoteCache',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '        Script to configure the remote software cache and associate the input client group with the configured remote cache.
'
 + CHAR(10) + '        Usage: Qoperation execscript sn QS_ConfigureRemoteCache -si ''Clientname'' -si ''SoftwareCachePath'' -si ''ClientGroupName'' -si ''1 or 0 (isNetworkShare)'' -si ''cachePathUserName'' -si ''encryptedPasswd''
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_ConfigureRemoteCache -si myClient -si C:\SWCache
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_ConfigureRemoteCache -si myClient -si C:\SWCache -si mygroup
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_ConfigureRemoteCache -si myClient -si \\xxx\SWCache -si mygroup -si 1 -si ''domainusername'' -si ''Password''
'
)
GO

