

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CompressionConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CompressionConfig.sp,v $ $Id: QS_CompressionConfig.sp,v 1.3.60.2 2018/03/19 23:58:56 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CompressionConfig <<<'

IF EXISTS (select * from sysobjects where name='QS_CompressionConfig')
	drop procedure QS_CompressionConfig
IF EXISTS (select * from GxQscripts where name='QS_CompressionConfig')
	delete from GxQscripts where name = 'QS_CompressionConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CompressionConfig')
	delete from GXDBVersions where aliasname = 'QS_CompressionConfig'
GO
print '... Creating Procedure: QS_CompressionConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CompressionConfig
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = ''
AS
Set NOCOUNT ON
/*
 Input Prameters
 */
DECLARE @spName				nvarchar(512)
DECLARE @OPT				varchar(1024)
DECLARE @ClientName			nvarchar(1024)
DECLARE @SubClientName		nvarchar(1024)
DECLARE @iCompressionTypeStr	varchar(512)
SET		@spName					= ''
IF LOWER(SUBSTRING(@PARAM1,1,3)) = 'sp='
BEGIN
	SET		@spName					= @PARAM1
	SET		@OPT					= @PARAM2
	SET		@iCompressionTypeStr	= @PARAM3
END
ELSE
BEGIN
	SET		@ClientName				= @PARAM1
	SET		@SubClientName			= @PARAM2
	SET		@OPT					= @PARAM3
	SET		@iCompressionTypeStr	= @PARAM4
END
---------------------------------------
--test
--SET		@ClientName			= 'all'
--SET		@SubClientName		= 'all'
--SET		@OPT				= 'get'
--SET		@iCompressionTypeStr	= 1
--SET		@spName				= 'sp=CCM_CS-SP1'
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'CompressionConfig'
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter			=@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
SET @clientId					= 0
DECLARE @subClientId			integer
SET @subClientId				= 0
DECLARE @lastError				integer
SET @lastError					= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			= 'No error encountered when running script.'
DECLARE @iCompressionType		INTEGER
SET		@iCompressionType		= -1
DECLARE @tClients				TABLE	(	id	INTEGER)
DECLARE @tSubClients			TABLE	(	id	INTEGER)
DECLARE @tSCPSubClients			TABLE	(	id	INTEGER)
IF LOWER(@OPT) = 'set'
BEGIN
	IF @iCompressionTypeStr = @NoParameter
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Parameter4 property value is not mentioned'
		goto ARGS_ERROR
	END
	SET @iCompressionType = convert(integer, @iCompressionTypeStr)
	IF @iCompressionType < 0 OR @iCompressionType > 4 OR @iCompressionType = 3
	BEGIN
		PRINT N'Compression Parameter is invalid'
		PRINT N'	0 - On Client'
		PRINT N'	1 - On Media Agent'
		PRINT N'	2 - Use Storage Policy Settings'
		PRINT N'	4 - Off'
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Invalid compression type parameter.'
		goto ARGS_ERROR
	END
END
IF	@spName = ''
BEGIN
-- Parse Client Name parameter
IF LOWER(@ClientName) = N'all'
BEGIN
	INSERT @tClients(id) SELECT id FROM App_Client WHERE id > 1
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@ClientName, 1, 2)) = N'c='
	BEGIN
		set @clientId= ISNULL((SELECT TOP(1) id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @lastError = 2
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2)) + '] Does not exist.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as all or c=clientName.'
		goto ARGS_ERROR
	END
	INSERT @tClients(id)
	SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))
END
-- Parse Sub Client Name parameter
IF LOWER(@SubClientName) = N'all'
BEGIN
	-- Exclude CV_APPTYPE_NAS_FS app type
	INSERT @tSubClients(id) SELECT id FROM App_Application WHERE appTypeId<>13 AND
		clientId in (SELECT id AS clientId FROM @tClients)
END
ELSE
BEGIN
	IF LOWER(@ClientName) = N'all'
	BEGIN
		SET @lastError = 4
		SET @localErrorMsg = 'Error.  Parameter2 must be all when Parameter1 is all.'
		goto ARGS_ERROR
	END
	IF LOWER(SUBSTRING(@SubClientName, 1, 2)) = N's='
	BEGIN
		set @subClientId= ISNULL((SELECT TOP(1) id from App_Application WHERE subclientName = (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2))
									AND clientId in (SELECT id AS clientId FROM @tClients)),0)
		IF @subClientId = 0
		BEGIN
			SET @lastError = 5
			SET @localErrorMsg = 'Error.  Sub Client ['+ (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2)) + '] Does not exist.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 6
		SET @localErrorMsg = 'Error.  Parameter2 must be specified as all or s=subClientName.'
		goto ARGS_ERROR
	END
	-- Exclude CV_APPTYPE_NAS_FS app type
	INSERT @tSubClients(id)
	SELECT id from App_Application WHERE subclientName = (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2))
		AND appTypeId<>13 AND clientId in (SELECT id AS clientId FROM @tClients)
	IF LOWER(@OPT) = 'set'
	BEGIN
		IF (SELECT COUNT(id)
		FROM @tSubClients
		WHERE id in
			(
				(SELECT DISTINCT ComponentNameId FROM App_SubClientProp
				WHERE AttrName = 'Associated subclient Policy' AND Modified = 0)
				UNION
				(SELECT DISTINCT Id FROM App_Application WHERE AppTypeId = 1030)
			)) > 0
		BEGIN
			SELECT DISTINCT 'Error! can not modify sub client "' + A.subClientName + '", it has associated subclient policy.'
			FROM @tSubClients AS T INNER JOIN App_Application AS A ON T.id = A.id
			WHERE T.id in
				(
					(SELECT DISTINCT ComponentNameId FROM App_SubClientProp
					WHERE AttrName = 'Associated subclient Policy' AND Modified = 0)
					UNION
					(SELECT DISTINCT Id FROM App_Application WHERE AppTypeId = 1030)
				)
			SET @lastError = 9
			SET @localErrorMsg = 'Error. Subclient policy is associated with mentioned sub client.'
			goto ARGS_ERROR
		END
	END
END
END
ELSE
BEGIN
	IF NOT EXISTS(SELECT id FROM archGroup WHERE name = (SELECT SUBSTRING(@spName, 4, LEN(@spName)-3)))
	BEGIN
			SET @lastError = 8
			SET @localErrorMsg = 'Error.  Storage policy ['+ (SELECT SUBSTRING(@spName, 4, LEN(@spName)-3)) + '] Does not exist.'
			goto ARGS_ERROR
	END
	ELSE
	BEGIN
			INSERT @tSubClients(id) SELECT DISTINCT APL.id FROM APP_Application APL
					INNER JOIN archGroup AGP ON APL.dataArchGrpID = AGP.id OR APL.logArchGrpID = AGP.id
					WHERE AGP.name = (SELECT SUBSTRING(@spName, 4, LEN(@spName)-2))
	END
END
-- Remove hidden, dummy and deleted subclients
DELETE FROM @tSubClients
WHERE id in
(
	SELECT Id FROM App_Application
	WHERE (subClientStatus & 0x4) <> 0 OR
		(subClientStatus & 0x10) <> 0 OR
		(subClientStatus & 0x20) <> 0
)
INSERT @tSCPSubClients(id)
SELECT id FROM @tSubClients
WHERE id in
(
	SELECT DISTINCT ComponentNameId FROM App_SubClientProp
	WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
)
DELETE FROM @tSubClients
WHERE id in
(
	SELECT DISTINCT ComponentNameId FROM App_SubClientProp
	WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
)
IF LOWER(@OPT) = 'get'
BEGIN
	-- To get compression properties
	(
	SELECT	C.name AS ClientName,
		A.subclientName AS SubClientName,
		CompressionType=
		CASE APC.compressWhere
			WHEN 0 THEN 'On Client'
			WHEN 1 THEN 'On Media Agent'
			WHEN 2 THEN 'Use Storage Policy Settings'
			WHEN 4 THEN 'Off'
			ELSE 'unknown'
		END
	FROM @tSubClients AS T INNER JOIN App_Application AS A ON T.id = A.Id
		INNER JOIN App_Client AS C ON C.id = A.clientId
		INNER JOIN archPipeConfig AS APC ON A.id = APC.appNumber
	)
	UNION ALL
	(
	SELECT	C.name AS ClientName,
		A.subclientName AS SubClientName,
		CompressionType=
		CASE APC.compressWhere
			WHEN 0 THEN 'On Client'
			WHEN 1 THEN 'On Media Agent'
			WHEN 2 THEN 'Use Storage Policy Settings'
			WHEN 4 THEN 'Off'
			ELSE 'unknown'
		END
	FROM App_Application AS A
		INNER JOIN App_Client AS C ON C.id = A.clientId
		INNER JOIN archPipeConfig AS APC ON A.id = APC.appNumber
		WHERE A.id in (
			SELECT attrVal AS id FROM App_SubClientProp
			WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
			AND componentNameId in (
				SELECT id FROM @tSCPSubClients
			)
		)
	)
END
ELSE IF LOWER(@OPT) = 'set'
BEGIN
	BEGIN TRY
		BEGIN TRANSACTION
			INSERT archPipeConfig (appNumber, compressWhere, numNWAgents, NWWriteSpeed)
			SELECT id AS appNumber, @iCompressionType, 1, 0
			FROM @tSubClients WHERE id NOT in (
				SELECT DISTINCT appNumber FROM archPipeConfig
			)
			UPDATE archPipeConfig SET compressWhere = @iCompressionType
			WHERE appNumber in (SELECT id FROM @tSubClients)
		COMMIT TRANSACTION
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @lastError = ERROR_NUMBER(), @localErrorMsg = ERROR_MESSAGE()
		PRINT N'Error occured. ErrorNo(' + CAST(@lastError AS NVARCHAR) + N') ErrorMsg(' + @localErrorMsg + N').'
		IF (XACT_STATE()) <> 0
		BEGIN
			PRINT N'So Rolling back Transactions.'
			ROLLBACK TRANSACTION
		END
	END CATCH
END
ELSE
BEGIN
	SET @lastError = 7
	SET @localErrorMsg ='Error, Parameter3 must be set or get.'
	goto ARGS_ERROR
END
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with '
         + ' Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CompressionConfig')
	delete from GxQscripts where name = 'QS_CompressionConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CompressionConfig')
	delete from GXDBVersions where aliasname = 'QS_CompressionConfig'
GO

insert into GXDBVersions values(2, 'QS_CompressionConfig',  '00010003006000020000', 'QS_CompressionConfig', '00010003006000020000')
GO

insert into GxQscripts values(2,'QS_CompressionConfig',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		To set the compression to On Media Agent for subclient01 in client01:'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si c=client01 -si s=subclient01 -si set -si 1'
 + CHAR(10) + '-- 		To set the compression to Use Storage Policy Settings for subclient01 in client01:'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si c=client01 -si s=subclient01 -si set -si 2'
 + CHAR(10) + '-- 		To set the compression to Off for all subclients in client01:'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si c=client01 si all -si set -si 4'
 + CHAR(10) + '-- 		To set the compression to On Client for all subclients in a CommCell'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si all -si all -si set -si 0'
 + CHAR(10) + '-- 		To set the compression to "Off" for subclient01 in client01:'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si c=client01 -si s=subclient01 -si set -si 4'
 + CHAR(10) + '-- 		To get the compression for subclient01 in client01 - this will provide the compression properties of the subclient as an output in the command console:'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si c=client01 -si s=subclient01 -si get'
 + CHAR(10) + '-- 		To set compression to On Client for all sub clients associated to a storage policy.'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si sp=spname -si set -si 0'
 + CHAR(10) + '-- 		To set compression to Use Storage Policy Settings for all sub clients associated to a storage policy.'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si sp=spname -si set -si 2'
 + CHAR(10) + '-- 		To set compression to On Media Agent for all sub clients associated to a storage policy.'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si sp=spname -si set -si 1'
 + CHAR(10) + '-- 		To set compression to "Off" for all sub clients associated to a storage policy.'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si sp=spname -si set -si 4'
 + CHAR(10) + '-- 		To get compression of all sub clients associated to a storage policy.'
 + CHAR(10) + '-- 		Qoperation execscript -sn CompressionConfig.sql -si sp=spname -si get'
)
GO

