

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_Commcellaveragedatatransfer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_Commcellaveragedatatransfer.sp,v $ $Id: QS_Commcellaveragedatatransfer.sp,v 1.2.188.2 2018/03/22 01:17:55 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CommCellAverageDataTransfer <<<'

IF EXISTS (select * from sysobjects where name='QS_CommCellAverageDataTransfer')
	drop procedure QS_CommCellAverageDataTransfer
IF EXISTS (select * from GxQscripts where name='QS_CommCellAverageDataTransfer')
	delete from GxQscripts where name = 'QS_CommCellAverageDataTransfer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CommCellAverageDataTransfer')
	delete from GXDBVersions where aliasname = 'QS_CommCellAverageDataTransfer'
GO
print '... Creating Procedure: QS_CommCellAverageDataTransfer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CommCellAverageDataTransfer
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @Param1 varchar(255)='',
  @Param2 varchar(255)='',
  @Param3 varchar(255)=''
AS
SET ANSI_PADDING ON
SET ARITHABORT ON
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'CommCellAverageDataTransfer'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------------------------------
--test
--SET		@PARAM1= '2009/01/01'
--SET		@PARAM2= '2010/01/01'
--SET		@PARAM3= 'AVG'
---------------------------------------
IF @PARAM1 = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Start Date is not provided.'
	GOTO ARGS_ERROR
END
IF @PARAM2 = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. End Date is not provided.'
	GOTO ARGS_ERROR
END
IF @PARAM3 = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. MAX / AVG option is not provided.'
	GOTO ARGS_ERROR
END
IF @PARAM3 NOT IN ('MAX' , 'AVG')
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. option entered is invalid. Please provide option MAX / AVG.'
	GOTO ARGS_ERROR
END
DECLARE @StartDate as DATETIME
DECLARE @EndDate as DATETIME
DECLARE @UTCAdd as DATETIME
SET @StartDate = @PARAM1
SET @EndDate = @PARAM2
SET @UTCAdd = '1970/01/01'
IF @PARAM3 = 'MAX'
BEGIN
		select JMBkpStats.appId ,
		   MAX(APP_Client.name) as ClientName,
		   APP_Client.id as ClientId,
		   JMBkpStats.appType as AppTypeId,
		   MAX(APP_iDAType.name) AS AppType,
		   MAX(APP_Application.subclientName) AS subClientName,
		   archGroup.id as SPId,
		   MAX(archGroup.name) as SPName,
		   CASE JMBkpStats.bkpLevel WHEN 1 THEN 'FULL' WHEN 2 THEN 'INCR' WHEN 4 THEN 'DIFF' END AS BackupLevel,
		   count(*) as NumOfJobs,
		   CAST(MAX(totalUnCompBytes)/(1024.0 * 1024) as DECIMAL (20,2)) as MaxUncompMB,
		   CAST(MAX(totalCompBytes)/(1024.0 * 1024) as DECIMAL (20,2))as MaxcompMB,
		   CASE WHEN MAX(totalUnCompBytes) = MAX(totalCompBytes) THEN 'UnCompressed' ELSE 'Compressed' END as IsCompressed
	FROM         APP_Application INNER JOIN
		     APP_Client ON APP_Application.clientId = APP_Client.id INNER JOIN
		     APP_iDAType ON APP_Application.appTypeId = APP_iDAType.type INNER JOIN
		     JMBkpStats ON APP_Application.id = JMBkpStats.appId INNER JOIN
		     archGroup on JMBkpStats.dataArchGrpId = archGroup.id
			AND bkpLevel in (1,2,4)
			AND JMBkpStats.status in (1)
			AND (dateadd(ss, servStartDate, @UTCAdd) Between @StartDate AND @EndDate)
	Group by JMBkpStats.appId, APP_Client.id, JMBkpStats.appType, archGroup.id, bkplevel
	Order by SPId, ClientId, JMBkpStats.appId, JMBkpStats.bkplevel
END
ELSE IF @PARAM3 = 'AVG'
BEGIN
		select JMBkpStats.appId ,
		   MAX(APP_Client.name) as ClientName,
		   APP_Client.id as ClientId,
		   JMBkpStats.appType as AppTypeId,
		   MAX(APP_iDAType.name) AS AppType,
		   MAX(APP_Application.subclientName) AS subClientName,
		   archGroup.id as SPId,
		   MAX(archGroup.name) as SPName,
		   CASE JMBkpStats.bkpLevel WHEN 1 THEN 'FULL' WHEN 2 THEN 'INCR' WHEN 4 THEN 'DIFF' END AS BackupLevel,
		   count(*) as NumOfJobs,
		   CAST(AVG(totalUnCompBytes)/(1024.0 * 1024) as DECIMAL (20,2)) as AvgUncompMB,
		   CAST(AVG(totalCompBytes)/(1024.0 * 1024) as DECIMAL (20,2))as AvgcompMB,
		   CASE WHEN AVG(totalUnCompBytes) = AVG(totalCompBytes) THEN 'UnCompressed' ELSE 'Compressed' END as IsCompressed
	FROM         APP_Application INNER JOIN
			  APP_Client ON APP_Application.clientId = APP_Client.id INNER JOIN
			  APP_iDAType ON APP_Application.appTypeId = APP_iDAType.type INNER JOIN
			  JMBkpStats ON APP_Application.id = JMBkpStats.appId INNER JOIN
			  archGroup on JMBkpStats.dataArchGrpId = archGroup.id
			  AND bkpLevel in (1,2,4)
			  AND JMBkpStats.status in (1)
			  AND (dateadd(ss, servStartDate, @UTCAdd) Between @StartDate AND @EndDate)
	Group by JMBkpStats.appId, APP_Client.id, JMBkpStats.appType, archGroup.id, bkplevel
	Order by SPId, ClientId, JMBkpStats.appId, JMBkpStats.bkplevel
END
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_Commcellaveragedatatransfer')
	delete from GxQscripts where name = 'QS_Commcellaveragedatatransfer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_Commcellaveragedatatransfer')
	delete from GXDBVersions where aliasname = 'QS_Commcellaveragedatatransfer'
GO

insert into GXDBVersions values(2, 'QS_Commcellaveragedatatransfer',  '00010002018800020000', 'QS_Commcellaveragedatatransfer', '00010002018800020000')
GO

insert into GxQscripts values(2,'QS_Commcellaveragedatatransfer',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CommCellAverageDataTransfer -si <Start Date in the form yyyy/mm/dd> -si <Start Date in the form yyyy/mm/dd> -si MAX/AVG
'
 + CHAR(10) + '-- 	script_name: CommCellAverageDataTransfer'
 + CHAR(10) + '-- 	Lists the Max / Average amount of data transferred by each backup type (Full, Incremental, Differential) for all subclients in the given time range. Returns data only for completed jobs. Since the CommServe database does not  contain information for jobs pruned more than a week ago, for the most accurate information, do not use older time ranges. Typical use is to find Max / Average amount of data transferred in the last month.'
)
GO

