

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CommservAssociateBillableEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CommServAssociateBillableEntity <<<'

IF EXISTS (select * from sysobjects where name='QS_CommServAssociateBillableEntity')
	drop procedure QS_CommServAssociateBillableEntity
IF EXISTS (select * from GxQscripts where name='QS_CommServAssociateBillableEntity')
	delete from GxQscripts where name = 'QS_CommServAssociateBillableEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CommServAssociateBillableEntity')
	delete from GXDBVersions where aliasname = 'QS_CommServAssociateBillableEntity'
GO
print '... Creating Procedure: QS_CommServAssociateBillableEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CommServAssociateBillableEntity
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @fileName nvarchar(MAX) = '%s'
AS
SET NOCOUNT ON
--DECLARE @filename NVARCHAR(MAX)   -- = 'c:\BE\MyBEAssocList.txt'
--SET  @filename ='%s'
EXECUTE ('
    USE CommServ
    -- Drop all Temporary tables that will be used in case a stale Temporary Table is still in memory
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalData'') IS NOT NULL DROP TABLE #tempBLExternalData
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalDataDirty'') IS NOT NULL DROP TABLE #tempBLExternalDataDirty
    --IF OBJECT_ID(''tempdb.dbo.#tempBLEntityMembers'') IS NOT NULL DROP TABLE #tempBLEntityMembers
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalDataSel'') IS NOT NULL DROP TABLE #tempBLExternalDataSel
    IF OBJECT_ID(''tempdb.dbo.#tempOPErrCodes'') IS NOT NULL DROP TABLE #tempOPErrCodes
    IF OBJECT_ID(''tempdb.dbo.#tempOPStatus'') IS NOT NULL DROP TABLE #tempOPStatus
	CREATE TABLE #tempOPErrCodes
	(
		ErrCode		INT,
		ErrString	VARCHAR(512)
	)
	CREATE TABLE #tempOPStatus
	(
       EntityName	NVARCHAR(512),
       ErrCode		INT
	)
    CREATE TABLE #tempBLExternalDataDirty
    (
        [Name]           NVARCHAR(512)                  NULL,
        [clientName]     NVARCHAR(512)                  NULL
    )
    CREATE TABLE #tempBLExternalDataDirtySel
    (
        [NameSel]           NVARCHAR(512)                  NULL,
        [clientNameSel]     NVARCHAR(512)                  NULL
    )
    CREATE TABLE #tempBLExternalData
    (
        [Name]           NVARCHAR(512)                  NULL,
        [clientName]     NVARCHAR(512)                  NULL,
        [IsAssocPresent] INTEGER						NULL,
        [BEID]			 INTEGER,
        [ClientID]		 INTEGER
    )
	INSERT INTO #tempOPErrCodes VALUES (1, ''Did not attempt to associate billable entity for the following non-existent clients'')
	INSERT INTO #tempOPErrCodes VALUES (2, ''Did not attempt to associate billable entity for the following non-existent billable entities'')
	INSERT INTO #tempOPErrCodes VALUES (3, ''Did not attempt to associate billable entity for the following clients since they already have previous associations'')
	INSERT INTO #tempOPErrCodes VALUES (4, ''Following clients had multiple associations defined on them. Only one association was honored'')
    -- load data into temporary table
    BULK
    INSERT  #tempBLExternalDataDirtySel
    FROM    ''' + @filename + '''
    WITH    (ROWTERMINATOR=''\n'', FIELDTERMINATOR='','') --, KEEPNULLS)
     UPDATE  #tempBLExternalDataDirtySel
		SET     [NameSel]          = LTRIM(RTRIM([NameSel])),
            [clientNameSel]    = LTRIM(RTRIM([clientNameSel]))
     -- Filter out any multiple  billable  entity associations on the same client.
     INSERT INTO #tempBLExternalDataDirty ([clientName])
     SELECT DISTINCT [clientNameSel] FROM #tempBLExternalDataDirtySel
     UPDATE #tempBLExternalDataDirty
        SET [Name] = (SELECT TOP 1 [NameSel] FROM #tempBLExternalDataDirtySel WHERE [clientNameSel] = [clientName])
    -- select original entries only
    INSERT  INTO #tempBLExternalData ([Name],[clientName],[IsAssocPresent],[BEID],[ClientID])
    SELECT   BLEX.[Name], BLEX.[clientName],-1, BLE.EntityID,APC.Id
    FROM #tempBLExternalDataDirty as BLEX, App_Client AS APC, BLEntity AS	 BLE
    WHERE       BLEX.[Name] IS NOT NULL
            AND [clientName] IS NOT NULL
            AND LEN(BLEX.[Name]) > 0
            AND LEN([clientName]) > 0
            AND APC.name = BLEX.clientName
            AND BLE.DisplayName = BLEX.Name
	-- if the BE association is already present for a client then do not attempt that client.
	UPDATE  #tempBLExternalData SET  [IsAssocPresent] = 1
	WHERE EXISTS (SELECT * FROM BLEntityMembers WHERE ClientID = #tempBLExternalData.[ClientID])
	UPDATE  #tempBLExternalData SET  [IsAssocPresent] = 0  WHERE [IsAssocPresent] = -1
	-- SELECT * FROM #tempBLEntityMembers
	INSERT INTO BLEntityMembers (EntityID, AssocType, ClientID, AppTypeID, InstanceID, BackupSetID, AppID)
	SELECT  [BEID],2,[ClientId],0,0,0,0 FROM #tempBLExternalData WHERE [IsAssocPresent] = 0
    IF EXISTS (SELECT [clientNameSel] FROM #tempBLExternalDataDirtySel
				WHERE [clientNameSel] NOT IN (SELECT [clientName] FROM #tempBLExternalData) )
	BEGIN
	   --print ''Billable Entity association was not attempted for the following non-existent clients ''
	   INSERT INTO #tempOPStatus
	   SELECT [clientNameSel],1 as ClientName FROM #tempBLExternalDataDirtySel
				WHERE [clientNameSel] NOT IN (SELECT [clientName] FROM #tempBLExternalData)
	END
	IF EXISTS (SELECT [NameSel] FROM #tempBLExternalDataDirtySel WHERE [NameSel] NOT IN (
				SELECT DisplayName FROM BLEntity))
     BEGIN
       --print ''Associations for the following non-existent billable entities were not attempted ''
       INSERT INTO #tempOPStatus
       SELECT [NameSel],2 as BillableEntity FROM #tempBLExternalDataDirtySel WHERE [NameSel] NOT IN (
				SELECT DisplayName FROM BLEntity)
     END
     IF EXISTS (SELECT * FROM #tempBLExternalData WHERE [IsAssocPresent] = 1 )
     BEGIN
       --print ''The following clients already have associations defined and hence were not attempted''
       INSERT INTO #tempOPStatus
       SELECT [clientName],3 FROM #tempBLExternalData WHERE [IsAssocPresent] = 1
     END
	 IF EXISTS (SELECT [clientNameSel], COUNT(*) FROM #tempBLExternalDataDirtySel
			WHERE [clientNameSel] IN (SELECT [clientName] FROM  #tempBLExternalData WHERE [IsAssocPresent] = 0)
			GROUP BY  [clientNameSel]
			HAVING COUNT(*) > 1)
	 BEGIN
	--   print ''For the following clients, there were multiple associations defined. Only one was honored''
	   INSERT INTO #tempOPStatus
	   SELECT [clientNameSel],4 FROM #tempBLExternalDataDirtySel
			WHERE [clientNameSel] IN (SELECT [clientName] FROM  #tempBLExternalData WHERE [IsAssocPresent] = 0)
			GROUP BY  [clientNameSel]
			HAVING COUNT(*) > 1
	 END
	IF EXISTS (SELECT * FROM #tempOPStatus WHERE ErrCode = 1)
	BEGIN
	  SELECT ''---- '' + ErrString + '' ----'' as '' '' FROM #tempOPErrCodes WHERE ErrCode = 1
	  SELECT EntityName as ClientName FROM #tempOPStatus WHERE ErrCode = 1
	END
	IF EXISTS (SELECT * FROM #tempOPStatus WHERE ErrCode  = 2 )
	BEGIN
	  SELECT ''---- '' + ErrString + '' ----'' as '' '' FROM #tempOPErrCodes WHERE ErrCode = 2
	  SELECT EntityName as BillableEntity FROM #tempOPStatus WHERE ErrCode = 2  ORDER BY EntityName
	END
	IF EXISTS (SELECT * FROM #tempOPStatus WHERE ErrCode = 3 )
	BEGIN
	  SELECT ''---- '' + ErrString + '' ----'' as '' '' FROM #tempOPErrCodes WHERE ErrCode = 3
	  SELECT EntityName as BillableEntity FROM #tempOPStatus WHERE ErrCode = 3  ORDER BY EntityName
	END
	IF EXISTS (SELECT * FROM #tempOPStatus WHERE ErrCode = 4)
	BEGIN
	  SELECT ''---- '' + ErrString + '' ----'' as '' '' FROM #tempOPErrCodes WHERE ErrCode = 4
	  SELECT EntityName as BillableEntity FROM #tempOPStatus WHERE ErrCode = 4 ORDER BY EntityName
	END
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalData'') IS NOT NULL DROP TABLE #tempBLExternalData
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalDataDirty'') IS NOT NULL DROP TABLE #tempBLExternalDataDirty
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalDataSel'') IS NOT NULL DROP TABLE #tempBLExternalDataSel
    --IF OBJECT_ID(''tempdb.dbo.#tempBLEntityMembers'') IS NOT NULL DROP TABLE #tempBLEntityMembers
    IF OBJECT_ID(''tempdb.dbo.#tempOPErrCodes'') IS NOT NULL DROP TABLE #tempOPErrCodes
    IF OBJECT_ID(''tempdb.dbo.#tempOPStatus'') IS NOT NULL DROP TABLE #tempOPStatus
    ')
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CommservAssociateBillableEntity')
	delete from GxQscripts where name = 'QS_CommservAssociateBillableEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CommservAssociateBillableEntity')
	delete from GXDBVersions where aliasname = 'QS_CommservAssociateBillableEntity'
GO

insert into GXDBVersions values(2, 'QS_CommservAssociateBillableEntity',  '00000000000000000000', 'QS_CommservAssociateBillableEntity', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CommservAssociateBillableEntity',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CommServAssociateBillableEntity.sql -si Billable Entity/Client CSV File Path
'
 + CHAR(10) + '--   script_name : CommServAssociateBillableEntity'
)
GO

