

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ClearDDBValidationFlag.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ClearDDBValidationFlag.sp,v $ $Id: QS_ClearDDBValidationFlag.sp,v 1.2.88.4 2019/09/23 16:02:05 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ClearDDBValidationFlag')
BEGIN
	print '>>> Drop Stored Procedure: QS_ClearDDBValidationFlag <<<'
	drop procedure QS_ClearDDBValidationFlag
END
IF EXISTS (select * from GxQscripts where name='QS_ClearDDBValidationFlag')
	delete from GxQscripts where name = 'QS_ClearDDBValidationFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ClearDDBValidationFlag')
	delete from GXDBVersions where aliasname = 'QS_ClearDDBValidationFlag'
GO
print '... Creating Procedure: QS_ClearDDBValidationFlag'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ClearDDBValidationFlag
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = ''
AS
Set NOCOUNT ON
	DECLARE @l_commCellNumber INT
	DECLARE @NoParameter			varchar(10)
	SET     @NoParameter			=''
	/*Input variables*/
	DECLARE @i_sidbSubStoreId 	INTEGER
	DECLARE @i_authcode		BIGINT
	/*Locale variables*/
	DECLARE @ErrorNumber 	INTEGER
	DECLARE @ErrorMessage NVARCHAR(MAX)
	SET @ErrorNumber  = 0
	IF(@PARAM1 = @NoParameter OR @PARAM2 = @NoParameter)
	BEGIN
		SET @ErrorMessage = 'Error: Insufficient command line parameters, Please refer to the readme file and retry with necessary parameters'
		SET @ErrorNumber = 1
		GOTO SCRIPT_EXIT
	END
	SELECT @l_commCellNumber = number from APP_CommCell where id = 2
	SET @i_sidbSubStoreId = convert(INT, @PARAM1)
/*
	--remove comments to test
	SET @PARAM2 = (checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+CAST(@i_sidbSubStoreId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646)
	SELECT	(checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+CAST(@i_sidbSubStoreId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646)
*/
	SET @i_authcode = convert(INT, @PARAM2)
	--IF Authentication code is odd
	if( @i_authcode % 2 <> 0)
	BEGIN
		IF((CHECKSUM(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+CAST(@i_sidbSubStoreId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646)+1 <>  @i_authcode)
		BEGIN
			SET @ErrorMessage = 'Error: Incorrect Authentication code passed.'
			SET @ErrorNumber = 2
			GOTO SCRIPT_EXIT
		END
	END
	ELSE	--IF Authentication code is even
	BEGIN
		IF((CHECKSUM(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><'+CAST(@i_sidbSubStoreId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646) <> @i_authcode)
		BEGIN
			SET @ErrorMessage = 'Error: Incorrect Authentication code passed.'
			SET @ErrorNumber = 2
			GOTO SCRIPT_EXIT
		END
	END
	IF NOT EXISTS(SELECT *	FROM IdxSIDBSubStore WHERE	subStoreId = @i_sidbSubStoreId)
	BEGIN
			SET @ErrorMessage = 'Error: Incorrect SubStore Id [' + CAST(@i_sidbSubStoreId AS VARCHAR(10)) + '].'
			SET @ErrorNumber = 3
			GOTO SCRIPT_EXIT
	END
IF EXISTS(SELECT *	FROM IdxSIDBSubStore WHERE	subStoreId = @i_sidbSubStoreId AND ((flags & 4194304) = 0))
	BEGIN
			SET @ErrorMessage = 'Error: This SubStore [' + CAST(@i_sidbSubStoreId AS VARCHAR(10)) + '] DDB Validation failed flag is not set.'
			SET @ErrorNumber = 3
			GOTO SCRIPT_EXIT
	END
	UPDATE	IdxSIDBSubStore
SET		Status = 0, Flags = Flags & ~4194304,
	ReconLevel = 0, MemDbTimeStamp = 0, CorruptionTime = 0
WHERE	subStoreId = @i_sidbSubStoreId AND ((flags & 4194304) <> 0)
	IF (@@ERROR <> 0)
	BEGIN
			SET @ErrorMessage = 'Error: Unable to clear DDB Validation failed flag on SubStore [' + CAST(@i_sidbSubStoreId AS VARCHAR(10)) + '].'
			SET @ErrorNumber = 4
			GOTO SCRIPT_EXIT
	END
SCRIPT_EXIT:
	IF @ErrorNumber <> 0
		Raiserror(@ErrorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ClearDDBValidationFlag')
	delete from GxQscripts where name = 'QS_ClearDDBValidationFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ClearDDBValidationFlag')
	delete from GXDBVersions where aliasname = 'QS_ClearDDBValidationFlag'
GO

insert into GXDBVersions values(2, 'QS_ClearDDBValidationFlag',  '00010002008800040000', 'QS_ClearDDBValidationFlag', '00010002008800040000')
GO

insert into GxQscripts values(2,'QS_ClearDDBValidationFlag',  1, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		Without Authcode:-'
 + CHAR(10) + '-- 			qoperation execscript -sn ClearDDBValidationFlag -si <SIDBSUBSTOREID> -si <authentication_code>'
)
GO

