

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CleanupVirtualServerDuplicateGUIDs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CleanupVirtualServerDuplicateGUIDs.sp,v $ $Id: QS_CleanupVirtualServerDuplicateGUIDs.sp,v 1.5.34.3 2020/08/14 14:35:18 scheppuri Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_CleanupVirtualServerDuplicateGUIDs')
BEGIN
	print '>>> Drop Stored Procedure: QS_CleanupVirtualServerDuplicateGUIDs <<<'
	drop procedure QS_CleanupVirtualServerDuplicateGUIDs
END
IF EXISTS (select * from GxQscripts where name='QS_CleanupVirtualServerDuplicateGUIDs')
	delete from GxQscripts where name = 'QS_CleanupVirtualServerDuplicateGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CleanupVirtualServerDuplicateGUIDs')
	delete from GXDBVersions where aliasname = 'QS_CleanupVirtualServerDuplicateGUIDs'
GO
print '... Creating Procedure: QS_CleanupVirtualServerDuplicateGUIDs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CleanupVirtualServerDuplicateGUIDs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
AS
-------------------------------------------
--         Name:   CleanupVirtualServerDuplicateGUIDs
--         Date:   24-Jul-2014
--       Author:   BKharabe
--  Description:   Cleanup the vm association of pseudo clients with duplicate GUIDs
--   CommcellId:   N/A (Generic Script)
-------------------------------------------
-------------------------------------------
-- CANNOT DO THE FOLLOWING IN A STORED PROCEDURE!  (MAKE SURE TO COMMENT OUT WHEN COPYING TEXT!)
--use commserv
--SET ANSI_PADDING ON
--GO
--SET ARITHABORT ON
--GO
--SET QUOTED_IDENTIFIER ON
--GO
--Set NOCOUNT ON
-- Stored Procedure Inputs
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'CleanupVirtualServerDuplicateGUIDs'
-------- Local Variables    -------------
DECLARE @curClid INT
DECLARE @lastError			integer
DECLARE @localErrorMsg		varchar(512)
SET		@localErrorMsg		='Error Encountered when running script.'
SET     @lastError				= 0		-- Be optimistic
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
begin tran
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#tmpClientsDupGUIDList') IS NOT NULL DROP TABLE #tmpClientsDupGUIDList
	CREATE TABLE #tmpClientsDupGUIDList(
		clid                      INT)
	INSERT INTO #tmpClientsDupGUIDList
	SELECT componentNameId FROM App_ClientProp
	WHERE attrName = 'Virtual Machine GUID'
	AND attrVal IN (
	SELECT attrVal
	FROM App_ClientProp
	WHERE attrName = 'Virtual Machine GUID' AND modified=0
	GROUP BY attrVal
	HAVING COUNT(attrVal) > 1)
	DELETE FROM #tmpClientsDupGUIDList WHERE EXISTS(SELECT componentNameId FROM App_ClientProp
		WHERE attrName = 'Virtual Machine Instance UUID' AND modified=0 AND #tmpClientsDupGUIDList.clid = componentNameId)
	INSERT INTO #tmpClientsDupGUIDList
	SELECT componentNameId FROM App_ClientProp
	WHERE attrName = 'Virtual Machine Instance UUID'
	AND attrVal IN (
	SELECT attrVal
	FROM App_ClientProp
	WHERE attrName = 'Virtual Machine Instance UUID' AND modified=0
	GROUP BY attrVal
	HAVING COUNT(attrVal) > 1)
	DELETE FROM APP_ClientProp WHERE componentNameId IN (SELECT clid FROM  #tmpClientsDupGUIDList) AND attrName IN
		( 'Virtual Machine GUID',
		'Virtual Machine Instance UUID',
		'Virtual Machine IP Address',
		'Virtual Machine Name',
		'Virtual Machine Host Name')
	DECLARE tempclients CURSOR FOR
		SELECT DISTINCT clid FROM #tmpClientsDupGUIDList
	OPEN tempclients
		FETCH NEXT FROM tempclients INTO @curClid
		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC AppSetSpecialClientStates @curClid
		FETCH NEXT FROM tempclients INTO @curClid
		END
	CLOSE  tempclients
	DEALLOCATE  tempclients
	DROP TABLE #tmpClientsDupGUIDList
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END   CATCH
ABORT:
IF @lastError  = 0
	COMMIT  Tran
ELSE
	ROLLBACK Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + '. Exit Code(' +convert(varchar(8), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CleanupVirtualServerDuplicateGUIDs')
	delete from GxQscripts where name = 'QS_CleanupVirtualServerDuplicateGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CleanupVirtualServerDuplicateGUIDs')
	delete from GXDBVersions where aliasname = 'QS_CleanupVirtualServerDuplicateGUIDs'
GO

insert into GXDBVersions values(2, 'QS_CleanupVirtualServerDuplicateGUIDs',  '00010005003400030000', 'QS_CleanupVirtualServerDuplicateGUIDs', '00010005003400030000')
GO

insert into GxQscripts values(2,'QS_CleanupVirtualServerDuplicateGUIDs',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn  CleanupVirtualServerDuplicateGUIDs '
)
GO

