

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CleanupDuplicateIndexServerEntries.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2019 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_CleanupDuplicateIndexServerEntries')
BEGIN
	print '>>> Drop Stored Procedure: QS_CleanupDuplicateIndexServerEntries <<<'
	drop procedure QS_CleanupDuplicateIndexServerEntries
END
IF EXISTS (select * from GxQscripts where name='QS_CleanupDuplicateIndexServerEntries')
	delete from GxQscripts where name = 'QS_CleanupDuplicateIndexServerEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CleanupDuplicateIndexServerEntries')
	delete from GXDBVersions where aliasname = 'QS_CleanupDuplicateIndexServerEntries'
GO
print '... Creating Procedure: QS_CleanupDuplicateIndexServerEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CleanupDuplicateIndexServerEntries
AS
SET NOCOUNT ON
--
	DECLARE @scriptName nvarchar(35) = 'CleanupDuplicateIndexServerEntries';
	DECLARE	@rowCnt int = 0
	DECLARE @retVal int = 0
	DECLARE @retStr nvarchar(100)= N''
	DELETE FROM App_IndexDBInfo WHERE id NOT IN
	(
		SELECT MAX(id) FROM App_IndexDBInfo GROUP BY backupSetGUID, dbName, idxDbEngineType
	)
	SELECT @rowCnt = @@ROWCOUNT, @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		set @retStr='Failed while cleaning up duplicate IndexServer entries.'
		GOTO CX_EXIT
	END
	PRINT 'Cleaned up ' + CONVERT(nvarchar(60), @rowCnt) + ' entries.'
	PRINT @scriptName + ' completed at ' + CONVERT(nvarchar(60), GETDATE())
	CX_EXIT:
	--if retstr is set, raise error
	if @retStr!=''
		RAISERROR(@retStr, 15 /* Severity > 10 to force DOS error code 1 */, 1);
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CleanupDuplicateIndexServerEntries')
	delete from GxQscripts where name = 'QS_CleanupDuplicateIndexServerEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CleanupDuplicateIndexServerEntries')
	delete from GXDBVersions where aliasname = 'QS_CleanupDuplicateIndexServerEntries'
GO

insert into GXDBVersions values(2, 'QS_CleanupDuplicateIndexServerEntries',  '00000000000000000000', 'QS_CleanupDuplicateIndexServerEntries', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CleanupDuplicateIndexServerEntries',  4, GETDATE(), GETDATE(), '' + CHAR(10) + ' Cleanup duplicate IndexServers entries for a backupset from the CommServer database 
'
 + CHAR(10) + ' 
'
 + CHAR(10) + '--  qoperation execscript -sn CleanupDuplicateIndexServerEntries'
 + CHAR(10) + ' 
'
)
GO

