

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_Changedefaultbackupset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ChangeDefaultBackupset')
BEGIN
	print '>>> Drop Stored Procedure: QS_ChangeDefaultBackupset <<<'
	drop procedure QS_ChangeDefaultBackupset
END
IF EXISTS (select * from GxQscripts where name='QS_ChangeDefaultBackupset')
	delete from GxQscripts where name = 'QS_ChangeDefaultBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeDefaultBackupset')
	delete from GXDBVersions where aliasname = 'QS_ChangeDefaultBackupset'
GO
print '... Creating Procedure: QS_ChangeDefaultBackupset'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ChangeDefaultBackupset
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @idaName varchar(1024) = '%s',
  @instanceName varchar(1024) = '%s',
  @oldDefaultBS varchar(1024) = '%s',
  @newDefaultBS varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName	varchar(1024)
--SET		@clientName	= '%s'
--DECLARE @idaName	varchar(1024)
--SET		@idaName	= '%s'
--DECLARE @instanceName	varchar(1024)
--SET		@instanceName	= '%s'
--DECLARE @oldDefaultBS	varchar(1024)
--SET		@oldDefaultBS	= '%s'
--DECLARE @newDefaultBS	varchar(1024)
--SET		@newDefaultBS	= '%s'
---------------------------------------
--test
--SET		@clientName = 'stlcvserv2'
--SET		@idaName = 'Virtual Server'
--SET		@instanceName = 'StlVcenter'
--SET		@newDefaultBS	= 'dontuse'
--SET		@oldDefaultBS	= 'defaultBackupSet'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'ChangeDefaultBackupset'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
DECLARE @now				integer
DECLARE @userId				integer
SET @now = dbo.GetUnixTime(GETDATE())
SET @userId	 = 1
----------------------- check inputs -----------------
IF @clientName	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @idaName	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. IDA name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @oldDefaultBS	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Old default backup set name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @newDefaultBS	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. New default backup set name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @instanceName	= @NoParameter
BEGIN
	SET @instanceName = 'DefaultInstanceName'
END
--------------SETP 1 ---------------------
BEGIN TRY
BEGIN TRAN
	DECLARE @clientId	int
	DECLARE @appTypeId	int
	DECLARE @instanceId	int
	DECLARE @oldBSId	int
	DECLARE @newBSId	int
	SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name=@clientName), 0)
	IF @clientId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client name ['+CAST(@clientName AS VARCHAR(10))+'] does not exists.'
		GOTO TRANS_EXIT
	END
	SET @appTypeId = (SELECT appTypeId FROM APP_IdaName
								 WHERE clientid = @clientId
								 AND appTypeId IN (SELECT distinct type FROM APP_IDAType
												   WHERE displayName = @idaName))
	IF @appTypeId IS null
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. IDA name ['+CAST(@idaName AS VARCHAR(10))+'] not found for client ['+CAST(@clientName AS VARCHAR(100))+'].'
		GOTO TRANS_EXIT
	END
	SET @instanceId = (SELECT id FROM APP_InstanceName
								WHERE name = @instanceName
								AND id IN (SELECT instance FROM APP_Application WHERE clientId=@clientId AND appTypeId=@appTypeId) )
	IF @instanceId IS null
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. IDA name ['+CAST(@instanceName AS VARCHAR(10))+'] not found for client ['+CAST(@clientName AS VARCHAR(100))+'] and appType ['+CAST(@idaName AS VARCHAR(100))+'].'
		GOTO TRANS_EXIT
	END
	SET @oldBSId = ISNULL((SELECT id FROM APP_Backupsetname WHERE id in (
							SELECT backupset FROM APP_Application WHERE clientId=@clientId and appTypeId=@appTypeId and instance=@instanceId) AND
								name = @oldDefaultBS), 0)
	IF @oldBSId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. BackupSet name1 ['+CAST(@oldDefaultBS AS VARCHAR(10))+'] not found for client ['+CAST(@clientName AS VARCHAR(100))+'] and appType ['+CAST(@idaName AS VARCHAR(100))+'].'
		GOTO TRANS_EXIT
	END
	SET @newBSId = ISNULL((SELECT id FROM APP_Backupsetname WHERE id in (
							SELECT backupset FROM APP_Application WHERE clientId=@clientId and appTypeId=@appTypeId and instance=@instanceId) AND
								name = @newDefaultBS), 0)
	IF @newBSId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. BackupSet name2 ['+CAST(@newDefaultBS AS VARCHAR(10))+'] not found for client ['+CAST(@clientName AS VARCHAR(100))+'] and appType ['+CAST(@idaName AS VARCHAR(100))+'].'
		GOTO TRANS_EXIT
	END
	--REMOVE DEFAULT BACKUP SET
	UPDATE APP_BackupSetName SET status=status&~8 WHERE id=@oldBSId
	--SET NEW DEFAULT BACKUP SET
	UPDATE APP_BackupSetName SET status=status|8 WHERE id=@newBSId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@clientName+', '+@idaName+
		 + @instanceName+', '+@oldDefaultBS+', '+@newDefaultBS+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_Changedefaultbackupset')
	delete from GxQscripts where name = 'QS_Changedefaultbackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_Changedefaultbackupset')
	delete from GXDBVersions where aliasname = 'QS_Changedefaultbackupset'
GO

insert into GXDBVersions values(2, 'QS_Changedefaultbackupset',  '00000000000000000000', 'QS_Changedefaultbackupset', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_Changedefaultbackupset',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript sn ChangeDefaultBackupSet.sql -si client name -si IDA Name -si Instance Name -si current default backupset -si new default backupset
'
 + CHAR(10) + '	Qoperation execscript sn ChangeDefaultBackupSet.sql -si myClient -si Oracle -si myInstance -si oldbackupset -si newbackupset
'
 + CHAR(10) + '--   script_name : Changedefaultbackupset'
)
GO

