

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ChangeSearchEngineAdminRole.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ChangeSearchEngineAdminRole')
BEGIN
	print '>>> Drop Stored Procedure: QS_ChangeSearchEngineAdminRole <<<'
	drop procedure QS_ChangeSearchEngineAdminRole
END
IF EXISTS (select * from GxQscripts where name='QS_ChangeSearchEngineAdminRole')
	delete from GxQscripts where name = 'QS_ChangeSearchEngineAdminRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeSearchEngineAdminRole')
	delete from GXDBVersions where aliasname = 'QS_ChangeSearchEngineAdminRole'
GO
print '... Creating Procedure: QS_ChangeSearchEngineAdminRole'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ChangeSearchEngineAdminRole
--This script is used to mark ADMIN role for given search engine and remove ADMIN role from other if any.
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  4 Corresponds to "high", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
-- SP Input Params
  @NodeclientName nvarchar(1024)=N''
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(64)
	SET		@scriptName	= 'QS_ChangeSearchEngineAdminRole'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg		varchar(512)
	SET		@localErrorMsg			='Successful.'
	DECLARE @now				integer
	SET @now = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @NoParameter		varchar(4)
	SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
	SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
	DECLARE @clientId INT
	DECLARE @noOfNodesInCloud INT
------------------------Check if node client exists or not------------------------
	IF NOT EXISTS(SELECT TOP 1 1 FROM APP_Client WITH (NOLOCK) WHERE name=@NodeclientName )
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Node client ['+CAST(@NodeclientName AS VARCHAR(64))+'] does not exists.'
		GOTO PROC_ERROR
	END
	SET @clientId = ISNULL((SELECT id FROM APP_Client WITH (NOLOCK) WHERE name=@NodeclientName),0)
	DECLARE @cloudId INT = ISNULL((SELECT cloudId from DM2SearchServerCoreInfo WITH (NOLOCK) WHERE clientId = @clientId AND cloudType = 3),0)
	IF @cloudId = 0
	BEGIN
		SET @localErrorMsg = N'Client is not part of any Cloud. Please specify correct node client name.'
		SET @lastError = 5
		GOTO PROC_ERROR
	END
	DECLARE @ID INT = ISNULL((SELECT Id FROM APP_ComponentProp WITH (NOLOCK)
								WHERE componentId = @cloudId AND longval = @clientId
AND propertyTypeId = 1008 AND modified = 0 ),0)
	DECLARE @adminClientId INT = ISNULL((SELECT ClientId FROM DM2SearchServerCoreInfo WITH (NOLOCK)
WHERE CloudId = @cloudId AND cloudType = 3 AND (CoreRoles & 4) >0 ),0)
	DECLARE @adminID INT = ISNULL((SELECT Id FROM APP_ComponentProp WITH (NOLOCK)
								WHERE componentId = @cloudId AND longval = @adminClientId
AND propertyTypeId = 1008 AND modified = 0 ),0)
	DECLARE @adminUrl VARCHAR(1024)  = ISNULL((SELECT serviceLink FROM DM2SearchServerCoreInfo WITH (NOLOCK)
											WHERE clientId = @clientId AND cloudType = 3),'')
	IF @adminClientId = 0  OR @adminID = 0 OR @ID = 0 OR @adminUrl =''
	BEGIN
		SET @localErrorMsg = N'Search node with ADMIN capability is not found.'
		SET @lastError = 6
		GOTO PROC_ERROR
	END
BEGIN TRY
BEGIN TRAN
------------------------Remove ADMIN node ------------------------
		update DM2SearchServerCoreInfo
set CoreRoles = (CoreRoles & ~(4 + 2 + 1))
		where clientId = @adminClientId AND cloudType = 3
		UPDATE APP_ComponentProp
SET longVal = (longVal & ~(4 + 2 + 1))
WHERE componentId = @adminID and propertyTypeId =1009 AND modified = 0
		--REMOVE FAST_QPS_URL
		IF EXISTS (SELECT * FROM APP_ClientProp WHERE componentNameId = @adminClientId AND modified =0 AND attrName = 'FAST_QPS_URL')
		BEGIN
			UPDATE APP_ClientProp
			SET modified = @now
			WHERE componentNameId = @adminClientId AND modified =0 AND attrName = 'FAST_QPS_URL'
		END
------------------------Mark ADMIN node------------------------
		--11.0 check for other roles on the client
		update DM2SearchServerCoreInfo
set CoreRoles = (CoreRoles | (4 | 2 | 1))
		where ClientId = @clientId AND cloudType = 3
		UPDATE APP_ComponentProp
SET longVal = (longVal | (4 | 2 | 1))
WHERE componentId = @ID and propertyTypeId =1009 AND modified = 0
		--SET FAST_QPS_URL
		IF NOT EXISTS (SELECT * FROM APP_ClientProp WHERE componentNameId = @clientId AND modified =0 AND attrName = 'FAST_QPS_URL')
		BEGIN
			INSERT INTO APP_ClientProp (componentNameId, attrName,attrType, attrVal, created, modified, ccpId)
			VALUES (@clientId,	'FAST_QPS_URL',	1,	@adminUrl,	@now,	0	,0)
		END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
END CATCH
ERROR_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'Client ['+ @NodeclientName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ChangeSearchEngineAdminRole')
	delete from GxQscripts where name = 'QS_ChangeSearchEngineAdminRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeSearchEngineAdminRole')
	delete from GXDBVersions where aliasname = 'QS_ChangeSearchEngineAdminRole'
GO

insert into GXDBVersions values(2, 'QS_ChangeSearchEngineAdminRole',  '00000000000000000000', 'QS_ChangeSearchEngineAdminRole', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ChangeSearchEngineAdminRole',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn QS_ChangeSearchEngineAdminRole -si SearchEngineNodeName '
 + CHAR(10) + '-- 		Mark ADMIN role for given search engine and remove ADMIN role from other if any.'
 + CHAR(10) + '-- 		SearchEngineNodeName: Name of the search engine node'
)
GO

