

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ChangeMediaType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_changeMediatype')
BEGIN
	print '>>> Drop Stored Procedure: QS_changeMediatype <<<'
	drop procedure QS_changeMediatype
END
IF EXISTS (select * from GxQscripts where name='QS_changeMediatype')
	delete from GxQscripts where name = 'QS_changeMediatype'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_changeMediatype')
	delete from GXDBVersions where aliasname = 'QS_changeMediatype'
GO
print '... Creating Procedure: QS_changeMediatype'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_changeMediatype
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 VARCHAR(1024)='',
  @PARAM2 VARCHAR(1024)='',
  @PARAM3 VARCHAR(1024)='',
  @PARAM4 VARCHAR(1024)='',
  @PARAM5 VARCHAR(1024)=''
AS
SET nocount ON
--------------------------------------------
---------- COMMANDLINE PARAMETERS ----------
--------------------------------------------
 --DECLARE @PARAM1 varchar(1024)
 --SET @PARAM1 ='%s'
 --DECLARE @PARAM2 varchar(1024)
 --SET @PARAM2 ='%s'
 --DECLARE @PARAM3 varchar(1024)
 --SET @PARAM3 ='%s'
 --DECLARE @PARAM4 varchar(1024)
 --SET @PARAM4 = '%s'
 --DECLARE @PARAM5 varchar(1024)
 --SET @PARAM5 = '%s'
/*
-- @Test remove comments
--  SET @PARAM1 = 'inlibraryandexportedgui'--'media' --'ListMediaTypes'--'inlibraryandexported''ListMediaTypes'
 -- SET @PARAM2 = 'HGB_SL500_Shared' --'SH_HP_MSL6030_Library' --'ECX477L1'--'KK1367L2'
 -- SET @PARAM3 = 'ULTRIUM V2'
--SET @PARAM4 = 'restrictbysuffix'
--SET @PARAM5 = 'L3'
*/
/* locale variables */
DECLARE @LibararyName NVARCHAR(128) --= 'EGDCLIB1'-- 'WICHLIB3'
DECLARE @LibraryId INTEGER
DECLARE @MediaType NVARCHAR(128)
DECLARE @MediaTypeId INTEGER
DECLARE @RecFormatId INTEGER
DECLARE @optionType VARCHAR(128)
DECLARE @Barcode NVARCHAR(128)
DECLARE @spareGrpId INTEGER
DECLARE @suffix VARCHAR(128)
DECLARE @useBarCodeForMtyp VARCHAR(128)
DECLARE @mediaCapacity		BIGINT
DECLARE @changeMediaTypeList TABLE
								(
										MediaId				INTEGER,
										SpareGroupType		INTEGER,
										oldSpareGroupId		INTEGER,
										origSpareGroupId	INTEGER,
										libraryId			INTEGER
								)
BEGIN TRANSACTION
-- we need at least two parameters
IF(@PARAM1 = '' OR @PARAM2 = '' )
BEGIN
		print 'Error: Insufficient command line parameters'
		print 'Please refer to the readme file and retry with necessary parameters'
		GOTO SCRIPT_EXIT
END
SET @optionType = @PARAM1
IF( @optionType NOT IN ('ListMediaTypes','media','inlibraryandexported','inlibrary','inlibraryandexportedgui'))
BEGIN
		print 'Error: Wrong option type '
		GOTO SCRIPT_EXIT
END
IF (@optionType = 'media')
BEGIN
		SET @Barcode = @PARAM2
END
ELSE
BEGIN
	SET @LibararyName = @PARAM2
	IF(ISNULL((SELECT COUNT(*) FROM MMLibrary WHERE AliasName = @LibararyName),0) = 0 )
	BEGIN
				print 'Error: Library does not exist'
				GOTO SCRIPT_EXIT
	END
	ELSE
				SELECT @libraryId = LibraryId FROM MMLibrary WHERE AliasName = @LibararyName
END
IF (@optionType = 'ListMediaTypes')
BEGIN
	SELECT DISTINCT MDT.MediaTypeName
	FROM MMRecFmtMedtyp MMR
	INNER JOIN MMDrive 	MDR ON MDR.driveTypeId = MMR.driveTypeId
	INNER JOIN MMMasterPool MMP ON MMP.masterPoolID = MDR.masterPoolID  AND MMP.LibraryId = @LibraryId
	INNER JOIN MMMediatype	MDT	ON MMR.MediaTypeId = MDT.MediaTypeId AND MDT.IsCleaningMedia <> 1
	GOTO EXIT_OK
END
IF(@PARAM3 = '' )
BEGIN
	print 'Error: Insufficient command line parameters'
	print 'Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
SET @MediaType = @PARAM3
IF(ISNULL((SELECT COUNT(*) FROM MMMediaType MDT WHERE MDT.MediaTypeName = @MediaType),0) = 0)
BEGIN
			print 'Error: Wrong Media Type'
			GOTO SCRIPT_EXIT
END
ELSE
	SELECT @mediaTypeId = MDT.MediaTypeId FROM MMMediaType MDT WHERE MDT.MediaTypeName = @MediaType
IF(@optionType = 'media')
 BEGIN
		IF EXISTS(SELECT MediaId FROM MMMedia MD WHERE MD.BarCode =  @Barcode)
		BEGIN
			INSERT @changeMediaTypeList (
										MediaId,
										SpareGroupType,
										oldSpareGroupId,
										origSpareGroupId,
										libraryId
										)
			SELECT MD.MediaId,MSP.SpareGroupType,MD.SpareGroupId,MD.origSpareGroupId,MD.LibraryId
				FROM MMMedia MD,MMSpareGroup MSP WHERE MD.BarCode =  @Barcode
													AND MSP.SpareGroupId = MD.SpareGroupId
			SELECT @LibraryId = LibraryId  FROM MMMedia MD WHERE MD.BarCode =  @Barcode
		END
		ELSE
		BEGIN
			print 'Error: Barcode does not exist'
			GOTO SCRIPT_EXIT
		END
 END
ELSE
 BEGIN
	SET @useBarCodeForMtyp = @PARAM4
	IF(@PARAM4 = 'restrictbysuffix')
	BEGIN
		SET @suffix = @PARAM5
		IF(@suffix = '%s' OR @suffix = '' )
		BEGIN
			print 'Error: Invalid suffix '
		END
	END
	INSERT @changeMediaTypeList	(
										MediaId,
										SpareGroupType,
										oldSpareGroupId,
										origSpareGroupId,
										libraryId
									)
    SELECT MD.MediaId,MSG.SpareGroupType,MD.SpareGroupId,MD.origSpareGroupId,MD.LibraryId
            FROM MMMedia MD INNER JOIN MMSpareGroup MSG ON MSG.SpareGroupId = MD.SpareGroupId
                         AND MSG.SpareGroupType <> 32 --Cleaning media
                         AND (
								(
								MD.LibraryId = @LibraryId
								AND (
										@optionType IN ('inlibraryandexported', 'inlibraryandexportedgui')
									  OR MD.MediaLocation <> 3
									)
                                )
								OR  (
										@optionType = 'inlibraryandexportedgui'
										AND MD.MediaLocation = 3
										AND LastWriteLibraryId = @libraryId
									)
								OR (
										@optionType = 'inlibraryandexportedgui'
										AND MD.MediaLocation = 3
										AND MD.SparegroupId IN
										( SELECT MSP.SpareGroupId FROM MMSpareGroup MSP WHERE MSP.LibraryId = @libraryId )
									)
							)
                        AND(
								@useBarCodeForMtyp <> 'restrictbysuffix'
                                OR  RIGHT(MD.BarCode,LEN(@suffix))= @suffix
                            )
END
IF(@@ERROR <> 0 )
BEGIN
	print 'Error: Script failed to run '
	GOTO SCRIPT_EXIT
END
-- now bein updating the media.
UPDATE MMMedia
	SET MMMedia.MediaTypeId = @MediaTypeId --change media type
FROM @changeMediaTypeList CMT
WHERE CMT.MediaId = MMMedia.MediaId
IF(@@ERROR <> 0 )
BEGIN
	print 'Error: Failed to update MMMedia table'
	GOTO SCRIPT_EXIT
END
-- Update media capcity MR#80734.
SELECT
	@mediaCapacity = MaxUncompressCapacityMB
FROM MMMediaType
where MediaTypeId = @MediaTypeId
-- Update Totalsize MMMediaSide
UPDATE MMMediaSide
	SET TotalSpaceMB = @mediaCapacity
FROM MMMediaSide MSD
INNER JOIN @changeMediaTypeList ML ON MSD.MediaId = ML.MediaId
IF(@@ERROR <> 0 )
BEGIN
	print 'Error: Failed to update MMMediaSide table'
	GOTO SCRIPT_EXIT
END
-- now update the sparegroup type
UPDATE MMMedia
SET MMMedia.SpareGroupId =
(
	SELECT TOP 1 IMSP.SpareGroupId
	FROM
		-- IMSP specifies the target sparegroup
		MMSpareGroup IMSP
	WHERE
		-- library has to match
		IMSP.LibraryId = @LibraryId AND
		(
			-- the default spare group for the new library is always a candidate
			IMSP.SpareGroupType = 2
			OR
			-- if it is a type 1, only allow it if it is of matching media type
			IMSP.SpareGroupType = 1 AND CMT.SpareGroupType IN (1,2) AND IMSP.MediaTypeId = @MediaTypeId
			OR
			-- if it is not (1,2) type, then allow any matching sparegroup types
			IMSP.SpareGroupType = CMT.SpareGroupType AND IMSP.SpareGroupType > 2
		)
	ORDER BY
				--keep same sparegroup if possible
				CASE WHEN IMSP.SpareGroupId = CMT.oldSpareGroupId THEN 0 ELSE 1 END,
				-- if sparegroup has to change, prefer default if it matches the media type and original type was user or default
				CASE WHEN IMSP.SpareGroupType = 2 AND IMSP.MediaTypeID = @mediaTypeID AND CMT.SpareGroupType IN (1,2) THEN 0 ELSE 1 END,
				-- if sparegroup is not (1,2), then make sure to use the right type
				CASE WHEN IMSP.SpareGroupType = CMT.SpareGroupType AND CMT.SpareGroupType > 2 THEN 0 ELSE 1 END,
				-- else prefer default
				CASE WHEN IMSP.SpareGroupType = 2 THEN 0 ELSE 1 END
)
FROM  @changeMediaTypeList CMT,MMSpareGroup MSP
WHERE
		-- which media need to change
		CMT.MediaId = MMMedia.MediaId
		-- MSP has info on old spare group info
		AND MSP.SpareGroupId = CMT.oldSpareGroupId
		AND
		(
			-- change sparegroup if library is the same and old spare group is user type and media type does not match
			MSP.MediaTypeId <> @MediaTypeId AND MSP.SpareGroupType = 1
			OR
			-- definately change if the library is different
			MSP.LibraryId <> @LibraryId
		)
IF(@@ERROR <> 0 )
BEGIN
	print 'Error: Failed to update MMMedia table'
	GOTO SCRIPT_EXIT
END
--change recording format type in MMVolume
SET @RecFormatId = (
					SELECT TOP 1 MRF.RecordingFormatId FROM MMRecFmtMedTyp MRF
											INNER JOIN MMMediaType MDT ON MRF.MediaTypeId = MDT.MediaTypeId
																		AND MDT.MediaTypeName =	@MediaType
											INNER JOIN MMDrive MMDR ON	MMDR.DriveTypeId = MRF.DriveTypeId
											INNER JOIN MMMasterPool MSP ON MSP.masterPoolId = MMDR.masterPoolId
																		AND MSP.LibraryId = @LibraryId
											ORDER BY MRF.RecordingFormatId DESC
					)
IF (@RecFormatId IS NULL)
BEGIN
	print 'Error: Cannot find recording format for media type and library combination'
	print 'Error: Incompatible target media type'
	GOTO SCRIPT_EXIT
END
UPDATE MMVolume
	SET RecordingFormatId = @RecFormatId
FROM @changeMediaTypeList CMT WHERE MMVolume.MediaId = CMT.MediaId
IF(@@ERROR <> 0 )
BEGIN
		print 'Error: Failed to update MMVolume table'
		GOTO SCRIPT_EXIT
END
GOTO EXIT_OK
SCRIPT_EXIT:
	ROLLBACK TRANSACTION
	print 'Error: Failed to run script'
	GOTO FINAL_EXIT
EXIT_OK:
	COMMIT TRANSACTION
FINAL_EXIT:
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ChangeMediaType')
	delete from GxQscripts where name = 'QS_ChangeMediaType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeMediaType')
	delete from GXDBVersions where aliasname = 'QS_ChangeMediaType'
GO

insert into GXDBVersions values(2, 'QS_ChangeMediaType',  '00000000000000000000', 'QS_ChangeMediaType', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ChangeMediaType',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Note - if the mediatype or library name has spaces, use double quotes!
'
 + CHAR(10) + '	1. List ALL compatible media types for that library
'
 + CHAR(10) + '	QOperation.exe execscript -sn changeMediaType -si ListMediaTypes -si <Libarary Name> 
'
 + CHAR(10) + '	2. change mediatype of a specific media
'
 + CHAR(10) + '	QOperation.exe execscript -sn changeMediaType -si media -si <barcode> -si <MediaType> 
'
 + CHAR(10) + '	3. Change mediatype of all available media in library
'
 + CHAR(10) + '	QOperation.exe execscript -sn changeMediaType -si inlibrary -si <Libarary Name> -si <MediaType>
'
 + CHAR(10) + '	4. Change mediatype of all available media in library whose barcode ends with suffix
'
 + CHAR(10) + '	QOperation.exe execscript -sn changeMediaType -si inlibrary -si <Libarary Name> -si <MediaType> -si restrictbysuffix -si <Suffix>
'
 + CHAR(10) + '	5. Change mediatype of all existing AND exported media of library
'
 + CHAR(10) + '	QOperation.exe execscript -sn changeMediaType -si inlibraryandexported -si <Libarary Name> -si <MediaType>
'
 + CHAR(10) + '	6. Change mediatype of all existing AND exported media of library whose barcode ends with suffix
'
 + CHAR(10) + '	QOperation.exe execscript -sn changeMediaType -si inlibraryandexported -si <Libarary Name> -si <MediaType> -si restrictbysuffix -si <Suffix>
'
 + CHAR(10) + '	Note:- In addition to "inlibraryandexported" an additional option "inlibraryandexportedgui" can be used.
'
 + CHAR(10) + '	"inlibraryandexported" selects the media in the library and media which were last exported from the library.
'
 + CHAR(10) + '	"inlibraryandexportedgui" selects the same as above  but in addition also selects media that were at one point written to inside the specified library. The name GUI comes from the fact that the exported media it selects uses a similar logic as the exported media node in the GUI.	
'
 + CHAR(10) + '--   script_name : ChangeMediaType'
)
GO

