

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ChangeFollowMountPoint.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ChangeFollowMountPoint <<<'

IF EXISTS (select * from sysobjects where name='QS_ChangeFollowMountPoint')
	drop procedure QS_ChangeFollowMountPoint
IF EXISTS (select * from GxQscripts where name='QS_ChangeFollowMountPoint')
	delete from GxQscripts where name = 'QS_ChangeFollowMountPoint'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeFollowMountPoint')
	delete from GXDBVersions where aliasname = 'QS_ChangeFollowMountPoint'
GO
print '... Creating Procedure: QS_ChangeFollowMountPoint'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ChangeFollowMountPoint
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @newValue NVARCHAR(10) = '0'
AS
SET NOCOUNT ON
	DECLARE @subTaskId INT
	DECLARE @taskId INT
	DECLARE @xmlValue XML = ''
	DECLARE @errorcode INT = 0
	DECLARE @errorstring NVARCHAR(MAX) = ''
	DECLARE @value NVARCHAR(MAX)
	DECLARE @inValue INT = 0
	DECLARE @nowTime		INT = dbo.GetUnixTime (GetDate())
	DECLARE @subTakBkpTable TABLE (subTaskId INT, taskId INT)
	IF ISNUMERIC(@newValue) = 0
	BEGIN
		IF @newValue = 'ON'
			SET @newValue = 1
	END
	--GET SUBTASKID FOR UPGRADED BACKUP SCHEDULES
	INSERT INTO @subTakBkpTable
	SELECT S.subTaskId, S.taskId FROM TM_SubTask S
	JOIN TM_Task T ON T.taskId = S.taskId
WHERE S.subTaskType = 2
AND T.taskType IN (2, 4)
BEGIN TRY
BEGIN TRAN
	DECLARE subTaskBkpCursor CURSOR
	FOR SELECT subTaskId, taskId FROM @subTakBkpTable
	OPEN subTaskBkpCursor
	FETCH FROM subTaskBkpCursor INTO @subTaskId, @taskId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--GET XML OPTIONS
		SELECT @xmlValue=xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @subTaskId
		--SET VALUE IN XML OPTION
		IF (@xmlValue.exist('/TMMsg_JobOption[1]/backupOpts[1]/dataOpt[1]/@followMountPoints')) = 1
			SET @xmlValue.modify('replace value of (TMMsg_JobOption[1]/backupOpts[1]/dataOpt[1]/@followMountPoints)[1] with sql:variable("@newValue")')
		ELSE
		BEGIN
			SET @xmlValue.modify('insert (attribute followMountPoints {sql:variable("@newValue")}) into (/TMMsg_JobOption/backupOpts/dataOpt)[1]')
		END
		--UPDATE THE XML OPTION
		UPDATE TM_SubTaskXMLOptions SET xmlValue=@xmlValue WHERE subTaskId=@subTaskId
		--BUILD THE EXTENDED BIT OPTIONS
		SELECT @value=dbo.BuildSubTaskExtOption(0, @subTaskId, 5)
		--SET THE EXTENDED BACKUP OPTION FOR SUBTASK
UPDATE TM_SubTaskOptions set value=@value WHERE optionId = 100004 AND subTaskId = @subTaskId
		--SET THE EXTENDED COMMON OPTION FOR SUBTASK
UPDATE TM_SubTaskOptions set value=@value WHERE optionId = 140015 AND subTaskId = @subTaskId
		--SET THE EXTENDED BACKUP OPTION FOR SUBTASK
UPDATE TM_JobOptions set value=@value WHERE optionId = 100004 AND subTaskId = @subTaskId
		--SET THE EXTENDED COMMON OPTION FOR JOBS
UPDATE TM_JobOptions set value=@value WHERE optionId = 140015 AND subTaskId = @subTaskId
		--SET SUBTASK OPTION
IF EXISTS(SELECT 1 FROM TM_SubTaskOptions WHERE optionId = 1817749836 AND subTaskId = @subTaskId)
UPDATE TM_SubTaskOptions SET value=@newValue WHERE optionId = 1817749836 AND subTaskId = @subTaskId
		ELSE
			INSERT TM_SubTaskOptions (subTaskId, optionId, type, value)
SELECT @subTaskId, 1817749836, 2, @newValue
		--SET JOB OPTION
IF EXISTS(SELECT 1 FROM TM_JobOptions WHERE optionId = 1817749836 AND subTaskId = @subTaskId AND jobId = 0)
UPDATE TM_JobOptions SET modified=@nowTime WHERE optionId = 1817749836 AND subTaskId = @subTaskId AND jobId = 0
		ELSE
			INSERT TM_JobOptions (jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
SELECT 0, 1817749836, 2, @newValue, @taskId, @subTaskId, 0, @nowTime, 0
		FETCH FROM subTaskBkpCursor INTO @subTaskId, @taskId
	END
	CLOSE subTaskBkpCursor
	DEALLOCATE subTaskBkpCursor
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
 	--Close cursor
 	IF ( CURSOR_STATUS('global', 'subTaskBkpCursor') >= 0  /* cursor is open */
 		OR CURSOR_STATUS('local', 'subTaskBkpCursor') >= 0 )
 	CLOSE subTaskBkpCursor
 	IF ( CURSOR_STATUS('global','subTaskBkpCursor') = -1  /* cursor is closed */
 		OR CURSOR_STATUS('local','subTaskBkpCursor') = -1 )
 	DEALLOCATE subTaskBkpCursor
	ROLLBACK TRAN
	SET @errorcode = ERROR_NUMBER()
	SET @errorstring = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END
END CATCH
CLEANUP:
if @errorCode <> 0
    Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
    )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ChangeFollowMountPoint')
	delete from GxQscripts where name = 'QS_ChangeFollowMountPoint'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeFollowMountPoint')
	delete from GXDBVersions where aliasname = 'QS_ChangeFollowMountPoint'
GO

insert into GXDBVersions values(2, 'QS_ChangeFollowMountPoint',  '00000000000000000000', 'QS_ChangeFollowMountPoint', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ChangeFollowMountPoint',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn ChangeFollowMountPoint [-si <newValue>]
'
)
GO

