

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ChangeDeviceControllerPathForMP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ChangeDeviceControllerPathForMP <<<'

IF EXISTS (select * from sysobjects where name='QS_ChangeDeviceControllerPathForMP')
	drop procedure QS_ChangeDeviceControllerPathForMP
IF EXISTS (select * from GxQscripts where name='QS_ChangeDeviceControllerPathForMP')
	delete from GxQscripts where name = 'QS_ChangeDeviceControllerPathForMP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeDeviceControllerPathForMP')
	delete from GXDBVersions where aliasname = 'QS_ChangeDeviceControllerPathForMP'
GO
print '... Creating Procedure: QS_ChangeDeviceControllerPathForMP'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ChangeDeviceControllerPathForMP
-- Qscript is enabled
-- Set to low audit level
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_mediaAgentName nvarchar(1024)='',
  @i_libraryName nvarchar(1024)='',
  @i_path nvarchar(1024)=''
AS
	SET NOCOUNT ON
	DECLARE  @errorCode 	INTEGER = 0
	DECLARE	 @errorString  	VARCHAR(1024)
	DECLARE  @clientId 		INTEGER
-- check if input params are provided.
	if( @i_mediaAgentName = '%s' OR LEN(@i_mediaAgentName) = 0)
	BEGIN
		SET @errorCode = -1
		SET @errorString = 'Error: Media Agent Name is not provided, please check the usage and try again.'
		GOTO CX_EXIT
	END
	if( @i_libraryName = '%s' OR LEN(@i_libraryName) = 0)
	BEGIN
		SET @errorCode = -2
		SET @errorString = 'Error: Library Name is not provided, please check the usage and try again.'
		GOTO CX_EXIT
	END
	if( @i_path = '%s' OR LEN(@i_path) = 0)
	BEGIN
		SET @errorCode = -3
		SET @errorString = 'Error: Device Controller Access Path is not provided, please check the usage and try again.'
		GOTO CX_EXIT
	END
	-- validate the input params
	IF NOT EXISTS (select * from APP_Client where name = @i_mediaAgentName)
	BEGIN
		set @errorCode = -4
		set @errorString = 'Error: Invalid media agent name provided ' + @i_mediaAgentName + ',Please try again.'
		GOTO CX_EXIT
	END
	IF NOT EXISTS (select * from MMLibrary where AliasName = @i_libraryName)
	BEGIN
		set @errorCode = -5
		set @errorString = 'Error: Invalid library name provided '+ @i_libraryName + ',Please try again.'
		GOTO CX_EXIT
	END
IF ( 7 = (SELECT distinct MountPathTypeId from MMMountPath where LibraryId =
		(SELECT LibraryId FROM MMLibrary WHERE AliasName = @i_libraryName) ) )
	BEGIN
		set @errorCode = -9
		set @errorString = 'Error: The input library '+ @i_libraryName + ' is a cloud library, the script does not support updating device access path for a cloud library so please try again.'
		GOTO CX_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#tempDeviceIds') IS NOT NULL DROP TABLE #tempDeviceIds
	CREATE TABLE #tempDeviceIds (DeviceId INTEGER)
	INSERT INTO #tempDeviceIds
	SELECT DeviceId FROM MMMountPathToStorageDevice AS MPS, MMMountPath AS MP, MMLibrary AS ML
	WHERE MPS.MountPathId = MP.MountPathId and MP.LibraryId = ML.LibraryId and  MP.origCCcommCellID = 2 and ML.AliasName = @i_libraryName
	IF( (select COUNT( distinct DeviceId) from #tempDeviceIds) > 1)
	BEGIN
		set @errorCode = -6
		set @errorString = 'Error: Input Library '+ @i_libraryName+' has more than one mount path, the script does not support modifying device controller access path for this library.'
		GOTO CX_EXIT
	END
	ELSE IF ((select COUNT( distinct DeviceId) from #tempDeviceIds) = 0)
	BEGIN
		set @errorCode = -7
		set @errorString = 'Error: Input Library '+ @i_libraryName+' does not have a mount path, please try again.'
		GOTO CX_EXIT
	END
	SET @clientId = (SELECT id FROM APP_Client WHERE name = @i_mediaAgentName)
	-- check if the media agent can access the library.
	DECLARE @nDeviceController INTEGER = 0
	SELECT @nDeviceController = COUNT(DISTINCT DeviceControllerId) FROM MMDeviceController DC, #tempDeviceIds t
	WHERE DC.DeviceId = t.DeviceId and DC.ClientId = @clientId
	IF( @nDeviceController = 0 )
	BEGIN
		set @errorCode = -8
		set @errorString = 'Error: Input library '+ @i_libraryName + ' is not accessible from the given media agent ' + @i_mediaAgentName + ',please try again.'
		GOTO CX_EXIT
	END
	UPDATE MMDeviceController
	SET Folder = @i_path
	WHERE ClientId = @clientId
	and DeviceId IN (SELECT DeviceId FROM #tempDeviceIds)
	DROP TABLE #tempDeviceIds
	CX_EXIT:
	IF( @errorCode <> 0)
	BEGIN
		RAISERROR(@errorString, 16, 1)
	END
	RETURN @errorCode -- return the error code as well
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ChangeDeviceControllerPathForMP')
	delete from GxQscripts where name = 'QS_ChangeDeviceControllerPathForMP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeDeviceControllerPathForMP')
	delete from GXDBVersions where aliasname = 'QS_ChangeDeviceControllerPathForMP'
GO

insert into GXDBVersions values(2, 'QS_ChangeDeviceControllerPathForMP',  '00000000000000000000', 'QS_ChangeDeviceControllerPathForMP', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ChangeDeviceControllerPathForMP',  4, GETDATE(), GETDATE(), '' + CHAR(10) + ' Qscript to update the device access path for a given library name and media agent client name.
'
 + CHAR(10) + ' Usage:
'
 + CHAR(10) + '--  qoperation execscript -sn ChangeDeviceControllerPathForMP -si Media_Agent_Name -si Library_Name -si New_Device_Access_Path'
)
GO

