

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ChangeCommcellName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ChangeCommcellName.sp,v $ $Id: QS_ChangeCommcellName.sp,v 1.1.2.3 2018/03/27 08:06:38 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ChangeCommcellName <<<'

IF EXISTS (select * from sysobjects where name='QS_ChangeCommcellName')
	drop procedure QS_ChangeCommcellName
IF EXISTS (select * from GxQscripts where name='QS_ChangeCommcellName')
	delete from GxQscripts where name = 'QS_ChangeCommcellName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeCommcellName')
	delete from GXDBVersions where aliasname = 'QS_ChangeCommcellName'
GO
print '... Creating Procedure: QS_ChangeCommcellName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ChangeCommcellName
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
  @oldName varchar(1024) = '%s',
  @newName varchar(1024) = '%s'
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'ChangeCommcellName'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError			integer
DECLARE @localErrorMsg		varchar(512)
SET		@localErrorMsg		='Error Encountered when running script.'
SET     @lastError				= 0		-- Be optimistic
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @oldName = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Missing old commcell name parameters.'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
IF @newName = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Missing new commcell name parameters.'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF NOT EXISTS(SELECT 1 FROM APP_CommCell WHERE aliasName = @oldName)
BEGIN
	SET @localErrorMsg	='Error. Commcell name [' + @oldName + '] not found'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
IF EXISTS(SELECT 1 FROM APP_CommCell WHERE aliasName = @newName)
BEGIN
	SET @localErrorMsg	='Error. Commcell name [' + @newName + '] already exists'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
BEGIN TRY
BEGIN TRAN
	UPDATE APP_CommCell SET aliasName = @newName WHERE aliasName= @oldName
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = ISNULL(ERROR_MESSAGE(), 'UNKNOWN ERROR')
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
IF @lastError  = 0
	COMMIT  Tran
ELSE
	ROLLBACK Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameter: oldName = ['
         + @oldName
		 + '], newName ['
         + @newName
         + ']. Exit Code(' +convert(varchar(8), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ChangeCommcellName')
	delete from GxQscripts where name = 'QS_ChangeCommcellName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeCommcellName')
	delete from GXDBVersions where aliasname = 'QS_ChangeCommcellName'
GO

insert into GXDBVersions values(2, 'QS_ChangeCommcellName',  '00010001000200030000', 'QS_ChangeCommcellName', '00010001000200030000')
GO

insert into GxQscripts values(2,'QS_ChangeCommcellName',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn  QS_ChangeCommcellName -si <old name>  -si <new name>'
)
GO

