

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ChangeCSHostNameAfterMigration.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ChangeCSHostNameAfterMigration')
BEGIN
	print '>>> Drop Stored Procedure: QS_ChangeCSHostNameAfterMigration <<<'
	drop procedure QS_ChangeCSHostNameAfterMigration
END
IF EXISTS (select * from GxQscripts where name='QS_ChangeCSHostNameAfterMigration')
	delete from GxQscripts where name = 'QS_ChangeCSHostNameAfterMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeCSHostNameAfterMigration')
	delete from GXDBVersions where aliasname = 'QS_ChangeCSHostNameAfterMigration'
GO
print '... Creating Procedure: QS_ChangeCSHostNameAfterMigration'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ChangeCSHostNameAfterMigration
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = '',
  @PARAM3 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_clientName VARCHAR(1024)
 DECLARE @i_newCsHostName VARCHAR(1024)
 DECLARE @i_filePath VARCHAR(1024)
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'ChangeCSHostNameAfterMigration'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @SQLString 		NVARCHAR(MAX) = N''
DECLARE @InvlidNames	NVARCHAR(MAX) = N''
DECLARE @clientId	INT = 0
BEGIN TRY
BEGIN TRAN
	IF((@PARAM1 = @NoParameter AND @PARAM2 = @NoParameter) OR @PARAM3 = @NoParameter) --Requires both clientName and destination cs host name
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_ChangeCSHostNameAfterMigration'
		SET @localErrorMsg = 'Error: Insufficient command line parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SET @i_clientName = @PARAM1
	SET @i_filePath = @PARAM2
	SET @i_newCsHostName = @PARAM3
	IF OBJECT_ID('tempdb..#clientList') IS NOT NULL
        DROP TABLE #clientList
	CREATE TABLE #clientList(clientName VARCHAR(1024))
	IF LEN(@i_clientName) > 0
	BEGIN
		INSERT INTO #clientList
		SELECT @i_clientName
	END
	IF LEN(@i_filePath) > 0
	BEGIN
		SET @SQLString= 'BULK INSERT #clientList FROM '''+ @i_filePath + ''' WITH (ROWTERMINATOR = ''\n'')'
		EXEC sp_executesql @SQLString
		IF @@ERROR > 0
		BEGIN
			SET @localErrorMsg = N'ERROR: Please check whether file path is valid -- bulk insert error.'
			SET @lastError = 1
			GOTO SCRIPT_EXIT
		END
	END
	--Validate client names
	IF EXISTS(	SELECT 1 FROM #clientList A
				LEFT OUTER JOIN App_Client B ON A.clientName = B.name
				WHERE B.name IS NULL )
	BEGIN
		SELECT  @InvlidNames = @InvlidNames + A.clientName + + ', '
		FROM	#clientList A
				LEFT OUTER JOIN App_Client B ON A.clientName = B.name
		WHERE B.name IS NULL
		SET @localErrorMsg	=	'Error: There are some invalid client names ['+ @InvlidNames +'] exists, please delete them from the input first then try again the operation.'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	IF EXISTS(	SELECT 1 FROM #clientList A
				INNER JOIN App_Client B ON A.clientName = B.name
				WHERE B.id = 2 )
	BEGIN
		SELECT  @InvlidNames = A.clientName
		FROM	#clientList A
				INNER JOIN App_Client B ON A.clientName = B.name
		WHERE B.id = 2
		SET @localErrorMsg	=	'Error: Client  [' + @InvlidNames + '] is a CommServer. It''s not allowed to change CommServer.'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	--Change csHostName and mark the client as not belongs to this commserver
	UPDATE 	A
	SET		csHostName 			= @i_newCsHostName,
specialClientFlags 	= (specialClientFlags | 0x20 | 0x2)
	FROM 	App_Client A INNER JOIN #clientList B ON A.name = B.clientName
	--Deconfigure clients first.
	DECLARE DeconfigureClientCur CURSOR LOCAL FORWARD_ONLY
    FOR SELECT B.id FROM #clientList A
		INNER JOIN App_Client B ON A.clientName = B.name
    OPEN DeconfigureClientCur
    FETCH DeconfigureClientCur INTO @clientId
    WHILE @@FETCH_STATUS = 0
    BEGIN
        EXEC AppConfDeconf @clientId, 0, 0, 2, @lastError OUTPUT, @localErrorMsg OUTPUT
        IF @@ERROR <> 0 OR @lastError <> 0 GOTO SCRIPT_EXIT
        FETCH NEXT FROM DeconfigureClientCur INTO @clientId
    END
    CLOSE DeconfigureClientCur
    DEALLOCATE DeconfigureClientCur
	--Remove packages for this client
	DELETE 	A
	FROM 	SimInstalledPackages A INNER JOIN App_Client B ON A.clientId = B.id
			INNER JOIN #clientList C ON B.name = C.clientName
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = ISNULL(ERROR_MESSAGE(), 'UNKNOWN ERROR')
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
		SELECT 'Successfully changed csHostName for all the given clients.'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ChangeCSHostNameAfterMigration')
	delete from GxQscripts where name = 'QS_ChangeCSHostNameAfterMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeCSHostNameAfterMigration')
	delete from GXDBVersions where aliasname = 'QS_ChangeCSHostNameAfterMigration'
GO

insert into GXDBVersions values(2, 'QS_ChangeCSHostNameAfterMigration',  '00000000000000000000', 'QS_ChangeCSHostNameAfterMigration', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ChangeCSHostNameAfterMigration',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn ChangeCSHostNameAfterMigration -si <Client Name> -si <file path of client names> -si <Destination CommServer Host Name>'
)
GO

