

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CSLiveSyncRetentionOverride.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2020  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_CSLiveSyncRetentionOverride')
BEGIN
	print '>>> Drop Stored Procedure: QS_CSLiveSyncRetentionOverride <<<'
	drop procedure QS_CSLiveSyncRetentionOverride
END
IF EXISTS (select * from GxQscripts where name='QS_CSLiveSyncRetentionOverride')
	delete from GxQscripts where name = 'QS_CSLiveSyncRetentionOverride'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CSLiveSyncRetentionOverride')
	delete from GXDBVersions where aliasname = 'QS_CSLiveSyncRetentionOverride'
GO
print '... Creating Procedure: QS_CSLiveSyncRetentionOverride'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CSLiveSyncRetentionOverride
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_operation VARCHAR(1024) = ''
AS
Set NOCOUNT ON
/*Locale variables*/
DECLARE @l_errorMessage NVARCHAR(MAX) = N''
DECLARE @l_errorNumber INTEGER = 0
DECLARE @DisableRetentionOverride INTEGER = 0
DECLARE @LogShippingSubclientId INTEGER = 0
DECLARE @nowTime int = dbo.getunixtime(getutcdate())
SELECT @LogShippingSubclientId = LogShippingSubclientId FROM CvFailoverLogShippingScInfo WITH (NOLOCK)
IF @LogShippingSubclientId = 0
BEGIN
	SET @l_errorMessage = N'Could not detect LiveSync Subclient.'
	SET @l_errorNumber = 1
	GOTO PROC_ERROR
END
IF @i_operation = 'status'
BEGIN
	IF EXISTS(SELECT 1 FROM APP_SubClientProp(NOLOCK)
			WHERE attrName = 'Override storage policy copy retention'
			AND componentNameId = @LogShippingSubclientId
			AND modified = 0
			AND cs_attrname = CHECKSUM(N'Override storage policy copy retention')
			) --CV_PROP_OVERRIDE_COPY_RETENTION_TYPE
	BEGIN
		DECLARE @retentionDays INT = 0
		DECLARE @fullCycles INT = 0
		SELECT @retentionDays = retentionDays
			, @fullCycles = fullCycles
		FROM archAppCopyAgingRule(NOLOCK)
		WHERE appId = @LogShippingSubclientId
		PRINT 'CommServe LiveSync Subclient Retention override is currently enabled. Retention days [' + TRY_CAST(@retentionDays AS VARCHAR(MAX)) + '] Full cycles [' + TRY_CAST(@fullCycles AS VARCHAR(MAX)) + '].'
	END
	ELSE
		PRINT 'CommServe LiveSync Subclient Retention override is currently disabled.'
	GOTO PROC_EXIT
END
IF @i_operation = 'disable'
	SET @DisableRetentionOverride = 1
ELSE IF @i_operation <> 'enable'
BEGIN
	SET @l_errorMessage = N'Invalid argument. Expecting enable/disable/status.'
	SET @l_errorNumber = 2
	GOTO PROC_ERROR
END
IF (@LogShippingSubclientId > 0)
BEGIN
	IF @DisableRetentionOverride = 1
	BEGIN
		DELETE FROM APP_SubClientProp
		WHERE attrName = 'Override storage policy copy retention'
		AND componentNameId = @LogShippingSubclientId
		AND modified = 0
		AND cs_attrname = CHECKSUM(N'Override storage policy copy retention')
		DELETE FROM archAppCopyAgingRule
		WHERE appId = @LogShippingSubclientId
		PRINT 'Successfully disabled CommServe LiveSync Subclient Retention override.'
	END
	ELSE
	BEGIN
		DECLARE @retentionXml XML = '<App_RetentionOverrideSettings>
			<copySettings retentionDays="14" fullCycles="2">
				<copy copyId="0"/>
			</copySettings>
		</App_RetentionOverrideSettings>'
		IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp(NOLOCK)
					WHERE attrName = 'Override storage policy copy retention'
					AND componentNameId = @LogShippingSubclientId
					AND modified = 0
					AND cs_attrname = CHECKSUM(N'Override storage policy copy retention')
					) --CV_PROP_OVERRIDE_COPY_RETENTION_TYPE
			INSERT INTO APP_SubClientProp
			VALUES (@LogShippingSubclientId, 'Override storage policy copy retention', 7, 2, @nowTime, 0, 0)
		DECLARE @tempTableOutputOverrideCopySettings TABLE(Response XML,ErrorCode INT, ErrorMessage NVARCHAR(1024) )
		INSERT INTO @tempTableOutputOverrideCopySettings
		EXEC OverrideCopySettingsFromSC @LogShippingSubclientId,@retentionXml, 1
		SELECT @l_errorNumber = ErrorCode, @l_errorMessage = ErrorMessage FROM @tempTableOutputOverrideCopySettings
		IF @l_errorNumber <> 0
			GOTO PROC_ERROR
		PRINT 'Successfully enabled CommServe LiveSync Subclient Retention override. Retention days [14] Full cycles [2].'
	END
END
GOTO PROC_EXIT
PROC_ERROR:
if @l_errorNumber <> 0
	Raiserror(@l_errorMessage,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State)
			)
PROC_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CSLiveSyncRetentionOverride')
	delete from GxQscripts where name = 'QS_CSLiveSyncRetentionOverride'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CSLiveSyncRetentionOverride')
	delete from GXDBVersions where aliasname = 'QS_CSLiveSyncRetentionOverride'
GO

insert into GXDBVersions values(2, 'QS_CSLiveSyncRetentionOverride',  '00000000000000000000', 'QS_CSLiveSyncRetentionOverride', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CSLiveSyncRetentionOverride',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn CSLiveSyncRetentionOverride -si <disable/enable/status>'
 + CHAR(10) + '-- 		Example: qoperation execscript -sn CSLiveSyncRetentionOverride -si ''disable'''
 + CHAR(10) + '-- 		Example: qoperation execscript -sn CSLiveSyncRetentionOverride -si ''enable'''
 + CHAR(10) + '-- 		Example: qoperation execscript -sn CSLiveSyncRetentionOverride -si ''status'''
)
GO

