

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_BulkInsertSubClientPolicyContent.sp] ---------- 

-------------------------------------------
--         Name:   QS_BulkInsertSubClientPolicyContent.sql
--         Date:   25-Jul-2011
--       Author:   SKatz
--  Description:   Do Bulk insert from text file to specified SubClient Policy subClient
--
-- TR(original):   None
--     Customer:   Cargill
--   CommcellId:   N/A (generic)
-------------------------------------------
-- TODO:  ADD OVERWRITE (VS UPDATE), NO WAIT FOR JOB RUNNING JOBS TO COMPLETE OPTIONS (hidden)
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_BulkInsertSubClientPolicyContent <<<'

IF EXISTS (select * from sysobjects where name='QS_BulkInsertSubClientPolicyContent')
	drop procedure QS_BulkInsertSubClientPolicyContent
IF EXISTS (select * from GxQscripts where name='QS_BulkInsertSubClientPolicyContent')
	delete from GxQscripts where name = 'QS_BulkInsertSubClientPolicyContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BulkInsertSubClientPolicyContent')
	delete from GXDBVersions where aliasname = 'QS_BulkInsertSubClientPolicyContent'
GO
print '... Creating Procedure: QS_BulkInsertSubClientPolicyContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_BulkInsertSubClientPolicyContent
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  3 Corresponds to "medium", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @SUBCLIENTPOLICY_NAME varchar(1024) = '',
  @SUBCLIENT_NAME varchar(1024) = '',
  @INPUTFILE_NAME varchar(1024) = '',
  @OPTIONS varchar(256) = ''
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'QS_BulkInsertSubClientPolicyContent'
DECLARE @created				AS integer		= 0
DECLARE @nowTime				AS integer		= dbo.GetUnixTime (GetUTCdate())
DECLARE @0x0080	AS integer		= 	128  		--Subclient Policy backupset
DECLARE @SEPERATOR				AS char(1)		= CHAR(18)
DECLARE @QUOTE					AS char(1)		= CHAR(39)
DECLARE @SCP_IDATYPE_PROP		AS nvarchar(256)= N'Associated subclient Policy Ida Type'
--
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--
--
-------- Local Variables    -------------
DECLARE @sqlString				nvarchar(1024)
--
DECLARE @subClientPolicyId		integer
DECLARE @appTypeId				integer
DECLARE @subClientId			integer
DECLARE @idaTypeVal				nvarchar(256)
DECLARE @userId					AS	integer = 1			-- Until we find a way to fetch from Qcommand!
DECLARE @isCaseSensitive		AS	integer	= 0
DECLARE	@isOverWriteContent		AS	integer = 0
DECLARE @isIgnoreJobsRunning	AS 	integer = 0
--
--
DECLARE @localErrorMsg			AS	varchar(512)	='Error Encountered when running script.'
DECLARE @lastError				AS	integer = 0							-- Be optimistic
--
--
--------- FOR USE BY CURSOR  ---------------------
DECLARE @thisType			INT
DECLARE @thisContent			varchar(max)
--
--
---------------------------------------------------
--- FOR GUI AUDIT TRAIL						-------
---------------------------------------------------
	DECLARE @opMsgId INTEGER
--
	DECLARE @opEvMsgId			INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId			INTEGER
	DECLARE @paramData 			NVARCHAR(MAX)
	DECLARE @dataIsEvent		INTEGER
	DECLARE @OLDCONTENT 			NVARCHAR(MAX)			-- For Audit Trail
	DECLARE @NEWCONTENT				NVARCHAR(MAX)			-- "     "     "     "
---------------------------------------------------
DECLARE @INSERT_CONTENT_RESULTS table (			-- THIS TABLE WILL BE USED TO CAPTURE THE RESULT SETS FROM
	errorCode 			integer,				-- APPINSERTSUBCLIENTCONTENT
	hasChanged			integer,
	errorString			varchar(1024)
)
--
IF object_id('tempdb.dbo.#rawInputData') is not null
	DROP TABLE #rawInputData
--
CREATE TABLE #rawInputData
(
  type 		varchar(1024),
  fileName	varchar(1024)
)
--
DECLARE @rawInputData TABLE
(
  type 		INT,
  fileName	varchar(1024)
)
--
DECLARE @filterMapTable TABLE
(
  type 		INT,
  typeName	varchar(1024)
)
--DECLARE @jobIdTbl table( jobId integer );
--
INSERT INTO @filterMapTable VALUES(0, 'NONE')				--CV_NO_FILTER
INSERT INTO @filterMapTable VALUES(1, 'CONTENT')			--CV_CONTENT
INSERT INTO @filterMapTable VALUES(2, 'EXCEPT')				--CV_YESDIRS_BACKUP_FILTERS
INSERT INTO @filterMapTable VALUES(3, 'EXCLUDE')			--CV_NODIRS_BACKUP_FILTERS
INSERT INTO @filterMapTable VALUES(4, 'YESFILES')			--CV_YESFILES_BACKUP_FILTERS
INSERT INTO @filterMapTable VALUES(5, 'NOFILES')			--CV_NOFILES_BACKUP_FILTERS
INSERT INTO @filterMapTable VALUES(6, 'DIRECTORIES')		--CV_DIRNAMES_BACKUP_FILTERS
INSERT INTO @filterMapTable VALUES(7, 'XCHANGE_DB')			--CV_XDB_FILTERS
INSERT INTO @filterMapTable VALUES(8, 'XCHANGE_MAIL')		--CV_XMB_FILTERS
INSERT INTO @filterMapTable VALUES(9, 'LN_PROFILES')		--CV_LNDOC_PROFILES
INSERT INTO @filterMapTable VALUES(10, 'LN_VIEWS')			--CV_LNDOC_VIEWS
INSERT INTO @filterMapTable VALUES(11, 'ARCHIVE_INCLUDE')	--CV_DM_INC_ATTCHMNTS_FILTER
INSERT INTO @filterMapTable VALUES(12, 'ARCHIVE_EXCLUDE')	--CV_DM_EXC_ATTCHMNTS_FILTER
INSERT INTO @filterMapTable VALUES(13, 'GLOBAL')			--CV_GLOBAL_FILTER
INSERT INTO @filterMapTable VALUES(14, 'SYBASE_SERVER')		--CV_SYBASE_BACKUP_SERVER
INSERT INTO @filterMapTable VALUES(15, 'SYMBOLIC_LINK')		--CV_SYMBOLIC_LINK
INSERT INTO @filterMapTable VALUES(16, 'DOCUMENTUM_FTI')	--CV_DOCUMENTUM_FTI_FILTER
INSERT INTO @filterMapTable VALUES(17, 'DOCUMENTUM_SA')		--CV_DOCUMENTUM_SA_FILTER
--
------------------------------------------------------------
--- CHECK IF MINIMUM (& VALID!) PARAMETERS SPECIFIED	 ---
------------------------------------------------------------
SET @subClientPolicyId = ISNULL((Select id from app_backupsetName where name = @SUBCLIENTPOLICY_NAME AND (status & 0x0080) <> 0), 0)
IF (@subClientPolicyId = 0)
BEGIN
	SET @localErrorMsg	='Error. [' + @SUBCLIENTPOLICY_NAME + '] is not a valid Subclient Policy.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--
--
SET @subClientId = ISNULL((Select id from app_Application where subclientName = @SUBCLIENT_NAME AND backupset = @subClientPolicyId), 0)
IF (@subClientId = 0)
BEGIN
	SET @localErrorMsg	='Error. [' +@SUBCLIENT_NAME + '] is not a valid Subclient or not part of SubClientPolicy [' + @SUBCLIENTPOLICY_NAME + '].'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET	@appTypeId		 = ISNULL((Select apptypeId from app_application where id = @subClientId), 0)
SET @idaTypeVal		 = ISNULL((Select attrVal from app_BackupsetProp Where ComponentNameId = @subClientId And attrName=@SCP_IDATYPE_PROP and modified = 0), N'0')
IF @idaTypeVal = N'3'   --  OF Available SCP types (windows, unix, netware FS), only UNIX is case sensitive
	SET @isCaseSensitive = 1
--
--
IF @INPUTFILE_NAME = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. No Input file specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--
--	------------------------------------------------------------------
--  CHECK FOR OPTIONS.  THIS IS A SIMPLE MODEL FOR PASSING MULTIPLE
--  OPTIONS USING A SINGLE PARAMETER
--
IF @OPTIONS like '%overWrite%'
	SET @isOverWriteContent = 1
--
IF @OPTIONS like '%skipjobcheck%'
	SET @isIgnoreJobsRunning = 1
--
--	-------------------------------------------------------------------
BEGIN TRY
	BEGIN TRAN
--	------------------------------
--	  CHECK FOR RUNNING JOBS:	--
--	------------------------------
--	if @isIgnoreJobsRunning = 0
--	BEGIN
--		INSERT INTO @jobIdTbl
--			SELECT jobId FROM JMRstJobInfo
--				WHERE bkpSetID IN (Select componentNAmeId from APP_backupsetProp where attrName = N'Associated subclient Policy' and attrVal = @subClientPolicyId AND modified = 0)
--		  UNION
--			SELECT jobId FROM JMBkpJobInfo
--				WHERE applicationId IN (Select componentNAmeId from APP_subClientProp where attrName = N'Associated subclient Policy'and attrVal = @subClientPolicyId  and modified = 0)
--		IF EXISTS( SELECT jobId FROM @jobIdTbl)
--			BEGIN						-- SINCE NO GUI AUDIT TRAIL OCCURS WHEN THIS HAPPENS THROGH JAVA GUI
--				SET @lastError= -2		-- .. WE ARE NOT OBLIGED TO AUDIT IT THRU THIS QSCRIPT EITHER
--				SET @localErrorMsg = N'Unable to modify content. Jobs are still in progress.'
--				GOTO PROCESS_ERROR
--			END
--	END
--	--------------------------------------------------
--	GUI AUDIT TRAIL: Need "OLD" CONTENT FOR REPORT	--
--	--------------------------------------------------
	SET @OldContent = (
	SELECT STUFF((
		SELECT ' '+ filename+ ';'
		FROM dbo.APP_ScFilterFile
		where componentNameId = @subClientId and modified = 0 and type = 1 --CV_CONTENT
		order by fileName
		FOR XML PATH('')
		), 1, 1, ''
	  ) As concatenated_string)
	  SET @OldContent=SUBSTRING(@OldContent, 0, LEN(@OldContent))        -- Lob off the trailing ';'
--	--------------------------------------------------
--
--
--	------------------------------------------
--	FETCH THE CONTENT FROM THE INPUT FILE	--
--	------------------------------------------
--	SET @sqlString = 'BULK Insert #rawInputData from ' +@QUOTE  +  @INPUTFILE_NAME  +@QUOTE
	SET @sqlString = 'BULK Insert #rawInputData from ' +@QUOTE  +  @INPUTFILE_NAME  +@QUOTE + 'WITH ( FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'')'
	exec sp_executeSql @sqlString
--
	INSERT @rawInputData
	SELECT FM.type, ID.fileName FROM #rawInputData ID
	JOIN @filterMapTable FM ON FM.typeName = ID.type
	UNION
	SELECT CAST(type AS INT), fileName FROM #rawInputData
	WHERE ISNUMERIC(type) = 1
--
	IF @isOverWriteContent <> 0
		UPDATE APP_SCfilterFile SET Modified = @nowTime
		WHERE componentNameId = @subClientId AND modified = 0
		AND type IN (SELECT type FROM @rawInputData)
--
--
--	----------------------------------------------------------------------------------------------
--	ITERATE THROUGH ALL THE CONTENT, USING THE STORED PROCEDURE, "APPInsertSubClientContent" To	--
--	PERFORM THE ACTUAL UPDATE ... THIS DOES "DUPLICATE" CHECKS AS WELL AS BEING CCP	Compliant	--
--	----------------------------------------------------------------------------------------------
--	Make sure cursor was closed by previous caller:
	IF ( CURSOR_STATUS('global', 'ContentCursor') >= 0   OR CURSOR_STATUS('local', 'ContentCursor') >= 0 )
		CLOSE ContentCursor
	IF ( CURSOR_STATUS('global','ContentCursor') = -1     OR CURSOR_STATUS('local','ContentCursor') = -1 )
		DEALLOCATE ContentCursor
--
	DECLARE ContentCursor CURSOR STATIC FOR
			SELECT [type], [fileName]
			from @rawInputData
--
	OPEN ContentCursor
	FETCH NEXT FROM ContentCursor INTO @thisType, @thisContent
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @thisContent='' OR @thisContent IS NULL
			goto NEXT_ROW
		DELETE @INSERT_CONTENT_RESULTS
		INSERT @INSERT_CONTENT_RESULTS
			EXEC APPInsertSubClientContent @subClientId, @isCaseSensitive, @thisType, @thisContent, @nowTime, 1
			SET @lastError		= ISNULL((Select top 1 errorCode from @INSERT_CONTENT_RESULTS), 0)
			SET @localErrorMsg	= ISNULL((Select top 1 errorString from @INSERT_CONTENT_RESULTS), 0)
			IF @lastError <> 0
			BEGIN
				CLOSE ContentCursor
				DEALLOCATE ContentCursor
				GOTO PROCESS_ERROR
			END
NEXT_ROW:
		FETCH NEXT FROM ContentCursor INTO @thisType, @thisContent
	END
	CLOSE ContentCursor
	DEALLOCATE ContentCursor
--
--	----------------------------------
--	IF WE GOT HERE, ALL WENT WELL	--
--	----------------------------------
	SET @NewContent = (							-- FOR GUI AUDIT TRAIL (MIMIC C++ Audit Message)
	SELECT STUFF((
		SELECT ' '+ filename+ ';'
		FROM dbo.APP_ScFilterFile
		where componentNameId = @subClientId and modified = 0 and type = 1 --CV_CONTENT
		order by fileName
		FOR XML PATH('')
		), 1, 1, ''
	  ) As concatenated_string)
	  SET @NewContent=SUBSTRING(@NewContent, 0, LEN(@NewContent))        -- Lob off the trailing ';'
--	---------------------------------------------------
--	DO GUI AUDIT TRAIL FOR SUBCLIENT CONTENT CHANGE  --
--	---------------------------------------------------
SET @opMsgId = (277 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @dataIsEvent = 0
--
SET @paramMsgId  = (202 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_client where id = 2), 'No Client Name')  --- FOR SCP, use client == commcell
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
SET @paramMsgId  = (206 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_idaType where type = @appTypeId), 'No Ida Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
SET @paramMsgId  = (208 | (CAST(POWER(2, 24) AS BIGINT) * 85))		--'GUIAUDIT_PARAMS_BACKUP_SET'
			SET @paramData   = ISNULL((Select name from app_backupsetName where id = @subClientPolicyId), 'No Backupset Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
SET @paramMsgId  = (211 | (CAST(POWER(2, 24) AS BIGINT) * 85))			--'GUIAUDIT_PARAMS_SUBCLIENT_NAME'
			SET @paramData   = ISNULL((Select subClientName from app_application where id = @subClientId), 'No Subclient Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
SET @paramMsgId  = (232 | (CAST(POWER(2, 24) AS BIGINT) * 85))		-- 'GUIAUDIT_PARAMS_SUBCLIENT_PROPERTY_CHANGE'
			SET @paramData   = 'Run from QCommand.'
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			--
			IF @isOverWriteContent <> 0
			BEGIN
				SET @paramData   = 'OverWrite option specified.  Previous content deleted prior to new content added.'
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			END
			IF	@isIgnoreJobsRunning <> 0
			BEGIN
				SET @paramData   = 'Running jobs check skipped by user request.'
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			END
SET @paramMsgId  = (776 | (CAST(POWER(2, 24) AS BIGINT) * 83))
			EXEC EvGuiAuditSetParamData @opId, @oldContent, @dataIsEvent
/*
--			POSSIBLE REPLACEMENT IF WE WANT TO CHECK IF CONTENT ACTUALLY CHANGED (TESTED)
			IF @OLDCONTENT = @NEWCONTENT OR @isOverWriteContent = 0
				EXEC EvGuiAuditSetParamData @opId, 'No Change', @dataIsEvent
			ELSE
				EXEC EvGuiAuditSetParamData @opId, @newContent, @dataIsEvent
*/
			EXEC EvGuiAuditSetParamData @opId, @newContent, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
--
END TRY
--
--
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END   CATCH
PROCESS_ERROR:
IF @lastError  = 0
	COMMIT  Tran
--	COMMIT TRAN
ELSE
	ROLLBACK Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: subClientPolicy = ['
         + @SUBCLIENTPOLICY_NAME
         + '], subClient = ['
         + @SUBCLIENT_NAME
         + '], Input File = ['
         + @INPUTFILE_NAME
        + '], Options = ['
         + @Options
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
IF object_id('tempdb.dbo.#rawInputData') is not null
	DROP TABLE #rawInputData
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_BulkInsertSubClientPolicyContent')
	delete from GxQscripts where name = 'QS_BulkInsertSubClientPolicyContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BulkInsertSubClientPolicyContent')
	delete from GXDBVersions where aliasname = 'QS_BulkInsertSubClientPolicyContent'
GO

insert into GXDBVersions values(2, 'QS_BulkInsertSubClientPolicyContent',  '00000000000000000000', 'QS_BulkInsertSubClientPolicyContent', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_BulkInsertSubClientPolicyContent',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn BulkInsertSubClientPolicyContent -si ''SubClientPolicyName'' -si ''subClient''  -si ''Input file'' [-si ''overwrite'']'
 + CHAR(10) + '--       Add content to a subclient Policy subclient'
 + CHAR(10) + '		Input file format:
'
 + CHAR(10) + '		<content type>, <content>
'
 + CHAR(10) + '		<content type>, <content>
'
 + CHAR(10) + '		<content type>, <content>
'
 + CHAR(10) + '	
'
 + CHAR(10) + '		Content type:
'
 + CHAR(10) + '		CONTENT		(subclient content)
'
 + CHAR(10) + '		EXCLUDE		(exclude filter)
'
 + CHAR(10) + '		EXCEPT		(do not exclude filter)
'
 + CHAR(10) + '	
'
 + CHAR(10) + '		Sample:
'
 + CHAR(10) + '		CONTENT, C:\MyFiles
'
 + CHAR(10) + '		CONTENT, C:\MyContent
'
)
GO

