

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_BackupStrikes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_BackupStrikes.sp,v $ $Id: QS_BackupStrikes.sp,v 1.4.64.3 2020/10/26 06:38:02 junlu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_BackupStrikes')
BEGIN
	print '>>> Drop Stored Procedure: QS_BackupStrikes <<<'
	drop procedure QS_BackupStrikes
END
IF EXISTS (select * from GxQscripts where name='QS_BackupStrikes')
	delete from GxQscripts where name = 'QS_BackupStrikes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BackupStrikes')
	delete from GXDBVersions where aliasname = 'QS_BackupStrikes'
GO
print '... Creating Procedure: QS_BackupStrikes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_BackupStrikes
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @BackupWindowFrom VARCHAR(32) = '18:00',
  @CountSynthFull INTEGER = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @csName	VARCHAR(256)
SELECT	@csName = aliasName FROM APP_CommCell WHERE id = 2
DECLARE @csTimeZone NVARCHAR(1024) = ''
SELECT	@csTimeZone = dbo.GetClientTimeZone(2)
IF ISNULL(@csTimeZone, '') = ''
BEGIN
	SELECT	@csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
	SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
	WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
END
DECLARE @dtCurrWindowBegin DATETIME= DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), @BackupWindowFrom)
IF		@dtCurrWindowBegin < GETDATE()
	SET	@dtCurrWindowBegin = DATEADD(DAY, 1, @dtCurrWindowBegin)
SET		@dtCurrWindowBegin = dbo.ClientLocalToUTCTime(@dtCurrWindowBegin, 2)
DECLARE @CurrWindowEnd INT = dbo.GetUnixTime(DATEADD(DAY, 1, @dtCurrWindowBegin))
DECLARE @hms INT = DATEPART(HOUR, @dtCurrWindowBegin)*3600 +  DATEPART(MINUTE, @dtCurrWindowBegin)*60 + DATEPART(SECOND, @dtCurrWindowBegin)
-- CV_COMPONENT_COMMCELL_EXCLUDE_CMDLINE_FROM_SLA 3308
DECLARE @ExcludeCmdlineSubclients INT = 0
SELECT	@ExcludeCmdlineSubclients = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3308 AND modified = 0
DECLARE @ExcludedAppIds TABLE (appId INT)
INSERT INTO @ExcludedAppIds
SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName IN ('DDB Backup', 'Index SubClient', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
UNION
SELECT id FROM APP_Application WITH (NOLOCK)
WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)
   OR clientId IN (SELECT id FROM APP_Client WITH (NOLOCK) WHERE (status & (4096|268435456)) <> 0)
   OR (@ExcludeCmdlineSubclients > 0 AND subclientStatus & (64|4096) > 0)
-- Allow successful incremental/differential jobs clear full strikes
DECLARE @IncrClearFullStrike INT = 0
DECLARE @csReleaseId int
SELECT	@csReleaseId = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = 2
IF @csReleaseId >= 16
BEGIN
	SELECT	@IncrClearFullStrike = longVal
	FROM	APP_ComponentProp WITH (NOLOCK)
	WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3317 AND modified = 0
END
CREATE TABLE #TblStrikes (
		vmClientId INT, appId INT, strikeType INT, lastSuccJobId INT, nFailedJobs INT, failedSince DATETIME, failedDays INT,
		lastJobId INT, lastJobBkpLvl INT, lastJobStart INT, lastJobEnd INT, lastJobStatus INT, failureReason VARCHAR(256),lastSJobStart INT,lastSJobEnd INT)
CREATE TABLE #TblLastFailedJob (entityId INT, fullJobId INT, incrJobId INT)
CREATE TABLE #TblIndexingV2VMs (vmClientId INT, vmAppId INT)
IF OBJECT_ID('APP_VMBackupset', 'U') IS NOT NULL
	EXEC sp_executesql N'INSERT INTO #TblIndexingV2VMs SELECT S.VMClientId, A.id FROM APP_VMBackupset S WITH(NOLOCK) INNER JOIN APP_Application A WITH(NOLOCK) ON S.VMClientId = A.clientId AND S.ChildBackupSetId = A.backupset AND A.subclientStatus&8 > 0'
-- For IndexingV2 VMs
INSERT	INTO #TblLastFailedJob
SELECT	appId, MAX(CASE WHEN bkpLevel IN (1, 1024, 32768) THEN jobId ELSE 0 END), MAX(CASE WHEN bkpLevel IN (1, 1024, 32768) THEN 0 ELSE jobId END)
FROM	JMBkpStats B WITH (NOLOCK)
		INNER JOIN #TblIndexingV2VMs VM ON B.appId = VM.vmAppId
WHERE	(bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND status NOT IN (1, 3, 14) AND (status <> 9 OR failureErrorCode = 8)
	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND commCellId = 2
GROUP BY appId
INSERT	INTO #TblLastFailedJob
SELECT	appId, MAX(CASE WHEN bkpLevel IN (1, 1024, 32768) THEN jobId ELSE 0 END), MAX(CASE WHEN bkpLevel IN (1, 1024, 32768) THEN 0 ELSE jobId END)
FROM	JMBkpStats WITH (NOLOCK)
WHERE	(bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND status NOT IN (1, 14) AND (status <> 9 OR failureErrorCode = 8)
	AND (status <> 3 OR appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND commCellId = 2
	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700 AND appType <> 106
GROUP BY appId
INSERT	INTO #TblStrikes
SELECT	0, F.entityId, 1, MAX(ISNULL(J.jobId, 0)), 0, NULL, 0, F.fullJobId, 0, 0, 0, 0, NULL,NULL,NULL
FROM	#TblLastFailedJob F
		INNER JOIN APP_Application A WITH (NOLOCK) ON F.entityId = A.id
		LEFT OUTER JOIN JMBkpStats J WITH (NOLOCK) ON J.appId = F.entityId
	AND (bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND (bkpLevel IN (1, 1024, 32768, 64, 128, 16384) OR @IncrClearFullStrike = 1)
	AND (status IN (1, 14) OR status = 3 AND appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND commCellId = 2
GROUP BY F.entityId, F.fullJobId
HAVING	MAX(ISNULL(J.jobId, 0)) < F.fullJobId
INSERT	INTO #TblStrikes
SELECT	0, F.entityId, 2, MAX(ISNULL(J.jobId, 0)), 0, NULL, 0, F.incrJobId, 0, 0, 0, 0, NULL,NULL,NULL
FROM	#TblLastFailedJob F
		INNER JOIN APP_Application A WITH (NOLOCK) ON F.entityId = A.id
		LEFT OUTER JOIN JMBkpStats J WITH (NOLOCK) ON J.appId = F.entityId
	AND	(bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND (status IN (1, 14) OR status = 3 AND appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND commCellId = 2
GROUP BY F.entityId, F.incrJobId
HAVING	MAX(ISNULL(J.jobId, 0)) < F.incrJobId
-- For IndexingV2 VMs
UPDATE	S SET vmClientId = VM.vmClientId
FROM	#TblStrikes S
		INNER JOIN #TblIndexingV2VMs VM ON S.appId = VM.vmAppId
DELETE	#TblLastFailedJob
CREATE TABLE #TblFailedJobStats (entityId INT, strikeType INT, nFailedJobs INT, failedSince INT)
INSERT	INTO #TblFailedJobStats
SELECT	F.appId, F.strikeType, COUNT(J.jobId), MIN(J.servStartDate)
FROM	JMBkpStats J WITH (NOLOCK) INNER JOIN #TblStrikes F ON J.appId = F.appId
WHERE	(F.strikeType = 1 AND J.bkpLevel IN (1, 1024, 32768) OR F.strikeType = 2 AND J.bkpLevel NOT IN (1, 64, 128, 16384, 1024, 32768))
	AND J.status NOT IN (1, 14) AND (J.status <> 9 OR J.failureErrorCode = 8)
	AND (J.status <> 3 OR J.appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId = 2
	AND J.jobId > F.lastSuccJobId
GROUP BY F.appId, F.strikeType
UPDATE	#TblStrikes
SET		nFailedJobs = F.nFailedJobs, failedSince = dbo.UTCToLocalTime(dbo.GetDateTime(F.failedSince), @csTimeZone)
FROM	#TblStrikes A INNER JOIN #TblFailedJobStats F ON A.appId = F.entityId AND A.strikeType = F.strikeType
DELETE	#TblFailedJobStats
DELETE	#TblStrikes
FROM	#TblStrikes F INNER JOIN APP_Application A WITH (NOLOCK) ON F.appId = A.id
WHERE	A.appTypeId >= 600
	OR A.appTypeId IN (72, 84, 85, 107, 121, 122, 127)
	OR A.appTypeId IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) AND A.subclientStatus&8 > 0
	OR A.subclientStatus & (2|4|16|32) > 0
	OR A.dataArchGrpId <= 1 AND A.logArchGrpId <= 1
	OR A.id IN (SELECT appId FROM @ExcludedAppIds)
DELETE	S FROM #TblStrikes S
	INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
	INNER JOIN (
	SELECT	DISTINCT CGA.ClientId
	FROM	APP_ComponentProp CP WITH (NOLOCK)
			INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CGA.ClientGroupId = CP.componentId
	WHERE	CP.componentType = 8 AND CP.propertyTypeId = 3301 AND CP.longVal = 1 AND CP.modified = 0
	) C ON A.ClientId = C.ClientId
DELETE	S FROM #TblStrikes S
	INNER JOIN APP_SubClientProp SP WITH (NOLOCK) ON S.appId = SP.componentNameId AND SP.attrName = 'Exclude From SLA' AND SP.attrVal = '1' AND SP.modified = 0
DELETE	S FROM #TblStrikes S INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
	INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON A.clientId = CP.componentNameId AND CP.attrName = 'Exclude From SLA' AND CP.attrVal = '1' AND CP.modified = 0
DELETE	S FROM #TblStrikes S
	INNER JOIN JMJobAction J WITH (NOLOCK) ON S.appId = J.appId
WHERE	J.opType = 4 AND J.action = 1
DELETE	S FROM #TblStrikes S
	INNER JOIN (
		SELECT	componentNameId AS appId, CAST(attrVal AS INT) AS subclientPolicyAppId
		FROM	APP_SubClientProp
		WHERE	attrName = 'Associated subclient Policy' AND modified = 0
	) T ON S.appId = T.appId
		INNER JOIN JMJobAction J WITH (NOLOCK) ON T.subclientPolicyAppId = J.appId
WHERE	J.opType = 4 AND J.action = 1
-- instanceID column was added to JMJobAction table in V11 SP6
IF COL_LENGTH('JMJobAction', 'instanceID') IS NOT NULL
	EXEC sp_executesql N'DELETE S FROM #TblStrikes S INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id INNER JOIN JMJobAction J WITH (NOLOCK) ON J.opType = 4 AND J.action = 1 AND J.instanceID = A.instance AND J.instanceID > 1'
DELETE	S FROM #TblStrikes S INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
		INNER JOIN JMJobAction J WITH (NOLOCK) ON A.clientId = J.clientId
WHERE	J.opType = 4 AND J.action = 1 AND J.appType IN (A.AppTypeId, 0)
DELETE	S FROM #TblStrikes S INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
		INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON A.clientId = CGA.clientId
		INNER JOIN JMJobAction J WITH (NOLOCK) ON CGA.clientGroupId = J.clientGroupId
			AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
			AND J.opType = 4 AND J.action = 1
-- Strikes of VMs
INSERT	INTO #TblLastFailedJob
SELECT	V.clientId, MAX(CASE WHEN J.bkpLevel IN (1, 1024, 32768) THEN J.jobId ELSE 0 END), MAX(CASE WHEN J.bkpLevel IN (1, 1024, 32768) THEN 0 ELSE J.jobId END)
FROM	JMBkpStats J WITH (NOLOCK)
 		INNER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId AND V.status IN (1, 2, 4)
 		INNER JOIN APP_Client C WITH (NOLOCK) ON V.clientId = C.id
 		INNER JOIN APP_Application A ON J.appId = A.id AND (A.subclientStatus & (16|32|4|2) = 0)
 WHERE	J.appType = 106 AND J.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND (J.status <> 9 OR J.failureErrorCode = 8)
	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
GROUP BY V.clientId
-- Strikes of IndexingV2 VMs have been inserted into #TblStrikes table before
DELETE	F
FROM	#TblLastFailedJob F
		INNER JOIN #TblIndexingV2VMs VM ON F.entityId = VM.vmClientId
INSERT INTO #TblStrikes
SELECT	F.entityId, 0, 1, MAX(ISNULL(J.jobId, 0)), 0, NULL, 0, F.fullJobId, 0, 0, 0, 0, NULL,NULL,NULL
FROM	#TblLastFailedJob F
		INNER JOIN APP_Client C WITH (NOLOCK) ON F.entityId = C.id
		LEFT OUTER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON V.clientId = F.entityId AND V.status IN (0, 3)
		LEFT OUTER JOIN JMBkpStats J WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId
	AND	J.appType = 106 AND J.commCellId = 2
	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND (J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) OR @IncrClearFullStrike = 1)
	AND J.status IN (1,3 ,14) AND (J.status <> 9 OR J.failureErrorCode = 8)
	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
GROUP BY F.entityId, F.fullJobId
HAVING	MAX(ISNULL(J.jobId, 0)) < F.fullJobId
INSERT INTO #TblStrikes
SELECT	F.entityId, 0, 2, MAX(ISNULL(J.jobId, 0)), 0, NULL, 0, F.incrJobId, 0, 0, 0, 0, NULL,NULL,NULL
FROM	#TblLastFailedJob F
		INNER JOIN APP_Client C WITH (NOLOCK) ON F.entityId = C.id
		LEFT OUTER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON V.clientId = F.entityId AND V.status IN (0, 3)
		LEFT OUTER JOIN JMBkpStats J WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId
	AND	J.appType = 106 AND J.commCellId = 2
	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND J.status IN (1,3 ,14) AND (J.status <> 9 OR J.failureErrorCode = 8)
	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
GROUP BY F.entityId, F.incrJobId
HAVING	MAX(ISNULL(J.jobId, 0)) < F.incrJobId
DROP TABLE #TblLastFailedJob
INSERT	INTO #TblFailedJobStats
SELECT	F.VMClientId, F.strikeType, COUNT(J.jobId), MIN(J.servStartDate)
FROM	JMBkpStats J WITH (NOLOCK)
		INNER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId AND V.status IN (1, 2, 4)
		INNER JOIN #TblStrikes F ON V.clientId = F.VMClientId
		INNER JOIN APP_Application A ON J.appId = A.id AND (A.subclientStatus & (16|32|4|2) = 0)
WHERE	(F.strikeType = 1 AND J.bkpLevel IN (1, 1024, 32768) OR F.strikeType = 2 AND J.bkpLevel NOT IN (1, 64, 128, 16384, 1024, 32768))
	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND (J.status <> 9 OR J.failureErrorCode = 8)
	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId = 2
	AND J.jobId > F.lastSuccJobId
GROUP BY F.VMClientId, F.strikeType
HAVING COUNT(J.jobId) > 0
UPDATE	#TblStrikes
SET		nFailedJobs = F.nFailedJobs, failedSince = dbo.UTCToLocalTime(dbo.GetDateTime(F.failedSince), @csTimeZone)
FROM	#TblStrikes A INNER JOIN #TblFailedJobStats F ON A.VMClientId = F.entityId AND A.strikeType = F.strikeType
UPDATE	#TblStrikes SET failedDays = DATEDIFF(DAY, failedSince, @dtCurrWindowBegin) +
		CASE WHEN ( DATEPART(HOUR,   failedSince)*3600 +
					DATEPART(MINUTE, failedSince)*60 +
					DATEPART(SECOND, failedSince) ) > @hms
		THEN -1 ELSE 0 END
DROP TABLE #TblFailedJobStats
UPDATE	#TblStrikes
SET		appId = J.appId, lastJobBkpLvl = J.bkpLevel, lastJobStart = J.servStartDate, lastJobEnd = J.servEndDate, lastJobStatus = J.status, failureReason = J.failureReason
FROM	#TblStrikes S INNER JOIN JMBkpStats J WITH (NOLOCK) ON S.lastJobId = J.jobId AND J.commCellId = 2
UPDATE	#TblStrikes
SET		lastSJobStart = J.servStartDate, lastSJobEnd = J.servEndDate
FROM	#TblStrikes S INNER JOIN JMBkpStats J WITH (NOLOCK) ON S.lastSuccJobId = J.jobId AND J.commCellId = 2
AND J.commCellId = 2 and S.lastSuccJobId>0
-- Exclude old strikes
IF @csReleaseId >= 16
BEGIN
	DECLARE @noJobSince INT = -1
	DECLARE @maxDays INT = -1
	SELECT	@maxDays = longVal
	FROM	APP_ComponentProp WITH (NOLOCK)
	WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3302 AND modified = 0
	IF @maxDays > 0 AND @maxDays <= 9999
	BEGIN
		SET @noJobSince = dbo.GetUnixTime(DATEADD(DAY, -@maxDays, GETUTCDATE()))
		DELETE #TblStrikes WHERE lastJobStart < @noJobSince
	END
	DELETE	S FROM #TblStrikes S
		INNER JOIN (SELECT componentNameId, CAST(attrVal AS INT) AS beforeTime
			FROM APP_SubClientProp WITH (NOLOCK)
			WHERE attrName = 'Ignore Strikes Before' AND CAST(attrVal AS INT) > @noJobSince AND modified = 0
			) T ON S.appId = T.componentNameId AND S.lastJobStart < T.beforeTime
END
-- Exclude Deleted VMs
IF @csReleaseId >= 15
BEGIN
	DELETE	#TblStrikes
	FROM	(SELECT	DISTINCT componentNameId
			FROM	APP_ClientProp CP WITH (NOLOCK)
			WHERE	attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0) T
	WHERE	#TblStrikes.vmClientId = T.componentNameId
END
DELETE	S FROM #TblStrikes S
	INNER JOIN (
		SELECT	DISTINCT CGA.ClientId
		FROM	APP_ComponentProp CP WITH (NOLOCK)
				INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CGA.ClientGroupId = CP.componentId
		WHERE	CP.componentType = 8 AND CP.propertyTypeId = 3301 AND CP.longVal = 1 AND CP.modified = 0
		) C ON S.vmClientId = C.ClientId
DELETE	S FROM #TblStrikes S
	INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON S.vmClientId = CP.componentNameId AND CP.attrName = 'Exclude From SLA' AND CP.attrVal = '1' AND CP.modified = 0
-- Exclude VMs if the VSA subclient is deconfigured or disabled for backup or excluded from SLA
DELETE	#TblStrikes
FROM	#TblStrikes F INNER JOIN
		(SELECT	S.appId
		FROM	APP_Application A WITH (NOLOCK)
				INNER JOIN (SELECT DISTINCT appId FROM #TblStrikes WHERE VMClientId > 0) S ON A.id = S.appId AND A.appTypeId = 106
		WHERE	A.dataArchGrpId <= 1
			OR (A.subclientStatus & (2|4)) > 0
			OR EXISTS (SELECT * FROM JMJobAction WITH (NOLOCK) WHERE opType = 4 AND action = 1 AND (clientId = A.ClientId AND appType IN (A.AppTypeId, 0) OR appId = A.id))
			OR A.clientId IN (SELECT DISTINCT CGA.clientId FROM JMJobAction J WITH (NOLOCK) INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK)
					ON CGA.clientGroupId = J.clientGroupId
					AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
					AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.action = 1)
			OR A.id IN (SELECT componentNameId FROM APP_SubclientProp WITH (NOLOCK) WHERE attrName = 'Exclude From SLA' AND attrVal = '1' AND modified = 0)
		) T ON F.appId = T.appId AND F.vmClientId > 0
DELETE	#TblStrikes
FROM	#TblStrikes S
		INNER JOIN APP_Application A WITH (NOLOCK) ON A.clientId = S.vmClientId AND A.appTypeId <> 106
		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.appId = A.id AND B.servStartDate > S.lastJobStart
 		AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND B.commCellId = 2
CREATE TABLE #TblFailedJobIds (appId INT, strikeType INT, failedJobIds VARCHAR(64))
INSERT	INTO #TblFailedJobIds
SELECT	T.appId, T.strikeType, CAST(T.jobId AS VARCHAR(20))
FROM	(
	SELECT	S.appId, S.strikeType, J.jobId, ROW_NUMBER() OVER (PARTITION BY S.appId, S.strikeType ORDER BY J.jobId DESC) AS rowId
	FROM	JMBkpStats J
			INNER JOIN #TblStrikes S ON J.appId = S.appId
	WHERE	nFailedJobs >= 3
		AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
		AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 2 END) = S.strikeType
		AND J.status NOT IN (1, 14) AND (J.status <> 9 OR J.failureErrorCode = 8)
		AND (J.status <> 3 OR J.appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
		AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId = 2
		AND J.jobId <= S.lastJobId) T
WHERE	rowId <= 3
ORDER BY rowId
INSERT	INTO #TblFailedJobIds
SELECT	T.appId, T.strikeType, CAST(T.jobId AS VARCHAR(20))
FROM	(
	SELECT	S.appId, S.strikeType, J.jobId, ROW_NUMBER() OVER (PARTITION BY S.appId, S.strikeType ORDER BY J.jobId DESC) AS rowId
	FROM	JMBkpStats J
			INNER JOIN #TblStrikes S ON J.appId = S.appId
	WHERE	nFailedJobs = 2
		AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
		AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 2 END) = S.strikeType
		AND J.status NOT IN (1, 14) AND (J.status <> 9 OR J.failureErrorCode = 8)
		AND (J.status <> 3 OR J.appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
		AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId = 2
		AND J.jobId <= S.lastJobId) T
WHERE	rowId <= 2
ORDER BY rowId
INSERT	INTO #TblFailedJobIds
SELECT	appId, strikeType, CAST(lastJobId AS VARCHAR(20))
FROM	#TblStrikes
WHERE	nFailedJobs = 1
CREATE TABLE #ClientGroupsString (clientId INT, clientGroups NVARCHAR(MAX))
INSERT  INTO #ClientGroupsString
SELECT  DISTINCT vmClientId, 0
FROM    #TblStrikes
WHERE	vmClientId > 0
UNION
SELECT  DISTINCT A.clientId, 0
FROM    #TblStrikes S
		INNER JOIN APP_Application A ON S.appId = A.id
WHERE	vmClientId = 0
EXEC GetClientGroupsString
CREATE TABLE #TblFailureMsgIds (jobId INT, messageId INT, JPR varchar(20), failureReasonTime INT)
INSERT INTO #TblFailureMsgIds
SELECT	M.jobId, M.messageId, DBO.GetJPRFromMsgId(M.messageId), MAX(M.failureReasonTime) AS maxFailureReasonTime
FROM	JMFailureReasonMsg M WITH (NOLOCK) INNER JOIN #TblStrikes S ON M.jobId = S.lastJobId AND M.commCellId = 2 AND S.vmClientId = 0
GROUP BY M.jobId, M.messageId
ORDER BY M.jobId, maxFailureReasonTime DESC
DECLARE @NewLine  CHAR(1) = CHAR(10)
DECLARE @NewLine2 CHAR(1) = CHAR(13)
DECLARE @BR       CHAR(4) = '<BR>'
SELECT	CASE WHEN F.FailedDays = 0 THEN 1 WHEN F.FailedDays > 3 THEN 3 ELSE F.FailedDays END AS StrikeCounts,
		@csName AS CommServer,
		ISNULL(CG.ClientGroups, '') AS ClientGroups,
		CASE WHEN F.vmClientId = 0 THEN CL.name ELSE (SELECT name FROM APP_Client WHERE id = F.vmClientId) END AS Client,
		IDA.name + CASE WHEN (A.appTypeId <> 106 OR ISNULL(A.id, 0) = 0) THEN ''
			ELSE ISNULL((SELECT ' in ' + name FROM APP_Client WITH (NOLOCK) WHERE id = A.clientId), '')
			END AS Agent,
		dbo.FixInstanceName(INS.name, A.appTypeId) + ' : ' + B.name + ' : ' + A.subclientName AS Subclient,
		CASE WHEN F.lastJobBkpLvl IN (1, 1024, 32768, 64, 128, 16384) THEN 'Full' ELSE 'NonFull' END AS BackupType,
		dbo.UTCToLocalStringTime(F.failedSince, @csTimeZone) AS FailedFrom,
		F.FailedDays AS FailedDays,
		F.lastJobId AS LastJobID,
		dbo.UTCToLocalStringTime(DATEADD(SS, F.lastJobStart, '1970-01-01'), @csTimeZone) AS LastJobStart,
		dbo.UTCToLocalStringTime(DATEADD(SS, F.lastJobEnd, '1970-01-01'), @csTimeZone) AS LastJobEnd,
		@csTimeZone AS TimeZone,
		dbo.GetJobStatusName(F.lastJobStatus) AS LastJobStatus,
		ISNULL((SELECT JPR + ' ; ' FROM #tblFailureMsgIds
				WHERE jobId = F.lastJobId FOR XML PATH('')), '') AS FailureMsgIds,
		CASE WHEN F.failureReason = '' THEN (Select V.attrVal FROM APP_VMProp V WHERE V.VMclientId = F.vmClientId AND F.lastJobId = V.jobId AND V.attrName = 'vmFailureReason')
			ELSE (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(LEFT(dbo.JMGetLocalizedMessageFunc(0, F.failureReason),1022),',',' '),@NewLine,';'),@NewLine2,';'),'''',' '),@BR,'')) END AS FailureReason
FROM	#TblStrikes F
		INNER JOIN APP_Application A ON A.id = F.appId
		LEFT OUTER JOIN #ClientGroupsString CG ON A.clientId = CG.ClientId
		INNER JOIN APP_Client CL ON CL.id = A.clientId
		INNER JOIN APP_iDAType IDA ON IDA.type = A.appTypeId
		INNER JOIN APP_InstanceName INS ON INS.id = A.instance
		INNER JOIN APP_BackupSetName B ON B.id = A.backupSet
ORDER BY StrikeCounts, ClientGroups, Client, Agent, Instance, Backupset, Subclient, BackupType
DROP TABLE #ClientGroupsString
DROP TABLE #TblFailedJobIds
DROP TABLE #TblIndexingV2VMs
DROP TABLE #tblFailureMsgIds
DROP TABLE #TblStrikes
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_BackupStrikes')
	delete from GxQscripts where name = 'QS_BackupStrikes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BackupStrikes')
	delete from GXDBVersions where aliasname = 'QS_BackupStrikes'
GO

insert into GXDBVersions values(2, 'QS_BackupStrikes',  '00010004006400030000', 'QS_BackupStrikes', '00010004006400030000')
GO

insert into GxQscripts values(2,'QS_BackupStrikes',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn QS_BackupStrikes [-si @BackupWindowFrom = ''20:00''] [-si @CountSynthFull = ''1'']'
 + CHAR(10) + '-- 	Default: @BackupWindowFrom = ''18:00'', @CountSynthFull = 0'
)
GO

