

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_BackendSubclientStorage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_BackendSubclientStorage.sp,v $ $Id: QS_BackendSubclientStorage.sp,v 1.4.192.2 2018/03/20 00:47:22 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_BackendSubclientStorage <<<'

IF EXISTS (select * from sysobjects where name='QS_BackendSubclientStorage')
	drop procedure QS_BackendSubclientStorage
IF EXISTS (select * from GxQscripts where name='QS_BackendSubclientStorage')
	delete from GxQscripts where name = 'QS_BackendSubclientStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BackendSubclientStorage')
	delete from GXDBVersions where aliasname = 'QS_BackendSubclientStorage'
GO
print '... Creating Procedure: QS_BackendSubclientStorage'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_BackendSubclientStorage
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @Frequency VARCHAR(1024)='Weekly',
  @NumberOfPoints INTEGER=4,
  @PredictionPoints INTEGER=1,
  @CostPerGB FLOAT=1,
  @AddlCostPerGB FLOAT=0,
  @ClientGroupName VARCHAR(1024)='',
  @BackupFrom VARCHAR(32) = '18:00',
  @IncludeCurrentPeriod INTEGER=0
AS
SET NOCOUNT ON
DECLARE @timeFrameType              INT =1 -- relative
DECLARE @freq                  INT  -- RelTimeFreq {Day = 1, Week = 2, Month = 3, Hour = 4, Year = 6}
IF ( @Frequency LIKE 'Weekly')
	SET @freq = 2
ELSE IF ( @Frequency LIKE 'Daily')
	SET @freq = 1
ELSE IF ( @Frequency LIKE 'Monthly')
	SET @freq = 3
ELSE IF ( @Frequency LIKE 'Yearly')
	SET @freq = 6
DECLARE @numberOfPeriods            INT = @NumberOfPoints
DECLARE @predictionSteps            INT = @PredictionPoints
DECLARE @reqStartTime				INT =0
DECLARE @reqEndTime					INT =0
DECLARE @treatWeekend				INT =1
DECLARE @totalCostPerGB				FLOAT = ( @CostPerGB + @AddlCostPerGB )
DECLARE @csName VARCHAR(256) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)
DECLARE @csTimeZone	VARCHAR(256)
SELECT	@csTimeZone	= timeZone FROM APP_CommCell WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PeriodsRaw')       IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Periods')          IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Periods
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__HistoryData')      IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__HistoryData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PredictedData')    IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PredictedData
DECLARE @const_AGG_JOBS_FULL		INT = 0x2000000
DECLARE @const_AGG_JOBS_INCR		INT = 0x4000000
DECLARE @const_AGG_JOBS_AUX			INT = 0x8000000
DECLARE @const_AGG_PROTECTEDDATA    INT = 0x0080000
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PeriodsRaw')       IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Periods')          IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Periods
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__HistoryData')      IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__HistoryData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PredictedData')    IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PredictedData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__HistoryData')      IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__HistoryData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Jobs')             IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Jobs
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__JobsAggDetails')   IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__JobsAggDetails
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__JobsList')			IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__JobsList
CREATE TABLE #GrowthAndTranding_tmp__PeriodsRaw
(
    commCellId              INT,
    dayNum                  INT,
    dayRefStart             DATETIME,
    dayRefEnd               DATETIME,
    dayStart                DATETIME,
    dayEnd                  DATETIME,
    predicted               INT,
    dayRefStartLocal        DATETIME,
    dayRefEndLocal          DATETIME,
    dayRefStartUnix         INT,
    dayRefEndUnix           INT,
    dayStartUnix            INT,
    dayEndUnix              INT,
    dayRefStartLocalUnix    INT,
    dayRefEndLocalUnix      INT
)
CREATE TABLE #GrowthAndTranding_tmp__Periods
(
    periodId            INT     IDENTITY(1,1)   NOT NULL,
    predicted           BIT                     NOT NULL,
    DayNo               INT                     NOT NULL,
    periodStart         INT                     NOT NULL,
    periodEnd           INT                     NOT NULL,
    periodStartDT       DATETIME                NOT NULL,
    periodEndDT         DATETIME                NOT NULL
)
CREATE TABLE #GrowthAndTranding_tmp__HistoryData
(
    periodId            INT,
    entityType          INT,
	doNotPlot			INT,
    value               BIGINT
)
CREATE TABLE #GrowthAndTranding_tmp__PredictedData
(
    entityType          INT,
    growthRate          FLOAT
)
CREATE TABLE #GrowthAndTranding_tmp__Jobs
(
	periodId			INT,
    commcellId          INT,
    clientId            INT,
    apptypeId           INT,
    instanceId          INT,
    backupsetId         INT,
    subclientId         INT,
    jobId               INT,
    opType              INT,
    backupLevel         INT,
    status              INT,
    jobType				INT,
    startDate           INT,
    endDate             INT,
    appSize				BIGINT,
    dataWritten			BIGINT,
    dataArchGroupId		INT,
    logArchGroupId		INT
)
CREATE INDEX tmp__Jobs_startEndDate_idx ON #GrowthAndTranding_tmp__Jobs
(
    startDate   ASC,
    endDate     ASC
)
CREATE TABLE #GrowthAndTranding_tmp__JobsList
(
    id                      INT IDENTITY(1,1),
	jobCategory			    INT,
    jobId                   INT,
    commCellId              INT,
    commCellName            NVARCHAR(1024),
    clientId                INT,
    clientName              NVARCHAR(1024),
    appTypeId               INT,
    appTypeName             NVARCHAR(1024),
    instanceId              INT,
    instanceName            NVARCHAR(1024),
    backupsetId             INT,
    backupsetName           NVARCHAR(1024),
    subclientId             INT,
    subclientName           NVARCHAR(1024),
    opType                  INT,
    startTime               INT,
    endTime                 INT,
    logicalSize             BIGINT,
    physicalSize            BIGINT
)
CREATE TABLE #GrowthAndTranding_tmp__JobsAggDetails
(
	jobTypeId				INT,
	predicted				INT,
	periodId				INT,
	entityId				INT,
	entityName				NVARCHAR(200),
	totalAppSize			BIGINT,
	totalDataWritten		BIGINT
)
EXEC dbo.wr_BuildDaysRange  2, '#GrowthAndTranding_tmp__PeriodsRaw', @timeFrameType, @numberOfPeriods, @freq, @reqStartTime, @reqEndTime, @treatWeekend, 0, 1, 10, @predictionSteps, @includeCurrentPeriod,@BackupFrom
-- -- get only the values we are going to work with
INSERT INTO #GrowthAndTranding_tmp__Periods (predicted, DayNo, periodStart, periodEnd, periodStartDT, periodEndDT)
    SELECT  predicted, dayNum, dayStartUnix, dayEndUnix, dayStart, dayEnd
    FROM    #GrowthAndTranding_tmp__PeriodsRaw
    ORDER   BY dayStart ASC
-- -- no need for #GrowthAndTranding_tmp__PeriodsRaw table any more. kill it
DROP TABLE #GrowthAndTranding_tmp__PeriodsRaw
DECLARE @periodMin      AS INT
DECLARE @periodMax      AS INT
DECLARE @periodMinDT    AS DATETIME
DECLARE @periodMaxDT    AS DATETIME
SELECT  @periodMin   = MIN(periodStart),   @periodMax   = MAX(periodEnd),
        @periodMinDT = MIN(periodStartDT), @periodMaxDT = MAX(periodEndDT)
FROM    #GrowthAndTranding_tmp__Periods
INSERT INTO #GrowthAndTranding_tmp__Jobs
		SELECT  (SELECT periodId FROM #GrowthAndTranding_tmp__Periods P WHERE B.servStartDate BETWEEN P.periodStart AND P.periodEnd),
				A.origCCId, A.clientId, A.appTypeId, A.instance, A.backupSet, A.id, B.jobId, B.opType,  B.bkpLevel,
				CASE B.displayStatus WHEN 0 THEN B.[status] ELSE B.displayStatus END,
				-- job type
				(CASE WHEN B.bkpLevel  in (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000)THEN @const_AGG_JOBS_FULL
																												 ELSE @const_AGG_JOBS_INCR
				 END),
				B.servStartDate, B.servEndDate,
				B.totalUncompBytes, 0, B.dataArchGrpId, B.logArchGrpId
		FROM    JMBkpStats B INNER JOIN APP_Application A ON A.id = B.appId
		WHERE       B.servStartDate BETWEEN @periodMin AND @periodMax
		AND ( @ClientGroupName = '' OR A.clientId IN ( SELECT clientId FROM ClientGroupsStringView WHERE ClientGroups LIKE '%'+@ClientGroupName+'%') )
		-- update sizes in the table
		UPDATE  #GrowthAndTranding_tmp__Jobs
		SET     dataWritten = ISNULL( (SELECT	MAX(T.sizeOnMedia)
									FROM	(SELECT	S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
											FROM	JMJobDataStats S WITH (READUNCOMMITTED)
												WHERE	#GrowthAndTranding_tmp__Jobs.jobId =S.jobid and S.AuxCopyJobId = 0
												GROUP BY S.archGrpCopyId) AS T) , 0)
		INSERT INTO #GrowthAndTranding_tmp__JobsAggDetails
		SELECT @const_AGG_PROTECTEDDATA, P.predicted, P.periodId, A.id, A.subclientName,0,0
		FROM #GrowthAndTranding_tmp__Periods P
		CROSS JOIN APP_Application A WHERE dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1
		IF ( @ClientGroupName <> '' )
		BEGIN
			DELETE #GrowthAndTranding_tmp__JobsAggDetails
				FROM #GrowthAndTranding_tmp__JobsAggDetails JAD
				INNER JOIN APP_Application A ON
				JAD.entityId = A.id
				INNER JOIN ClientGroupsStringView CGV ON
				CGV.ClientId = A.clientId
				AND CGV.ClientGroups NOT LIKE '%'+@ClientGroupName+'%'
		END
		UPDATE #GrowthAndTranding_tmp__JobsAggDetails
		SET totalAppSize = T.appSize	,
			totalDataWritten = T.dataWritten
		FROM (SELECT SUM(ISNULL(J.appSize, 0)) as appSize ,SUM(ISNULL(J.dataWritten, 0)) as dataWritten, J.periodId as periodId, J.subclientId
		FROM	#GrowthAndTranding_tmp__Periods P
				INNER JOIN #GrowthAndTranding_tmp__Jobs J ON J.periodId = P.periodId
				INNER JOIN APP_Application A ON J.subclientId = A.id
		WHERE	J.status IN (1, 3, 14)
		GROUP BY P.predicted, J.periodId, J.subclientId, A.subclientName
		)T INNER JOIN #GrowthAndTranding_tmp__JobsAggDetails JAD
		ON T.periodId = JAD.periodId
		AND T.subclientId = JAD.entityId
	DECLARE @currentPeriodId  INT = 2
	DECLARE @maxRealPeriodId INT = (SELECT MAX(periodId) FROM #GrowthAndTranding_tmp__Periods WHERE predicted = 0)
	DECLARE @currentEntityId INT = (SELECT MIN(entityId) FROM #GrowthAndTranding_tmp__JobsAggDetails )
	DECLARE @previous2 BIGINT = 0
	DECLARE @previous1 BIGINT = 0
	WHILE @currentEntityId IS NOT NULL BEGIN
		DECLARE @growthRate1 FLOAT = 0
		DECLARE @growthRate2 FLOAT = 0
		IF @maxRealPeriodId > 1 BEGIN
			SET @currentPeriodId = 2
			DECLARE @current1  BIGINT = 0
			SET @previous2  = 0
			SET @previous1  = 0
			DECLARE @current2  BIGINT = 0
			SELECT	@previous1 = totalAppSize,
					@previous2 = totalDataWritten
			FROM	#GrowthAndTranding_tmp__JobsAggDetails WHERE  entityId = @currentEntityId AND periodId = (@currentPeriodId - 1)
			SELECT	@current1 = totalAppSize,
					@current2 = totalDataWritten
			FROM	#GrowthAndTranding_tmp__JobsAggDetails WHERE  entityId = @currentEntityId AND periodId = (@currentPeriodId)
			WHILE (@current1 IS NOT NULL) AND (@current2 IS NOT NULL) BEGIN
				IF ( @current1 = 0 ) BEGIN
					SET @current1 = @previous1 +  @growthRate1/(@currentPeriodId-1)
				END
				IF ( @current2 = 0 ) BEGIN
					SET @current2 = @previous2 +  @growthRate2/(@currentPeriodId-1)
				END
				IF ( @current1 - @previous1 > 0)
					SET @growthRate1 =  @growthRate1 + CAST((@current1 - @previous1) AS FLOAT)
				IF ( @current2 - @previous2 > 0)
					SET @growthRate2 =  @growthRate2 + CAST((@current2 - @previous2) AS FLOAT)
				SET @currentPeriodId = @currentPeriodId + 1
				SET @previous1 = @current1
				SET @previous2 = @current2
				SET @current1 = NULL
				SET @current2 = NULL
				SELECT	@current1 = totalAppSize,
						@current2 = totalDataWritten
				FROM	#GrowthAndTranding_tmp__JobsAggDetails WHERE  entityId = @currentEntityId AND periodId = (@currentPeriodId)
				AND predicted =0
			END
			SET @growthRate1   = @growthRate1   / (@maxRealPeriodId - 1)
			SET @growthRate2   = @growthRate2   / (@maxRealPeriodId - 1)
		END
		ELSE BEGIN
			SELECT	@growthRate1 = totalAppSize,
					@growthRate2 = totalDataWritten
			FROM	#GrowthAndTranding_tmp__JobsAggDetails WHERE  entityId = @currentEntityId AND periodId = 1
		END
		IF ( @growthRate1 < 0 ) SET @growthRate1 =1
		IF ( @growthRate2 < 0 ) SET @growthRate2 =1
		UPDATE #GrowthAndTranding_tmp__JobsAggDetails
		SET		totalAppSize			  = (SELECT (@previous1 + (P.periodId - @maxRealPeriodId) * @growthRate1)),
				totalDataWritten          =	(SELECT (@previous2 + (P.periodId - @maxRealPeriodId) * @growthRate2))
		FROM    #GrowthAndTranding_tmp__JobsAggDetails JAG INNER JOIN #GrowthAndTranding_tmp__Periods P ON P.periodId = JAG.periodId
		WHERE		P.predicted = 1
				AND entityId  = @currentEntityId
		SELECT @currentEntityId = MIN(entityId) FROM #GrowthAndTranding_tmp__JobsAggDetails WHERE  entityId > @currentEntityId
	END
	SELECT 	@csName AS CommServer,
			CL.name as Client,
		    ISNULL(CG.ClientGroups,'') AS ClientGroups,
			INST.name + ' : ' + BSN.name + ' : ' + JAD.entityName AS Subclient,
            dbo.UTCToLocalStringTime(dbo.GetDateTime(P.periodStart), @csTimeZone) AS DateStart,
            dbo.UTCToLocalStringTime(dbo.GetDateTime(P.periodEnd), @csTimeZone) AS DateEnd,
			@csTimeZone AS TimeZone,
            P.predicted				   AS IsPredicted,
            CAST(ISNULL(JAD.totalAppSize,0)/1024.0/1024.0/1024.0 AS DECIMAL(20,2))   AS ApplicationSizeGB,
            CAST(ISNULL(JAD.totalDataWritten,0)/1024.0/1024.0/1024.0 AS DECIMAL(20,2)) AS MediaSizeGB,
            CAST((ISNULL(JAD.totalAppSize,0)/1024.0/1024.0/1024.0) * @totalCostPerGB AS DECIMAL(20,2)) AS TotalApplicationCost,
            CAST((ISNULL(JAD.totalDataWritten,0)/1024.0/1024.0/1024.0) * @totalCostPerGB AS DECIMAL(20,2)) AS TotalMediaCost
            FROM   #GrowthAndTranding_tmp__JobsAggDetails JAD
            INNER JOIN     #GrowthAndTranding_tmp__Periods P
            	ON P.periodId = JAD.periodId
            INNER JOIN APP_Application S ON S.id = JAD.entityId
			INNER JOIN APP_Client CL ON CL.id = S.ClientId
			INNER JOIN APP_iDAType IDA ON IDA.type = S.AppTypeId
			INNER JOIN APP_InstanceName INST ON INST.id = S.instance
			INNER JOIN APP_BackupsetName BSN ON BSN.id = S.backupSet
			LEFT OUTER JOIN ClientGroupsStringView CG ON S.clientId = CG.ClientId
		ORDER BY CL.name, Subclient, P.periodStart
GO

IF EXISTS (select * from GxQscripts where name = 'QS_BackendSubclientStorage')
	delete from GxQscripts where name = 'QS_BackendSubclientStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BackendSubclientStorage')
	delete from GXDBVersions where aliasname = 'QS_BackendSubclientStorage'
GO

insert into GXDBVersions values(2, 'QS_BackendSubclientStorage',  '00010004019200020000', 'QS_BackendSubclientStorage', '00010004019200020000')
GO

insert into GxQscripts values(2,'QS_BackendSubclientStorage',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '  qoperation execscript -sn QS_BackendSubclientStorage  [Frequency] [NumberOfPoints] [PredictionPoints]  [CostPerGB] [AddlCostPerGB] [ClientGroupName] [BackupFrom] [IncludeCurrentPeriod]
'
 + CHAR(10) + '
'
 + CHAR(10) + '  Example:
'
 + CHAR(10) + '
'
 + CHAR(10) + '  qoperation execscript -sn QS_BackendSubclientStorage -si @Frequency = ''Weekly'' -si @NumberOfPoints =''4'' -si @PredictionPoints=''2'' -si @ClientGroupName=''CG1'' [-si @BackupFrom = ''20:00'']
'
 + CHAR(10) + '
'
 + CHAR(10) + '
'
 + CHAR(10) + '  Input Parameters: 
'
 + CHAR(10) + '  --  Frequency			- Default is Weekly. Possible values Daily, Weekly, Monthly, Yearly.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  NumberOfPoints	- Default is 4. Number of Days/Weeks/Months/Years 
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  PredictionPoints  - Default is 1. Number of Prediction Days/Weeks/Months/Years
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  CostPerGB			- Default is 1. Cost per 1 GB of data.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  AddlCostPerGB		- Default is 0. Additional Cost Per 1 GB of data.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  ClientGroupName	- Client group Name. It is optional. Only clients beloging to this client group are returned.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  BackupFrom		- Start time for the Data protection activity windows , default is 6 PM
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  IncludeCurrentPeriod		- Default is 0. Include current activity window.
'
 + CHAR(10) + '
'
)
GO

