

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_BackendStorage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_BackendStorage.sp,v $ $Id: QS_BackendStorage.sp,v 1.6.34.11 2018/12/28 19:15:10 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_BackendStorage')
BEGIN
	print '>>> Drop Stored Procedure: QS_BackendStorage <<<'
	drop procedure QS_BackendStorage
END
IF EXISTS (select * from GxQscripts where name='QS_BackendStorage')
	delete from GxQscripts where name = 'QS_BackendStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BackendStorage')
	delete from GXDBVersions where aliasname = 'QS_BackendStorage'
GO
print '... Creating Procedure: QS_BackendStorage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_BackendStorage
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_fromTime VARCHAR(32) = '',
  @i_toTime VARCHAR(32) = '',
  @i_isAged int = 2,
  @i_backupType VARCHAR(32) = '',
  @i_orderBy VARCHAR(32) = '',
  @i_policyName varchar(144) = '',
  @i_copyName varchar(64)  = ''
AS
SET NOCOUNT ON
DECLARE	@CopyId			INT = 0
DECLARE	@TimeRangeBegin	INT = 0
DECLARE	@TimeRangeEnd	INT = 0
DECLARE	@BackupLevel	INT = 0
DECLARE	@OrderByCode	INT = 0
DECLARE @csTimeZone VARCHAR(256)
SELECT	@csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
DECLARE	@FromDateTime	DATETIME = @i_fromTime
DECLARE	@ToDateTime		DATETIME = @i_toTime
IF @i_fromTime <> ''
BEGIN
	SET	@FromDateTime	= dbo.ClientLocalToUTCTime(@FromDateTime, 2)
	SET	@TimeRangeBegin = dbo.GetUnixTime(@FromDateTime)
END
IF @i_toTime <> ''
BEGIN
	SET	@ToDateTime		= dbo.ClientLocalToUTCTime(@ToDateTime, 2)
	SET	@TimeRangeEnd	= dbo.GetUnixTime(@ToDateTime)
END
SET @BackupLevel = CASE WHEN @i_backupType = 'Full' THEN 1
						WHEN @i_backupType = 'Incr' THEN 2
						ELSE 0
					END
SET @OrderByCode = CASE WHEN @i_orderBy = 'Client' THEN 1
						WHEN @i_orderBy = 'Agent' THEN 2
						ELSE 0
					END
DECLARE @TblCopyIds TABLE (CopyId INT);
IF @i_copyName = '' AND @i_policyName = ''
	INSERT INTO @TblCopyIds
	SELECT	id
	FROM	archGroupCopy
	where	id > 0
ELSE
	INSERT INTO @TblCopyIds
	SELECT	AGC.id
	FROM	archGroup AG
				INNER JOIN archGroupCopy AGC
					ON AGC.archGroupId = AG.id
	WHERE	AG.name = @i_policyName AND (AGC.name = @i_copyName OR @i_copyName = '')
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#TblResult'))
         DROP TABLE #TblResult
CREATE	TABLE #TblResult  (
		jobId				int,
		commCellId			int,
		appId				int,
		sizeOfApplication	bigint,
		sizeOfAppCompressed	bigint,
		sizeOfBackup		bigint,
		sizeOfNWTransfer	bigint,
		startTime			int,
		endTime				int,
		opType				int,
		level				int,
		jobStatus			int,
		fullCycleNum		int,
		seqNumInCycle		int,
		duration			int,
		numStreams			int,
		numObjects			bigint,
		initFrom			int,
		attributes			bigint,
		attributesEx		bigint,
		userName			nvarchar(255),
		totalWriteTime		int,
		scanFileFailures	int,
		scanFolderFailures	int,
		bkpFileFailures		int,
		bkpFolderFailures	int,
		subClientId 		int,
		clientId			int	,
		appTypeId			int	,
		instanceId			int,
		backupSetId			int,
		clientName			nvarchar(255),
		appTypeName			varchar(255),
		instanceName		nvarchar(255),
		backupSetName		nvarchar(255),
		subClientName		nvarchar(255),
		commCellName		nvarchar(255),
		dataStatus			int,
		disabled			int,
		toBeCopied			int,
		jobCopyAttributes	int,
		sizeOnMedia			bigint,
		archCheckEndTime	int,
		archCheckStatus 	int,
		extRetentionFlags	int,
		retentionEndTime	bigint,
		copiedTime			bigint,
		agedTime			bigint,
		errorCode			int,
		retainedBy          int,
        copyId              int,
        dedupSaving         bigint,
        jobCopyStatus       bigint,
		jobDescription		nvarchar(MAX),
		jobDisplayFlags		bigint,
		indexBackupJob		int,
		clientOwnerList		nvarchar(MAX),
		RequiredByJobIds		nvarchar(MAX),
		lastRefreshTime      int,
clientDisplayName	nvarchar(255)
)
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#vmsummaryTbl'))
         DROP TABLE #vmsummaryTbl
create table #vmsummaryTbl
(
		copyId				int,
		jobId				int,
		subClientId 		int,
		clientId			int	,
		appTypeId			int	,
		instanceId			int,
		backupSetId			int,
		clientName			nvarchar(255),
		appTypeName			varchar(255),
		instanceName		nvarchar(255),
		backupSetName		nvarchar(255),
		subClientName		nvarchar(255),
		sizeOnMedia			bigint,
		applicationSize      bigint,
		level				int
)
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#summaryTbl'))
         DROP TABLE #summaryTbl
create table #summaryTbl
(
		copyId				int,
		subClientId 		int,
		clientId			int	,
		appTypeId			int	,
		instanceId			int,
		backupSetId			int,
		clientName			nvarchar(255),
		appTypeName			varchar(255),
		instanceName		nvarchar(255),
		backupSetName		nvarchar(255),
		subClientName		nvarchar(255),
		--sizeOnMedia			bigint,
		applicationSize		bigint,
		approxSize			bigint
)
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMInfo'))
         DROP TABLE #VMInfo
	CREATE TABLE #VMInfo (
		clientId			INT,
		appId				int,
		VMName				nvarchar(1024),
		VMSize				bigint,
		vmJobId				INT,
	)
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMTotalSize'))
         DROP TABLE #VMTotalSize
	CREATE TABLE #VMTotalSize (
		vmJobId				INT,
		copyId				int,
		TotalVMBackupSize	BIGINT,
		applicationSize			bigint	)
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMJobSize'))
         DROP TABLE #VMJobSize
	create table #VMJobSize (
		vmJobId			INT,
		copyId				int,
		clientId		int,
		applicationSize bigint
	)
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#sidbRatio'))
         DROP TABLE #sidbRatio
create table #sidbRatio (
	storeId    int,
	ratio	  float
)
DECLARE Get_CopyID CURSOR FOR
SELECT	CopyId
FROM	@TblCopyIds
DECLARE @clientCopySize bigint
OPEN Get_CopyID
FETCH FROM Get_CopyID
INTO @CopyId
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO #TblResult
	EXEC archViewJobsByCopy @CopyId, 0, @i_isAged, @BackupLevel, @TimeRangeBegin, @TimeRangeEnd, 0, @OrderByCode, 0
	INSERT INTO #summaryTbl
	select @CopyId,
		subClientId ,
		clientId	,
		appTypeId	,
		instanceId	,
		backupSetId	,
		clientName	,
		appTypeName	,
		instanceName,
		backupSetName,
		subClientName,
		--sum(sizeOnMedia),
		SUM(sizeOfApplication),
		SUM(sizeOnMedia)
	FROM #TblResult
	where appTypeId !=106
	group by appId,subClientId,clientId, appTypeId,instanceId,backupSetId,clientName,appTypeName,instanceName,backupSetName,subClientName
	INSERT INTO #vmsummaryTbl
	select @CopyId,
		jobId,
		subClientId ,
		clientId	,
		appTypeId	,
		instanceId	,
		backupSetId	,
		clientName	,
		appTypeName	,
		instanceName,
		backupSetName,
		subClientName,
		sizeOnMedia,
		sizeOfApplication,
		level
	FROM #TblResult
	where appTypeId =106
	TRUNCATE TABLE #TblResult
	FETCH FROM Get_CopyID
	INTO @CopyId
END
CLOSE		Get_CopyID
DEALLOCATE	Get_CopyID
declare @inputXML xml
set @inputXML = (select copy.id as '@policyId'
FROM archGroupCopy copy
FOR XML PATH ('Policy'))
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#sidbReport'))
         DROP TABLE #sidbReport
create table #sidbReport
(
archGroupId int,
PolicyName	nvarchar(255),
CopyId	int,
CopyName nvarchar(255),
CopyFlags int,
dedupeFlags int,
SIDBStoreId int,
SIDBStoreName nvarchar(255),
Nopartitions  int,
clientName nvarchar(255),
accessPath varchar(255),
flags  int,
CreatedTime int,
LastDDBBackupJobId int,
LastDDBBackuptime int,
LastRecoverytime int,
SealedTime int,
SealedReason int,
SizeOfApplication bigint,
SizeOfStore bigint,
SizeToBeInSilo bigint,
SizeInSilo bigint,
SizeOffDisk bigint,
SizeOffSIDB bigint,
RetainUntill int,
RetainedByJobId int,
baseLineSize bigint,
appsizeTobeFreed bigint
)
insert into #sidbReport
exec RptGetSIStore @inputXML
insert into #sidbRatio
select SIDBStoreId as storeId,
	   	   case when (SizeOfApplication >0)  AND (SizeOfApplication > SizeOfStore) THEN  1-( SizeOfApplication*1.0 - SizeOfStore*1.0)/SizeOfApplication ELSE 0 END
FROM #sidbReport
insert into #VMTotalSize
select jobId,copyId,0,applicationSize from #vmsummaryTbl
INSERT INTO #VMInfo  (clientId, VMName,VMSize,vmJobId)
select distinct C.id, C.name,CAST(VmProp.attrVal as bigint),VMT.vmJobId
from APP_Client C
	INNER JOIN APP_VMProp Vmprop
		On VmProp.vmClientId = C.id
		AND VmProp.attrName ='vmUsedSpace'
	INNER JOIN #VMTotalSize VMT
		ON VMT.vmJobId = Vmprop.jobId
update #VMInfo
set appId = bkpStat.appID
FROM JMBkpStats bkpStat
inner join #VMInfo info on
bkpstat.jobId = info.vmJobId
--synthetic full jobs
insert into #VMInfo (clientId, appId, VMName,VMSize,vmJobId)
select  distinct vminfo.clientId, 0,vminfo.VMName , MAX(vmInfo.VMSize),vmsummary.jobId
FROM #VMInfo vmInfo
inner join #vmsummaryTbl vmsummary
on vmInfo.appId = vmsummary.subClientId
and vmsummary.level = 64
and vmInfo.vmJobId <= vmsummary.jobId
group by vminfo.clientId, vminfo.VMName,vmsummary.jobId
order by vmsummary.jobId
insert into #VMInfo (clientId, appId, VMName,VMSize,vmJobId)
select clientId, 0, clientName, summary.applicationSize, summary.jobId from #vmsummaryTbl summary
left JOIN ( select distinct vmJobId from #VMInfo vmInfo) T
ON summary.jobId = T.vmJobId
where T.vmJobId IS NULL
update #VMInfo
set appId = bkpStat.appID
FROM JMBkpStats bkpStat
inner join #VMInfo info on
bkpstat.jobId = info.vmJobId
AND info.appId =0
update #VMTotalSize
set TotalVMBackupSize = T.size FROM
(select vmt.vmJobId,vmt.copyId, sum(vmInfo.VMSize) as size
FROM #VMTotalSize VMT
INNER JOIN #VMInfo vmInfo
ON VMT.vmJobId = vmInfo.vmJobId
group by VMT.vmJobId,copyId) T
inner join #VMTotalSize VMTotalSize
on VMTotalSize.vmJobId = T.vmJobId
and VMTotalSize.copyId = T.copyId
----select * from #VMTotalSize
insert into #VMJobSize
select vmInfo.vmJobId,vmTotalSize.copyId, vmInfo.clientId,cast(VMSize*(cast(vmTotalSize.applicationSize as real)/vmTotalSize.TotalVMBackupSize) as bigint)
FROM #VMInfo VMInfo
INNER JOIN #VMTotalSize vmTotalSize
 ON VMInfo.vmJobId  = vmTotalSize.vmJobId
 ANd vmTotalSize.TotalVMBackupSize !=0
INSERT into #summaryTbl
SELECT
		VMS.copyId,
		subClientId ,
		T.clientId	,
		appTypeId	,
		instanceId	,
		backupSetId	,
		V.VMName	,
		appTypeName	,
		instanceName,
		backupSetName,
		subClientName,
		SUM(T.applicationSize ),
		0--SUM(T.applicationSize )
from #vmsummaryTbl VMS
INNER JOIN #VMJobSize T
ON VMS.jobId = T.vmJobId
AND VMS.copyId = T.copyId
INNER JOIN #VMInfo V
ON V.clientId = T.clientId
and v.vmJobId=T.vmJobId
GROUP BY 		VMS.copyId,subClientId ,
		T.clientId	,
		appTypeId	,
		instanceId	,
		backupSetId	,
		V.VMName	,
		appTypeName	,
		instanceName,
		backupSetName,
		subClientName
--select SUM(approxSize) FROM #summaryTbl where clientId = 612
update #summaryTbl
set approxSize = case WHEN sidbRatio.ratio IS NULL  THEN summaryTbl.approxSize ELSE applicationSize * (sidbRatio.ratio) END
FROM #sidbRatio sidbRatio
LEFT OUTER JOIN archCopySIDBStore CS
ON	sidbRatio.storeID = CS.SIDBStoreId AND ((CS.Flags & 4) > 0)
LEFT OUTER JOIN #summaryTbl summaryTbl
ON summaryTbl.copyId = CS.CopyId
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#aggrOutput'))
         DROP TABLE #aggrOutput
create table #aggrOutput (
	clientId	int,
		clientName			nvarchar(255),
		appTypeName			varchar(255),
		appTypeId			int,
		instanceName		nvarchar(255),
		backupSetName		nvarchar(255),
		subClientName		nvarchar(255),
		copyId		int,
		applicationSize bigint,
	approxSize  bigint
)
insert into #aggrOutput
select clientId,
		clientName,
		appTypeName,
		appTypeId,
		instanceName,
		backupSetName,
		subClientName,
	   copyId,
	   SUM(applicationSize) as applicationSize,
	   SUM(approxSize) as approxSize
	   from #summaryTbl
group by clientId, copyId, clientName, appTypeName, appTypeId,instanceName, backupSetName, subClientName
SELECT			ClientName			= clientName,
		'Agent'				= appTypeName,
		Instance			= (case when dbo.FixInstanceName(instanceName, appTypeId) <> '' then dbo.FixInstanceName(instanceName, appTypeId) else									instanceName end),
		BackupSet			= backupSetName,
		SubClient			= subClientName,
		StoragePolicy		= AG.name,
		Copy				= AGC.name,
		Retention			= CASE WHEN AGE.retentionDays < 0 THEN 'INFINITE' ELSE CAST(AGE.retentionDays AS VARCHAR(10))+ ' day(s);' + CAST(AGE.fullCycles AS VARCHAR(10)) +' Cycle(s)' END,
		'Application Size (GB)'		= cast(applicationSize/(1024.0*1024.0*1024.0) as decimal(10,2)),
		'Backend Size (GB)'		= cast(approxSize/(1024.0*1024.0*1024.0) as decimal(10,2))
FROM #aggrOutput T
				JOIN
					archGroupCopy AGC
						ON AGC.id = T.copyId
				JOIN
					archGroup AG
						ON AG.id = AGC.archGroupId
				JOIN
					archAgingRule AGE
						ON AGE.copyId = T.copyId
--WHERE	T.dataStatus IN (100, 102, 103) --and jobid = 1684
order by clientName
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_BackendStorage')
	delete from GxQscripts where name = 'QS_BackendStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BackendStorage')
	delete from GXDBVersions where aliasname = 'QS_BackendStorage'
GO

insert into GXDBVersions values(2, 'QS_BackendStorage',  '00010006003400110000', 'QS_BackendStorage', '00010006003400110000')
GO

insert into GxQscripts values(2,'QS_BackendStorage',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn BackendStorage [-si @i_fromTime=''2013/02/12''] [-si @i_toTime=''2013/02/20''] [-si @i_isAged=''2''] [-si @i_backupType=''Full''] [-si @i_orderBy=''Client''] [-si @i_policyName=''policyName''] [-si @i_copyName=''copyName'']
'
 + CHAR(10) + '-- 	Returns Backend Storage Utilizaiton by Client.'
)
GO

