

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_AuxCopyReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_AuxCopyReport.sp,v $ $Id: QS_AuxCopyReport.sp,v 1.5.56.5 2018/03/20 00:49:45 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_AuxCopyReport <<<'

IF EXISTS (select * from sysobjects where name='QS_AuxCopyReport')
	drop procedure QS_AuxCopyReport
IF EXISTS (select * from GxQscripts where name='QS_AuxCopyReport')
	delete from GxQscripts where name = 'QS_AuxCopyReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AuxCopyReport')
	delete from GXDBVersions where aliasname = 'QS_AuxCopyReport'
GO
print '... Creating Procedure: QS_AuxCopyReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_AuxCopyReport
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @GroupBy NVARCHAR(512) = N'StoragePolicy',
  @CopyName NVARCHAR(512) = N'',	
  @ClientGroupName NVARCHAR(512) = N''
AS
SET NOCOUNT ON
--CopyName			NVARCHAR(512) = N'',	-- Give copy name
--ClientGroup			NVARCHAR(512) = N'',	-- Give a client group name if only clients of this group are interested
--i_GroupByClientGroup		INT = 1,				-- Show a mount of data to copy in a table grouped by client group
--i_GroupByClient			INT = 1,				-- Show a mount of data to copy in a table grouped by client
--i_GroupBySubclient		INT = 1,				-- Show a mount of data to copy in a table grouped by subclient
--i_GroupByStoragePolicy	INT = 1,				-- Show estimated hours for auxiliary copy to complete in a table grouped by storage policy
--i_GroupByPolicyClient		INT = 1					-- Show storage policy and copy in a descending order of data to copy
DECLARE @i_GroupByClientGroup		INT = 0
DECLARE @i_GroupByClient			INT = 0
DECLARE @i_GroupBySubclient		INT = 0
DECLARE @i_GroupByStoragePolicy	INT = 0
DECLARE @i_GroupByPolicyClient	INT = 0
DECLARE @now INT = dbo.getUnixTime(GETUTCDATE())
IF ( @GroupBy LIKE '%PolicyANDClient%')
	SET @i_GroupByPolicyClient =1
ELSE IF ( @GroupBy LIKE '%StoragePolicy%')
	SET @i_GroupByStoragePolicy =1
ELSE IF ( @GroupBy LIKE '%Subclient%')
	SET @i_GroupBySubclient =1
ELSE IF ( @GroupBy LIKE '%ClientGroup%')
	SET @i_GroupByClientGroup =1
ELSE IF ( @GroupBy LIKE '%Client%')
	SET @i_GroupByClient =1
DECLARE @csTimeZone VARCHAR(256)
SELECT	 @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
DECLARE @AuxCopyCountAppSize INT = 0
SET     @AuxCopyCountAppSize = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'MMS2_CONFIG_STRING_AUXCOPY_DETAILS_IN_APPLICATION_SIZE'), 0)
IF (@AuxCopyCountAppSize < 0)
    SET @AuxCopyCountAppSize = 0
CREATE TABLE #tblClient
		(ClientGroupId INT, ClientGrp NVARCHAR(512), ClientId INT, ClientName NVARCHAR(512),
		PRIMARY KEY (ClientId))
DECLARE	@l_ClientGroupId	INT = 0
IF	@ClientGroupName <> ''
BEGIN
	SELECT	@l_ClientGroupId = id
	FROM	APP_ClientGroup WITH (NOLOCK)
	WHERE	name = @ClientGroupName
	IF	@l_ClientGroupId IS NULL OR @l_ClientGroupId = 0
	BEGIN
		PRINT 'Incorrect Client Group Name'
		RETURN
	END
	INSERT	INTO #tblClient
	SELECT	@l_ClientGroupId, @ClientGroupName, C.id, C.name
	FROM	APP_Client C WITH (NOLOCK), APP_ClientGroupAssoc A WITH (NOLOCK)
	WHERE	C.id = A.clientId AND A.clientGroupId = @l_ClientGroupId
END
ELSE
	INSERT	INTO #tblClient
	SELECT	ISNULL(G.id, 0), ISNULL(G.name, ''), C.id, C.name
	FROM	APP_Client C WITH (NOLOCK)
			LEFT OUTER JOIN
			(SELECT	clientId, MIN(clientGroupId) AS clientGroupId
			FROM	APP_ClientGroupAssoc WITH (NOLOCK)
			GROUP BY  clientId) AS A ON C.id = A.clientId
			LEFT OUTER JOIN APP_ClientGroup G WITH (NOLOCK) ON A.clientGroupId = G.id
CREATE TABLE #tblAuxCopy
		(id INT, archGroupId INT, primaryCopyId INT, sourceCopyId INT,	PRIMARY KEY (id))
INSERT	INTO #tblAuxCopy
SELECT	AGC.id, AG.id, AG.defaultCopy, CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId ELSE AG.defaultCopy END
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AGC.archGroupId = AG.id AND AGC.type IN (1, 2) AND AGC.isSnapCopy = 0 AND AGC.id <> AG.defaultCopy
	AND (@CopyName  IN ('', '%%') OR AGC.name LIKE @CopyName)
CREATE TABLE #tblPrimaryCopyJobs
		(jobId INT, commCellId INT, appId INT, clientId INT, archGrpId INT, archGrpCopyId INT, bytes BIGINT,
		PRIMARY KEY(jobId, commCellId, archGrpCopyId))
INSERT	INTO #tblPrimaryCopyJobs
SELECT	J.jobId, J.commCellId, J.appId, A.clientId, J.archGrpId, J.archGrpCopyId, SUM(J.sizeOnMedia)
FROM	JMJobDataStats J WITH (NOLOCK), APP_Application A WITH (NOLOCK)
WHERE	J.archGrpCopyId IN (SELECT DISTINCT primaryCopyId FROM #tblAuxCopy)
	AND J.status = 100 AND (J.disabled & (1|256)) = 0
	AND A.id = J.appId AND (A.dataArchGrpID > 1 OR A.logArchGrpID > 1)
GROUP BY J.jobId, J.commCellId, J.appId, A.clientId, J.archGrpId, J.archGrpCopyId
CREATE TABLE #tblAuxCopyJobs
		(jobId INT, commCellId INT, appId INT, clientId INT, archGrpId INT, archGrpCopyId INT, sourceCopyId INT,
		bytes BIGINT, needToCopy INT, disabled INT, bytesToCopy BIGINT, appSizeToCopy BIGINT,
		PRIMARY KEY(jobId, commCellId, archGrpCopyId))
INSERT	INTO #tblAuxCopyJobs
SELECT	J.jobId, J.commCellId, J.appId, A.clientId, J.archGrpId, J.archGrpCopyId, C.sourceCopyId,
		SUM(J.sizeOnMedia), MAX(status%100), MAX(J.disabled & 1), 0, 0
FROM	JMJobDataStats J WITH (NOLOCK), APP_Application A WITH (NOLOCK), #tblAuxCopy C
WHERE	J.status IN (100, 101, 102, 103) and (J.disabled & (1|256)) = 0
	AND A.id = J.appId AND (A.dataArchGrpID > 1 OR A.logArchGrpID > 1)
	AND J.archGrpCopyId = C.id
GROUP BY J.jobId, J.commCellId, J.appId, A.clientId, J.archGrpId, J.archGrpCopyId, C.sourceCopyId
DELETE	T
FROM	#tblAuxCopyJobs T
		INNER JOIN JMJobDataStats J WITH (NOLOCK) ON T.jobId = J.jobId AND T.commCellId = J.commCellId AND T.sourceCopyId = J.archGrpCopyId
WHERE	(J.disabled & (1|256)) > 0
IF EXISTS (SELECT * FROM #tblAuxCopy WHERE sourceCopyId <> primaryCopyId)
	UPDATE	T SET sourceCopyId = C.primaryCopyId
	FROM	#tblAuxCopyJobs T
			INNER JOIN #tblAuxCopy C ON T.archGrpCopyId = C.id AND T.sourceCopyId <> C.primaryCopyId
			INNER JOIN JMJobDataStats J WITH (NOLOCK) ON T.jobId = J.jobId AND T.commCellId = J.commCellId AND T.sourceCopyId = J.archGrpCopyId
	WHERE	J.status IN (101, 102, 103)
CREATE TABLE #tblDstJobSize
		(jobId INT, commCellId INT, archGrpId INT, archGrpCopyId INT, dataSize BIGINT,
		PRIMARY KEY(jobId, commCellId, archGrpCopyId))
INSERT	INTO #tblDstJobSize
SELECT	J.jobId, J.commCellId, J.archGrpId, J.archGrpCopyId, SUM(AFC.physicalSize)
FROM	#tblAuxCopyJobs J, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
WHERE	AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND J.needToCopy <> 0 AND J.disabled = 0
	AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId AND AF.isValid = 1
GROUP BY J.jobId, J.commCellId, J.archGrpId, J.archGrpCopyId
CREATE TABLE #tblSrcJobSize
		(jobId INT, commCellId INT, archGrpId INT, archGrpCopyId INT, dataSize BIGINT, appSize BIGINT,
		PRIMARY KEY(jobId, commCellId, archGrpCopyId))
INSERT	INTO #tblSrcJobSize
SELECT	J.jobId, J.commCellId, J.archGrpId, J.sourceCopyId, SUM(AFC.physicalSize), 0
FROM	#tblAuxCopyJobs J, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
WHERE	AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.archGroupId = J.archGrpId
	AND J.needToCopy <> 0 AND J.disabled = 0
	AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.sourceCopyId AND AF.isValid = 1
GROUP BY J.jobId, J.commCellId, J.archGrpId, J.sourceCopyId
IF @AuxCopyCountAppSize > 0
BEGIN
	UPDATE	#tblSrcJobSize SET appSize = J.totalUncompbytes
	FROM	JMBkpStats J
	WHERE	#tblSrcJobSize.jobId = J.jobId AND #tblSrcJobSize.commCellId = J.commCellId
	UPDATE	#tblSrcJobSize SET appSize = J.totalBackupSize
	FROM	JMAdminJobStatsTable J
	WHERE	#tblSrcJobSize.jobId = J.jobId AND #tblSrcJobSize.commCellId = J.commCellId
END
UPDATE	#tblAuxCopyJobs
SET		bytesToCopy = (S.dataSize - ISNULL(D.dataSize, 0)),
		appSizeToCopy = S.appSize - (CASE WHEN S.dataSize > 0 THEN ISNULL(1.0*D.dataSize/S.dataSize, 0)*S.appSize ELSE 0 END)
FROM	#tblAuxCopyJobs J
		INNER JOIN #tblSrcJobSize S
			ON S.jobId = J.jobId AND S.commCellId = J.commCellId AND S.archGrpId = J.archGrpId
		LEFT OUTER JOIN #tblDstJobSize D
			ON D.jobId = J.jobId AND D.commCellId = J.commCellId AND D.archGrpCopyId = J.archGrpCopyId
WHERE	J.needToCopy <> 0
DROP TABLE #tblSrcJobSize
DROP TABLE #tblDstJobSize
IF	@i_GroupByClientGroup = 1 OR @i_GroupByClient = 1 OR @i_GroupBySubclient = 1 OR @i_GroupByPolicyClient = 1
BEGIN
	CREATE TABLE #tblBaselineByApp
			(clientId INT, appId INT, startTime INT, fullCycleNum INT, lastBackupTime INT, archGrpId INT, archGrpCopyId INT, AuxCopyJobId INT, failureReason VARCHAR(MAX), PRIMARY KEY (appId))
	INSERT	INTO #tblBaselineByApp
	SELECT	A.clientId,	B.appId, MAX(B.servStartDate), 0, 0,  MAX(J.archGrpId), MAX(J.archGrpCopyId), 0, ''
	FROM	JMBkpStats B WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK), APP_Application A WITH (NOLOCK), #tblAuxCopy C
	WHERE	J.jobId = B.jobId AND J.commCellId = B.commCellId AND J.archGrpCopyId = C.id
		AND A.id = J.appId AND (A.dataArchGrpID > 1 OR A.logArchGrpID > 1)
		AND J.status = 100 AND (J.disabled & 256) = 0
		AND B.status IN (1, 3, 14) AND B.bkpLevel IN (1, 64, 128, 1024, 32768)
	GROUP BY A.clientId, B.appId
	UPDATE	#tblBaselineByApp
	SET		fullCycleNum = B.fullCycleNum
	FROM	#tblBaselineByApp A, JMBkpStats B WITH (NOLOCK)
	WHERE	B.appId = A.appId AND B.servStartDate =  A.startTime
	UPDATE	#tblBaselineByApp
	SET		lastBackupTime = B.lastBackupTime
	FROM	#tblBaselineByApp A,
			(SELECT appId, MAX(servStartDate) AS lastBackupTime FROM JMBkpStats WITH (NOLOCK) WHERE status IN (1, 3, 14) GROUP BY appId) B
	WHERE	B.appId = A.appId
	CREATE TABLE #tblLastCopiedCycle
			(appId INT, jobId INT, commCellId INT, startTime INT, backpuLevel INT, copied INT,
			PRIMARY KEY (jobId, commCellId))
	INSERT	INTO #tblLastCopiedCycle
	SELECT	B.appId, B.jobId, B.commCellId, B.servStartDate, B.bkpLevel, 0
	FROM	#tblBaselineByApp A, JMBkpStats B WITH (NOLOCK)
	WHERE	B.appId = A.appId AND B.fullCycleNum = A.fullCycleNum
		AND B.status IN (1, 3, 14)
	UPDATE	#tblLastCopiedCycle
	SET		copied = 1
	FROM	#tblLastCopiedCycle B, JMJobDataStats J WITH (NOLOCK), #tblAuxCopy C
	WHERE	J.jobId = B.jobId AND J.commCellId = B.commCellId AND J.archGrpCopyId = C.id
		AND J.status = 100 AND (J.disabled & 256) = 0
	UPDATE	#tblBaselineByApp
	SET		startTime = B.startTime
	FROM	#tblBaselineByApp A,
			(SELECT appId, MAX(startTime) AS startTime FROM #tblLastCopiedCycle WHERE backpuLevel = 4 AND copied = 1 GROUP BY appId) B
	WHERE	A.appId = B.appId AND A.startTime < B.startTime
	DELETE	#tblLastCopiedCycle
	FROM	#tblLastCopiedCycle A,
			(SELECT appId, MIN(startTime) AS startTime FROM #tblLastCopiedCycle WHERE copied = 0 GROUP BY appId) B
	WHERE	A.appId = B.appId AND A.startTime >= B.startTime
	UPDATE	#tblBaselineByApp
	SET		startTime = B.startTime
	FROM	#tblBaselineByApp A,
			(SELECT appId, MAX(startTime) AS startTime FROM #tblLastCopiedCycle GROUP BY appId) B
	WHERE	A.appId = B.appId AND A.startTime < B.startTime
	IF	@i_GroupByClientGroup = 1 OR @i_GroupByClient = 1 OR @i_GroupBySubclient = 1
	BEGIN
		CREATE TABLE #tblJobsToCopyByApp
				(appId INT, clientId INT, bytes BIGINT, nJobs INT, archGrpId INT, archGrpCopyId INT, AuxCopyJobId INT, failureReason VARCHAR(MAX),	PRIMARY KEY (appId))
		INSERT	INTO #tblJobsToCopyByApp
		SELECT	appId, clientId, SUM(CASE WHEN @AuxCopyCountAppSize > 0 THEN appSizeToCopy ELSE bytesToCopy END), COUNT(DISTINCT jobId), MAX(archGrpId), MAX(archGrpCopyId), 0, ''
		FROM	#tblAuxCopyJobs
		WHERE	needToCopy = 1 AND disabled = 0
		GROUP BY appId, clientId
		CREATE TABLE #tblJobsOnSrcCopyByApp
				(appId INT, clientId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (appId))
		INSERT	INTO #tblJobsOnSrcCopyByApp
		SELECT	appId, clientId, SUM(bytes), COUNT(DISTINCT jobId)
		FROM	#tblPrimaryCopyJobs
		GROUP BY appId, clientId
		CREATE TABLE #tblJobsOnAuxCopyByApp
				(appId INT, clientId INT, bytes BIGINT, nJobs INT, archGrpId INT, archGrpCopyId INT, AuxCopyJobId INT, failureReason VARCHAR(MAX),	PRIMARY KEY (appId))
		INSERT	INTO #tblJobsOnAuxCopyByApp
		SELECT	A.appId, A.clientId, SUM(A.bytes), COUNT(DISTINCT A.jobId), MAX(p.archGrpId), MAX(p.archGrpCopyId), 0, ''
		FROM	#tblAuxCopyJobs A, #tblPrimaryCopyJobs P
		WHERE	A.jobId = P.jobId AND A.commCellId = P.commCellId AND A.archGrpId = P.archGrpId
		GROUP BY A.appId, A.clientId
		UPDATE	#tblJobsOnAuxCopyByApp
		SET		nJobs = (A.nJobs - B.nJobs)
		FROM	#tblJobsOnAuxCopyByApp A, #tblJobsToCopyByApp B
		WHERE	A.appId = B.appId
		CREATE TABLE #tblLastAuxCopyJobDetails
			(archGrpId INT, archGrpCopyId INT,	jobId INT, PRIMARY KEY (archGrpCopyId, archGrpId))
		INSERT	INTO #tblLastAuxCopyJobDetails
		SELECT	J.archGrpId, J.archGrpCopyId, MAX(J.jobId)
		FROM	JMAdminJobStatsTable J  WITH (NOLOCK)
		LEFT OUTER JOIN #tblBaselineByApp B ON
		J.archGrpID = B.archGrpId AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = B.archGrpCopyId)
		LEFT OUTER JOIN #tblJobsToCopyByApp D ON
		J.archGrpID = D.archGrpId AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = D.archGrpCopyId)
		LEFT OUTER JOIN #tblJobsOnAuxCopyByApp T ON
		J.archGrpID = T.archGrpId AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = T.archGrpCopyId)
		WHERE J.opType IN (13, 104)
		GROUP BY J.archGrpId, J.archGrpCopyId
		DECLARE @NewLine char(1)
		SET @NewLine=char(10)
		DECLARE @NewLine2 char(1)
		SET @NewLine2=char(13)
		DECLARE @BR char(4)
		SET @BR='<BR>'
		UPDATE	#tblBaselineByApp
		SET		AuxCopyJobId = B.jobId
		FROM	#tblBaselineByApp S,
				(SELECT	A.archGrpId, A.archGrpCopyId, MAX(J.jobId) AS jobId
				FROM	#tblLastAuxCopyJobDetails A, JMAdminJobStatsTable J WITH (NOLOCK)
				WHERE	J.archGrpID = A.archGrpId AND J.opType IN (13, 104)
				GROUP BY A.archGrpId, A.archGrpCopyId) B
		WHERE	S.archGrpId = B.archGrpId
		UPDATE	#tblJobsToCopyByApp
		SET		AuxCopyJobId = B.jobId
		FROM	#tblJobsToCopyByApp S,
				(SELECT	A.archGrpId, A.archGrpCopyId, MAX(J.jobId) AS jobId
				FROM	#tblLastAuxCopyJobDetails A, JMAdminJobStatsTable J WITH (NOLOCK)
				WHERE	J.archGrpID = A.archGrpId AND J.opType IN (13, 104)
				GROUP BY A.archGrpId, A.archGrpCopyId) B
		WHERE	S.archGrpId = B.archGrpId
		UPDATE	#tblJobsOnAuxCopyByApp
		SET		AuxCopyJobId = B.jobId
		FROM	#tblJobsOnAuxCopyByApp S,
				(SELECT	A.archGrpId, A.archGrpCopyId, MAX(J.jobId) AS jobId
				FROM	#tblLastAuxCopyJobDetails A, JMAdminJobStatsTable J WITH (NOLOCK)
				WHERE	J.archGrpID = A.archGrpId AND J.opType IN (13, 104)
				GROUP BY A.archGrpId, A.archGrpCopyId) B
		WHERE	S.archGrpId = B.archGrpId
		UPDATE	#tblBaselineByApp
		SET		failureReason= (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(LEFT(dbo.JMGetLocalizedMessageFunc(0, J.failureReason),1022),',',' '),@NewLine,';'),@NewLine2,';'),'''',' '),@BR,''))
		FROM #tblBaselineByApp A INNER JOIN JMAdminJobStatsTable J WITH (NOLOCK)
		ON A.AuxCopyJobId = J.jobId
		UPDATE	#tblJobsToCopyByApp
		SET		failureReason= (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(LEFT(dbo.JMGetLocalizedMessageFunc(0, J.failureReason),1022),',',' '),@NewLine,';'),@NewLine2,';'),'''',' '),@BR,''))
		FROM #tblJobsToCopyByApp A INNER JOIN JMAdminJobStatsTable J WITH (NOLOCK)
		ON A.AuxCopyJobId = J.jobId
		UPDATE	#tblJobsOnAuxCopyByApp
		SET		failureReason= (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(LEFT(dbo.JMGetLocalizedMessageFunc(0, J.failureReason),1022),',',' '),@NewLine,';'),@NewLine2,';'),'''',' '),@BR,''))
		FROM #tblJobsOnAuxCopyByApp A INNER JOIN JMAdminJobStatsTable J WITH (NOLOCK)
		ON A.AuxCopyJobId = J.jobId
		DROP TABLE #tblLastAuxCopyJobDetails
	END
	IF	@i_GroupBySubclient = 1
	BEGIN
		SELECT	C.ClientGrp					AS 'Client Group',
				C.ClientName						AS Client,
				IDA.name							AS iDA,
				INS.name							AS Instance,
				BS.name								AS BackupSet,
				A.subclientName						AS Subclient,
				AG.name								AS 'Storage Policy',
				CONVERT(DECIMAL(20, 3), ISNULL(CAST(S.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Source (GB)',
				ISNULL(S.nJobs, 0)					AS 'Source Jobs',
				CONVERT(DECIMAL(20, 3), ISNULL(CAST(D.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Destination (GB)',
				ISNULL(D.nJobs, 0)					AS 'Available Jobs',
				CONVERT(DECIMAL(20, 3), ISNULL(CAST(T.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Data to Copy (GB)',
				ISNULL(T.nJobs, 0)					AS 'Jobs to Copy',
				CASE WHEN B.startTime IS NULL OR B.startTime = 0 THEN NULL
						ELSE dbo.UTCToLocalStringTime( dbo.GetDateTime(B.startTime), @csTimeZone) END	AS 'Last backup job time on secondary copy',
				CASE WHEN B.startTime IS NULL OR B.startTime = 0 THEN NULL
						ELSE (@now - B.startTime)/24/60/60	END								AS 'Number of days behind',
				CASE WHEN B.lastBackupTime IS NULL OR B.lastBackupTime = 0 THEN NULL
						ELSE dbo.UTCToLocalStringTime( dbo.GetDateTime(B.lastBackupTime), @csTimeZone) END	AS 'Last Backup Time',
				CASE WHEN T.failureReason IS NULL THEN
						CASE WHEN D.failureReason IS NULL OR D.failureReason = '' THEN
							CASE WHEN B.failureReason IS NULL OR B.failureReason = '' THEN 'N/A' ELSE B.failureReason END ELSE D.failureReason END
					WHEN T.failureReason = '' OR D.failureReason = '' OR B.failureReason = '' THEN 'N/A'
						ELSE T.failureReason END AS 'Last Job Failure Reason'
		FROM	#tblClient C
				LEFT OUTER JOIN #tblJobsOnSrcCopyByApp	S			ON S.clientId = C.ClientId
				INNER JOIN APP_Application A WITH (NOLOCK)		ON A.id = S.appId
				INNER JOIN APP_iDAType IDA WITH (NOLOCK)		ON IDA.type = A.appTypeId
				INNER JOIN APP_InstanceName INS WITH (NOLOCK)	ON INS.id = A.instance
				INNER JOIN APP_BackupSetName BS WITH (NOLOCK)	ON BS.id = A.backupSet
				INNER JOIN archGroup AG WITH (NOLOCK)			ON (AG.id = A.dataArchGrpID AND A.dataArchGrpID > 1 OR AG.id = A.logArchGrpID AND A.logArchGrpID > 1)
				LEFT OUTER JOIN #tblJobsOnAuxCopyByApp	D		ON D.appId = S.appId AND D.archGrpId = AG.id
				LEFT OUTER JOIN #tblJobsToCopyByApp		T		ON T.appId = S.appId AND T.archGrpId = AG.id
				LEFT OUTER JOIN #tblBaselineByApp		B		ON B.appId = S.appId AND B.archGrpId = AG.id
		WHERE	S.nJobs > 0 OR D.nJobs > 0 OR B.startTime > 0
		ORDER BY C.ClientGrp, C.ClientName, IDA.name, INS.name, BS.name, A.subclientName
	END
	IF	@i_GroupByPolicyClient = 1
	BEGIN
		CREATE TABLE #tblJobsToCopyByPolicyClient
				(archGrpId INT, clientId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (archGrpId, clientId))
		INSERT	INTO #tblJobsToCopyByPolicyClient
		SELECT	archGrpId, clientId, SUM(CASE WHEN @AuxCopyCountAppSize > 0 THEN appSizeToCopy ELSE bytesToCopy END), COUNT(DISTINCT jobId)
		FROM	#tblAuxCopyJobs
		WHERE	needToCopy = 1 AND disabled = 0
		GROUP BY archGrpId, clientId
		CREATE TABLE #tblJobsOnSrcCopyByPolicyClient
				(archGrpId INT, clientId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (archGrpId, clientId))
		INSERT	INTO #tblJobsOnSrcCopyByPolicyCLient
		SELECT	archGrpId, clientId, SUM(bytes), COUNT(DISTINCT jobId)
		FROM	#tblPrimaryCopyJobs
		GROUP BY archGrpId, clientId
		CREATE TABLE #tblJobsOnAuxCopyByPolicyClient
				(archGrpId INT, clientId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (archGrpId, clientId))
		INSERT	INTO #tblJobsOnAuxCopyByPolicyClient
		SELECT	A.archGrpId, A.clientId, SUM(A.bytes), COUNT(DISTINCT A.jobId)
		FROM	#tblAuxCopyJobs A, #tblPrimaryCopyJobs P
		WHERE	A.jobId = P.jobId AND A.commCellId = P.commCellId AND A.archGrpId = P.archGrpId
		GROUP BY A.archGrpId, A.clientId
		UPDATE	#tblJobsOnAuxCopyByPolicyClient
		SET		nJobs = (A.nJobs - B.nJobs)
		FROM	#tblJobsOnAuxCopyByPolicyClient A, #tblJobsToCopyByPolicyClient B
		WHERE	A.archGrpId = B.archGrpId AND A.clientId = B.clientId
		CREATE TABLE #tblJobsToCopyByPolicy
				(archGrpId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (archGrpId))
		INSERT	INTO #tblJobsToCopyByPolicy
		SELECT	archGrpId, SUM(bytes), SUM(DISTINCT nJobs)
		FROM	#tblJobsToCopyByPolicyClient
		GROUP BY archGrpId
		SELECT	AG.name								AS 'Storage Policy',
				C.ClientName						AS Client,
				C.ClientGrp					AS 'Client Group',
				CONVERT(DECIMAL(20, 3), ISNULL(CAST(S.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Source (GB)',
				ISNULL(S.nJobs, 0)					AS 'Source Jobs',
				CONVERT(DECIMAL(20, 3), ISNULL(CAST(D.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Destination (GB)',
				ISNULL(D.nJobs, 0)					AS 'Available Jobs',
				CONVERT(DECIMAL(20, 3), ISNULL(CAST(T.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Data to Copy (GB)',
				ISNULL(T.nJobs, 0)					AS 'Jobs to Copy'
		FROM	archGroup AG WITH (NOLOCK)
				INNER JOIN #tblJobsToCopyByPolicy			P ON P.archGrpId = AG.id
				INNER JOIN #tblJobsToCopyByPolicyClient		T ON T.archGrpId = AG.id
				INNER JOIN #tblClient						C ON C.ClientId = T.clientId
				INNER JOIN #tblJobsOnSrcCopyByPolicyClient	S ON S.archGrpId = T.archGrpId AND S.clientId = T.ClientId
				INNER JOIN #tblJobsOnAuxCopyByPolicyClient	D ON D.archGrpId = T.archGrpId AND D.clientId = T.ClientId
		WHERE	S.nJobs > 0 OR D.nJobs > 0
		ORDER BY P.bytes DESC, T.bytes DESC
		DROP  TABLE #tblJobsToCopyByPolicy
		DROP  TABLE #tblJobsToCopyByPolicyClient
		DROP  TABLE #tblJobsOnSrcCopyByPolicyClient
		DROP  TABLE #tblJobsOnAuxCopyByPolicyClient
	END
	IF	@i_GroupByClientGroup = 1 OR @i_GroupByClient = 1 OR @i_GroupBySubclient = 1
	BEGIN
		CREATE TABLE #tblBaselineByClient
				(clientId INT, startTime INT, lastBackupTime INT, PRIMARY KEY (clientId))
		INSERT	INTO #tblBaselineByClient
		SELECT	clientId, MIN(startTime), MAX(lastBackupTime)
		FROM	#tblBaselineByApp
		GROUP BY clientId
		CREATE TABLE #tblJobsToCopyByClient
				(clientId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (clientId))
		INSERT	INTO #tblJobsToCopyByClient
		SELECT	clientId, SUM(bytes), SUM(nJobs)
		FROM	#tblJobsToCopyByApp
		GROUP BY clientId
		CREATE TABLE #tblJobsOnSrcCopyByClient
				(clientId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (clientId))
		INSERT	INTO #tblJobsOnSrcCopyByClient
		SELECT	clientId, SUM(bytes), SUM(nJobs)
		FROM	#tblJobsOnSrcCopyByApp
		GROUP BY clientId
		CREATE TABLE #tblJobsOnAuxCopyByClient
				(clientId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (clientId))
		INSERT	INTO #tblJobsOnAuxCopyByClient
		SELECT	clientId, SUM(bytes), SUM(nJobs)
		FROM	#tblJobsOnAuxCopyByApp
		GROUP BY clientId
		IF	@i_GroupByClientGroup = 1
		BEGIN
			CREATE TABLE #tblBaselineByClientGroup
					(clientGroupId INT, startTime INT, lastBackupTime INT, PRIMARY KEY (clientGroupId))
			INSERT	INTO #tblBaselineByClientGroup
			SELECT	C.ClientGroupId, MIN(B.startTime), MAX(B.lastBackupTime)
			FROM	#tblBaselineByClient B INNER JOIN #tblClient C ON B.clientId = C.ClientId
			GROUP BY C.ClientGroupId
			CREATE TABLE #tblJobsToCopyByClientGroup
					(clientGroupId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (clientGroupId))
			INSERT	INTO #tblJobsToCopyByClientGroup
			SELECT	C.ClientGroupId, SUM(bytes), SUM(nJobs)
			FROM	#tblJobsToCopyByClient B INNER JOIN #tblClient C ON B.clientId = C.ClientId
			GROUP BY C.ClientGroupId
			CREATE TABLE #tblJobsOnSrcCopyByClientGroup
					(clientGroupId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (clientGroupId))
			INSERT	INTO #tblJobsOnSrcCopyByClientGroup
			SELECT	C.ClientGroupId, SUM(bytes), SUM(nJobs)
			FROM	#tblJobsOnSrcCopyByClient B INNER JOIN #tblClient C ON B.clientId = C.ClientId
			GROUP BY C.ClientGroupId
			CREATE TABLE #tblJobsOnAuxCopyByClientGroup
					(clientGroupId INT, bytes BIGINT, nJobs INT,	PRIMARY KEY (clientGroupId))
			INSERT	INTO #tblJobsOnAuxCopyByClientGroup
			SELECT	C.ClientGroupId, SUM(bytes), SUM(nJobs)
			FROM	#tblJobsOnAuxCopyByClient B INNER JOIN #tblClient C ON B.clientId = C.ClientId
			GROUP BY C.ClientGroupId
			SELECT	C.ClientGrp					AS ClientGroup,
					CONVERT(DECIMAL(20, 3), ISNULL(CAST(S.bytes AS FLOAT), 0)/1024/1024/1024/1024)	AS 'Source (TB)',
					ISNULL(S.nJobs, 0)					AS 'Source Jobs',
					CONVERT(DECIMAL(20, 3), ISNULL(CAST(D.bytes AS FLOAT), 0)/1024/1024/1024/1024)	AS 'Destination (TB)',
					ISNULL(D.nJobs, 0)					AS 'Available Jobs',
					CONVERT(DECIMAL(20, 3), ISNULL(CAST(T.bytes AS FLOAT), 0)/1024/1024/1024/1024)	AS 'Data to Copy (TB)',
					ISNULL(T.nJobs, 0)					AS 'Jobs to Copy',
					CASE WHEN B.startTime IS NULL OR B.startTime = 0 THEN NULL
							ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(B.startTime), @csTimeZone) END	AS 'Last backup job time on secondary copy',
					CASE WHEN B.startTime IS NULL OR B.startTime = 0 THEN NULL
							ELSE (@now - B.startTime)/24/60/60	END								AS 'Fallen Behind Days',
					CASE WHEN B.lastBackupTime IS NULL OR B.lastBackupTime = 0 THEN NULL
							ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(B.lastBackupTime), @csTimeZone) END	AS 'Last backup time'
			FROM	(SELECT DISTINCT ClientGroupId, ClientGrp FROM #tblClient) C
					LEFT OUTER JOIN #tblJobsOnSrcCopyByClientGroup	S ON S.ClientGroupId = C.ClientGroupId
					LEFT OUTER JOIN #tblJobsOnAuxCopyByClientGroup	D ON D.ClientGroupId = C.ClientGroupId
					LEFT OUTER JOIN #tblJobsToCopyByClientGroup		T ON T.ClientGroupId = C.ClientGroupId
					LEFT OUTER JOIN #tblBaselineByClientGroup		B ON B.clientGroupId = C.ClientGroupId
			WHERE	S.nJobs > 0 OR D.nJobs > 0 OR B.startTime > 0
			ORDER BY C.ClientGrp
			DROP TABLE #tblJobsOnSrcCopyByClientGroup
			DROP TABLE #tblJobsOnAuxCopyByClientGroup
			DROP TABLE #tblJobsToCopyByClientGroup
			DROP TABLE #tblBaselineByClientGroup
		END
		IF	@i_GroupByClient = 1
			SELECT	C.ClientGrp					AS ClientGroup,
					C.ClientName						AS Client,
					CONVERT(DECIMAL(20, 3), ISNULL(CAST(S.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Source (GB)',
					ISNULL(S.nJobs, 0)					AS 'Source Jobs',
					CONVERT(DECIMAL(20, 3), ISNULL(CAST(D.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Destination (GB)',
					ISNULL(D.nJobs, 0)					AS 'Available Jobs',
					CONVERT(DECIMAL(20, 3), ISNULL(CAST(T.bytes AS FLOAT), 0)/1024/1024/1024)	AS 'Data to Copy (GB)',
					ISNULL(T.nJobs, 0)					AS 'Jobs to Copy',
					CASE WHEN B.startTime IS NULL OR B.startTime = 0 THEN NULL
							ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(B.startTime), @csTimeZone) END	AS 'Last backup job time on secondary copy',
					CASE WHEN B.startTime IS NULL OR B.startTime = 0 THEN NULL
							ELSE (@now - B.startTime)/24/60/60	END								AS 'Number of days behind',
					CASE WHEN B.lastBackupTime IS NULL OR B.lastBackupTime = 0 THEN NULL
							ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(B.lastBackupTime), @csTimeZone) END	AS 'Last backup time'
			FROM	#tblClient C
					LEFT OUTER JOIN #tblJobsOnSrcCopyByClient	S ON S.clientId = C.ClientId
					LEFT OUTER JOIN #tblJobsOnAuxCopyByClient	D ON D.clientId = C.ClientId
					LEFT OUTER JOIN #tblJobsToCopyByClient		T ON T.clientId = C.ClientId
					LEFT OUTER JOIN #tblBaselineByClient		B ON B.clientId = C.ClientId
			WHERE	S.nJobs > 0 OR D.nJobs > 0 OR B.startTime > 0
			ORDER BY C.ClientGrp, C.ClientName
		DROP TABLE #tblJobsOnSrcCopyByClient
		DROP TABLE #tblJobsOnAuxCopyByClient
		DROP TABLE #tblJobsToCopyByClient
		DROP TABLE #tblBaselineByClient
	END
	IF	@i_GroupByClientGroup = 1 OR @i_GroupByClient = 1 OR @i_GroupBySubclient = 1
	BEGIN
		DROP TABLE #tblJobsOnSrcCopyByApp
		DROP TABLE #tblJobsOnAuxCopyByApp
		DROP TABLE #tblJobsToCopyByApp
	END
	DROP TABLE #tblLastCopiedCycle
	DROP TABLE #tblBaselineByApp
END
IF	@i_GroupByStoragePolicy = 1
BEGIN
	CREATE TABLE #tblSizePerCopy
			(archGrpId INT, archGrpCopyId INT, bytesToCopy BIGINT, appSizeToCopy BIGINT, bytes BIGINT, seconds INT,
			AuxCopyJobId INT, AuxCopyStartTime INT, AuxCopyStatus INT,
			PRIMARY KEY (archGrpCopyId))
	INSERT	INTO #tblSizePerCopy
	SELECT	archGrpId, archGrpCopyId, SUM(bytesToCopy), SUM(appSizeToCopy), 0, 0, 0, 0, 0
	FROM	#tblAuxCopyJobs
	WHERE	needToCopy <> 0 AND disabled = 0
	GROUP BY archGrpId, archGrpCopyId
	HAVING	SUM(bytesToCopy) > 0
	UPDATE	#tblSizePerCopy
	SET		bytes = C.BytesXferred, seconds = C.mediaUsageTime
	FROM	#tblSizePerCopy A,
			(SELECT	S.archGrpCopyId, MAX(D.jobId) AS jobId
			FROM	#tblSizePerCopy S, JMDataCopiedStatsTable D WITH (NOLOCK)
			WHERE	D.archGrpCopyID = S.archGrpCopyId AND D.mediaUsageTime > 0
			GROUP BY S.archGrpId, S.archGrpCopyId) B,
			JMDataCopiedStatsTable C WITH (NOLOCK)
	WHERE	A.archGrpCopyId = B.archGrpCopyId AND C.jobId = B.jobId AND C.archGrpCopyId = B.archGrpCopyId
	CREATE TABLE #tblLastAuxCopyJob
			(archGrpCopyId INT,	jobId INT, PRIMARY KEY (archGrpCopyId))
	INSERT	INTO #tblLastAuxCopyJob
	SELECT	S.archGrpCopyId, MAX(J.jobId)
	FROM	#tblSizePerCopy S, JMAdminJobInfoTable J WITH (NOLOCK)
	WHERE	J.archGrpID = S.archGrpId AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = S.archGrpCopyId)
		AND J.opType IN (13, 104)
	GROUP BY S.archGrpCopyId
	UPDATE	#tblSizePerCopy
	SET		AuxCopyJobId = B.jobId, AuxCopyStartTime = B.jobStartTime, AuxCopyStatus = -1
	FROM	#tblSizePerCopy S,
			(SELECT	A.archGrpCopyId, J.jobId, J.jobStartTime, J.state
			FROM	#tblLastAuxCopyJob A, JMJobInfo J WITH (NOLOCK)
			WHERE	J.jobId = A.jobId AND J.state IN (1,4,9)) B
	WHERE	S.archGrpCopyId = B.archGrpCopyId
	INSERT	INTO #tblLastAuxCopyJob
	SELECT	S.archGrpCopyId, MAX(J.jobId)
	FROM	#tblSizePerCopy S, JMAdminJobStatsTable J WITH (NOLOCK)
	WHERE	J.archGrpID = S.archGrpId AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = S.archGrpCopyId)
		AND J.opType IN (13, 104) AND S.archGrpCopyId NOT IN (SELECT archGrpCopyId FROM #tblLastAuxCopyJob)
	GROUP BY S.archGrpCopyId
	UPDATE	#tblSizePerCopy
	SET		AuxCopyJobId = B.jobId, AuxCopyStartTime = B.servStart, AuxCopyStatus = B.status
	FROM	#tblSizePerCopy S,
			(SELECT	A.archGrpCopyId, J.jobId, J.servStart, J.status
			FROM	#tblLastAuxCopyJob A, JMAdminJobStatsTable J WITH (NOLOCK)
			WHERE	J.jobId = A.jobId) B
	WHERE	S.archGrpCopyId = B.archGrpCopyId
	DROP TABLE #tblLastAuxCopyJob
	SELECT	AG.name		AS 'Storage Policy',
			AGC.name	AS Copy,
			CASE WHEN AGC.sourceCopyId > 0 THEN (SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = AGC.sourceCopyId)
				 ELSE (SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = AG.defaultCopy) END
						AS 'Source Copy',
			CONVERT(DECIMAL(20, 3), 1.0*(CASE WHEN @AuxCopyCountAppSize > 0 THEN T.appSizeToCopy ELSE T.bytesToCopy END)/1024/1024/1024/1024)
						AS 'Size to Copy (TB)',
			CASE WHEN T.seconds > 0 THEN LTrIM(STR(3600*CAST(T.bytes AS FLOAT)/T.seconds/1024/1024/1024, 10,2)) ELSE 'N/A' END
						AS 'Estimated Throughput (GB/Hr)',
			CASE WHEN T.bytes > 0 THEN LTRIM(STR(CAST(T.bytesToCopy AS FLOAT)*T.seconds/T.bytes/3600, 10)) ELSE 'N/A' END
						AS 'Estimated Hours',
			T.AuxCopyJobId
						AS 'Last JobId',
			CASE WHEN T.AuxCopyStartTime IS NULL OR T.AuxCopyStartTime = 0 THEN NULL
				ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(T.AuxCopyStartTime), @csTimeZone) END
						AS 'Last Job Start Time',
			CASE WHEN T.AuxCopyStartTime IS NULL OR T.AuxCopyStartTime = 0 THEN NULL
				ELSE (@now - T.AuxCopyStartTime)/24/60/60 END
						AS 'Fallen Behind Days',
			CASE T.AuxCopyStatus    WHEN  -1     THEN 'RUNNING'              -- NOTE: !NOT! Using JMJobStatusNames Table for lookup as
									WHEN   0     THEN 'N/A'                  --       it was 1st introduced in 11.0 (won't work w/10.0)
									WHEN   1     THEN 'Completed'
									WHEN   2     THEN 'Failed'
									WHEN   3     THEN 'Completed w/ one or more errors'
									WHEN   4     THEN 'Killed'
									WHEN   5     THEN 'Suspended'
									WHEN   6     THEN 'Interrupted'
									WHEN   8     THEN 'Skipped'
									WHEN   9     THEN 'Failed to Start'
									WHEN  12     THEN 'NotAttempted'
									WHEN  13     THEN 'Started'
									WHEN  14     THEN 'Completed w/ one or more warnings'
									WHEN  16     THEN 'Committed'
								    ELSE  'N/A'
								END
			AS 'Last Job Status'
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), #tblSizePerCopy T
	WHERE	AG.id = T.archGrpId AND AGC.id = T.archGrpCopyId
	ORDER BY T.bytesToCopy desc
	DROP TABLE #tblSizePerCopy
END
DROP TABLE #tblClient
DROP TABLE #tblAuxCopy
DROP TABLE #tblAuxCopyJobs
DROP TABLE #tblPrimaryCopyJobs
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_AuxCopyReport')
	delete from GxQscripts where name = 'QS_AuxCopyReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AuxCopyReport')
	delete from GXDBVersions where aliasname = 'QS_AuxCopyReport'
GO

insert into GXDBVersions values(2, 'QS_AuxCopyReport',  '00010005005600050000', 'QS_AuxCopyReport', '00010005005600050000')
GO

insert into GxQscripts values(2,'QS_AuxCopyReport',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_AuxCopyReport  [-si @GroupBy=''StoragePolicy''] [-si @CopyName=''copyName''] [-si @ClientGroupName=''ClientGroup'']
'
 + CHAR(10) + '-- 	Returns list of storage policies that are fallen behind for aux copy.'
)
GO

